/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.diagram.managers;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.UmlNodeHighlighter;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.jboss.jbpm.diagram.beans.BpmnDiagramEdge;
import com.intellij.jboss.jbpm.diagram.beans.wrappers.BpmnElementWrapper;
import com.intellij.jboss.jbpm.diagram.managers.BpmnUmlNodeHighlighter;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.layout.LayoutOrientation;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.hierarchic.IncrementalHierarchicLayouter;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiTarget;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class BpmnDiagramExtras
extends DiagramExtras<BpmnElementWrapper> {
    private final UmlNodeHighlighter<BpmnElementWrapper> nodeHighlighter = new BpmnUmlNodeHighlighter();

    public List getExtraActions() {
        return Collections.emptyList();
    }

    public Layouter getCustomLayouter(Graph2D graph, Project project) {
        IncrementalHierarchicLayouter layouter = GraphManager.getGraphManager().createIncrementalHierarchicLayouter();
        layouter.setConsiderNodeLabelsEnabled(true);
        layouter.setIntegratedEdgeLabelingEnabled(true);
        layouter.setOrthogonallyRouted(true);
        layouter.setEdgeToEdgeDistance(30.0);
        layouter.setBackloopRoutingEnabled(true);
        layouter.setLayoutOrientation(LayoutOrientation.TOP_TO_BOTTOM);
        return layouter;
    }

    public Object getData(String dataId, List<DiagramNode<BpmnElementWrapper>> nodes, DiagramBuilder builder) {
        if (!CommonDataKeys.NAVIGATABLE.is(dataId) && !CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return null;
        }
        if (nodes.size() == 1) {
            BpmnElementWrapper elementWrapper = (BpmnElementWrapper)nodes.get(0).getIdentifyingElement();
            Object element = elementWrapper.getElement();
            if (!(element instanceof DomElement)) {
                return null;
            }
            return BpmnDiagramExtras.getPsiForDomElement((DomElement)element);
        }
        List edges = DiagramUtils.getSelectedEdges((DiagramBuilder)builder);
        if (edges.size() == 1) {
            DiagramEdge edge = (DiagramEdge)edges.get(0);
            if (!(edge instanceof BpmnDiagramEdge)) {
                return null;
            }
            DomElement domElement = ((BpmnDiagramEdge)edge).getDefiningElement();
            if (domElement == null) {
                return null;
            }
            return BpmnDiagramExtras.getPsiForDomElement(domElement);
        }
        return null;
    }

    @Nullable
    private static Object getPsiForDomElement(DomElement domElement) {
        if (!domElement.isValid()) {
            return null;
        }
        DomTarget domTarget = DomTarget.getTarget((DomElement)domElement);
        return domTarget != null ? PomService.convertToPsi((PsiTarget)domTarget) : domElement.getXmlElement();
    }

    public String suggestDiagramFileName(BpmnElementWrapper element) {
        return element.getName();
    }

    public UmlNodeHighlighter<BpmnElementWrapper> getNodeHighlighter() {
        return this.nodeHighlighter;
    }
}

