/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.diagram.beans.wrappers;

import com.intellij.jboss.jbpm.diagram.beans.wrappers.BpmnElementWrapper;
import com.intellij.jboss.jbpm.model.BpmnDomModel;
import com.intellij.jboss.jbpm.model.BpmnDomModelManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmnDefinitionsWrapper
extends BpmnElementWrapper<XmlFile> {
    private static final String PATH = "flowPath";

    public BpmnDefinitionsWrapper(@NotNull XmlFile file) {
        if (file == null) {
            BpmnDefinitionsWrapper.$$$reportNull$$$0(0);
        }
        super(file);
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((XmlFile)this.myElement).getName();
        if (string == null) {
            BpmnDefinitionsWrapper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String getFqn() {
        VirtualFile virtualFile = ((XmlFile)this.myElement).getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return "flowPath=" + virtualFile.getPath();
    }

    @Override
    @NotNull
    public List<BpmnDomModel> getBpmnModels() {
        if (!((XmlFile)this.myElement).isValid()) {
            List<BpmnDomModel> list = Collections.emptyList();
            if (list == null) {
                BpmnDefinitionsWrapper.$$$reportNull$$$0(2);
            }
            return list;
        }
        BpmnDomModel model = BpmnDomModelManager.getInstance(((XmlFile)this.myElement).getProject()).getModel((XmlFile)this.myElement);
        assert (model != null) : (XmlFile)this.myElement;
        List<BpmnDomModel> list = Collections.singletonList(model);
        if (list == null) {
            BpmnDefinitionsWrapper.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public static BpmnElementWrapper resolveElementByFQN(String fqn, Project project) {
        String path = BpmnDefinitionsWrapper.split(fqn).get(PATH);
        XmlFile file = BpmnDefinitionsWrapper.findFile(project, path);
        if (file == null) {
            return null;
        }
        return new BpmnDefinitionsWrapper(file);
    }

    @Nullable
    private static XmlFile findFile(@NotNull Project project, @Nullable String path) {
        PsiFile psiFile;
        VirtualFile relativeFile;
        if (project == null) {
            BpmnDefinitionsWrapper.$$$reportNull$$$0(4);
        }
        if (!StringUtil.isEmptyOrSpaces((String)path) && (relativeFile = VfsUtil.findRelativeFile((String)path, null)) != null && (psiFile = PsiManager.getInstance((Project)project).findFile(relativeFile)) instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jboss/jbpm/diagram/beans/wrappers/BpmnDefinitionsWrapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jboss/jbpm/diagram/beans/wrappers/BpmnDefinitionsWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBpmnModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

