/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.diagram;

import com.intellij.ProjectTopics;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.jboss.jbpm.diagram.beans.BpmnDiagramEdge;
import com.intellij.jboss.jbpm.diagram.beans.BpmnDiagramNode;
import com.intellij.jboss.jbpm.diagram.beans.BpmnEdgeType;
import com.intellij.jboss.jbpm.diagram.beans.wrappers.Bpmn20DomElementWrapper;
import com.intellij.jboss.jbpm.diagram.beans.wrappers.BpmnElementWrapper;
import com.intellij.jboss.jbpm.diagram.beans.wrappers.BpmnUnknownNodeElementWrapper;
import com.intellij.jboss.jbpm.diagram.managers.BpmnNodeContentManager;
import com.intellij.jboss.jbpm.model.BpmnDomModel;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TBaseElement;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TDefinitions;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TFlowNode;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TProcess;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TSequenceFlow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.events.DomEvent;
import gnu.trove.THashMap;
import icons.JbpmIcons;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BpmnDiagramDataModel
extends DiagramDataModel<BpmnElementWrapper> {
    public static final DiagramCategory SUB_FLOWS = new DiagramCategory("Sub Flows", JbpmIcons.Bpmn.SubProcess, true, true, true);
    private final Collection<DiagramNode<BpmnElementWrapper>> myNodes = new HashSet<DiagramNode<BpmnElementWrapper>>();
    private final Collection<DiagramEdge<BpmnElementWrapper>> myEdges = new HashSet<DiagramEdge<BpmnElementWrapper>>();
    private final BpmnElementWrapper<?> myRootElementWrapper;
    private final DiagramPresentationModel myPresentationModel;

    public BpmnDiagramDataModel(Project project, DiagramProvider<BpmnElementWrapper> provider, BpmnElementWrapper<?> rootElementWrapper, DiagramPresentationModel presentationModel) {
        super(project, provider);
        this.myRootElementWrapper = rootElementWrapper;
        this.myPresentationModel = presentationModel;
        this.setShowDependencies(true);
        DomManager.getDomManager((Project)project).addDomEventListener(new DomEventListener(){

            public void eventOccured(DomEvent event) {
                BpmnDiagramDataModel.this.incModificationCount();
            }
        }, (Disposable)this);
        MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
        connection.setDefaultHandler(new MessageHandler(){

            public void handle(Method event, Object ... params) {
                BpmnDiagramDataModel.this.incModificationCount();
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS);
        connection.subscribe(ProjectTopics.MODULES);
    }

    public boolean isDependencyDiagramSupported() {
        return true;
    }

    public boolean isPsiListener() {
        return true;
    }

    public boolean hasFile(PsiFile file) {
        for (BpmnDomModel model : this.getProcessDefinitionModels()) {
            TDefinitions flow = model.getDefinitions();
            XmlFile xmlFile = DomUtil.getFile((DomElement)flow);
            if (!xmlFile.equals(file)) continue;
            return true;
        }
        return false;
    }

    public void removeNode(DiagramNode<BpmnElementWrapper> node) {
        this.myNodes.remove(node);
        SmartList toRemove = new SmartList();
        for (DiagramEdge<BpmnElementWrapper> edge : this.myEdges) {
            if (!edge.getSource().equals(node) && !edge.getTarget().equals(node)) continue;
            toRemove.add(edge);
        }
        this.myEdges.removeAll((Collection<?>)toRemove);
    }

    @NotNull
    public Collection<DiagramNode<BpmnElementWrapper>> getNodes() {
        Collection<DiagramNode<BpmnElementWrapper>> collection = this.myNodes;
        if (collection == null) {
            BpmnDiagramDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<BpmnElementWrapper>> getEdges() {
        Collection<DiagramEdge<BpmnElementWrapper>> collection = this.myEdges;
        if (collection == null) {
            BpmnDiagramDataModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(DiagramNode<BpmnElementWrapper> node) {
        String string = node.getTooltip();
        if (string == null) {
            BpmnDiagramDataModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public DiagramNode<BpmnElementWrapper> addElement(BpmnElementWrapper element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        return null;
    }

    public DiagramEdge<BpmnElementWrapper> createEdge(@NotNull DiagramNode<BpmnElementWrapper> from, @NotNull DiagramNode<BpmnElementWrapper> to) {
        if (from == null) {
            BpmnDiagramDataModel.$$$reportNull$$$0(3);
        }
        if (to == null) {
            BpmnDiagramDataModel.$$$reportNull$$$0(4);
        }
        if (this.getBuilder().isPopupMode()) {
            return null;
        }
        DomElement fromDom = (DomElement)((Bpmn20DomElementWrapper)from.getIdentifyingElement()).getElement();
        DomElement toDom = (DomElement)((Bpmn20DomElementWrapper)to.getIdentifyingElement()).getElement();
        return super.createEdge(from, to);
    }

    public List<BpmnDomModel> getProcessDefinitionModels() {
        return this.myRootElementWrapper.getBpmnModels();
    }

    public void refreshDataModel() {
        this.myNodes.clear();
        this.myEdges.clear();
        this.updateDataModel();
    }

    private void updateDataModel() {
        DumbService.getInstance((Project)this.getProject()).runWhenSmart(() -> {
            if (this.getBuilder().isPopupMode()) {
                this.setShowDependencies(false);
                this.myPresentationModel.getPresentation().setCategoryEnabled(BpmnNodeContentManager.DETAILS, false);
            }
            for (BpmnDomModel model : this.getProcessDefinitionModels()) {
                this.processDefinitions(model.getDefinitions());
            }
        });
    }

    private void processDefinitions(TDefinitions definitions) {
        for (TProcess tProcess : definitions.getProcesses()) {
            this.processTProcess(tProcess);
        }
    }

    private void processTProcess(@NotNull TProcess process) {
        if (process == null) {
            BpmnDiagramDataModel.$$$reportNull$$$0(5);
        }
        List<TFlowNode> elements = process.getFlowNodes();
        THashMap nodes = new THashMap();
        for (TFlowNode element : elements) {
            String nodeId = element.getId().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)nodeId)) continue;
            nodes.put(nodeId, new BpmnDiagramNode(new Bpmn20DomElementWrapper(element), (DiagramProvider<BpmnElementWrapper>)this.getProvider()));
        }
        for (TSequenceFlow flow : process.getSequenceFlows()) {
            GenericAttributeValue<TBaseElement> sourceRef = flow.getSourceRef();
            GenericAttributeValue<TBaseElement> targetRef = flow.getTargetRef();
            String sourceId = sourceRef.getStringValue();
            String targetId = targetRef.getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)sourceId) || StringUtil.isEmptyOrSpaces((String)targetId)) continue;
            this.myEdges.add((DiagramEdge<BpmnElementWrapper>)new BpmnDiagramEdge((DiagramNode<BpmnElementWrapper>)this.getNodeById((Map<String, BpmnDiagramNode>)nodes, sourceId), (DiagramNode<BpmnElementWrapper>)this.getNodeById((Map<String, BpmnDiagramNode>)nodes, targetId), flow, BpmnEdgeType.FLOW));
        }
        this.myNodes.addAll(nodes.values());
    }

    @NotNull
    private BpmnDiagramNode getNodeById(@NotNull Map<String, BpmnDiagramNode> nodes, @NotNull String nodeId) {
        if (nodes == null) {
            BpmnDiagramDataModel.$$$reportNull$$$0(6);
        }
        if (nodeId == null) {
            BpmnDiagramDataModel.$$$reportNull$$$0(7);
        }
        if (!nodes.containsKey(nodeId)) {
            nodes.put(nodeId, new BpmnDiagramNode(new BpmnUnknownNodeElementWrapper(nodeId), (DiagramProvider<BpmnElementWrapper>)this.getProvider()));
        }
        BpmnDiagramNode bpmnDiagramNode = nodes.get(nodeId);
        if (bpmnDiagramNode == null) {
            BpmnDiagramDataModel.$$$reportNull$$$0(8);
        }
        return bpmnDiagramNode;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        BpmnDiagramDataModel bpmnDiagramDataModel = this;
        if (bpmnDiagramDataModel == null) {
            BpmnDiagramDataModel.$$$reportNull$$$0(9);
        }
        return bpmnDiagramDataModel;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jboss/jbpm/diagram/BpmnDiagramDataModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jboss/jbpm/diagram/BpmnDiagramDataModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeById";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processTProcess";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNodeById";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

