/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public abstract class SaveFileListener
implements ActionListener {
    private final JPanel myContentPanel;
    private final TextFieldWithBrowseButton myTextField;
    private final String myDialogTitle;
    private final String myExtension;

    public SaveFileListener(JPanel contentPanel, TextFieldWithBrowseButton textField, String dialogTitle, String extension) {
        this.myContentPanel = contentPanel;
        this.myTextField = textField;
        this.myDialogTitle = dialogTitle;
        this.myExtension = extension;
    }

    @Nullable
    protected abstract String getDefaultLocation();

    @Override
    public void actionPerformed(ActionEvent e) {
        VirtualFileWrapper result;
        File file;
        String path = this.myTextField.getText().trim();
        if (path.length() == 0) {
            String defaultLocation = this.getDefaultLocation();
            String string = path = defaultLocation != null && defaultLocation.length() > 0 ? defaultLocation : SystemProperties.getUserHome();
        }
        if (!(file = new File(path)).exists()) {
            path = SystemProperties.getUserHome();
        }
        FileSaverDescriptor descriptor = new FileSaverDescriptor(this.myDialogTitle, "Save as *." + this.myExtension, new String[]{this.myExtension});
        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, (Component)this.myContentPanel);
        VirtualFile vf = LocalFileSystem.getInstance().findFileByIoFile(file.exists() ? file : new File(path));
        if (vf == null) {
            vf = VfsUtil.getUserHomeDir();
        }
        if ((result = saveFileDialog.save(vf, null)) == null || result.getFile() == null) {
            return;
        }
        this.myTextField.setText(result.getFile().getPath());
    }
}

