/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.TargetSelectionMode;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.java.IKeywordElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidDependenciesCache;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.android.util.ExecutionStatus;
import org.jetbrains.android.util.OutputProcessor;
import org.jetbrains.android.util.WaitingStrategies;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidUtils {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.util.AndroidUtils");
    @NonNls
    public static final String NAMESPACE_KEY = "android";
    @NonNls
    public static final String SYSTEM_RESOURCE_PACKAGE = "android";
    @NonNls
    public static final String VIEW_CLASS_NAME = "android.view.View";
    @NonNls
    public static final String APPLICATION_CLASS_NAME = "android.app.Application";
    @NonNls
    public static final String ACTIVITY_BASE_CLASS_NAME = "android.app.Activity";
    @NonNls
    public static final String R_CLASS_NAME = "R";
    @NonNls
    public static final String MANIFEST_CLASS_NAME = "Manifest";
    @NonNls
    public static final String LAUNCH_ACTION_NAME = "android.intent.action.MAIN";
    @NonNls
    public static final String WALLPAPER_SERVICE_ACTION_NAME = "android.service.wallpaper.WallpaperService";
    @NonNls
    public static final String LAUNCH_CATEGORY_NAME = "android.intent.category.LAUNCHER";
    @NonNls
    public static final String LEANBACK_LAUNCH_CATEGORY_NAME = "android.intent.category.LEANBACK_LAUNCHER";
    @NonNls
    public static final String DEFAULT_CATEGORY_NAME = "android.intent.category.DEFAULT";
    @NonNls
    public static final String WATCHFACE_CATEGORY_NAME = "com.google.android.wearable.watchface.category.WATCH_FACE";
    @NonNls
    public static final String INSTRUMENTATION_RUNNER_BASE_CLASS = "android.app.Instrumentation";
    @NonNls
    public static final String SERVICE_CLASS_NAME = "android.app.Service";
    @NonNls
    public static final String RECEIVER_CLASS_NAME = "android.content.BroadcastReceiver";
    @NonNls
    public static final String PROVIDER_CLASS_NAME = "android.content.ContentProvider";
    public static final int TIMEOUT = 3000000;
    public static final int MAX_RETRIES = 5;
    private static final Key<ConsoleView> CONSOLE_VIEW_KEY = new Key("AndroidConsoleView");
    @NonNls
    public static final String ANDROID_LIBRARY_PROPERTY = "android.library";
    @NonNls
    public static final String ANDROID_PROJECT_TYPE_PROPERTY = "project.type";
    @NonNls
    public static final String ANDROID_MANIFEST_MERGER_PROPERTY = "manifestmerger.enabled";
    @NonNls
    public static final String ANDROID_DEX_DISABLE_MERGER = "dex.disable.merger";
    @NonNls
    public static final String ANDROID_DEX_FORCE_JUMBO_PROPERTY = "dex.force.jumbo";
    @NonNls
    public static final String ANDROID_TARGET_PROPERTY = "target";
    @NonNls
    public static final String ANDROID_LIBRARY_REFERENCE_PROPERTY_PREFIX = "android.library.reference.";
    @NonNls
    public static final String TAG_LINEAR_LAYOUT = "LinearLayout";
    private static final String[] ANDROID_COMPONENT_CLASSES = new String[]{"android.app.Activity", "android.app.Service", "android.content.BroadcastReceiver", "android.content.ContentProvider"};
    private static final Lexer JAVA_LEXER = JavaParserDefinition.createLexer((LanguageLevel)LanguageLevel.JDK_1_5);

    private AndroidUtils() {
    }

    @Nullable
    public static <T extends DomElement> T loadDomElement(@NotNull Module module, @NotNull VirtualFile file, @NotNull Class<T> aClass) {
        if (module == null) {
            AndroidUtils.$$$reportNull$$$0(0);
        }
        if (file == null) {
            AndroidUtils.$$$reportNull$$$0(1);
        }
        if (aClass == null) {
            AndroidUtils.$$$reportNull$$$0(2);
        }
        return AndroidUtils.loadDomElement(module.getProject(), file, aClass);
    }

    @Nullable
    public static <T extends DomElement> T loadDomElement(final @NotNull Project project, final @NotNull VirtualFile file, final @NotNull Class<T> aClass) {
        if (project == null) {
            AndroidUtils.$$$reportNull$$$0(3);
        }
        if (file == null) {
            AndroidUtils.$$$reportNull$$$0(4);
        }
        if (aClass == null) {
            AndroidUtils.$$$reportNull$$$0(5);
        }
        return (T)((DomElement)ApplicationManager.getApplication().runReadAction(new Computable<T>(){

            @Nullable
            public T compute() {
                if (project.isDisposed()) {
                    return null;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile instanceof XmlFile) {
                    return AndroidUtils.loadDomElementWithReadPermission(project, (XmlFile)psiFile, aClass);
                }
                return null;
            }
        }));
    }

    @Nullable
    public static <T extends DomElement> T loadDomElementWithReadPermission(@NotNull Project project, @NotNull XmlFile xmlFile, @NotNull Class<T> aClass) {
        if (project == null) {
            AndroidUtils.$$$reportNull$$$0(6);
        }
        if (xmlFile == null) {
            AndroidUtils.$$$reportNull$$$0(7);
        }
        if (aClass == null) {
            AndroidUtils.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        DomManager domManager = DomManager.getDomManager((Project)project);
        DomFileElement element = domManager.getFileElement(xmlFile, aClass);
        if (element == null) {
            return null;
        }
        return (T)element.getRootElement();
    }

    @Nullable
    public static VirtualFile findSourceRoot(@NotNull Module module, VirtualFile file) {
        if (module == null) {
            AndroidUtils.$$$reportNull$$$0(9);
        }
        HashSet sourceRoots = new HashSet();
        Collections.addAll(sourceRoots, ModuleRootManager.getInstance((Module)module).getSourceRoots());
        while (file != null) {
            if (sourceRoots.contains(file)) {
                return file;
            }
            file = file.getParent();
        }
        return null;
    }

    @Nullable
    public static String computePackageName(@NotNull Module module, VirtualFile file) {
        if (module == null) {
            AndroidUtils.$$$reportNull$$$0(10);
        }
        HashSet sourceRoots = new HashSet();
        Collections.addAll(sourceRoots, ModuleRootManager.getInstance((Module)module).getSourceRoots());
        VirtualFile projectDir = module.getProject().getBaseDir();
        ArrayList<String> packages = new ArrayList<String>();
        for (file = file.getParent(); file != null && !Comparing.equal((Object)projectDir, (Object)file) && !sourceRoots.contains(file); file = file.getParent()) {
            packages.add(file.getName());
        }
        if (file != null && sourceRoots.contains(file)) {
            StringBuilder packageName = new StringBuilder();
            for (int i = packages.size() - 1; i >= 0; --i) {
                packageName.append((String)packages.get(i));
                if (i <= 0) continue;
                packageName.append('.');
            }
            return packageName.toString();
        }
        return null;
    }

    public static boolean isAbstract(@NotNull PsiClass c) {
        if (c == null) {
            AndroidUtils.$$$reportNull$$$0(11);
        }
        return c.isInterface() || c.hasModifierProperty("abstract");
    }

    public static void executeCommandOnDevice(@NotNull IDevice device, @NotNull String command, @NotNull AndroidOutputReceiver receiver, boolean infinite) throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
        if (device == null) {
            AndroidUtils.$$$reportNull$$$0(12);
        }
        if (command == null) {
            AndroidUtils.$$$reportNull$$$0(13);
        }
        if (receiver == null) {
            AndroidUtils.$$$reportNull$$$0(14);
        }
        long timeout = infinite ? 0L : 3000000L;
        for (int attempt = 0; attempt < 5; ++attempt) {
            boolean retry;
            device.executeShellCommand(command, (IShellOutputReceiver)receiver, timeout, TimeUnit.MILLISECONDS);
            if (receiver.isCancelled()) break;
            boolean bl = retry = infinite || receiver.isTryAgain();
            if (!retry) break;
            receiver.invalidate();
        }
    }

    @Nullable
    public static Module getAndroidModule(ConfigurationContext context) {
        Module module = context.getModule();
        if (module == null || AndroidFacet.getInstance(module) == null) {
            return null;
        }
        return module;
    }

    public static VirtualFile createChildDirectoryIfNotExist(Project project, VirtualFile parent, String name) throws IOException {
        VirtualFile child = parent.findChild(name);
        return child == null ? parent.createChildDirectory((Object)project, name) : child;
    }

    @Nullable
    public static PsiFile getContainingFile(@NotNull PsiElement element) {
        if (element == null) {
            AndroidUtils.$$$reportNull$$$0(15);
        }
        return element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
    }

    public static void navigateTo(@NotNull PsiElement[] targets, @Nullable RelativePoint pointToShowPopup) {
        if (targets == null) {
            AndroidUtils.$$$reportNull$$$0(16);
        }
        if (targets.length == 0) {
            JComponent renderer = HintUtil.createErrorLabel((String)"Empty text");
            JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder(renderer, renderer).createPopup();
            if (pointToShowPopup != null) {
                popup.show(pointToShowPopup);
            }
            return;
        }
        if (targets.length == 1 || pointToShowPopup == null) {
            PsiNavigateUtil.navigate((PsiElement)targets[0]);
        } else {
            DefaultPsiElementCellRenderer renderer = new DefaultPsiElementCellRenderer(){

                public String getElementText(PsiElement element) {
                    PsiFile file = AndroidUtils.getContainingFile(element);
                    return file != null ? file.getName() : super.getElementText(element);
                }

                public String getContainerText(PsiElement element, String name) {
                    PsiFile file = AndroidUtils.getContainingFile(element);
                    PsiDirectory dir = file != null ? file.getContainingDirectory() : null;
                    return dir == null ? "" : '(' + dir.getName() + ')';
                }
            };
            JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])targets, (PsiElementListCellRenderer)renderer, null);
            popup.show(pointToShowPopup);
        }
    }

    @NotNull
    public static ExecutionStatus executeCommand(@NotNull GeneralCommandLine commandLine, final @Nullable OutputProcessor processor, @Nullable WaitingStrategies.Strategy strategy) throws ExecutionException {
        int exitCode;
        if (commandLine == null) {
            AndroidUtils.$$$reportNull$$$0(17);
        }
        LOG.info(commandLine.getCommandLineString());
        OSProcessHandler handler = new OSProcessHandler(commandLine);
        ProcessAdapter listener = new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (processor != null) {
                    String message = event.getText();
                    processor.onTextAvailable(message);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/android/util/AndroidUtils$3";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (!(strategy instanceof WaitingStrategies.DoNotWait)) {
            handler.addProcessListener((ProcessListener)listener);
        }
        handler.startNotify();
        try {
            if (!(strategy instanceof WaitingStrategies.WaitForever)) {
                if (strategy instanceof WaitingStrategies.WaitForTime) {
                    handler.waitFor((long)((WaitingStrategies.WaitForTime)strategy).getTimeMs());
                }
            } else {
                handler.waitFor();
            }
        }
        catch (ProcessCanceledException e) {
            ExecutionStatus executionStatus = ExecutionStatus.ERROR;
            if (executionStatus == null) {
                AndroidUtils.$$$reportNull$$$0(18);
            }
            return executionStatus;
        }
        if (!handler.isProcessTerminated()) {
            ExecutionStatus executionStatus = ExecutionStatus.TIMEOUT;
            if (executionStatus == null) {
                AndroidUtils.$$$reportNull$$$0(19);
            }
            return executionStatus;
        }
        if (!(strategy instanceof WaitingStrategies.DoNotWait)) {
            handler.removeProcessListener((ProcessListener)listener);
        }
        ExecutionStatus executionStatus = (exitCode = handler.getProcess().exitValue()) == 0 ? ExecutionStatus.SUCCESS : ExecutionStatus.ERROR;
        if (executionStatus == null) {
            AndroidUtils.$$$reportNull$$$0(20);
        }
        return executionStatus;
    }

    @NotNull
    public static String getSimpleNameByRelativePath(@NotNull String relativePath) {
        int index;
        if (relativePath == null) {
            AndroidUtils.$$$reportNull$$$0(21);
        }
        if ((index = (relativePath = FileUtil.toSystemIndependentName((String)relativePath)).lastIndexOf(47)) < 0) {
            String string = relativePath;
            if (string == null) {
                AndroidUtils.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = relativePath.substring(index + 1);
        if (string == null) {
            AndroidUtils.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    public static String getUnqualifiedName(@NotNull String qualifiedName) {
        int start;
        if (qualifiedName == null) {
            AndroidUtils.$$$reportNull$$$0(24);
        }
        if ((start = qualifiedName.lastIndexOf(46)) == -1 || start + 1 == qualifiedName.length()) {
            return null;
        }
        return qualifiedName.substring(start + 1);
    }

    public static void printMessageToConsole(@NotNull Project project, @NotNull String s, @NotNull ConsoleViewContentType contentType) {
        ConsoleView consoleView;
        if (project == null) {
            AndroidUtils.$$$reportNull$$$0(25);
        }
        if (s == null) {
            AndroidUtils.$$$reportNull$$$0(26);
        }
        if (contentType == null) {
            AndroidUtils.$$$reportNull$$$0(27);
        }
        if ((consoleView = (ConsoleView)project.getUserData(CONSOLE_VIEW_KEY)) != null) {
            consoleView.print(s + '\n', contentType);
        }
    }

    public static void activateConsoleToolWindow(@NotNull Project project, @NotNull Runnable runAfterActivation) {
        String toolWindowId;
        ToolWindowManager manager;
        ToolWindow toolWindow;
        if (project == null) {
            AndroidUtils.$$$reportNull$$$0(28);
        }
        if (runAfterActivation == null) {
            AndroidUtils.$$$reportNull$$$0(29);
        }
        if ((toolWindow = (manager = ToolWindowManager.getInstance((Project)project)).getToolWindow(toolWindowId = AndroidBundle.message("android.console.tool.window.title", new Object[0]))) != null) {
            runAfterActivation.run();
            return;
        }
        toolWindow = manager.registerToolWindow(toolWindowId, true, ToolWindowAnchor.BOTTOM);
        ConsoleViewImpl console = new ConsoleViewImpl(project, false);
        project.putUserData(CONSOLE_VIEW_KEY, (Object)console);
        toolWindow.getContentManager().addContent((Content)new ContentImpl(console.getComponent(), "", false));
        ToolWindowManagerListener listener = new ToolWindowManagerListener(){

            public void toolWindowRegistered(@NotNull String id) {
                if (id == null) {
                    4.$$$reportNull$$$0(0);
                }
            }

            public void stateChanged() {
                ToolWindow window = manager.getToolWindow(toolWindowId);
                if (window != null && !window.isVisible()) {
                    ((ToolWindowManagerEx)manager).removeToolWindowManagerListener((ToolWindowManagerListener)this);
                    ApplicationManager.getApplication().invokeLater(() -> manager.unregisterToolWindow(toolWindowId));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/android/util/AndroidUtils$4", "toolWindowRegistered"));
            }
        };
        toolWindow.show(() -> {
            if (runAfterActivation == null) {
                AndroidUtils.$$$reportNull$$$0(69);
            }
            runAfterActivation.run();
            ((ToolWindowManagerEx)manager).addToolWindowManagerListener(listener);
        });
    }

    @NotNull
    public static AndroidFacet addAndroidFacetInWriteAction(final @NotNull Module module, final @NotNull VirtualFile contentRoot, final boolean library) {
        if (module == null) {
            AndroidUtils.$$$reportNull$$$0(30);
        }
        if (contentRoot == null) {
            AndroidUtils.$$$reportNull$$$0(31);
        }
        AndroidFacet androidFacet = (AndroidFacet)((Object)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<AndroidFacet>(){

            public AndroidFacet compute() {
                return AndroidUtils.addAndroidFacet(module, contentRoot, library);
            }
        }));
        if (androidFacet == null) {
            AndroidUtils.$$$reportNull$$$0(32);
        }
        return androidFacet;
    }

    @NotNull
    public static AndroidFacet addAndroidFacet(Module module, @NotNull VirtualFile contentRoot, boolean library) {
        FacetManager facetManager;
        ModifiableFacetModel model;
        AndroidFacet facet;
        if (contentRoot == null) {
            AndroidUtils.$$$reportNull$$$0(33);
        }
        if ((facet = (AndroidFacet)(model = (facetManager = FacetManager.getInstance((Module)module)).createModifiableModel()).getFacetByType(AndroidFacet.ID)) == null) {
            facet = (AndroidFacet)facetManager.createFacet((FacetType)AndroidFacet.getFacetType(), "Android", null);
            AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
            configuration.init(module, contentRoot);
            if (library) {
                facet.setProjectType(1);
            }
            model.addFacet((Facet)facet);
        }
        model.commit();
        AndroidFacet androidFacet = facet;
        if (androidFacet == null) {
            AndroidUtils.$$$reportNull$$$0(34);
        }
        return androidFacet;
    }

    @Nullable
    public static VirtualFile findFileByAbsoluteOrRelativePath(@Nullable VirtualFile baseDir, @NotNull String path) {
        VirtualFile libDir;
        if (path == null) {
            AndroidUtils.$$$reportNull$$$0(35);
        }
        if ((libDir = LocalFileSystem.getInstance().findFileByPath(path)) != null) {
            return libDir;
        }
        if (baseDir != null) {
            return LocalFileSystem.getInstance().findFileByPath(baseDir.getPath() + '/' + path);
        }
        return null;
    }

    @Nullable
    public static TargetSelectionMode getDefaultTargetSelectionMode(@NotNull Module module, @NotNull ConfigurationType type, @NonNls ConfigurationType alternativeType) {
        if (module == null) {
            AndroidUtils.$$$reportNull$$$0(36);
        }
        if (type == null) {
            AndroidUtils.$$$reportNull$$$0(37);
        }
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        List configurations = runManager.getConfigurationsList(type);
        TargetSelectionMode alternative = null;
        if (configurations.size() > 0) {
            for (RunConfiguration configuration : configurations) {
                if (!(configuration instanceof AndroidRunConfigurationBase)) continue;
                AndroidRunConfigurationBase runConfig = (AndroidRunConfigurationBase)configuration;
                TargetSelectionMode targetMode = runConfig.getDeployTargetContext().getTargetSelectionMode();
                if (runConfig.getConfigurationModule() == module) {
                    return targetMode;
                }
                alternative = targetMode;
            }
        }
        if (alternative != null) {
            return alternative;
        }
        configurations = runManager.getConfigurationsList(alternativeType);
        if (configurations.size() > 0) {
            for (RunConfiguration configuration : configurations) {
                if (!(configuration instanceof AndroidRunConfigurationBase)) continue;
                return ((AndroidRunConfigurationBase)configuration).getDeployTargetContext().getTargetSelectionMode();
            }
        }
        return null;
    }

    public static boolean equal(@Nullable String s1, @Nullable String s2, boolean distinguishDelimiters) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        int n = s1.length();
        for (int i = 0; i < n; ++i) {
            char c1 = s1.charAt(i);
            char c2 = s2.charAt(i);
            if (!distinguishDelimiters && (!Character.isLetterOrDigit(c1) || !Character.isLetterOrDigit(c2)) || c1 == c2) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static List<AndroidFacet> getApplicationFacets(@NotNull Project project) {
        if (project == null) {
            AndroidUtils.$$$reportNull$$$0(38);
        }
        ArrayList<AndroidFacet> result = new ArrayList<AndroidFacet>();
        for (AndroidFacet facet : ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID)) {
            if (!facet.isAppProject()) continue;
            result.add(facet);
        }
        ArrayList<AndroidFacet> arrayList = result;
        if (arrayList == null) {
            AndroidUtils.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    @NotNull
    public static List<AndroidFacet> getAndroidLibraryDependencies(@NotNull Module module) {
        if (module == null) {
            AndroidUtils.$$$reportNull$$$0(40);
        }
        ArrayList<AndroidFacet> depFacets = new ArrayList<AndroidFacet>();
        for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            AndroidFacet depFacet;
            Module depModule;
            ModuleOrderEntry moduleOrderEntry;
            if (!(orderEntry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getScope() != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || (depFacet = AndroidFacet.getInstance(depModule)) == null || !depFacet.canBeDependency()) continue;
            depFacets.add(depFacet);
        }
        ArrayList<AndroidFacet> arrayList = depFacets;
        if (arrayList == null) {
            AndroidUtils.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    @NotNull
    public static List<AndroidFacet> getAllAndroidDependencies(@NotNull Module module, boolean androidLibrariesOnly) {
        if (module == null) {
            AndroidUtils.$$$reportNull$$$0(42);
        }
        List<AndroidFacet> list = AndroidDependenciesCache.getInstance(module).getAllAndroidDependencies(androidLibrariesOnly);
        if (list == null) {
            AndroidUtils.$$$reportNull$$$0(43);
        }
        return list;
    }

    @NotNull
    public static Set<String> getDepLibsPackages(Module module) {
        HashSet result = new HashSet();
        HashSet visited = new HashSet();
        if (visited.add((Object)module)) {
            for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(module, true)) {
                String aPackage;
                Manifest manifest = depFacet.getManifest();
                if (manifest == null || (aPackage = (String)manifest.getPackage().getValue()) == null) continue;
                result.add(aPackage);
            }
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            AndroidUtils.$$$reportNull$$$0(44);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkNewPassword(JPasswordField passwordField, JPasswordField confirmedPasswordField) throws CommitStepException {
        char[] password = passwordField.getPassword();
        char[] confirmedPassword = confirmedPasswordField.getPassword();
        try {
            AndroidUtils.checkPassword(password);
            if (password.length < 6) {
                throw new CommitStepException(AndroidBundle.message("android.export.package.incorrect.password.length", new Object[0]));
            }
            if (!Arrays.equals(password, confirmedPassword)) {
                throw new CommitStepException(AndroidBundle.message("android.export.package.passwords.not.match.error", new Object[0]));
            }
        }
        finally {
            Arrays.fill(password, '\u0000');
            Arrays.fill(confirmedPassword, '\u0000');
        }
    }

    public static void checkPassword(char[] password) throws CommitStepException {
        if (password.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.password.error", new Object[0]));
        }
    }

    @NotNull
    public static <T> List<T> toList(@NotNull Enumeration<T> enumeration) {
        if (enumeration == null) {
            AndroidUtils.$$$reportNull$$$0(45);
        }
        List list = ContainerUtil.toList(enumeration);
        if (list == null) {
            AndroidUtils.$$$reportNull$$$0(46);
        }
        return list;
    }

    public static void reportError(@NotNull Project project, @NotNull String message) {
        if (project == null) {
            AndroidUtils.$$$reportNull$$$0(47);
        }
        if (message == null) {
            AndroidUtils.$$$reportNull$$$0(48);
        }
        AndroidUtils.reportError(project, message, CommonBundle.getErrorTitle());
    }

    public static void reportError(@NotNull Project project, @NotNull String message, @NotNull String title) {
        if (project == null) {
            AndroidUtils.$$$reportNull$$$0(49);
        }
        if (message == null) {
            AndroidUtils.$$$reportNull$$$0(50);
        }
        if (title == null) {
            AndroidUtils.$$$reportNull$$$0(51);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IncorrectOperationException(message);
        }
        Messages.showErrorDialog((Project)project, (String)message, (String)title);
    }

    public static void showStackStace(@NotNull Project project, @NotNull Throwable[] throwables) {
        if (project == null) {
            AndroidUtils.$$$reportNull$$$0(52);
        }
        if (throwables == null) {
            AndroidUtils.$$$reportNull$$$0(53);
        }
        final StringBuilder messageBuilder = new StringBuilder();
        for (Throwable t : throwables) {
            if (messageBuilder.length() > 0) {
                messageBuilder.append("\n\n");
            }
            messageBuilder.append(AndroidCommonUtils.getStackTrace((Throwable)t));
        }
        DialogWrapper wrapper = new DialogWrapper(project, false){
            {
                super(arg0, arg1);
                this.init();
            }

            protected JComponent createCenterPanel() {
                JPanel panel = new JPanel(new BorderLayout());
                JTextArea textArea = new JTextArea(messageBuilder.toString());
                textArea.setEditable(false);
                textArea.setRows(40);
                textArea.setColumns(70);
                panel.add(ScrollPaneFactory.createScrollPane((Component)textArea));
                return panel;
            }
        };
        wrapper.setTitle("Stack Trace");
        wrapper.show();
    }

    public static boolean isValidAndroidPackageName(@NotNull String name) {
        if (name == null) {
            AndroidUtils.$$$reportNull$$$0(54);
        }
        return AndroidUtils.validateAndroidPackageName(name) == null;
    }

    public static boolean isValidJavaPackageName(@NotNull String name) {
        if (name == null) {
            AndroidUtils.$$$reportNull$$$0(55);
        }
        int index = 0;
        while (true) {
            int index1;
            if ((index1 = name.indexOf(46, index)) < 0) {
                index1 = name.length();
            }
            if (!AndroidUtils.isIdentifier(name.substring(index, index1))) {
                return false;
            }
            if (index1 == name.length()) {
                return true;
            }
            index = index1 + 1;
        }
    }

    @Nullable
    public static String validateAndroidPackageName(@NotNull String name) {
        if (name == null) {
            AndroidUtils.$$$reportNull$$$0(56);
        }
        if (name.isEmpty()) {
            return "Package name is missing";
        }
        String packageManagerCheck = AndroidUtils.validateName(name, true);
        if (packageManagerCheck != null) {
            return packageManagerCheck;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int index = 0;
        while (true) {
            String error;
            int index1;
            if ((index1 = name.indexOf(46, index)) < 0) {
                index1 = name.length();
            }
            if ((error = AndroidUtils.isReservedKeyword(name.substring(index, index1))) != null) {
                return error;
            }
            if (index1 == name.length()) break;
            index = index1 + 1;
        }
        return null;
    }

    @Nullable
    public static String isReservedKeyword(@NotNull String string) {
        if (string == null) {
            AndroidUtils.$$$reportNull$$$0(57);
        }
        Lexer lexer = JAVA_LEXER;
        lexer.start((CharSequence)string);
        if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
            if (lexer.getTokenType() instanceof IKeywordElementType) {
                return "Package names cannot contain Java keywords like '" + string + "'";
            }
            if (string.isEmpty()) {
                return "Package segments must be of non-zero length";
            }
            return string + " is not a valid identifier";
        }
        return null;
    }

    @Nullable
    private static String validateName(String name, boolean requiresSeparator) {
        int N = name.length();
        boolean hasSep = false;
        boolean front = true;
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                front = false;
                continue;
            }
            if (c >= '0' && c <= '9' || c == '_') {
                if (!front) continue;
                if (c == '_') {
                    return "The character '_' cannot be the first character in a package segment";
                }
                return "A digit cannot be the first character in a package segment";
            }
            if (c == '.') {
                hasSep = true;
                front = true;
                continue;
            }
            return "The character '" + c + "' is not allowed in Android application package names";
        }
        return hasSep || !requiresSeparator ? null : "The package must have at least one '.' separator";
    }

    public static boolean isIdentifier(@NotNull String candidate) {
        if (candidate == null) {
            AndroidUtils.$$$reportNull$$$0(58);
        }
        return StringUtil.isJavaIdentifier((String)candidate) && !JavaLexer.isKeyword((String)candidate, (LanguageLevel)LanguageLevel.JDK_1_5);
    }

    public static void reportImportErrorToEventLog(String message, String modName, Project project) {
        AndroidUtils.reportImportErrorToEventLog(message, modName, project, null);
    }

    public static void reportImportErrorToEventLog(String message, String modName, Project project, NotificationListener listener) {
        Notifications.Bus.notify((Notification)new Notification(AndroidBundle.message("android.facet.importing.notification.group", new Object[0]), AndroidBundle.message("android.facet.importing.title", modName), message, NotificationType.ERROR, listener), (Project)project);
        LOG.debug(message);
    }

    public static boolean isPackagePrefix(@NotNull String prefix, @NotNull String name) {
        if (prefix == null) {
            AndroidUtils.$$$reportNull$$$0(59);
        }
        if (name == null) {
            AndroidUtils.$$$reportNull$$$0(60);
        }
        return name.equals(prefix) || name.startsWith(prefix + ".");
    }

    @NotNull
    public static Set<Module> getSetWithBackwardDependencies(@NotNull Collection<Module> modules) {
        if (modules == null) {
            AndroidUtils.$$$reportNull$$$0(61);
        }
        if (modules.isEmpty()) {
            Set<Module> set = Collections.emptySet();
            if (set == null) {
                AndroidUtils.$$$reportNull$$$0(62);
            }
            return set;
        }
        Module next = modules.iterator().next();
        Graph graph = ModuleManager.getInstance((Project)next.getProject()).moduleGraph();
        HashSet set = new HashSet();
        for (Module module : modules) {
            GraphAlgorithms.getInstance().collectOutsRecursively(graph, (Object)module, (Set)set);
        }
        HashSet hashSet = set;
        if (hashSet == null) {
            AndroidUtils.$$$reportNull$$$0(63);
        }
        return hashSet;
    }

    @NotNull
    public static List<String> urlsToOsPaths(@NotNull List<String> urls, @Nullable String sdkHomeCanonicalPath) {
        if (urls == null) {
            AndroidUtils.$$$reportNull$$$0(64);
        }
        if (urls.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                AndroidUtils.$$$reportNull$$$0(65);
            }
            return list;
        }
        ArrayList<String> result = new ArrayList<String>(urls.size());
        for (String url : urls) {
            if (sdkHomeCanonicalPath != null) {
                url = StringUtil.replace((String)url, (String)"%MODULE_SDK_HOME%", (String)sdkHomeCanonicalPath);
            }
            result.add(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url)));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            AndroidUtils.$$$reportNull$$$0(66);
        }
        return arrayList;
    }

    @NotNull
    public static String getAndroidSystemDirectoryOsPath() {
        String string = PathManager.getSystemPath() + File.separator + "android";
        if (string == null) {
            AndroidUtils.$$$reportNull$$$0(67);
        }
        return string;
    }

    public static boolean isAndroidComponent(@NotNull PsiClass c) {
        if (c == null) {
            AndroidUtils.$$$reportNull$$$0(68);
        }
        Project project = c.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        for (String componentClassName : ANDROID_COMPONENT_CLASSES) {
            PsiClass componentClass = facade.findClass(componentClassName, ProjectScope.getAllScope((Project)project));
            if (componentClass == null || !c.isInheritor(componentClass, true)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 32: 
            case 34: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 32: 
            case 34: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 6: 
            case 25: 
            case 28: 
            case 38: 
            case 47: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 11: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 32: 
            case 34: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/util/AndroidUtils";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 29: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runAfterActivation";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeration";
                break;
            }
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwables";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/util/AndroidUtils";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "executeCommand";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleNameByRelativePath";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "addAndroidFacetInWriteAction";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "addAndroidFacet";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationFacets";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidLibraryDependencies";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAndroidDependencies";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getDepLibsPackages";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getSetWithBackwardDependencies";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "urlsToOsPaths";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidSystemDirectoryOsPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadDomElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadDomElementWithReadPermission";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSourceRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computePackageName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAbstract";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeCommandOnDevice";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 32: 
            case 34: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleNameByRelativePath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getUnqualifiedName";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "printMessageToConsole";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "activateConsoleToolWindow";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addAndroidFacetInWriteAction";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addAndroidFacet";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findFileByAbsoluteOrRelativePath";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTargetSelectionMode";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationFacets";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidLibraryDependencies";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAllAndroidDependencies";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "toList";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "showStackStace";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isValidAndroidPackageName";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isValidJavaPackageName";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "validateAndroidPackageName";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isReservedKeyword";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isPackagePrefix";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getSetWithBackwardDependencies";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "urlsToOsPaths";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidComponent";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "lambda$activateConsoleToolWindow$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 32: 
            case 34: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

