/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.text.html.HTMLDocument;
import org.jetbrains.android.compiler.artifact.ApkSigningSettingsForm;
import org.jetbrains.android.compiler.artifact.ChooseKeyDialog;
import org.jetbrains.android.compiler.artifact.NewKeyStoreDialog;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidUiUtil {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.android.util.AndroidUiUtil");

    private AndroidUiUtil() {
    }

    public static void setUpAsHtmlLabel(@NotNull JEditorPane editorPane) {
        if (editorPane == null) {
            AndroidUiUtil.$$$reportNull$$$0(0);
        }
        AndroidUiUtil.setUpAsHtmlLabel(editorPane, UIUtil.getLabelFont());
    }

    public static void setUpAsHtmlLabel(@NotNull JEditorPane editorPane, @NotNull Font font) {
        if (editorPane == null) {
            AndroidUiUtil.$$$reportNull$$$0(1);
        }
        if (font == null) {
            AndroidUiUtil.$$$reportNull$$$0(2);
        }
        editorPane.setContentType("text/html");
        editorPane.setEditable(false);
        editorPane.setOpaque(false);
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; } ol { padding-left: 0px; margin-left: 35px; margin-top: 0px; } ol li { margin-left: 0px; padding-left: 0px; list-style-type: decimal; }";
        ((HTMLDocument)editorPane.getDocument()).getStyleSheet().addRule(bodyRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static List<String> loadExistingKeys(@NotNull ApkSigningSettingsForm form) {
        if (form == null) {
            AndroidUiUtil.$$$reportNull$$$0(3);
        }
        String errorPrefix = "Cannot load key store: ";
        InputStream is = null;
        try {
            is = new FileInputStream(new File(form.getKeyStorePathField().getText().trim()));
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(is, form.getKeyStorePasswordField().getPassword());
            List<String> list = AndroidUtils.toList(keyStore.aliases());
            return list;
        }
        catch (KeyStoreException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (FileNotFoundException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (CertificateException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (NoSuchAlgorithmException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        catch (IOException e) {
            Messages.showErrorDialog((Component)form.getPanel(), (String)("Cannot load key store: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            List<String> list = null;
            return list;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
    }

    public static void initSigningSettingsForm(final @NotNull Project project, final @NotNull ApkSigningSettingsForm form) {
        if (project == null) {
            AndroidUiUtil.$$$reportNull$$$0(4);
        }
        if (form == null) {
            AndroidUiUtil.$$$reportNull$$$0(5);
        }
        form.getLoadKeyStoreButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String defaultPath = form.getKeyStorePathField().getText().trim();
                VirtualFile defaultFile = LocalFileSystem.getInstance().findFileByPath(defaultPath);
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)form.getPanel(), (Project)project, (VirtualFile)defaultFile);
                if (file != null) {
                    form.getKeyStorePathField().setText(FileUtil.toSystemDependentName((String)file.getPath()));
                }
            }
        });
        form.getCreateKeyStoreButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewKeyStoreDialog dialog = new NewKeyStoreDialog(project, form.getKeyStorePathField().getText());
                dialog.show();
                if (dialog.getExitCode() == 0) {
                    form.getKeyStorePathField().setText(dialog.getKeyStorePath());
                    form.getKeyStorePasswordField().setText(String.valueOf(dialog.getKeyStorePassword()));
                    form.getKeyAliasField().setText(dialog.getKeyAlias());
                    form.getKeyPasswordField().setText(String.valueOf(dialog.getKeyPassword()));
                }
            }
        });
        form.getKeyAliasField().getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List keys = AndroidUiUtil.loadExistingKeys(form);
                if (keys == null) {
                    return;
                }
                ChooseKeyDialog dialog = new ChooseKeyDialog(project, form.getKeyStorePathField().getText().trim(), form.getKeyStorePasswordField().getPassword(), keys, form.getKeyAliasField().getText().trim());
                dialog.show();
                if (dialog.getExitCode() == 0) {
                    char[] password;
                    String chosenKey = dialog.getChosenKey();
                    if (chosenKey != null) {
                        form.getKeyAliasField().setText(chosenKey);
                    }
                    if ((password = dialog.getChosenKeyPassword()) != null) {
                        form.getKeyPasswordField().setText(String.valueOf(password));
                    }
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorPane";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "form";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/util/AndroidUiUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpAsHtmlLabel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadExistingKeys";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "initSigningSettingsForm";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

