/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;

public class ChooseClassDialog
extends DialogWrapper
implements ListSelectionListener {
    private final JList myList = new JBList();
    private final JScrollPane myComponent = ScrollPaneFactory.createScrollPane((Component)this.myList);
    private final Condition<PsiClass> myFilter;
    private String myResultClassName;

    public ChooseClassDialog(Module module, String title, boolean includeAll, @Nullable Condition<PsiClass> filter, String ... classes) {
        super(module.getProject());
        this.myFilter = filter;
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (ChooseClassDialog.this.myList.getSelectedValue() != null) {
                    ChooseClassDialog.this.close(0);
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myList);
        DefaultListModel model = new DefaultListModel();
        this.findClasses(module, includeAll, model, classes);
        this.myList.setModel(model);
        this.myList.setCellRenderer(new DefaultPsiElementCellRenderer());
        ListSelectionModel selectionModel = this.myList.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(this);
        new ListSpeedSearch(this.myList){

            protected boolean isMatchingElement(Object element, String pattern) {
                PsiClass psiClass = (PsiClass)element;
                return this.compare(psiClass.getName(), pattern) || this.compare(psiClass.getQualifiedName(), pattern);
            }
        };
        this.setTitle(title);
        this.setOKActionEnabled(false);
        this.init();
        Dimension size = this.myComponent.getPreferredSize();
        size.height = this.myList.getPreferredSize().height + 20;
        this.myComponent.setPreferredSize(size);
    }

    protected void findClasses(Module module, boolean includeAll, DefaultListModel model, String[] classes) {
        for (String className : classes) {
            for (PsiClass psiClass : ChooseClassDialog.findInheritors(module, className, includeAll)) {
                if (this.myFilter != null && !this.myFilter.value((Object)psiClass)) continue;
                model.addElement(psiClass);
            }
        }
    }

    public static Collection<PsiClass> findInheritors(Module module, String name, boolean includeAll) {
        PsiClass base = ChooseClassDialog.findClass(module, name);
        if (base != null) {
            Collection<Object> classes;
            GlobalSearchScope scope = includeAll ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false) : GlobalSearchScope.moduleScope((Module)module);
            try {
                classes = ClassInheritorsSearch.search((PsiClass)base, (SearchScope)scope, (boolean)true).findAll();
            }
            catch (IndexNotReadyException e) {
                classes = Collections.emptyList();
            }
            return classes;
        }
        return Collections.emptyList();
    }

    @Nullable
    public static PsiClass findClass(Module module, @Nullable String name) {
        PsiClass aClass;
        if (name == null) {
            return null;
        }
        Project project = module.getProject();
        try {
            aClass = JavaPsiFacade.getInstance((Project)project).findClass(name, GlobalSearchScope.allScope((Project)project));
        }
        catch (IndexNotReadyException e) {
            aClass = null;
        }
        return aClass;
    }

    @Nullable
    public static String openDialog(Module module, String title, boolean includeAll, @Nullable Condition<PsiClass> filter, String ... classes) {
        Project project;
        DumbService dumbService;
        if (classes == null) {
            ChooseClassDialog.$$$reportNull$$$0(0);
        }
        if ((dumbService = DumbService.getInstance((Project)(project = module.getProject()))).isDumb()) {
            dumbService.showDumbModeNotification(String.format("%1$s are not available while indices are updating.", title));
            return null;
        }
        ChooseClassDialog dialog = new ChooseClassDialog(module, title, includeAll, filter, classes);
        return dialog.showAndGet() ? dialog.getClassName() : null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    protected JComponent createCenterPanel() {
        return this.myComponent;
    }

    public String getClassName() {
        return this.myResultClassName;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        PsiClass psiClass = (PsiClass)this.myList.getSelectedValue();
        this.setOKActionEnabled(psiClass != null);
        this.myResultClassName = psiClass == null ? null : psiClass.getQualifiedName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "org/jetbrains/android/uipreview/ChooseClassDialog", "openDialog"));
    }
}

