/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run.testing;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathsList;
import java.io.File;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.Nullable;

public class AndroidJunitPatcher
extends JUnitPatcher {
    public void patchJavaParameters(@Nullable Module module, JavaParameters javaParameters) {
        if (module == null) {
            return;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel == null) {
            return;
        }
        PathsList classPath = javaParameters.getClassPath();
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null || !(sdk.getSdkType() instanceof AndroidSdkType)) {
            return;
        }
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        if (!(data instanceof AndroidSdkAdditionalData)) {
            return;
        }
        AndroidPlatform platform = ((AndroidSdkAdditionalData)data).getAndroidPlatform();
        if (platform == null) {
            return;
        }
        classPath.remove(platform.getTarget().getPath(1));
        String mockableJarPath = null;
        for (String path : classPath.getPathList()) {
            if (!new File(FileUtil.toSystemDependentName((String)path)).getName().startsWith("mockable-android")) continue;
            mockableJarPath = path;
            break;
        }
        if (mockableJarPath != null) {
            classPath.remove(mockableJarPath);
            classPath.addTail(mockableJarPath);
        }
    }
}

