/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceDirectoryNode
extends ProjectViewNode<PsiDirectory> {
    private final Map<String, AbstractTreeNode> myChildMap = new HashMap();
    private final ArrayList<AbstractTreeNode> myChildren = new ArrayList();
    private final PsiDirectoryNode myBaseNode;

    protected ResourceDirectoryNode(Project project, PsiDirectoryNode directory, ViewSettings viewSettings) {
        super(project, directory.getValue(), viewSettings);
        this.myBaseNode = directory;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            ResourceDirectoryNode.$$$reportNull$$$0(0);
        }
        return false;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<AbstractTreeNode> arrayList = this.myChildren;
        if (arrayList == null) {
            ResourceDirectoryNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    protected void update(PresentationData presentation) {
        presentation.clearText();
        presentation.addText(((PsiDirectory)this.getValue()).getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setPresentableText(((PsiDirectory)this.getValue()).getName());
        presentation.setIcon(((PsiDirectory)this.getValue()).getIcon(0));
    }

    public void collectChildren() {
        for (AbstractTreeNode child : this.myBaseNode.getChildren()) {
            Object value = child.getValue();
            if (value instanceof PsiNamedElement) {
                String name = ((PsiNamedElement)value).getName();
                if (this.myChildMap.containsKey(name)) continue;
                this.myChildMap.put(name, child);
                this.myChildren.add(child);
                continue;
            }
            this.myChildren.add(child);
        }
    }

    @Nullable
    public String getTestPresentation() {
        return "ResourceDirectory:" + ((PsiDirectory)this.getValue()).getName();
    }

    public String toString() {
        return "ResourceDirectory:" + ((PsiDirectory)this.getValue()).getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/projectView/ResourceDirectoryNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/projectView/ResourceDirectoryNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

