/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.templates.SupportLibrary;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import javax.swing.JList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class AndroidAddLibraryDependencyAction
extends AbstractIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getText() {
        String string = AndroidBundle.message("add.dependency.intention.text", new Object[0]);
        if (string == null) {
            AndroidAddLibraryDependencyAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            AndroidAddLibraryDependencyAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static GradleBuildModel getGradleBuildModel(@NotNull Project project, @NotNull PsiFile file) {
        ProjectFileIndex index;
        Module module;
        if (project == null) {
            AndroidAddLibraryDependencyAction.$$$reportNull$$$0(2);
        }
        if (file == null) {
            AndroidAddLibraryDependencyAction.$$$reportNull$$$0(3);
        }
        if ((module = (index = ProjectRootManager.getInstance((Project)project).getFileIndex()).getModuleForFile(file.getVirtualFile())) == null) {
            return null;
        }
        return GradleBuildModel.get(module);
    }

    @NotNull
    private static ImmutableCollection<String> findAllDependencies(@NotNull GradleBuildModel buildModel) {
        if (buildModel == null) {
            AndroidAddLibraryDependencyAction.$$$reportNull$$$0(4);
        }
        HashSet existingDependencies = Sets.newHashSet();
        for (ArtifactDependencyModel dependency : buildModel.dependencies().artifacts()) {
            existingDependencies.add((String)dependency.group().value() + ":" + dependency.name().value());
        }
        ImmutableList.Builder dependenciesBuilder = ImmutableList.builder();
        RepositoryUrlManager repositoryUrlManager = RepositoryUrlManager.get();
        for (SupportLibrary library : SupportLibrary.values()) {
            GradleCoordinate coordinate;
            GradleCoordinate libraryCoordinate = library.getGradleCoordinate("+");
            if (existingDependencies.contains(libraryCoordinate.getId()) || (coordinate = repositoryUrlManager.resolveDynamicCoordinate(libraryCoordinate, buildModel.getProject())) == null) continue;
            dependenciesBuilder.add((Object)coordinate.toString());
        }
        ImmutableList immutableList = dependenciesBuilder.build();
        if (immutableList == null) {
            AndroidAddLibraryDependencyAction.$$$reportNull$$$0(5);
        }
        return immutableList;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AndroidAddLibraryDependencyAction.$$$reportNull$$$0(6);
        }
        if (!(file instanceof GroovyFile) || !file.getName().equals("build.gradle")) {
            return false;
        }
        if (AndroidFacet.getInstance((PsiElement)file) == null) {
            return false;
        }
        GradleBuildModel buildModel = AndroidAddLibraryDependencyAction.getGradleBuildModel(project, file);
        if (buildModel == null || buildModel.dependencies().all().isEmpty()) {
            return false;
        }
        return !AndroidAddLibraryDependencyAction.findAllDependencies(buildModel).isEmpty();
    }

    private static void addDependency(@NotNull Project project, final @NotNull GradleBuildModel buildModel, @NotNull String coordinateString) {
        GradleCoordinate coordinate;
        if (project == null) {
            AndroidAddLibraryDependencyAction.$$$reportNull$$$0(7);
        }
        if (buildModel == null) {
            AndroidAddLibraryDependencyAction.$$$reportNull$$$0(8);
        }
        if (coordinateString == null) {
            AndroidAddLibraryDependencyAction.$$$reportNull$$$0(9);
        }
        if ((coordinate = GradleCoordinate.parseCoordinateString((String)coordinateString)) == null || coordinate.getArtifactId() == null) {
            return;
        }
        final ArtifactDependencySpec newDependency = new ArtifactDependencySpec(coordinate.getArtifactId(), coordinate.getGroupId(), coordinate.getRevision());
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

            @Override
            public void run() {
                buildModel.dependencies().addArtifact("compile", newDependency);
                buildModel.applyChanges();
            }
        });
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        GradleBuildModel buildModel;
        if (project == null) {
            AndroidAddLibraryDependencyAction.$$$reportNull$$$0(10);
        }
        if ((buildModel = AndroidAddLibraryDependencyAction.getGradleBuildModel(project, file)) == null) {
            return;
        }
        ImmutableCollection<String> dependencies = AndroidAddLibraryDependencyAction.findAllDependencies(buildModel);
        if (dependencies.isEmpty()) {
            return;
        }
        JBList list = new JBList(dependencies);
        JBPopup popup = new PopupChooserBuilder((JList)list).setItemChoosenCallback(new Runnable((JList)list, project, buildModel){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Project val$project;
            final /* synthetic */ GradleBuildModel val$buildModel;
            {
                this.val$list = jList;
                this.val$project = project;
                this.val$buildModel = gradleBuildModel;
            }

            @Override
            public void run() {
                for (Object selectedValue : this.val$list.getSelectedValues()) {
                    if (selectedValue == null) {
                        return;
                    }
                    AndroidAddLibraryDependencyAction.addDependency(this.val$project, this.val$buildModel, (String)selectedValue);
                }
            }
        }).createPopup();
        popup.showInBestPositionFor(editor);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/intentions/AndroidAddLibraryDependencyAction";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinateString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/intentions/AndroidAddLibraryDependencyAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGradleBuildModel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAllDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

