/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.builder.model.Dependencies;
import com.android.builder.model.Variant;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.lint.AddTargetApiQuickFix;
import com.android.tools.idea.lint.AddTargetVersionCheckQuickFix;
import com.android.tools.idea.lint.LintIdeJavaParser;
import com.android.tools.idea.lint.LintIdeUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.LintInspectionBridge;
import com.android.tools.lint.checks.PermissionFinder;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.checks.SupportAnnotationDetector;
import com.android.tools.lint.checks.VersionChecks;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByJavaCommentFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressForClassFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressLocalWithCommentFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressParameterFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import lombok.ast.NullLiteral;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.inspections.FloatRangeConstraint;
import org.jetbrains.android.inspections.IntRangeConstraint;
import org.jetbrains.android.inspections.RangeAllowedValues;
import org.jetbrains.android.inspections.SizeConstraint;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceTypeInspection
extends AbstractBaseJavaLocalInspectionTool
implements CustomSuppressableInspectionTool {
    private static final Key<Map<String, PsiExpression>> LITERAL_EXPRESSION_CACHE = Key.create((String)"TYPE_DEF_LITERAL_EXPRESSION");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        AndroidFacet facet;
        if (holder == null) {
            ResourceTypeInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ResourceTypeInspection.$$$reportNull$$$0(1);
        }
        if ((facet = AndroidFacet.getInstance((PsiElement)holder.getFile())) == null) {
            PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){};
            if (psiElementVisitor == null) {
                ResourceTypeInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){
            private LintIdeJavaParser.LintPsiJavaEvaluator myEvaluator;
            {
                this.myEvaluator = new LintIdeJavaParser.LintPsiJavaEvaluator(holder.getProject());
            }

            public void visitCallExpression(PsiCallExpression callExpression) {
                ResourceTypeInspection.checkCall((PsiCall)callExpression, holder, this.myEvaluator);
            }

            public void visitEnumConstant(PsiEnumConstant enumConstant) {
                ResourceTypeInspection.checkCall((PsiCall)enumConstant, holder, this.myEvaluator);
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                PsiExpression r = expression.getRExpression();
                if (r == null) {
                    return;
                }
                PsiExpression l = expression.getLExpression();
                if (l instanceof PsiArrayAccessExpression) {
                    l = ((PsiArrayAccessExpression)l).getArrayExpression();
                }
                if (!(l instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiElement resolved = ((PsiReferenceExpression)l).resolve();
                if (!(resolved instanceof PsiModifierListOwner)) {
                    return;
                }
                PsiModifierListOwner owner = (PsiModifierListOwner)resolved;
                PsiType type = expression.getType();
                ResourceTypeInspection.checkExpression(r, owner, type, holder);
            }

            public void visitReturnStatement(PsiReturnStatement statement) {
                PsiMethod method;
                PsiExpression value = statement.getReturnValue();
                if (value == null) {
                    return;
                }
                PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                PsiMethod psiMethod = method = element instanceof PsiMethod ? (PsiMethod)element : LambdaUtil.getFunctionalInterfaceMethod((PsiElement)element);
                if (method == null) {
                    return;
                }
                ResourceTypeInspection.checkExpression(value, (PsiModifierListOwner)method, value.getType(), holder);
            }

            public void visitNameValuePair(PsiNameValuePair pair) {
                PsiAnnotationMemberValue value = pair.getValue();
                if (!(value instanceof PsiExpression)) {
                    return;
                }
                PsiReference ref = pair.getReference();
                if (ref == null) {
                    return;
                }
                PsiMethod method = (PsiMethod)ref.resolve();
                if (method == null) {
                    return;
                }
                ResourceTypeInspection.checkExpression((PsiExpression)value, (PsiModifierListOwner)method, method.getReturnType(), holder);
            }

            public void visitBinaryExpression(PsiBinaryExpression expression) {
                IElementType tokenType = expression.getOperationTokenType();
                if (tokenType != JavaTokenType.EQEQ && tokenType != JavaTokenType.NE) {
                    return;
                }
                PsiExpression l = expression.getLOperand();
                PsiExpression r = expression.getROperand();
                if (r == null) {
                    return;
                }
                this.checkBinary(l, r);
                this.checkBinary(r, l);
            }

            private void checkBinary(PsiExpression l, PsiExpression r) {
                PsiMethod method;
                if (l instanceof PsiReference) {
                    PsiElement resolved = ((PsiReference)l).resolve();
                    if (resolved instanceof PsiModifierListOwner) {
                        ResourceTypeInspection.checkExpression(r, (PsiModifierListOwner)resolved, ResourceTypeInspection.getType((PsiModifierListOwner)resolved), holder);
                    }
                } else if (l instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)l).resolveMethod()) != null) {
                    ResourceTypeInspection.checkExpression(r, (PsiModifierListOwner)method, method.getReturnType(), holder);
                }
            }
        };
        if (javaElementVisitor == null) {
            ResourceTypeInspection.$$$reportNull$$$0(3);
        }
        return javaElementVisitor;
    }

    private static void checkExpression(@NotNull PsiExpression expression, @NotNull PsiModifierListOwner owner, @Nullable PsiType type, @NotNull ProblemsHolder holder) {
        Constraints allowed;
        if (expression == null) {
            ResourceTypeInspection.$$$reportNull$$$0(4);
        }
        if (owner == null) {
            ResourceTypeInspection.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            ResourceTypeInspection.$$$reportNull$$$0(6);
        }
        if ((allowed = ResourceTypeInspection.getAllowedValues(owner, type, null)) == null) {
            return;
        }
        PsiElement scope = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)expression, null);
        if (scope == null) {
            scope = expression;
        }
        ResourceTypeInspection.checkConstraints(scope, expression, allowed, holder);
    }

    private static void checkConstraints(@NotNull PsiElement scope, @NotNull PsiExpression expression, @NotNull Constraints constraints, @NotNull ProblemsHolder holder) {
        if (scope == null) {
            ResourceTypeInspection.$$$reportNull$$$0(7);
        }
        if (expression == null) {
            ResourceTypeInspection.$$$reportNull$$$0(8);
        }
        if (constraints == null) {
            ResourceTypeInspection.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            ResourceTypeInspection.$$$reportNull$$$0(10);
        }
        if (expression.getTextRange().isEmpty()) {
            return;
        }
        PsiManager manager = expression.getManager();
        if (constraints.next != null && ExpressionUtils.isLiteral((PsiExpression)expression)) {
            InspectionResult result = ResourceTypeInspection.isAllowed(scope, expression, constraints, manager, null);
            if (result.isInvalid() && ResourceTypeInspection.isAllowed(scope, expression, constraints.next, manager, null).isInvalid()) {
                ResourceTypeInspection.registerProblem(result.getErrorNode(), constraints, holder);
            }
        } else {
            InspectionResult result = ResourceTypeInspection.isAllowed(scope, expression, constraints, manager, null);
            if (result.isInvalid()) {
                ResourceTypeInspection.registerProblem(result.getErrorNode(), constraints, holder);
            }
        }
    }

    private static void checkCall(@NotNull PsiCall methodCall, @NotNull ProblemsHolder holder, JavaEvaluator evaluator) {
        PsiMethod method;
        if (methodCall == null) {
            ResourceTypeInspection.$$$reportNull$$$0(11);
        }
        if (holder == null) {
            ResourceTypeInspection.$$$reportNull$$$0(12);
        }
        if ((method = methodCall.resolveMethod()) == null) {
            return;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length > 0) {
            PsiExpressionList argumentList = methodCall.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            int parametersIdx = 0;
            for (int i = 0; i < arguments.length && parametersIdx < parameters.length; ++i) {
                Constraints values;
                PsiParameter parameter = parameters[parametersIdx];
                if (!(parameter.getType() instanceof PsiEllipsisType)) {
                    ++parametersIdx;
                }
                if ((values = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)parameter, parameter.getType(), null)) == null) continue;
                if (i >= arguments.length) break;
                PsiExpression argument = arguments[i];
                if ((argument = PsiUtil.deparenthesizeExpression((PsiExpression)argument)) == null) continue;
                ResourceTypeInspection.checkConstraints(parameter.getDeclarationScope(), argument, values, holder);
            }
        }
        ResourceTypeInspection.checkMethodAnnotations(methodCall, holder, method, evaluator);
    }

    private static void checkMethodAnnotations(@NotNull PsiCall methodCall, @NotNull ProblemsHolder holder, @NotNull PsiMethod method, JavaEvaluator evaluator) {
        PsiClass cls;
        PsiElement resolved;
        PsiJavaCodeReferenceElement ref;
        String qualifiedName;
        PsiAnnotation[] classAnnotations;
        if (methodCall == null) {
            ResourceTypeInspection.$$$reportNull$$$0(13);
        }
        if (holder == null) {
            ResourceTypeInspection.$$$reportNull$$$0(14);
        }
        if (method == null) {
            ResourceTypeInspection.$$$reportNull$$$0(15);
        }
        PsiAnnotation[] methodAnnotations = ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)method);
        PsiAnnotation[] packageAnnotations = null;
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null) {
            boolean isStatic = method.hasModifierProperty("static");
            classAnnotations = isStatic ? ResourceTypeInspection.getLocalAnnotations((PsiModifierListOwner)containingClass) : ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)containingClass);
            String pkgName = containingClass.getQualifiedName();
            String simpleName = containingClass.getName();
            if (pkgName != null && simpleName != null && pkgName.length() > simpleName.length()) {
                pkgName = pkgName.substring(0, pkgName.length() - simpleName.length() - 1);
                PsiPackage pkg = JavaPsiFacade.getInstance((Project)methodCall.getProject()).findPackage(pkgName);
                if (pkg != null) {
                    packageAnnotations = ResourceTypeInspection.getLocalAnnotations((PsiModifierListOwner)pkg);
                }
            }
        } else {
            classAnnotations = PsiAnnotation.EMPTY_ARRAY;
        }
        for (PsiAnnotation annotation : methodAnnotations) {
            qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null) continue;
            if (!qualifiedName.startsWith("android.support.annotation.")) {
                if (qualifiedName.startsWith("java.lang")) continue;
                ref = annotation.getNameReferenceElement();
                PsiElement psiElement = resolved = ref == null ? null : ref.resolve();
                if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
                cls = (PsiClass)resolved;
                for (PsiAnnotation a : ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)cls)) {
                    Constraints constraints;
                    PsiMethodCallExpression equalsCall;
                    PsiExpression[] arguments;
                    PsiElement parent2;
                    PsiReferenceExpression expression;
                    PsiElement name;
                    qualifiedName = a.getQualifiedName();
                    if (qualifiedName != null && qualifiedName.endsWith("android.support.annotation.RequiresPermission")) {
                        ResourceTypeInspection.checkPermissionRequirement(methodCall, holder, method, a);
                        continue;
                    }
                    if (!"android.support.annotation.StringDef".equals(qualifiedName)) continue;
                    PsiElement parent = methodCall.getParent();
                    PsiType type = method.getReturnType();
                    if (type == null || !(parent instanceof PsiReferenceExpression) || (name = (expression = (PsiReferenceExpression)parent).getReferenceNameElement()) == null || !"equals".equals(name.getText()) || !((parent2 = parent.getParent()) instanceof PsiMethodCallExpression) || (arguments = (equalsCall = (PsiMethodCallExpression)parent2).getArgumentList().getExpressions()).length != 1 || (constraints = ResourceTypeInspection.getAllowedValuesFromTypedef(type, a, methodCall.getManager())) == null) continue;
                    ResourceTypeInspection.checkConstraints(parent2, arguments[0], constraints, holder);
                }
                continue;
            }
            if ("android.support.annotation.RequiresPermission".equals(qualifiedName)) {
                ResourceTypeInspection.checkPermissionRequirement(methodCall, holder, method, annotation);
                continue;
            }
            if ("android.support.annotation.CheckResult".equals(qualifiedName)) {
                ResourceTypeInspection.checkReturnValueUsage(methodCall, holder, method);
                continue;
            }
            if (qualifiedName.endsWith("Thread") && qualifiedName.startsWith("android.support.annotation.")) {
                ResourceTypeInspection.checkThreadAnnotation(methodCall, holder, method, annotation, qualifiedName, methodAnnotations, classAnnotations);
                continue;
            }
            if ("android.support.annotation.RequiresApi".equals(qualifiedName)) {
                ResourceTypeInspection.checkApiLevel(methodCall, method, holder, annotation, methodAnnotations, classAnnotations);
                continue;
            }
            if ("android.support.annotation.RestrictTo".equals(qualifiedName)) {
                ResourceTypeInspection.checkRestrictionAnnotation(methodCall, holder, method, annotation, methodAnnotations, classAnnotations, evaluator);
                continue;
            }
            if (!"android.support.annotation.VisibleForTesting".equals(qualifiedName)) continue;
            ResourceTypeInspection.checkVisibleForTestAnnotation(methodCall, holder, method, annotation, methodAnnotations, classAnnotations, evaluator);
        }
        if (classAnnotations.length > 0) {
            for (PsiAnnotation annotation : classAnnotations) {
                qualifiedName = annotation.getQualifiedName();
                if (qualifiedName == null) continue;
                if (qualifiedName.endsWith("Thread") && qualifiedName.startsWith("android.support.annotation.")) {
                    ResourceTypeInspection.checkThreadAnnotation(methodCall, holder, method, annotation, qualifiedName, methodAnnotations, classAnnotations);
                    continue;
                }
                if ("android.support.annotation.RequiresApi".equals(qualifiedName)) {
                    ResourceTypeInspection.checkApiLevel(methodCall, method, holder, annotation, methodAnnotations, classAnnotations);
                    continue;
                }
                if ("android.support.annotation.RestrictTo".equals(qualifiedName)) {
                    ResourceTypeInspection.checkRestrictionAnnotation(methodCall, holder, method, annotation, methodAnnotations, classAnnotations, evaluator);
                    continue;
                }
                if ("android.support.annotation.VisibleForTesting".equals(qualifiedName)) {
                    ResourceTypeInspection.checkVisibleForTestAnnotation(methodCall, holder, method, annotation, methodAnnotations, classAnnotations, evaluator);
                    continue;
                }
                if (qualifiedName.startsWith("java.lang")) continue;
                ref = annotation.getNameReferenceElement();
                PsiElement psiElement = resolved = ref == null ? null : ref.resolve();
                if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
                cls = (PsiClass)resolved;
                for (PsiAnnotation a : ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)cls)) {
                    qualifiedName = a.getQualifiedName();
                    if (qualifiedName == null || !qualifiedName.endsWith("android.support.annotation.RequiresPermission")) continue;
                    ResourceTypeInspection.checkPermissionRequirement(methodCall, holder, method, a);
                }
            }
        }
        if (packageAnnotations != null) {
            for (PsiAnnotation annotation : packageAnnotations) {
                qualifiedName = annotation.getQualifiedName();
                if (qualifiedName == null) continue;
                if ("android.support.annotation.RestrictTo".equals(qualifiedName)) {
                    ResourceTypeInspection.checkRestrictionAnnotation(methodCall, holder, method, annotation, methodAnnotations, classAnnotations, evaluator);
                    continue;
                }
                if (!"android.support.annotation.VisibleForTesting".equals(qualifiedName)) continue;
                ResourceTypeInspection.checkVisibleForTestAnnotation(methodCall, holder, method, annotation, methodAnnotations, classAnnotations, evaluator);
            }
        }
    }

    private static void checkApiLevel(@NotNull PsiCall methodCall, @NotNull PsiMethod method, @NotNull ProblemsHolder holder, @NotNull PsiAnnotation annotation, @NotNull PsiAnnotation[] allMethodAnnotations, PsiAnnotation[] allClassAnnotations) {
        int api;
        PsiAnnotationOwner owner;
        if (methodCall == null) {
            ResourceTypeInspection.$$$reportNull$$$0(16);
        }
        if (method == null) {
            ResourceTypeInspection.$$$reportNull$$$0(17);
        }
        if (holder == null) {
            ResourceTypeInspection.$$$reportNull$$$0(18);
        }
        if (annotation == null) {
            ResourceTypeInspection.$$$reportNull$$$0(19);
        }
        if (allMethodAnnotations == null) {
            ResourceTypeInspection.$$$reportNull$$$0(20);
        }
        if ((owner = annotation.getOwner()) == null || !method.getModifierList().equals(owner) && (method.getContainingClass() == null || !owner.equals(method.getContainingClass().getModifierList()))) {
            return;
        }
        if (SupportAnnotationDetector.containsAnnotation((PsiAnnotation[])allClassAnnotations, (PsiAnnotation)annotation) && SupportAnnotationDetector.containsAnnotation((PsiAnnotation[])allMethodAnnotations, (String)"android.support.annotation.RequiresApi")) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)methodCall);
        assert (facet != null);
        AndroidVersion minSdkVersion = AndroidModuleInfo.get(facet).getMinSdkVersion();
        PsiAnnotationMemberValue apiValue = annotation.findAttributeValue("value");
        if (apiValue == null || (int)ResourceTypeInspection.getLongValue((PsiElement)apiValue, 1L) == 1) {
            apiValue = annotation.findAttributeValue("api");
        }
        if ((api = (int)ResourceTypeInspection.getLongValue((PsiElement)apiValue, 1L)) <= 1) {
            return;
        }
        int minSdk = minSdkVersion.getFeatureLevel();
        if (api <= minSdk) {
            return;
        }
        int target = ApiDetector.getTargetApi((PsiElement)methodCall);
        if (target != -1 && api <= target) {
            return;
        }
        if (LintIdeUtils.isSuppressed((PsiElement)methodCall, ApiDetector.UNSUPPORTED)) {
            return;
        }
        if (VersionChecks.isWithinVersionCheckConditional((PsiElement)methodCall, (int)api)) {
            return;
        }
        if (VersionChecks.isPrecededByVersionCheckExit((PsiElement)methodCall, (int)api)) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        String fqcn = containingClass != null ? containingClass.getQualifiedName() : "";
        String message = String.format("Call requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn + '#' + method.getName());
        AndroidLintQuickFix.LocalFixWrapper versionCheck = new AndroidLintQuickFix.LocalFixWrapper(new AddTargetVersionCheckQuickFix(api), (PsiElement)methodCall, (PsiElement)methodCall);
        AndroidLintQuickFix.LocalFixWrapper addTargetApiQuickFix = new AndroidLintQuickFix.LocalFixWrapper(new AddTargetApiQuickFix(api, false, (PsiElement)methodCall), (PsiElement)methodCall, (PsiElement)methodCall);
        AndroidLintQuickFix.LocalFixWrapper addRequiresApiQuickFix = new AndroidLintQuickFix.LocalFixWrapper(new AddTargetApiQuickFix(api, true, (PsiElement)methodCall), (PsiElement)methodCall, (PsiElement)methodCall);
        ResourceTypeInspection.registerProblem(holder, ApiDetector.UNSUPPORTED, (PsiElement)methodCall, message, new LocalQuickFix[]{versionCheck, addRequiresApiQuickFix, addTargetApiQuickFix});
    }

    @Nullable
    private static PermissionFinder.Result search(PsiElement node, PermissionFinder.Operation operation) {
        block23: {
            PsiElement resolved;
            block24: {
                block22: {
                    if (node instanceof NullLiteral) {
                        return null;
                    }
                    if (!(node instanceof PsiTypeCastExpression)) break block22;
                    PsiTypeCastExpression cast = (PsiTypeCastExpression)node;
                    PsiExpression operand = cast.getOperand();
                    if (operand != null) {
                        return ResourceTypeInspection.search((PsiElement)operand, operation);
                    }
                    break block23;
                }
                if (node instanceof PsiNewExpression && operation == PermissionFinder.Operation.ACTION) {
                    PsiExpression[] expressions;
                    PsiExpressionList argumentList;
                    String qualifiedName;
                    PsiNewExpression call = (PsiNewExpression)node;
                    PsiJavaCodeReferenceElement classOrAnonymousClassReference = call.getClassOrAnonymousClassReference();
                    if (classOrAnonymousClassReference != null && "android.content.Intent".equals(qualifiedName = classOrAnonymousClassReference.getQualifiedName()) && (argumentList = call.getArgumentList()) != null && (expressions = argumentList.getExpressions()).length > 0) {
                        return ResourceTypeInspection.search((PsiElement)expressions[0], operation);
                    }
                    return null;
                }
                if (!(node instanceof PsiJavaReference)) break block23;
                resolved = ((PsiJavaReference)node).resolve();
                if (!(resolved instanceof PsiField)) break block24;
                PsiField field = (PsiField)resolved;
                if (operation == PermissionFinder.Operation.ACTION) {
                    for (PsiAnnotation annotation : ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)field)) {
                        if (!"android.support.annotation.RequiresPermission".equals(annotation.getQualifiedName())) continue;
                        return ResourceTypeInspection.getPermissionRequirement(field, annotation, operation);
                    }
                } else if (operation == PermissionFinder.Operation.READ || operation == PermissionFinder.Operation.WRITE) {
                    PsiExpression[] expressions;
                    PsiMethodCallExpression call;
                    String fqn = operation == PermissionFinder.Operation.READ ? "android.support.annotation.RequiresPermission.Read" : "android.support.annotation.RequiresPermission.Write";
                    PsiAnnotation annotation = null;
                    for (PsiAnnotation a : ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)field)) {
                        if (!fqn.equals(a.getQualifiedName())) continue;
                        annotation = null;
                        if (AnnotationUtil.isExternalAnnotation((PsiAnnotation)a)) {
                            annotation = a;
                            break;
                        }
                        PsiAnnotationMemberValue o = a.findAttributeValue("value");
                        if (o instanceof PsiAnnotation && "android.support.annotation.RequiresPermission".equals((annotation = (PsiAnnotation)o).getQualifiedName())) break;
                    }
                    if (annotation != null) {
                        return ResourceTypeInspection.getPermissionRequirement(field, annotation, operation);
                    }
                    PsiExpression initializer = field.getInitializer();
                    if (initializer instanceof PsiMethodCallExpression && (call = (PsiMethodCallExpression)initializer).getMethodExpression().getQualifiedName().equals("Uri.withAppendedPath") && (expressions = call.getArgumentList().getExpressions()).length == 2) {
                        return ResourceTypeInspection.search((PsiElement)expressions[0], operation);
                    }
                } else assert (false) : operation;
                break block23;
            }
            if (!(resolved instanceof PsiLocalVariable)) break block23;
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PsiStatement.class, (boolean)false);
            while (statement != null) {
                PsiBinaryExpression binary;
                if (statement instanceof PsiDeclarationStatement) {
                    PsiElement[] declaredElements;
                    PsiDeclarationStatement declaration = (PsiDeclarationStatement)statement;
                    for (PsiElement declared : declaredElements = declaration.getDeclaredElements()) {
                        PsiExpression initializer;
                        if (declared != resolved || !(declared instanceof PsiLocalVariable) || (initializer = ((PsiLocalVariable)declared).getInitializer()) == null) continue;
                        return ResourceTypeInspection.search((PsiElement)initializer, operation);
                    }
                } else if (statement instanceof PsiExpressionStatement) {
                    PsiExpression value;
                    PsiElement variable;
                    PsiAssignmentExpression assignment;
                    PsiExpression expression = ((PsiExpressionStatement)statement).getExpression();
                    if (expression instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)expression).getLExpression() instanceof PsiReferenceExpression && (variable = ((PsiReferenceExpression)assignment.getLExpression()).resolve()) == resolved && (value = assignment.getRExpression()) != null) {
                        return ResourceTypeInspection.search((PsiElement)value, operation);
                    }
                } else if (statement instanceof PsiBinaryExpression && (binary = (PsiBinaryExpression)statement).getOperationTokenType() == JavaTokenType.EQ && binary.getLOperand() == resolved && binary.getROperand() != null) {
                    return ResourceTypeInspection.search((PsiElement)binary.getROperand(), operation);
                }
                statement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
            }
        }
        return null;
    }

    private static PermissionFinder.Result getPermissionRequirement(PsiField field, PsiAnnotation annotation, PermissionFinder.Operation operation) {
        PermissionRequirement requirement = PermissionRequirement.create((PsiAnnotation)annotation);
        PsiClass containingClass = field.getContainingClass();
        String name = containingClass != null ? containingClass.getName() + "." + field.getName() : field.getName();
        return new PermissionFinder.Result(operation, requirement, StringUtil.notNullize((String)name));
    }

    private static void checkRestrictionAnnotation(@NotNull PsiCall methodCall, @NotNull ProblemsHolder holder, @NotNull PsiMethod method, @NotNull PsiAnnotation annotation, @NotNull PsiAnnotation[] allMethodAnnotations, PsiAnnotation[] allClassAnnotations, JavaEvaluator evaluator) {
        if (methodCall == null) {
            ResourceTypeInspection.$$$reportNull$$$0(21);
        }
        if (holder == null) {
            ResourceTypeInspection.$$$reportNull$$$0(22);
        }
        if (method == null) {
            ResourceTypeInspection.$$$reportNull$$$0(23);
        }
        if (annotation == null) {
            ResourceTypeInspection.$$$reportNull$$$0(24);
        }
        if (allMethodAnnotations == null) {
            ResourceTypeInspection.$$$reportNull$$$0(25);
        }
        MyLintInspectionBridge bridge = new MyLintInspectionBridge((PsiElement)methodCall, holder, evaluator);
        SupportAnnotationDetector.checkRestrictTo((LintInspectionBridge)bridge, (PsiElement)methodCall, (PsiMethod)method, (PsiAnnotation)annotation, (PsiAnnotation[])allMethodAnnotations, (PsiAnnotation[])allClassAnnotations);
    }

    private static void checkVisibleForTestAnnotation(@NotNull PsiCall methodCall, @NotNull ProblemsHolder holder, @NotNull PsiMethod method, @NotNull PsiAnnotation annotation, @NotNull PsiAnnotation[] allMethodAnnotations, PsiAnnotation[] allClassAnnotations, JavaEvaluator evaluator) {
        if (methodCall == null) {
            ResourceTypeInspection.$$$reportNull$$$0(26);
        }
        if (holder == null) {
            ResourceTypeInspection.$$$reportNull$$$0(27);
        }
        if (method == null) {
            ResourceTypeInspection.$$$reportNull$$$0(28);
        }
        if (annotation == null) {
            ResourceTypeInspection.$$$reportNull$$$0(29);
        }
        if (allMethodAnnotations == null) {
            ResourceTypeInspection.$$$reportNull$$$0(30);
        }
        MyLintInspectionBridge bridge = new MyLintInspectionBridge((PsiElement)methodCall, holder, evaluator);
        SupportAnnotationDetector.checkVisibleForTesting((LintInspectionBridge)bridge, (PsiElement)methodCall, (PsiMethod)method, (PsiAnnotation)annotation, (PsiAnnotation[])allMethodAnnotations, (PsiAnnotation[])allClassAnnotations);
    }

    private static void checkThreadAnnotation(@NotNull PsiCall methodCall, @NotNull ProblemsHolder holder, @NotNull PsiMethod method, @NotNull PsiAnnotation annotation, @NotNull String qualifiedName, @NotNull PsiAnnotation[] allMethodAnnotations, PsiAnnotation[] allClassAnnotations) {
        List<String> threadContext;
        if (methodCall == null) {
            ResourceTypeInspection.$$$reportNull$$$0(31);
        }
        if (holder == null) {
            ResourceTypeInspection.$$$reportNull$$$0(32);
        }
        if (method == null) {
            ResourceTypeInspection.$$$reportNull$$$0(33);
        }
        if (annotation == null) {
            ResourceTypeInspection.$$$reportNull$$$0(34);
        }
        if (qualifiedName == null) {
            ResourceTypeInspection.$$$reportNull$$$0(35);
        }
        if (allMethodAnnotations == null) {
            ResourceTypeInspection.$$$reportNull$$$0(36);
        }
        if ((threadContext = ResourceTypeInspection.getThreadContext(methodCall)) != null && !SupportAnnotationDetector.isCompatibleThread(threadContext, (String)qualifiedName)) {
            String name;
            PsiClass containingClass = method.getContainingClass();
            if (SupportAnnotationDetector.containsAnnotation((PsiAnnotation[])allClassAnnotations, (PsiAnnotation)annotation)) {
                if (SupportAnnotationDetector.containsThreadingAnnotation((PsiAnnotation[])allMethodAnnotations)) {
                    return;
                }
            } else {
                assert (SupportAnnotationDetector.containsAnnotation((PsiAnnotation[])allMethodAnnotations, (PsiAnnotation)annotation));
                Boolean isFirst = null;
                for (PsiAnnotation other : allMethodAnnotations) {
                    if (other == annotation) {
                        if (isFirst != null) continue;
                        isFirst = true;
                        continue;
                    }
                    if (!SupportAnnotationDetector.isThreadingAnnotation((PsiAnnotation)other)) continue;
                    if (isFirst == null) {
                        return;
                    }
                    String s = other.getQualifiedName();
                    if (s == null || !SupportAnnotationDetector.isCompatibleThread(threadContext, (String)s)) continue;
                    return;
                }
            }
            if ((name = method.getName()).startsWith("post") && containingClass != null && "android.view.View".equals(containingClass.getQualifiedName())) {
                return;
            }
            List<String> targetThreads = ResourceTypeInspection.getThreads(method);
            if (targetThreads == null) {
                targetThreads = Collections.singletonList(qualifiedName);
            }
            String message = String.format("Method %1$s must be called from the %2$s thread, currently inferred thread is %3$s", method.getName(), SupportAnnotationDetector.describeThreads(targetThreads, (boolean)true), SupportAnnotationDetector.describeThreads(threadContext, (boolean)false));
            ResourceTypeInspection.registerProblem(holder, SupportAnnotationDetector.THREAD, (PsiElement)methodCall, message, new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static List<String> getThreadContext(PsiCall methodCall) {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiAnonymousClass.class, PsiLambdaExpression.class});
        return ResourceTypeInspection.getThreads(method);
    }

    public static List<String> getThreads(@Nullable PsiMethod method) {
        if (method != null) {
            PsiAnnotation[] annotations;
            ArrayList<String> result = null;
            for (PsiAnnotation annotation : annotations = ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)method)) {
                String qualifiedName = annotation.getQualifiedName();
                if (qualifiedName == null || !qualifiedName.startsWith("android.support.annotation.") || !qualifiedName.endsWith("Thread")) continue;
                if (result == null) {
                    result = new ArrayList<String>(4);
                }
                result.add(qualifiedName);
            }
            if (result != null) {
                return result;
            }
            PsiClass cls = method.getContainingClass();
            if (cls != null) {
                for (PsiAnnotation annotation : annotations = ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)cls)) {
                    String qualifiedName = annotation.getQualifiedName();
                    if (qualifiedName == null || !qualifiedName.startsWith("android.support.annotation.") || !qualifiedName.endsWith("Thread")) continue;
                    if (result == null) {
                        result = new ArrayList(4);
                    }
                    result.add(qualifiedName);
                }
                if (result != null) {
                    return result;
                }
            }
        }
        return null;
    }

    private static void checkPermissionRequirement(@NotNull PsiCall methodCall, @NotNull ProblemsHolder holder, @Nullable PsiMethod method, @NotNull PsiAnnotation annotation) {
        if (methodCall == null) {
            ResourceTypeInspection.$$$reportNull$$$0(37);
        }
        if (holder == null) {
            ResourceTypeInspection.$$$reportNull$$$0(38);
        }
        if (annotation == null) {
            ResourceTypeInspection.$$$reportNull$$$0(39);
        }
        PermissionRequirement requirement = PermissionRequirement.create((PsiAnnotation)annotation);
        ResourceTypeInspection.checkPermissionRequirement(methodCall, holder, method, null, requirement);
    }

    private static void checkPermissionRequirement(@NotNull PsiCall methodCall, @NotNull ProblemsHolder holder, @Nullable PsiMethod method, @Nullable PermissionFinder.Result result, PermissionRequirement requirement) {
        if (methodCall == null) {
            ResourceTypeInspection.$$$reportNull$$$0(40);
        }
        if (holder == null) {
            ResourceTypeInspection.$$$reportNull$$$0(41);
        }
        if (!requirement.isConditional()) {
            Project project = methodCall.getProject();
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)methodCall);
            assert (facet != null);
            PermissionHolder lookup = MergedManifest.get(facet.getModule()).getPermissionHolder();
            if (!requirement.isSatisfied(lookup)) {
                String methodName;
                PermissionFinder.Operation operation;
                if (requirement.isSatisfied(lookup = ResourceTypeInspection.addLocalPermissions(lookup, methodCall))) {
                    return;
                }
                if (result != null) {
                    operation = result.operation;
                    methodName = result.name;
                } else {
                    assert (method != null);
                    operation = PermissionFinder.Operation.CALL;
                    PsiClass containingClass = method.getContainingClass();
                    methodName = containingClass != null ? containingClass.getName() + "." + method.getName() : method.getName();
                }
                String message = SupportAnnotationDetector.getMissingPermissionMessage((PermissionRequirement)requirement, (String)methodName, (PermissionHolder)lookup, (PermissionFinder.Operation)operation);
                LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                ArrayList list = Lists.newArrayList();
                for (String permissionName : requirement.getMissingPermissions(lookup)) {
                    list.add(new AddPermissionFix(facet, permissionName, requirement));
                }
                if (!list.isEmpty()) {
                    fixes = list.toArray(new LocalQuickFix[list.size()]);
                }
                ResourceTypeInspection.registerProblem(holder, SupportAnnotationDetector.MISSING_PERMISSION, (PsiElement)methodCall, message, fixes);
            } else if (requirement.isRevocable(lookup) && AndroidModuleInfo.get(facet).getTargetSdkVersion().getFeatureLevel() >= 23 && requirement.getLastApplicableApi() >= 23) {
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                PsiClass securityException = psiFacade.findClass("java.lang.SecurityException", GlobalSearchScope.allScope((Project)project));
                if (securityException != null && ResourceTypeInspection.isHandled((PsiElement)methodCall, PsiTypesUtil.getClassType((PsiClass)securityException), (PsiElement)methodCall.getContainingFile())) {
                    return;
                }
                PsiMethod methodNode = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true);
                if (methodNode != null) {
                    for (PsiMethodCallExpression call : PsiTreeUtil.collectElementsOfType((PsiElement)methodNode, (Class[])new Class[]{PsiMethodCallExpression.class})) {
                        String name = call.getMethodExpression().getReferenceName();
                        if (name == null || !name.endsWith("Permission") || !name.startsWith("check") && !name.startsWith("enforce")) continue;
                        return;
                    }
                    Set revocablePermissions = requirement.getRevocablePermissions(lookup);
                    AddCheckPermissionFix fix = new AddCheckPermissionFix(facet, requirement, methodCall, revocablePermissions);
                    ResourceTypeInspection.registerProblem(holder, SupportAnnotationDetector.MISSING_PERMISSION, (PsiElement)methodCall, SupportAnnotationDetector.getUnhandledPermissionMessage(), fix);
                }
            }
        }
    }

    @NotNull
    private static PermissionHolder addLocalPermissions(@NotNull PermissionHolder lookup, @NotNull PsiCall call) {
        PsiMethod method;
        if (lookup == null) {
            ResourceTypeInspection.$$$reportNull$$$0(42);
        }
        if (call == null) {
            ResourceTypeInspection.$$$reportNull$$$0(43);
        }
        if ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class)) == null) {
            PermissionHolder permissionHolder = lookup;
            if (permissionHolder == null) {
                ResourceTypeInspection.$$$reportNull$$$0(44);
            }
            return permissionHolder;
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Collections.singleton("android.support.annotation.RequiresPermission"));
        if (annotation == null) {
            PermissionHolder permissionHolder = lookup;
            if (permissionHolder == null) {
                ResourceTypeInspection.$$$reportNull$$$0(45);
            }
            return permissionHolder;
        }
        PermissionRequirement requirement = PermissionRequirement.create((PsiAnnotation)annotation);
        PermissionHolder permissionHolder = PermissionHolder.SetPermissionLookup.join((PermissionHolder)lookup, (PermissionRequirement)requirement);
        if (permissionHolder == null) {
            ResourceTypeInspection.$$$reportNull$$$0(46);
        }
        return permissionHolder;
    }

    private static void checkReturnValueUsage(@NotNull PsiCall methodCall, ProblemsHolder holder, PsiMethod method) {
        if (methodCall == null) {
            ResourceTypeInspection.$$$reportNull$$$0(47);
        }
        if (methodCall.getParent() instanceof PsiExpressionStatement) {
            String suggest;
            PsiLiteral literal;
            Object literalValue;
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"android.support.annotation.CheckResult"});
            if (annotation == null) {
                return;
            }
            String message = String.format("The result of '%1$s' is not used", method.getName());
            PsiAnnotationMemberValue value = annotation.findAttributeValue("suggest");
            if (value instanceof PsiLiteral && (literalValue = (literal = (PsiLiteral)value).getValue()) instanceof String && !(suggest = (String)literalValue).isEmpty()) {
                String name = StringUtil.trimStart((String)suggest, (String)"#");
                message = String.format("The result of '%1$s' is not used; did you mean to call '%2$s'?", method.getName(), name);
                if (suggest.startsWith("#") && methodCall instanceof PsiMethodCallExpression) {
                    ResourceTypeInspection.registerProblem(holder, SupportAnnotationDetector.CHECK_RESULT, (PsiElement)methodCall, message, new ReplaceCallFix((PsiMethodCallExpression)methodCall, suggest));
                    return;
                }
            }
            ResourceTypeInspection.registerProblem(holder, SupportAnnotationDetector.CHECK_RESULT, (PsiElement)methodCall, message, new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static Constraints getAllowedValuesFromTypedef(@NotNull PsiType type, @NotNull PsiAnnotation magic, @NotNull PsiManager manager) {
        boolean canBeOred;
        PsiAnnotationMemberValue[] allowedValues;
        boolean isString;
        if (type == null) {
            ResourceTypeInspection.$$$reportNull$$$0(48);
        }
        if (magic == null) {
            ResourceTypeInspection.$$$reportNull$$$0(49);
        }
        if (manager == null) {
            ResourceTypeInspection.$$$reportNull$$$0(50);
        }
        if (type instanceof PsiEllipsisType) {
            type = ((PsiEllipsisType)type).getComponentType();
        } else if (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
        }
        boolean isInt = TypeConversionUtil.getTypeRank((PsiType)type) <= 5;
        boolean bl = isString = !isInt && type.equals(PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)manager.getProject())));
        if (isInt || isString) {
            PsiAnnotationMemberValue orValue;
            PsiAnnotationMemberValue intValues = magic.findAttributeValue("value");
            PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = allowedValues = intValues instanceof PsiArrayInitializerMemberValue ? ((PsiArrayInitializerMemberValue)intValues).getInitializers() : PsiAnnotationMemberValue.EMPTY_ARRAY;
            canBeOred = isInt ? (orValue = magic.findAttributeValue("flag")) instanceof PsiLiteral && Boolean.TRUE.equals(((PsiLiteral)orValue).getValue()) : false;
        } else {
            return null;
        }
        if (allowedValues.length != 0) {
            return new AllowedValues(allowedValues, canBeOred);
        }
        return null;
    }

    @Nullable
    public static ResourceType getResourceTypeFromAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            ResourceTypeInspection.$$$reportNull$$$0(51);
        }
        String resourceTypeName = Character.toLowerCase(qualifiedName.charAt("android.support.annotation.".length())) + qualifiedName.substring("android.support.annotation.".length() + 1, qualifiedName.length() - "Res".length());
        return ResourceType.getEnum((String)resourceTypeName);
    }

    @Nullable
    private static Constraints merge(@Nullable Constraints head, @Nullable Constraints tail) {
        if (head != null) {
            if (tail != null) {
                head.next = tail;
                if (tail instanceof AllowedValues) {
                    head.next = tail.next;
                    tail.next = head;
                    head = tail;
                }
                return head;
            }
            return head;
        }
        return tail;
    }

    @Nullable
    public static Constraints getAllowedValues(@NotNull PsiModifierListOwner element, @Nullable PsiType type, @Nullable Set<PsiClass> visited) {
        if (element == null) {
            ResourceTypeInspection.$$$reportNull$$$0(52);
        }
        PsiAnnotation[] annotations = ResourceTypeInspection.getAllAnnotations(element);
        PsiManager manager = element.getManager();
        ArrayList resourceTypes = null;
        Constraints constraint = null;
        for (PsiAnnotation annotation : annotations) {
            PsiElement resolved;
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null) continue;
            if (qualifiedName.startsWith("android.support.annotation.") || qualifiedName.startsWith("test.pkg.")) {
                ResourceType resourceType;
                if ("android.support.annotation.IntDef".equals(qualifiedName) || "android.support.annotation.StringDef".equals(qualifiedName)) {
                    if (type != null && !(annotation instanceof PsiCompiledElement)) {
                        constraint = ResourceTypeInspection.merge(ResourceTypeInspection.getAllowedValuesFromTypedef(type, annotation, manager), constraint);
                    }
                } else if ("android.support.annotation.IntRange".equals(qualifiedName) || "test.pkg.IntRange".equals(qualifiedName)) {
                    constraint = ResourceTypeInspection.merge(new IntRangeConstraint(annotation), constraint);
                } else if ("android.support.annotation.FloatRange".equals(qualifiedName)) {
                    constraint = ResourceTypeInspection.merge(new FloatRangeConstraint(annotation), constraint);
                } else if ("android.support.annotation.Size".equals(qualifiedName)) {
                    constraint = ResourceTypeInspection.merge(new SizeConstraint(annotation), constraint);
                } else if ("android.support.annotation.ColorInt".equals(qualifiedName)) {
                    constraint = ResourceTypeInspection.merge(new ResourceTypeAllowedValues(Collections.singletonList(ResourceEvaluator.COLOR_INT_MARKER_TYPE)), constraint);
                } else if ("android.support.annotation.Px".equals(qualifiedName) || "android.support.annotation.Dimension".equals(qualifiedName)) {
                    constraint = ResourceTypeInspection.merge(new ResourceTypeAllowedValues(Collections.singletonList(ResourceEvaluator.DIMENSION_MARKER_TYPE)), constraint);
                } else if (qualifiedName.startsWith("android.support.annotation.RequiresPermission")) {
                    constraint = ResourceTypeInspection.merge(new IndirectPermission(qualifiedName), constraint);
                } else if (qualifiedName.endsWith("Res") && (resourceType = ResourceTypeInspection.getResourceTypeFromAnnotation(qualifiedName)) != null) {
                    if (resourceTypes == null) {
                        resourceTypes = Lists.newArrayList();
                    }
                    resourceTypes.add(resourceType);
                }
            }
            if (constraint != null) continue;
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            PsiElement psiElement = resolved = ref == null ? null : ref.resolve();
            if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
            PsiClass aClass = (PsiClass)resolved;
            if (visited == null) {
                visited = new THashSet();
            }
            if (!visited.add((PsiClass)aClass)) continue;
            constraint = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)aClass, type, (Set<PsiClass>)visited);
        }
        if (resourceTypes != null) {
            constraint = ResourceTypeInspection.merge(new ResourceTypeAllowedValues(resourceTypes), constraint);
        }
        return constraint;
    }

    @NotNull
    public static PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            ResourceTypeInspection.$$$reportNull$$$0(53);
        }
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)element, () -> {
            if (element == null) {
                ResourceTypeInspection.$$$reportNull$$$0(168);
            }
            return CachedValueProvider.Result.create((Object)AnnotationUtil.getAllAnnotations((PsiModifierListOwner)element, (boolean)true, null), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (psiAnnotationArray == null) {
            ResourceTypeInspection.$$$reportNull$$$0(54);
        }
        return psiAnnotationArray;
    }

    @NotNull
    public static PsiAnnotation[] getLocalAnnotations(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            ResourceTypeInspection.$$$reportNull$$$0(55);
        }
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)element, () -> {
            if (element == null) {
                ResourceTypeInspection.$$$reportNull$$$0(167);
            }
            return CachedValueProvider.Result.create((Object)AnnotationUtil.getAllAnnotations((PsiModifierListOwner)element, (boolean)false, null), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (psiAnnotationArray == null) {
            ResourceTypeInspection.$$$reportNull$$$0(56);
        }
        return psiAnnotationArray;
    }

    @Nullable
    private static PsiType getType(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            ResourceTypeInspection.$$$reportNull$$$0(57);
        }
        return element instanceof PsiVariable ? ((PsiVariable)element).getType() : (element instanceof PsiMethod ? ((PsiMethod)element).getReturnType() : null);
    }

    private static void registerProblem(@NotNull PsiExpression argument, @NotNull Constraints constraint, @NotNull ProblemsHolder holder) {
        if (argument == null) {
            ResourceTypeInspection.$$$reportNull$$$0(58);
        }
        if (constraint == null) {
            ResourceTypeInspection.$$$reportNull$$$0(59);
        }
        if (holder == null) {
            ResourceTypeInspection.$$$reportNull$$$0(60);
        }
        if (constraint instanceof IndirectPermission) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)argument, PsiMethodCallExpression.class);
            IndirectPermission ip = (IndirectPermission)constraint;
            if (call != null && ip.result != null) {
                ResourceTypeInspection.checkPermissionRequirement((PsiCall)call, holder, null, ip.result, ip.result.requirement);
            }
        } else if (constraint instanceof ResourceTypeAllowedValues) {
            String message;
            PsiExpression qualifier;
            PsiExpressionList argumentList;
            Issue issue = SupportAnnotationDetector.RESOURCE_TYPE;
            List<ResourceType> types = ((ResourceTypeAllowedValues)constraint).types;
            if (types.contains(ResourceType.STYLEABLE) && types.size() == 1 && (argumentList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)argument, PsiExpressionList.class, (boolean)true)) != null && argumentList.getParent() instanceof PsiMethodCallExpression && (qualifier = ((PsiMethodCallExpression)argumentList.getParent()).getMethodExpression().getQualifierExpression()) != null && qualifier.getType() != null && "android.content.res.TypedArray".equals(qualifier.getType().getCanonicalText()) && SupportAnnotationDetector.typeArrayFromArrayLiteral((PsiElement)qualifier)) {
                return;
            }
            if (types.size() == 1) {
                if (types.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE)) {
                    message = String.format("Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`", argument.getText());
                    issue = SupportAnnotationDetector.COLOR_USAGE;
                } else {
                    message = types.contains(ResourceEvaluator.DIMENSION_MARKER_TYPE) ? String.format("Should pass resolved pixel dimension instead of resource id here: `getResources().getDimension*(%1$s)`", argument.getText()) : "Expected resource of type " + types.get(0);
                }
            } else {
                message = "Expected resource type to be one of " + Joiner.on((String)", ").join(types);
            }
            ResourceTypeInspection.registerProblem(holder, issue, (PsiElement)argument, message, new LocalQuickFix[0]);
        } else if (constraint instanceof RangeAllowedValues) {
            String message = ((RangeAllowedValues)constraint).describe(argument);
            ResourceTypeInspection.registerProblem(holder, SupportAnnotationDetector.RANGE, (PsiElement)argument, message, new LocalQuickFix[0]);
        } else {
            assert (constraint instanceof AllowedValues);
            AllowedValues typedef = (AllowedValues)constraint;
            Function formatter = value -> {
                PsiElement resolved;
                if (value instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)value).resolve()) instanceof PsiVariable) {
                    return PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)resolved), (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                }
                return value.getText();
            };
            String values = StringUtil.join((Object[])typedef.values, (Function)formatter, (String)", ");
            String message = typedef.canBeOred ? "Must be one or more of: " + values : "Must be one of: " + values;
            if (constraint.next instanceof RangeAllowedValues) {
                message = message + " or " + StringUtil.decapitalize((String)((RangeAllowedValues)constraint.next).describe(argument));
            }
            ResourceTypeInspection.registerProblem(holder, SupportAnnotationDetector.TYPE_DEF, (PsiElement)argument, message, new LocalQuickFix[0]);
        }
    }

    @NotNull
    private static InspectionResult isAllowed(@NotNull PsiElement scope, @NotNull PsiExpression argument, @NotNull Constraints constraints, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        if (scope == null) {
            ResourceTypeInspection.$$$reportNull$$$0(61);
        }
        if (argument == null) {
            ResourceTypeInspection.$$$reportNull$$$0(62);
        }
        if (constraints == null) {
            ResourceTypeInspection.$$$reportNull$$$0(63);
        }
        if (manager == null) {
            ResourceTypeInspection.$$$reportNull$$$0(64);
        }
        if (constraints instanceof ResourceTypeAllowedValues) {
            InspectionResult inspectionResult = ResourceTypeInspection.isResourceTypeAllowed(scope, argument, (ResourceTypeAllowedValues)constraints, manager, visited);
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(65);
            }
            return inspectionResult;
        }
        if (constraints instanceof RangeAllowedValues) {
            InspectionResult inspectionResult = ResourceTypeInspection.isInRange(scope, argument, (RangeAllowedValues)constraints, manager, visited);
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(66);
            }
            return inspectionResult;
        }
        if (constraints instanceof IndirectPermission) {
            InspectionResult inspectionResult = ResourceTypeInspection.isGrantedPermission(argument, (IndirectPermission)constraints);
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(67);
            }
            return inspectionResult;
        }
        assert (constraints instanceof AllowedValues);
        AllowedValues a = (AllowedValues)constraints;
        InspectionResult result = ResourceTypeInspection.isGoodExpression(argument, a, scope, manager, visited);
        if (result.isValid()) {
            InspectionResult inspectionResult = result;
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(68);
            }
            return inspectionResult;
        }
        InspectionResult flowResult = ResourceTypeInspection.processValuesFlownTo(argument, scope, manager, (Function<PsiExpression, InspectionResult>)((Function)expression -> {
            if (scope == null) {
                ResourceTypeInspection.$$$reportNull$$$0(165);
            }
            if (manager == null) {
                ResourceTypeInspection.$$$reportNull$$$0(166);
            }
            return ResourceTypeInspection.isGoodExpression(expression, a, scope, manager, visited);
        }));
        if (flowResult.isUncertain()) {
            InspectionResult inspectionResult = result;
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(69);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = flowResult;
        if (inspectionResult == null) {
            ResourceTypeInspection.$$$reportNull$$$0(70);
        }
        return inspectionResult;
    }

    private static InspectionResult checkArrayInitializerExpression(@NotNull PsiArrayInitializerExpression e, @NotNull AllowedValues allowedValues, @NotNull PsiElement scope, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        if (e == null) {
            ResourceTypeInspection.$$$reportNull$$$0(71);
        }
        if (allowedValues == null) {
            ResourceTypeInspection.$$$reportNull$$$0(72);
        }
        if (scope == null) {
            ResourceTypeInspection.$$$reportNull$$$0(73);
        }
        if (manager == null) {
            ResourceTypeInspection.$$$reportNull$$$0(74);
        }
        for (PsiExpression arrayValueExpression : e.getInitializers()) {
            InspectionResult result = ResourceTypeInspection.isGoodExpression(arrayValueExpression, allowedValues, scope, manager, visited).useErrorNode(arrayValueExpression);
            if (!result.isInvalid()) continue;
            return result;
        }
        return InspectionResult.valid();
    }

    private static InspectionResult isGoodExpression(@NotNull PsiExpression e, @NotNull AllowedValues allowedValues, @NotNull PsiElement scope, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        Constraints allowedForRef;
        PsiExpression expression;
        if (e == null) {
            ResourceTypeInspection.$$$reportNull$$$0(75);
        }
        if (allowedValues == null) {
            ResourceTypeInspection.$$$reportNull$$$0(76);
        }
        if (scope == null) {
            ResourceTypeInspection.$$$reportNull$$$0(77);
        }
        if (manager == null) {
            ResourceTypeInspection.$$$reportNull$$$0(78);
        }
        if ((expression = PsiUtil.deparenthesizeExpression((PsiExpression)e)) == null) {
            return InspectionResult.valid();
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiExpression)expression)) {
            return InspectionResult.valid();
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expression).getThenExpression();
            if (thenExpression != null && ResourceTypeInspection.isAllowed(scope, thenExpression, allowedValues, manager, (Set<PsiExpression>)visited).isInvalid()) {
                return InspectionResult.invalid(thenExpression);
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expression).getElseExpression();
            return elseExpression == null || !ResourceTypeInspection.isAllowed(scope, elseExpression, allowedValues, manager, (Set<PsiExpression>)visited).isInvalid() ? InspectionResult.valid() : InspectionResult.invalid(elseExpression);
        }
        if (expression instanceof PsiNewExpression) {
            PsiArrayInitializerExpression arrayInitializerExpression = ((PsiNewExpression)expression).getArrayInitializer();
            if (arrayInitializerExpression != null) {
                return ResourceTypeInspection.checkArrayInitializerExpression(arrayInitializerExpression, allowedValues, scope, manager, (Set<PsiExpression>)visited);
            }
        } else if (expression instanceof PsiArrayInitializerExpression) {
            return ResourceTypeInspection.checkArrayInitializerExpression((PsiArrayInitializerExpression)expression, allowedValues, scope, manager, (Set<PsiExpression>)visited);
        }
        if (ResourceTypeInspection.isOneOf(expression, allowedValues, manager)) {
            return InspectionResult.valid();
        }
        if (allowedValues.canBeOred) {
            IElementType tokenType;
            PsiExpression zero = ResourceTypeInspection.getLiteralExpression(expression, manager, "0");
            if (ResourceTypeInspection.same((PsiElement)expression, (PsiElement)zero, manager)) {
                return InspectionResult.valid();
            }
            PsiExpression one = ResourceTypeInspection.getLiteralExpression(expression, manager, "-1");
            if (ResourceTypeInspection.same((PsiElement)expression, (PsiElement)one, manager)) {
                return InspectionResult.valid();
            }
            if (expression instanceof PsiPolyadicExpression && (JavaTokenType.OR.equals(tokenType = ((PsiPolyadicExpression)expression).getOperationTokenType()) || JavaTokenType.AND.equals(tokenType) || JavaTokenType.PLUS.equals(tokenType))) {
                for (PsiExpression operand : ((PsiPolyadicExpression)expression).getOperands()) {
                    if (!ResourceTypeInspection.isAllowed(scope, operand, allowedValues, manager, (Set<PsiExpression>)visited).isInvalid()) continue;
                    return InspectionResult.invalid(operand);
                }
                return InspectionResult.valid();
            }
            if (expression instanceof PsiPrefixExpression && JavaTokenType.TILDE.equals(((PsiPrefixExpression)expression).getOperationTokenType())) {
                PsiExpression operand = ((PsiPrefixExpression)expression).getOperand();
                if (operand == null) {
                    return InspectionResult.valid();
                }
                return ResourceTypeInspection.isAllowed(scope, operand, allowedValues, manager, (Set<PsiExpression>)visited);
            }
        }
        PsiElement resolved = null;
        if (expression instanceof PsiReference) {
            resolved = ((PsiReference)expression).resolve();
        } else if (expression instanceof PsiCallExpression) {
            resolved = ((PsiCallExpression)expression).resolveMethod();
        }
        if (resolved instanceof PsiModifierListOwner && (allowedForRef = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)resolved, ResourceTypeInspection.getType((PsiModifierListOwner)resolved), null)) != null && allowedForRef.isSubsetOf(allowedValues, manager)) {
            return InspectionResult.valid();
        }
        return PsiType.NULL.equals((Object)expression.getType()) ? InspectionResult.valid() : InspectionResult.invalid(expression);
    }

    static long getLongValue(@Nullable PsiElement value, long defaultValue) {
        PsiElement resolved;
        Object o;
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof PsiLiteral) {
            o = ((PsiLiteral)value).getValue();
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
        } else if (value instanceof PsiPrefixExpression) {
            Object o2;
            PsiExpression operand;
            PsiPrefixExpression exp = (PsiPrefixExpression)value;
            if (exp.getOperationTokenType() == JavaTokenType.MINUS && (operand = exp.getOperand()) instanceof PsiLiteral && (o2 = ((PsiLiteral)operand).getValue()) instanceof Number) {
                return -((Number)o2).longValue();
            }
        } else if (value instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)value).resolve()) instanceof PsiField) {
            return ResourceTypeInspection.getLongValue((PsiElement)((PsiField)resolved).getInitializer(), defaultValue);
        }
        if (value instanceof PsiExpression && (o = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiExpression)value), (boolean)false)) instanceof Number) {
            return ((Number)o).longValue();
        }
        return defaultValue;
    }

    static double getDoubleValue(@Nullable PsiAnnotationMemberValue value, double defaultValue) {
        PsiElement resolved;
        Object o;
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof PsiLiteral) {
            o = ((PsiLiteral)value).getValue();
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
        } else if (value instanceof PsiPrefixExpression) {
            Object o2;
            PsiExpression operand;
            PsiPrefixExpression exp = (PsiPrefixExpression)value;
            if (exp.getOperationTokenType() == JavaTokenType.MINUS && (operand = exp.getOperand()) instanceof PsiLiteral && (o2 = ((PsiLiteral)operand).getValue()) instanceof Number) {
                return -((Number)o2).doubleValue();
            }
        } else if (value instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)value).resolve()) instanceof PsiField) {
            return ResourceTypeInspection.getDoubleValue((PsiAnnotationMemberValue)((PsiField)resolved).getInitializer(), defaultValue);
        }
        if (value instanceof PsiExpression && (o = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiExpression)value), (boolean)false)) instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return defaultValue;
    }

    static boolean getBooleanValue(@Nullable PsiAnnotationMemberValue value, boolean defaultValue) {
        Object o;
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof PsiLiteral && (o = ((PsiLiteral)value).getValue()) instanceof Boolean) {
            return (Boolean)o;
        }
        return defaultValue;
    }

    @NotNull
    private static InspectionResult isResourceTypeAllowed(@NotNull PsiElement scope, @NotNull PsiExpression argument, @NotNull ResourceTypeAllowedValues allowedValues, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        InspectionResult result;
        if (scope == null) {
            ResourceTypeInspection.$$$reportNull$$$0(79);
        }
        if (argument == null) {
            ResourceTypeInspection.$$$reportNull$$$0(80);
        }
        if (allowedValues == null) {
            ResourceTypeInspection.$$$reportNull$$$0(81);
        }
        if (manager == null) {
            ResourceTypeInspection.$$$reportNull$$$0(82);
        }
        if (!(result = ResourceTypeInspection.isValidResourceTypeExpression(argument, allowedValues, scope, manager, visited)).isUncertain()) {
            InspectionResult inspectionResult = result;
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(83);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = ResourceTypeInspection.processValuesFlownTo(argument, scope, manager, (Function<PsiExpression, InspectionResult>)((Function)expression -> {
            if (allowedValues == null) {
                ResourceTypeInspection.$$$reportNull$$$0(162);
            }
            if (scope == null) {
                ResourceTypeInspection.$$$reportNull$$$0(163);
            }
            if (manager == null) {
                ResourceTypeInspection.$$$reportNull$$$0(164);
            }
            return ResourceTypeInspection.isValidResourceTypeExpression(expression, allowedValues, scope, manager, visited);
        }));
        if (inspectionResult == null) {
            ResourceTypeInspection.$$$reportNull$$$0(84);
        }
        return inspectionResult;
    }

    @NotNull
    private static InspectionResult isValidResourceTypeExpression(@NotNull PsiExpression e, @NotNull ResourceTypeAllowedValues allowedValues, @NotNull PsiElement scope, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        PsiType type;
        Constraints allowedForRef;
        Object value;
        PsiPrefixExpression ppe;
        PsiExpression r;
        PsiExpression expression;
        if (e == null) {
            ResourceTypeInspection.$$$reportNull$$$0(85);
        }
        if (allowedValues == null) {
            ResourceTypeInspection.$$$reportNull$$$0(86);
        }
        if (scope == null) {
            ResourceTypeInspection.$$$reportNull$$$0(87);
        }
        if (manager == null) {
            ResourceTypeInspection.$$$reportNull$$$0(88);
        }
        if ((expression = PsiUtil.deparenthesizeExpression((PsiExpression)e)) == null) {
            InspectionResult inspectionResult = InspectionResult.valid();
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(89);
            }
            return inspectionResult;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiExpression)expression)) {
            InspectionResult inspectionResult = InspectionResult.valid();
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(90);
            }
            return inspectionResult;
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expression).getThenExpression();
            if (thenExpression != null && ResourceTypeInspection.isAllowed(scope, thenExpression, allowedValues, manager, (Set<PsiExpression>)visited).isInvalid()) {
                InspectionResult inspectionResult = InspectionResult.invalid(thenExpression);
                if (inspectionResult == null) {
                    ResourceTypeInspection.$$$reportNull$$$0(91);
                }
                return inspectionResult;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expression).getElseExpression();
            InspectionResult inspectionResult = elseExpression == null || !ResourceTypeInspection.isAllowed(scope, elseExpression, allowedValues, manager, (Set<PsiExpression>)visited).isInvalid() ? InspectionResult.valid() : InspectionResult.invalid(expression);
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(92);
            }
            return inspectionResult;
        }
        if (expression instanceof PsiReferenceExpression) {
            String typeName;
            PsiReferenceExpression typeDef;
            PsiReferenceExpression refExpression = (PsiReferenceExpression)expression;
            PsiExpression qualifierExpression = refExpression.getQualifierExpression();
            if (qualifierExpression instanceof PsiReferenceExpression && (r = (typeDef = (PsiReferenceExpression)qualifierExpression).getQualifierExpression()) instanceof PsiReferenceExpression && "R".equals(((PsiReferenceExpression)r).getReferenceName()) && (typeName = typeDef.getReferenceName()) != null) {
                InspectionResult inspectionResult = allowedValues.isTypeAllowed(typeName) ? InspectionResult.valid() : InspectionResult.invalid(expression);
                if (inspectionResult == null) {
                    ResourceTypeInspection.$$$reportNull$$$0(93);
                }
                return inspectionResult;
            }
        } else if (expression instanceof PsiLiteral) {
            Object value2;
            if (expression instanceof PsiLiteralExpression) {
                PsiElement outerMost;
                PsiElement parent = expression.getParent();
                if (parent instanceof PsiField && (parent = parent.getParent()) instanceof PsiClass && (outerMost = parent.getParent()) instanceof PsiClass && "R".equals(((PsiClass)outerMost).getName())) {
                    PsiClass typeClass = (PsiClass)parent;
                    String typeClassName = typeClass.getName();
                    InspectionResult inspectionResult = typeClassName != null && allowedValues.isTypeAllowed(typeClassName) ? InspectionResult.valid() : InspectionResult.invalid(expression);
                    if (inspectionResult == null) {
                        ResourceTypeInspection.$$$reportNull$$$0(94);
                    }
                    return inspectionResult;
                }
                if (allowedValues.types.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE) && PsiType.INT.equals((Object)expression.getType())) {
                    InspectionResult inspectionResult = InspectionResult.valid();
                    if (inspectionResult == null) {
                        ResourceTypeInspection.$$$reportNull$$$0(95);
                    }
                    return inspectionResult;
                }
                if (allowedValues.types.contains(ResourceEvaluator.DIMENSION_MARKER_TYPE) && PsiType.INT.equals((Object)expression.getType())) {
                    InspectionResult inspectionResult = InspectionResult.valid();
                    if (inspectionResult == null) {
                        ResourceTypeInspection.$$$reportNull$$$0(96);
                    }
                    return inspectionResult;
                }
            }
            if ((value2 = ((PsiLiteral)expression).getValue()) instanceof Integer) {
                InspectionResult inspectionResult = (Integer)value2 == 0 ? InspectionResult.valid() : InspectionResult.invalid(expression);
                if (inspectionResult == null) {
                    ResourceTypeInspection.$$$reportNull$$$0(97);
                }
                return inspectionResult;
            }
        } else if (expression instanceof PsiPrefixExpression && (ppe = (PsiPrefixExpression)expression).getOperationTokenType() == JavaTokenType.MINUS && ppe.getOperand() instanceof PsiLiteral && (value = ((PsiLiteral)ppe.getOperand()).getValue()) instanceof Integer) {
            InspectionResult inspectionResult = (Integer)value == 1 ? InspectionResult.valid() : InspectionResult.invalid(expression);
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(98);
            }
            return inspectionResult;
        }
        PsiElement resolved = null;
        if (expression instanceof PsiReference) {
            ResourceType type2;
            PsiField field;
            PsiClass containingClass;
            resolved = ((PsiReference)expression).resolve();
            if (resolved instanceof PsiField && (containingClass = (field = (PsiField)resolved).getContainingClass()) != null && (r = containingClass.getContainingClass()) != null && "R".equals(r.getName()) && (type2 = ResourceType.getEnum((String)containingClass.getName())) != null) {
                if (allowedValues.isTypeAllowed(type2)) {
                    InspectionResult inspectionResult = InspectionResult.valid();
                    if (inspectionResult == null) {
                        ResourceTypeInspection.$$$reportNull$$$0(99);
                    }
                    return inspectionResult;
                }
                InspectionResult inspectionResult = InspectionResult.invalid(expression);
                if (inspectionResult == null) {
                    ResourceTypeInspection.$$$reportNull$$$0(100);
                }
                return inspectionResult;
            }
        } else if (expression instanceof PsiCallExpression) {
            resolved = ((PsiCallExpression)expression).resolveMethod();
        }
        if (resolved instanceof PsiModifierListOwner && (allowedForRef = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)resolved, type = ResourceTypeInspection.getType((PsiModifierListOwner)resolved), null)) instanceof ResourceTypeAllowedValues) {
            InspectionResult inspectionResult = allowedValues.isCompatibleWith((ResourceTypeAllowedValues)allowedForRef) ? InspectionResult.valid() : InspectionResult.invalid(expression);
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(101);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = InspectionResult.uncertain();
        if (inspectionResult == null) {
            ResourceTypeInspection.$$$reportNull$$$0(102);
        }
        return inspectionResult;
    }

    @NotNull
    private static InspectionResult isInRange(@NotNull PsiElement scope, @NotNull PsiExpression argument, @NotNull RangeAllowedValues allowedValues, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        InspectionResult result;
        if (scope == null) {
            ResourceTypeInspection.$$$reportNull$$$0(103);
        }
        if (argument == null) {
            ResourceTypeInspection.$$$reportNull$$$0(104);
        }
        if (allowedValues == null) {
            ResourceTypeInspection.$$$reportNull$$$0(105);
        }
        if (manager == null) {
            ResourceTypeInspection.$$$reportNull$$$0(106);
        }
        if (!(result = ResourceTypeInspection.isValidRangeExpression(argument, argument, allowedValues, scope, manager, visited)).isUncertain()) {
            InspectionResult inspectionResult = result;
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(107);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = ResourceTypeInspection.processValuesFlownTo(argument, scope, manager, (Function<PsiExpression, InspectionResult>)((Function)expression -> {
            if (argument == null) {
                ResourceTypeInspection.$$$reportNull$$$0(158);
            }
            if (allowedValues == null) {
                ResourceTypeInspection.$$$reportNull$$$0(159);
            }
            if (scope == null) {
                ResourceTypeInspection.$$$reportNull$$$0(160);
            }
            if (manager == null) {
                ResourceTypeInspection.$$$reportNull$$$0(161);
            }
            return ResourceTypeInspection.isValidRangeExpression(expression, argument, allowedValues, scope, manager, visited);
        }));
        if (inspectionResult == null) {
            ResourceTypeInspection.$$$reportNull$$$0(108);
        }
        return inspectionResult;
    }

    private static boolean comparesReference(@NotNull PsiElement reference, @Nullable PsiExpression expression) {
        if (reference == null) {
            ResourceTypeInspection.$$$reportNull$$$0(109);
        }
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binary = (PsiBinaryExpression)expression;
            IElementType tokenType = binary.getOperationTokenType();
            if (tokenType == JavaTokenType.GE || tokenType == JavaTokenType.GT || tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE || tokenType == JavaTokenType.EQ) {
                PsiExpression lOperand = binary.getLOperand();
                PsiExpression rOperand = binary.getROperand();
                if (lOperand instanceof PsiReferenceExpression) {
                    return reference.equals(((PsiReferenceExpression)lOperand).resolve());
                }
                if (rOperand instanceof PsiReferenceExpression) {
                    return reference.equals(((PsiReferenceExpression)rOperand).resolve());
                }
            } else if (tokenType == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR) {
                return ResourceTypeInspection.comparesReference(reference, binary.getLOperand()) || ResourceTypeInspection.comparesReference(reference, binary.getROperand());
            }
        }
        return false;
    }

    @NotNull
    private static InspectionResult isValidRangeExpression(@NotNull PsiExpression e, @Nullable PsiExpression argument, @NotNull RangeAllowedValues allowedValues, @NotNull PsiElement scope, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        PsiType type;
        Constraints allowedForRef;
        PsiExpression condition;
        PsiElement resolved;
        PsiIfStatement ifStatement;
        PsiExpression expression;
        if (e == null) {
            ResourceTypeInspection.$$$reportNull$$$0(110);
        }
        if (allowedValues == null) {
            ResourceTypeInspection.$$$reportNull$$$0(111);
        }
        if (scope == null) {
            ResourceTypeInspection.$$$reportNull$$$0(112);
        }
        if (manager == null) {
            ResourceTypeInspection.$$$reportNull$$$0(113);
        }
        if ((expression = PsiUtil.deparenthesizeExpression((PsiExpression)e)) == null) {
            InspectionResult inspectionResult = InspectionResult.valid();
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(114);
            }
            return inspectionResult;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiExpression)expression)) {
            InspectionResult inspectionResult = InspectionResult.valid();
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(115);
            }
            return inspectionResult;
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expression).getThenExpression();
            if (thenExpression != null && ResourceTypeInspection.isAllowed(scope, thenExpression, allowedValues, manager, (Set<PsiExpression>)visited).isInvalid()) {
                InspectionResult inspectionResult = InspectionResult.invalid(expression);
                if (inspectionResult == null) {
                    ResourceTypeInspection.$$$reportNull$$$0(116);
                }
                return inspectionResult;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expression).getElseExpression();
            InspectionResult inspectionResult = elseExpression == null || !ResourceTypeInspection.isAllowed(scope, elseExpression, allowedValues, manager, (Set<PsiExpression>)visited).isInvalid() ? InspectionResult.valid() : InspectionResult.invalid(expression);
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(117);
            }
            return inspectionResult;
        }
        if (e != argument && argument instanceof PsiReferenceExpression && (ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)argument, PsiIfStatement.class, (boolean)true)) != null && (resolved = ((PsiReferenceExpression)argument).resolve()) != null && ResourceTypeInspection.comparesReference(resolved, condition = ifStatement.getCondition())) {
            InspectionResult inspectionResult = InspectionResult.uncertain();
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(118);
            }
            return inspectionResult;
        }
        InspectionResult fieldValid = allowedValues.isValid(expression);
        if (!fieldValid.isUncertain()) {
            InspectionResult inspectionResult = fieldValid;
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(119);
            }
            return inspectionResult;
        }
        resolved = null;
        if (expression instanceof PsiReference) {
            PsiField field;
            resolved = ((PsiReference)expression).resolve();
            if (resolved instanceof PsiField && (field = (PsiField)resolved).getInitializer() != null && !(fieldValid = allowedValues.isValid(field.getInitializer())).isUncertain()) {
                PsiExpression condition2;
                PsiIfStatement ifStatement2;
                if (fieldValid.isInvalid() && argument != null && (ifStatement2 = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)argument, PsiIfStatement.class, (boolean)true)) != null && ResourceTypeInspection.comparesReference(resolved, condition2 = ifStatement2.getCondition())) {
                    InspectionResult inspectionResult = InspectionResult.uncertain();
                    if (inspectionResult == null) {
                        ResourceTypeInspection.$$$reportNull$$$0(120);
                    }
                    return inspectionResult;
                }
                InspectionResult inspectionResult = fieldValid;
                if (inspectionResult == null) {
                    ResourceTypeInspection.$$$reportNull$$$0(121);
                }
                return inspectionResult;
            }
        } else if (expression instanceof PsiNewExpression || expression instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializerExpression;
            PsiArrayInitializerExpression psiArrayInitializerExpression = arrayInitializerExpression = expression instanceof PsiNewExpression ? ((PsiNewExpression)expression).getArrayInitializer() : (PsiArrayInitializerExpression)expression;
            if (arrayInitializerExpression != null) {
                for (PsiExpression initializer : arrayInitializerExpression.getInitializers()) {
                    if (!ResourceTypeInspection.isAllowed(scope, initializer, allowedValues, manager, (Set<PsiExpression>)visited).isInvalid()) continue;
                    InspectionResult inspectionResult = InspectionResult.invalid(expression);
                    if (inspectionResult == null) {
                        ResourceTypeInspection.$$$reportNull$$$0(122);
                    }
                    return inspectionResult;
                }
            }
        } else if (expression instanceof PsiCallExpression) {
            resolved = ((PsiCallExpression)expression).resolveMethod();
        }
        if (resolved instanceof PsiModifierListOwner && (allowedForRef = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)resolved, type = ResourceTypeInspection.getType((PsiModifierListOwner)resolved), null)) instanceof RangeAllowedValues) {
            InspectionResult inspectionResult = allowedValues.contains((RangeAllowedValues)allowedForRef).useErrorNode(expression);
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(123);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = InspectionResult.uncertain();
        if (inspectionResult == null) {
            ResourceTypeInspection.$$$reportNull$$$0(124);
        }
        return inspectionResult;
    }

    @NotNull
    private static InspectionResult isGrantedPermission(@NotNull PsiExpression argument, @NotNull IndirectPermission permission) {
        PsiMethodCallExpression call;
        if (argument == null) {
            ResourceTypeInspection.$$$reportNull$$$0(125);
        }
        if (permission == null) {
            ResourceTypeInspection.$$$reportNull$$$0(126);
        }
        if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)argument, PsiMethodCallExpression.class)) != null) {
            PermissionFinder.Operation operation;
            String signature = permission.signature;
            if (signature.equals("android.support.annotation.RequiresPermission.Read")) {
                operation = PermissionFinder.Operation.READ;
            } else if (signature.equals("android.support.annotation.RequiresPermission.Write")) {
                operation = PermissionFinder.Operation.WRITE;
            } else {
                PsiType type = argument.getType();
                if (type == null || !"android.content.Intent".equals(type.getCanonicalText())) {
                    InspectionResult inspectionResult = InspectionResult.valid();
                    if (inspectionResult == null) {
                        ResourceTypeInspection.$$$reportNull$$$0(127);
                    }
                    return inspectionResult;
                }
                operation = PermissionFinder.Operation.ACTION;
            }
            permission.result = ResourceTypeInspection.search((PsiElement)argument, operation);
            if (permission.result != null) {
                InspectionResult inspectionResult = InspectionResult.invalid(argument);
                if (inspectionResult == null) {
                    ResourceTypeInspection.$$$reportNull$$$0(128);
                }
                return inspectionResult;
            }
        }
        InspectionResult inspectionResult = InspectionResult.valid();
        if (inspectionResult == null) {
            ResourceTypeInspection.$$$reportNull$$$0(129);
        }
        return inspectionResult;
    }

    private static PsiExpression getLiteralExpression(@NotNull PsiExpression context, @NotNull PsiManager manager, @NotNull String text) {
        PsiExpression expression;
        Map cache;
        if (context == null) {
            ResourceTypeInspection.$$$reportNull$$$0(130);
        }
        if (manager == null) {
            ResourceTypeInspection.$$$reportNull$$$0(131);
        }
        if (text == null) {
            ResourceTypeInspection.$$$reportNull$$$0(132);
        }
        if ((cache = (Map)LITERAL_EXPRESSION_CACHE.get((UserDataHolder)manager)) == null) {
            cache = ContainerUtil.createConcurrentSoftValueMap();
            cache = (Map)manager.putUserDataIfAbsent(LITERAL_EXPRESSION_CACHE, (Object)cache);
        }
        if ((expression = (PsiExpression)cache.get(text)) == null) {
            expression = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText(text, (PsiElement)context);
            cache.put(text, expression);
        }
        return expression;
    }

    private static boolean isOneOf(@NotNull PsiExpression expression, @NotNull AllowedValues allowedValues, @NotNull PsiManager manager) {
        if (expression == null) {
            ResourceTypeInspection.$$$reportNull$$$0(133);
        }
        if (allowedValues == null) {
            ResourceTypeInspection.$$$reportNull$$$0(134);
        }
        if (manager == null) {
            ResourceTypeInspection.$$$reportNull$$$0(135);
        }
        for (PsiAnnotationMemberValue allowedValue : allowedValues.values) {
            if (!ResourceTypeInspection.same((PsiElement)allowedValue, (PsiElement)expression, manager)) continue;
            return true;
        }
        return false;
    }

    private static boolean same(@Nullable PsiElement e1, @Nullable PsiElement e2, @NotNull PsiManager manager) {
        if (manager == null) {
            ResourceTypeInspection.$$$reportNull$$$0(136);
        }
        if (e1 instanceof PsiLiteralExpression && e2 instanceof PsiLiteralExpression) {
            return Comparing.equal((Object)((PsiLiteralExpression)e1).getValue(), (Object)((PsiLiteralExpression)e2).getValue());
        }
        if (e1 instanceof PsiPrefixExpression && e2 instanceof PsiPrefixExpression && ((PsiPrefixExpression)e1).getOperationTokenType() == ((PsiPrefixExpression)e2).getOperationTokenType()) {
            return ResourceTypeInspection.same((PsiElement)((PsiPrefixExpression)e1).getOperand(), (PsiElement)((PsiPrefixExpression)e2).getOperand(), manager);
        }
        if (e1 instanceof PsiReference && e2 instanceof PsiReference) {
            e1 = ((PsiReference)e1).resolve();
            e2 = ((PsiReference)e2).resolve();
        }
        return manager.areElementsEquivalent(e2, e1);
    }

    @NotNull
    private static InspectionResult processValuesFlownTo(@NotNull PsiExpression argument, @NotNull PsiElement scope, @NotNull PsiManager manager, @NotNull Function<PsiExpression, InspectionResult> processor) {
        if (argument == null) {
            ResourceTypeInspection.$$$reportNull$$$0(137);
        }
        if (scope == null) {
            ResourceTypeInspection.$$$reportNull$$$0(138);
        }
        if (manager == null) {
            ResourceTypeInspection.$$$reportNull$$$0(139);
        }
        if (processor == null) {
            ResourceTypeInspection.$$$reportNull$$$0(140);
        }
        SliceAnalysisParams params = new SliceAnalysisParams();
        params.dataFlowToThis = true;
        params.scope = new AnalysisScope((SearchScope)new LocalSearchScope(scope), manager.getProject());
        SliceLanguageSupportProvider languageSlicing = LanguageSlicing.getProvider((PsiElement)argument);
        assert (languageSlicing != null);
        SliceRootNode rootNode = new SliceRootNode(manager.getProject(), new DuplicateMap(), languageSlicing.createRootUsage((PsiElement)argument, params));
        Collection children = ((SliceNode)rootNode.getChildren().iterator().next()).getChildren();
        for (AbstractTreeNode child : children) {
            InspectionResult result;
            PsiElement element;
            SliceUsage usage = (SliceUsage)child.getValue();
            if (usage == null || !((element = usage.getElement()) instanceof PsiExpression) || !(result = ((InspectionResult)processor.fun((Object)((PsiExpression)element))).useErrorNode(argument)).isInvalid()) continue;
            InspectionResult inspectionResult = result;
            if (inspectionResult == null) {
                ResourceTypeInspection.$$$reportNull$$$0(141);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = !children.isEmpty() ? InspectionResult.valid() : InspectionResult.uncertain();
        if (inspectionResult == null) {
            ResourceTypeInspection.$$$reportNull$$$0(142);
        }
        return inspectionResult;
    }

    private static boolean isHandled(@Nullable PsiElement element, @NotNull PsiClassType exceptionType, PsiElement topElement) {
        if (exceptionType == null) {
            ResourceTypeInspection.$$$reportNull$$$0(143);
        }
        if (element == null || element.getParent() == topElement || element.getParent() == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            return ResourceTypeInspection.isHandledByMethodThrowsClause(method, exceptionType, PsiSubstitutor.EMPTY);
        }
        if (parent instanceof PsiClass) {
            return parent instanceof PsiAnonymousClass && ResourceTypeInspection.isHandled(parent, exceptionType, topElement);
        }
        if (parent instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            if (tryStatement.getTryBlock() == element && ResourceTypeInspection.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            if (tryStatement.getResourceList() == element && ResourceTypeInspection.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && finallyBlock != null && ResourceTypeInspection.blockCompletesAbruptly(finallyBlock)) {
                return true;
            }
        } else if (parent instanceof PsiFile) {
            return false;
        }
        return ResourceTypeInspection.isHandled(parent, exceptionType, topElement);
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, PsiSubstitutor substitutor) {
        if (method == null) {
            ResourceTypeInspection.$$$reportNull$$$0(144);
        }
        if (exceptionType == null) {
            ResourceTypeInspection.$$$reportNull$$$0(145);
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        return ResourceTypeInspection.isHandledBy(exceptionType, referencedTypes, substitutor);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes, PsiSubstitutor substitutor) {
        if (exceptionType == null) {
            ResourceTypeInspection.$$$reportNull$$$0(146);
        }
        if (referencedTypes == null) {
            ResourceTypeInspection.$$$reportNull$$$0(147);
        }
        for (PsiClassType classType : referencedTypes) {
            PsiType psiType = substitutor.substitute((PsiType)classType);
            if (psiType == null || !psiType.equals(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCaught(@NotNull PsiTryStatement tryStatement, @NotNull PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        PsiCodeBlock finallyBlock;
        if (tryStatement == null) {
            ResourceTypeInspection.$$$reportNull$$$0(148);
        }
        if (exceptionType == null) {
            ResourceTypeInspection.$$$reportNull$$$0(149);
        }
        if ((finallyBlock = tryStatement.getFinallyBlock()) != null && ResourceTypeInspection.blockCompletesAbruptly(finallyBlock)) {
            return true;
        }
        for (PsiParameter parameter : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter.getType();
            if (paramType instanceof PsiDisjunctionType) {
                for (PsiType multiCatchType : ((PsiDisjunctionType)paramType).getDisjunctions()) {
                    if (!multiCatchType.equals(exceptionType)) continue;
                    return true;
                }
                continue;
            }
            if (!paramType.equals(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static boolean blockCompletesAbruptly(@NotNull PsiCodeBlock finallyBlock) {
        if (finallyBlock == null) {
            ResourceTypeInspection.$$$reportNull$$$0(150);
        }
        try {
            ControlFlow flow = ControlFlowFactory.getInstance((Project)finallyBlock.getProject()).getControlFlow((PsiElement)finallyBlock, (ControlFlowPolicy)LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons((ControlFlow)flow, (int)0, (int)flow.getSize());
            if ((completionReasons & 1) == 0) {
                return true;
            }
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return false;
    }

    private static void registerProblem(@NotNull ProblemsHolder holder, @NotNull Issue lintIssue, @NotNull PsiElement psiElement, @NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String message, LocalQuickFix ... fixes) {
        String id;
        SuppressManager suppressManager;
        if (holder == null) {
            ResourceTypeInspection.$$$reportNull$$$0(151);
        }
        if (lintIssue == null) {
            ResourceTypeInspection.$$$reportNull$$$0(152);
        }
        if (psiElement == null) {
            ResourceTypeInspection.$$$reportNull$$$0(153);
        }
        if (message == null) {
            ResourceTypeInspection.$$$reportNull$$$0(154);
        }
        if ((suppressManager = SuppressManager.getInstance()).isSuppressedFor(psiElement, id = lintIssue.getId()) || suppressManager.isSuppressedFor(psiElement, "AndroidLint" + id)) {
            return;
        }
        assert (ResourceTypeInspection.guessLintIssue(message) != null) : message;
        holder.registerProblem(psiElement, message, fixes);
    }

    @Nullable
    private static Issue guessLintIssue(@NotNull String message) {
        if (message == null) {
            ResourceTypeInspection.$$$reportNull$$$0(155);
        }
        if (message.startsWith("Should pass resolved color ")) {
            return SupportAnnotationDetector.COLOR_USAGE;
        }
        if (message.startsWith("Should pass resolved pixel dimension ")) {
            return SupportAnnotationDetector.RESOURCE_TYPE;
        }
        if (message.startsWith("The result of ")) {
            return SupportAnnotationDetector.CHECK_RESULT;
        }
        if (message.startsWith("Call requires permission ") || message.startsWith("Missing permissions ")) {
            return SupportAnnotationDetector.MISSING_PERMISSION;
        }
        if (message.startsWith("Value must ") || message.startsWith("Length ") || message.startsWith("Size ")) {
            return SupportAnnotationDetector.RANGE;
        }
        if (message.startsWith("Must be one ")) {
            return SupportAnnotationDetector.TYPE_DEF;
        }
        if (message.startsWith("Expected resource ")) {
            return SupportAnnotationDetector.RESOURCE_TYPE;
        }
        if (message.contains("must be called from ")) {
            return SupportAnnotationDetector.THREAD;
        }
        if (message.contains("Call requires API ")) {
            return ApiDetector.UNSUPPORTED;
        }
        if (message.contains(" can only be called from ") || message.contains("marked as internal to the support library")) {
            return SupportAnnotationDetector.RESTRICTED;
        }
        if (message.contains(" should only be accessed from tests")) {
            return SupportAnnotationDetector.TEST_VISIBILITY;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalArgumentException(message);
        }
        return null;
    }

    @NotNull
    public SuppressIntentionAction[] getSuppressActions(PsiElement element) {
        String shortName = this.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        SuppressQuickFix[] actions = SuppressManager.getInstance().createBatchSuppressActions(key);
        SuppressIntentionAction[] suppressActions = SuppressIntentionActionFromFix.convertBatchToSuppressIntentionActions((SuppressQuickFix[])actions);
        if (suppressActions.length == actions.length) {
            int index = 0;
            ArrayList replaced = Lists.newArrayListWithExpectedSize((int)suppressActions.length);
            for (SuppressIntentionAction action : suppressActions) {
                replaced.add(new MyDelegatingSuppressAction(action, actions[index++]));
            }
            SuppressIntentionAction[] suppressIntentionActionArray = replaced.toArray(new SuppressIntentionAction[replaced.size()]);
            if (suppressIntentionActionArray == null) {
                ResourceTypeInspection.$$$reportNull$$$0(156);
            }
            return suppressIntentionActionArray;
        }
        if (suppressActions == null) {
            ResourceTypeInspection.$$$reportNull$$$0(157);
        }
        return suppressActions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 56: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 107: 
            case 108: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 127: 
            case 128: 
            case 129: 
            case 141: 
            case 142: 
            case 156: 
            case 157: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 56: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 107: 
            case 108: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 127: 
            case 128: 
            case 129: 
            case 141: 
            case 142: 
            case 156: 
            case 157: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 56: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 107: 
            case 108: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 127: 
            case 128: 
            case 129: 
            case 141: 
            case 142: 
            case 156: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/ResourceTypeInspection";
                break;
            }
            case 4: 
            case 8: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 7: 
            case 61: 
            case 73: 
            case 77: 
            case 79: 
            case 87: 
            case 103: 
            case 112: 
            case 138: 
            case 160: 
            case 163: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 26: 
            case 31: 
            case 37: 
            case 40: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 15: 
            case 17: 
            case 23: 
            case 28: 
            case 33: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 19: 
            case 24: 
            case 29: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 20: 
            case 25: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allMethodAnnotations";
                break;
            }
            case 35: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookup";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "magic";
                break;
            }
            case 50: 
            case 64: 
            case 74: 
            case 78: 
            case 82: 
            case 88: 
            case 106: 
            case 113: 
            case 131: 
            case 135: 
            case 136: 
            case 139: 
            case 161: 
            case 164: 
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 167: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 58: 
            case 62: 
            case 80: 
            case 104: 
            case 125: 
            case 137: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 71: 
            case 75: 
            case 85: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 72: 
            case 76: 
            case 81: 
            case 86: 
            case 105: 
            case 111: 
            case 134: 
            case 159: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedValues";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permission";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 143: 
            case 145: 
            case 146: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedTypes";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finallyBlock";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lintIssue";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 154: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/ResourceTypeInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "addLocalPermissions";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnnotations";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalAnnotations";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "isAllowed";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "isResourceTypeAllowed";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "isValidResourceTypeExpression";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "isInRange";
                break;
            }
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "isValidRangeExpression";
                break;
            }
            case 127: 
            case 128: 
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "isGrantedPermission";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "processValuesFlownTo";
                break;
            }
            case 156: 
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 56: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 107: 
            case 108: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 127: 
            case 128: 
            case 129: 
            case 141: 
            case 142: 
            case 156: 
            case 157: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkExpression";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkConstraints";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkCall";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodAnnotations";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkApiLevel";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkRestrictionAnnotation";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkVisibleForTestAnnotation";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkThreadAnnotation";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkPermissionRequirement";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addLocalPermissions";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "checkReturnValueUsage";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getAllowedValuesFromTypedef";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getResourceTypeFromAnnotation";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getAllowedValues";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnnotations";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getLocalAnnotations";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 151: 
            case 152: 
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isAllowed";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayInitializerExpression";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isGoodExpression";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isResourceTypeAllowed";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "isValidResourceTypeExpression";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "isInRange";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "comparesReference";
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "isValidRangeExpression";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "isGrantedPermission";
                break;
            }
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralExpression";
                break;
            }
            case 133: 
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "isOneOf";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "same";
                break;
            }
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "processValuesFlownTo";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "isHandled";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "isHandledByMethodThrowsClause";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "isHandledBy";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "isCaught";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "blockCompletesAbruptly";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "guessLintIssue";
                break;
            }
            case 158: 
            case 159: 
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isInRange$5";
                break;
            }
            case 162: 
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isResourceTypeAllowed$4";
                break;
            }
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isAllowed$3";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLocalAnnotations$1";
                break;
            }
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllAnnotations$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 56: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 107: 
            case 108: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 127: 
            case 128: 
            case 129: 
            case 141: 
            case 142: 
            case 156: 
            case 157: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLintInspectionBridge
    extends LintInspectionBridge {
        private final PsiElement myElement;
        private final ProblemsHolder myHolder;
        private final JavaEvaluator myEvaluator;

        public MyLintInspectionBridge(PsiElement element, ProblemsHolder holder, JavaEvaluator evaluator) {
            this.myElement = element;
            this.myHolder = holder;
            this.myEvaluator = evaluator;
        }

        public void report(Issue issue, PsiElement locationNode, PsiElement scopeNode, String message) {
            ResourceTypeInspection.registerProblem(this.myHolder, issue, locationNode, message, new LocalQuickFix[0]);
        }

        public boolean isTestSource() {
            PsiFile containingFile = this.myElement.getContainingFile();
            if (containingFile != null) {
                AndroidFacet facet = AndroidFacet.getInstance((PsiElement)containingFile);
                VirtualFile virtualFile = containingFile.getVirtualFile();
                if (facet != null && virtualFile != null) {
                    return PackageClassConverter.isTestFile(facet, virtualFile);
                }
            }
            return false;
        }

        @Nullable
        public Dependencies getDependencies() {
            AndroidModuleModel model;
            AndroidFacet facet = AndroidFacet.getInstance(this.myElement);
            if (facet != null && (model = AndroidModuleModel.get(facet)) != null) {
                Variant variant = model.getSelectedVariant();
                return variant.getMainArtifact().getDependencies();
            }
            return null;
        }

        @NotNull
        public JavaEvaluator getEvaluator() {
            JavaEvaluator javaEvaluator = this.myEvaluator;
            if (javaEvaluator == null) {
                MyLintInspectionBridge.$$$reportNull$$$0(0);
            }
            return javaEvaluator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection$MyLintInspectionBridge", "getEvaluator"));
        }
    }

    private static class MyDelegatingSuppressAction
    extends SuppressIntentionAction {
        private final SuppressIntentionAction myDelegate;
        private final SuppressQuickFix myFix;

        public MyDelegatingSuppressAction(SuppressIntentionAction delegate, SuppressQuickFix fix) {
            this.myDelegate = delegate;
            this.myFix = fix;
        }

        public Icon getIcon(int flags) {
            return this.myDelegate.getIcon(flags);
        }

        @NotNull
        public String getText() {
            String string = this.myDelegate.getText();
            if (string == null) {
                MyDelegatingSuppressAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void setText(@NotNull String text) {
            if (text == null) {
                MyDelegatingSuppressAction.$$$reportNull$$$0(1);
            }
        }

        public boolean startInWriteAction() {
            return this.myDelegate.startInWriteAction();
        }

        public String toString() {
            return this.myDelegate.toString();
        }

        public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
            String description;
            Issue issue;
            int offset;
            Document hostDocument;
            DaemonCodeAnalyzerImpl codeAnalyzer;
            HighlightInfo infoAtCursor;
            if (project == null) {
                MyDelegatingSuppressAction.$$$reportNull$$$0(2);
            }
            if (element == null) {
                MyDelegatingSuppressAction.$$$reportNull$$$0(3);
            }
            if ((infoAtCursor = (codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project)).findHighlightByOffset(hostDocument = editor.getDocument(), offset = editor.getCaretModel().getOffset(), true)) != null && (issue = ResourceTypeInspection.guessLintIssue(description = infoAtCursor.getDescription())) != null) {
                SuppressLocalWithCommentFix replaced;
                String id = issue.getId();
                SuppressQuickFix action = this.myFix;
                HighlightDisplayKey localKey = HighlightDisplayKey.findOrRegister((String)id, (String)id, (String)id);
                if (action instanceof SuppressLocalWithCommentFix) {
                    replaced = new SuppressLocalWithCommentFix(localKey);
                } else if (action instanceof SuppressByJavaCommentFix) {
                    replaced = new SuppressByJavaCommentFix(localKey);
                } else if (action instanceof SuppressParameterFix) {
                    replaced = new SuppressParameterFix(localKey);
                } else if (action instanceof SuppressForClassFix) {
                    replaced = new SuppressForClassFix(localKey);
                } else if (action instanceof SuppressFix) {
                    replaced = new SuppressFix(localKey);
                } else {
                    this.myDelegate.invoke(project, editor, element);
                    return;
                }
                SuppressIntentionAction wrapped = SuppressIntentionActionFromFix.convertBatchToSuppressIntentionAction((SuppressQuickFix)replaced);
                wrapped.invoke(project, editor, element);
                return;
            }
            this.myDelegate.invoke(project, editor, element);
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
            if (project == null) {
                MyDelegatingSuppressAction.$$$reportNull$$$0(4);
            }
            if (element == null) {
                MyDelegatingSuppressAction.$$$reportNull$$$0(5);
            }
            return this.myDelegate.isAvailable(project, editor, element);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.myDelegate.getFamilyName();
            if (string == null) {
                MyDelegatingSuppressAction.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/ResourceTypeInspection$MyDelegatingSuppressAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/ResourceTypeInspection$MyDelegatingSuppressAction";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class IndirectPermission
    extends Constraints {
        public final String signature;
        @Nullable
        public PermissionFinder.Result result;

        public IndirectPermission(String signature) {
            this.signature = signature;
        }
    }

    static class ResourceTypeAllowedValues
    extends Constraints {
        @NotNull
        final List<ResourceType> types;

        public ResourceTypeAllowedValues(@NotNull List<ResourceType> types) {
            if (types == null) {
                ResourceTypeAllowedValues.$$$reportNull$$$0(0);
            }
            this.types = types;
        }

        public boolean isTypeAllowed(@NotNull ResourceType type) {
            if (type == null) {
                ResourceTypeAllowedValues.$$$reportNull$$$0(1);
            }
            return this.isTypeAllowed(type.getName());
        }

        public boolean isTypeAllowed(@NotNull String typeName) {
            if (typeName == null) {
                ResourceTypeAllowedValues.$$$reportNull$$$0(2);
            }
            for (ResourceType type : this.types) {
                if (!type.getName().equals(typeName) && (type != ResourceType.DRAWABLE || !ResourceType.COLOR.getName().equals(typeName) && !ResourceType.MIPMAP.getName().equals(typeName))) continue;
                return true;
            }
            return false;
        }

        public boolean isCompatibleWith(@NotNull ResourceTypeAllowedValues other) {
            if (other == null) {
                ResourceTypeAllowedValues.$$$reportNull$$$0(3);
            }
            for (ResourceType type : other.types) {
                if (!this.isTypeAllowed(type)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/inspections/ResourceTypeInspection$ResourceTypeAllowedValues";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isTypeAllowed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCompatibleWith";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class AllowedValues
    extends Constraints {
        final PsiAnnotationMemberValue[] values;
        final boolean canBeOred;

        private AllowedValues(@NotNull PsiAnnotationMemberValue[] values, boolean canBeOred) {
            if (values == null) {
                AllowedValues.$$$reportNull$$$0(0);
            }
            this.values = values;
            this.canBeOred = canBeOred;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllowedValues a2 = (AllowedValues)o;
            if (this.canBeOred != a2.canBeOred) {
                return false;
            }
            THashSet v1 = new THashSet(Arrays.asList(this.values));
            THashSet v2 = new THashSet(Arrays.asList(a2.values));
            if (v1.size() != v2.size()) {
                return false;
            }
            block0: for (PsiAnnotationMemberValue value : v1) {
                for (PsiAnnotationMemberValue value2 : v2) {
                    if (!ResourceTypeInspection.same((PsiElement)value, (PsiElement)value2, value.getManager())) continue;
                    v2.remove(value2);
                    continue block0;
                }
            }
            return v2.isEmpty();
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.values);
            result = 31 * result + (this.canBeOred ? 1 : 0);
            return result;
        }

        @Override
        public boolean isSubsetOf(@NotNull Constraints other, @NotNull PsiManager manager) {
            if (other == null) {
                AllowedValues.$$$reportNull$$$0(1);
            }
            if (manager == null) {
                AllowedValues.$$$reportNull$$$0(2);
            }
            if (!(other instanceof AllowedValues)) {
                return false;
            }
            AllowedValues o = (AllowedValues)other;
            for (PsiAnnotationMemberValue value : this.values) {
                boolean found = false;
                for (PsiAnnotationMemberValue otherValue : o.values) {
                    if (!ResourceTypeInspection.same((PsiElement)value, (PsiElement)otherValue, manager)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/inspections/ResourceTypeInspection$AllowedValues";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSubsetOf";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Constraints {
        @Nullable
        public Constraints next;

        Constraints() {
        }

        public boolean isSubsetOf(@NotNull Constraints other, @NotNull PsiManager manager) {
            if (other == null) {
                Constraints.$$$reportNull$$$0(0);
            }
            if (manager == null) {
                Constraints.$$$reportNull$$$0(1);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "other";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "manager";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/inspections/ResourceTypeInspection$Constraints";
            objectArray[2] = "isSubsetOf";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReplaceCallFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiMethodCallExpression> myMethodCall;
        private final String mySuggest;

        public ReplaceCallFix(@NotNull PsiMethodCallExpression methodCall, @NotNull String suggest) {
            if (methodCall == null) {
                ReplaceCallFix.$$$reportNull$$$0(0);
            }
            if (suggest == null) {
                ReplaceCallFix.$$$reportNull$$$0(1);
            }
            this.myMethodCall = SmartPointerManager.getInstance((Project)methodCall.getProject()).createSmartPsiElementPointer((PsiElement)methodCall);
            this.mySuggest = suggest;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = String.format("Call %1$s instead", this.getMethodName());
            if (string == null) {
                ReplaceCallFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace calls" == null) {
                ReplaceCallFix.$$$reportNull$$$0(3);
            }
            return "Replace calls";
        }

        private String getMethodName() {
            assert (this.mySuggest.startsWith("#"));
            int start = 1;
            int parameters = this.mySuggest.indexOf(40, start);
            if (parameters == -1) {
                parameters = this.mySuggest.length();
            }
            return this.mySuggest.substring(start, parameters).trim();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            TextRange range;
            PsiReferenceExpression methodExpression;
            PsiElement referenceNameElement;
            PsiMethodCallExpression methodCall;
            if (project == null) {
                ReplaceCallFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                ReplaceCallFix.$$$reportNull$$$0(5);
            }
            if ((methodCall = (PsiMethodCallExpression)this.myMethodCall.getElement()) == null || !methodCall.isValid()) {
                return;
            }
            String name = this.getMethodName();
            PsiFile file = methodCall.getContainingFile();
            if (file == null || !FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(file.getVirtualFile());
            if (document != null && (referenceNameElement = (methodExpression = methodCall.getMethodExpression()).getReferenceNameElement()) != null && (range = referenceNameElement.getTextRange()) != null) {
                if (name.startsWith("enforce") && methodExpression.getReferenceName() != null && methodExpression.getReferenceName().startsWith("check")) {
                    PsiExpressionList argumentList = methodCall.getArgumentList();
                    int offset = argumentList.getTextOffset() + argumentList.getTextLength() - 1;
                    document.insertString(offset, (CharSequence)", \"TODO: message if thrown\"");
                }
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)name);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodCall";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suggest";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/ResourceTypeInspection$ReplaceCallFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/ResourceTypeInspection$ReplaceCallFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddCheckPermissionFix
    implements LocalQuickFix {
        private final AndroidFacet myFacet;
        private final PermissionRequirement myRequirement;
        private final Set<String> myRevocablePermissions;
        private final SmartPsiElementPointer<PsiCall> myCall;

        public AddCheckPermissionFix(@NotNull AndroidFacet facet, @NotNull PermissionRequirement requirement, @NotNull PsiCall call, @NotNull Set<String> revocablePermissions) {
            if (facet == null) {
                AddCheckPermissionFix.$$$reportNull$$$0(0);
            }
            if (requirement == null) {
                AddCheckPermissionFix.$$$reportNull$$$0(1);
            }
            if (call == null) {
                AddCheckPermissionFix.$$$reportNull$$$0(2);
            }
            if (revocablePermissions == null) {
                AddCheckPermissionFix.$$$reportNull$$$0(3);
            }
            this.myFacet = facet;
            this.myRequirement = requirement;
            this.myCall = SmartPointerManager.getInstance((Project)call.getProject()).createSmartPsiElementPointer((PsiElement)call);
            this.myRevocablePermissions = revocablePermissions;
        }

        @Nls
        @NotNull
        public String getName() {
            if ("Add permission check" == null) {
                AddCheckPermissionFix.$$$reportNull$$$0(4);
            }
            return "Add permission check";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                AddCheckPermissionFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            boolean usingAppCompat;
            IElementType operator;
            HashMap permissionNames;
            GlobalSearchScope moduleScope;
            PsiCall call;
            if (project == null) {
                AddCheckPermissionFix.$$$reportNull$$$0(6);
            }
            if (descriptor == null) {
                AddCheckPermissionFix.$$$reportNull$$$0(7);
            }
            if ((call = (PsiCall)this.myCall.getElement()) == null) {
                return;
            }
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)call, PsiStatement.class, (boolean)true);
            if (statement == null) {
                return;
            }
            PsiElement parent = statement.getParent();
            if (parent == null) {
                return;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiClass manifest = facade.findClass("android.Manifest.permission", moduleScope = GlobalSearchScope.moduleWithLibrariesScope((Module)this.myFacet.getModule()));
            if (manifest != null) {
                PsiField[] fields = manifest.getFields();
                permissionNames = Maps.newHashMapWithExpectedSize((int)fields.length);
                for (PsiField field : fields) {
                    Iterator<String> value;
                    PsiExpression initializer = field.getInitializer();
                    if (!(initializer instanceof PsiLiteralExpression) || !((value = ((PsiLiteralExpression)initializer).getValue()) instanceof String)) continue;
                    permissionNames.put((String)((Object)value), field);
                }
            } else {
                permissionNames = Collections.emptyMap();
            }
            if ((operator = this.myRequirement.getOperator()) == null || operator == JavaTokenType.ANDAND) {
                operator = JavaTokenType.OROR;
            } else if (operator == JavaTokenType.OROR) {
                operator = JavaTokenType.ANDAND;
            }
            PsiElementFactory factory = facade.getElementFactory();
            StringBuilder sb = new StringBuilder(200);
            sb.append("if (");
            boolean first = true;
            PsiClass activityCompat = facade.findClass("android.support.v4.app.ActivityCompat", moduleScope);
            boolean bl = usingAppCompat = activityCompat != null;
            if (usingAppCompat && activityCompat.findMethodsByName("requestPermissions", false).length == 0) {
                usingAppCompat = false;
            }
            for (String permission : this.myRevocablePermissions) {
                PsiField field;
                if (first) {
                    first = false;
                } else {
                    sb.append(' ');
                    if (operator == JavaTokenType.ANDAND) {
                        sb.append("&&");
                    } else if (operator == JavaTokenType.OROR) {
                        sb.append("||");
                    } else if (operator == JavaTokenType.XOR) {
                        sb.append("^");
                    }
                    sb.append(' ');
                }
                if (usingAppCompat) {
                    sb.append("android.support.v4.app.ActivityCompat.");
                }
                sb.append("checkSelfPermission(");
                if (usingAppCompat) {
                    sb.append("this, ");
                }
                if ((field = (PsiField)permissionNames.get(permission)) != null && field.getContainingClass() != null) {
                    sb.append(field.getContainingClass().getQualifiedName()).append('.').append(field.getName());
                } else {
                    sb.append('\"').append(permission).append('\"');
                }
                sb.append(") != android.content.pm.PackageManager.PERMISSION_GRANTED");
            }
            sb.append(") {\n");
            sb.append(" // TODO: Consider calling\n //    Activity").append(usingAppCompat ? "Compat" : "").append("#requestPermissions\n // here to request the missing permissions, and then overriding\n //   public void onRequestPermissionsResult(int requestCode, String[] permissions,\n //                                          int[] grantResults)\n // to handle the case where the user grants the permission. See the documentation\n // for Activity").append(usingAppCompat ? "Compat" : "").append("#requestPermissions for more details.\n");
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class, (boolean)true);
            if (method != null && !PsiType.VOID.equals((Object)method.getReturnType())) {
                sb.append("return TODO;\n");
            } else {
                sb.append("return;\n");
            }
            sb.append("}\n");
            String code = sb.toString();
            PsiStatement check = factory.createStatementFromText(code, (PsiElement)call);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)check);
            parent.addBefore((PsiElement)check, (PsiElement)statement);
            CodeStyleManager.getInstance((Project)project).reformatRange(parent, check.getTextOffset(), statement.getTextOffset() + statement.getTextLength());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requirement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revocablePermissions";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/ResourceTypeInspection$AddCheckPermissionFix";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/ResourceTypeInspection$AddCheckPermissionFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddPermissionFix
    implements LocalQuickFix {
        private final AndroidFacet myFacet;
        private final String myPermissionName;
        private PermissionRequirement myRequirement;

        public AddPermissionFix(@NotNull AndroidFacet facet, @NotNull String permissionName, @NotNull PermissionRequirement requirement) {
            if (facet == null) {
                AddPermissionFix.$$$reportNull$$$0(0);
            }
            if (permissionName == null) {
                AddPermissionFix.$$$reportNull$$$0(1);
            }
            if (requirement == null) {
                AddPermissionFix.$$$reportNull$$$0(2);
            }
            this.myFacet = facet;
            this.myPermissionName = permissionName;
            this.myRequirement = requirement;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = String.format("Add Permission %1$s", this.myPermissionName.substring(this.myPermissionName.lastIndexOf(46) + 1));
            if (string == null) {
                AddPermissionFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Add permissions" == null) {
                AddPermissionFix.$$$reportNull$$$0(4);
            }
            return "Add permissions";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            VirtualFile manifestFile;
            if (project == null) {
                AddPermissionFix.$$$reportNull$$$0(5);
            }
            if (descriptor == null) {
                AddPermissionFix.$$$reportNull$$$0(6);
            }
            if ((manifestFile = AndroidRootUtil.getPrimaryManifestFile(this.myFacet)) == null || !ReadonlyStatusHandler.ensureFilesWritable((Project)this.myFacet.getModule().getProject(), (VirtualFile[])new VirtualFile[]{manifestFile})) {
                return;
            }
            Manifest manifest = this.myFacet.getManifest();
            if (manifest == null) {
                return;
            }
            XmlTag manifestTag = manifest.getXmlTag();
            if (manifestTag == null) {
                return;
            }
            XmlTag permissionTag = manifestTag.createChildTag("uses-permission", "", null, false);
            if (permissionTag != null) {
                XmlTag before = null;
                for (XmlTag tag : manifestTag.getSubTags()) {
                    String name;
                    String tagName = tag.getName();
                    if (tagName.equals("application")) {
                        before = tag;
                        break;
                    }
                    if (!tagName.equals("uses-permission") && !tagName.equals("uses-permission-sdk-23") && !tagName.equals("uses-permission-sdk-m") || (name = tag.getAttributeValue("name", "http://schemas.android.com/apk/res/android")) == null || name.compareTo(this.myPermissionName) <= 0) continue;
                    before = tag;
                    break;
                }
                permissionTag = before == null ? manifestTag.addSubTag(permissionTag, false) : (XmlTag)manifestTag.addBefore((PsiElement)permissionTag, before);
                permissionTag.setAttribute("name", "http://schemas.android.com/apk/res/android", this.myPermissionName);
                if (this.myRequirement.getLastApplicableApi() != Integer.MAX_VALUE && this.myRequirement.getLastApplicableApi() >= AndroidModuleInfo.get(this.myFacet).getMinSdkVersion().getApiLevel()) {
                    permissionTag.setAttribute("maxSdkVersion", "http://schemas.android.com/apk/res/android", Integer.toString(this.myRequirement.getLastApplicableApi()));
                }
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)permissionTag);
                FileDocumentManager.getInstance().saveAllDocuments();
                PsiFile containingFile = permissionTag.getContainingFile();
                if (containingFile != null) {
                    DaemonCodeAnalyzer.getInstance((Project)project).restart();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "permissionName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requirement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/ResourceTypeInspection$AddPermissionFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/ResourceTypeInspection$AddPermissionFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class InspectionResult {
        private static final InspectionResult VALID_RESULT = new InspectionResult(Status.VALID);
        private static final InspectionResult UNCERTAIN_RESULT = new InspectionResult(Status.UNCERTAIN);
        private static final InspectionResult INVALID_RESULT_NO_NODE = new InspectionResult(Status.INVALID);
        private final Status myStatus;
        private final PsiExpression myErrorNode;

        private InspectionResult(@NotNull Status status) {
            if (status == null) {
                InspectionResult.$$$reportNull$$$0(0);
            }
            this.myStatus = status;
            this.myErrorNode = null;
        }

        private InspectionResult(@NotNull PsiExpression element) {
            if (element == null) {
                InspectionResult.$$$reportNull$$$0(1);
            }
            this.myStatus = Status.INVALID;
            this.myErrorNode = element;
        }

        @NotNull
        public static InspectionResult invalid(@NotNull PsiExpression node) {
            if (node == null) {
                InspectionResult.$$$reportNull$$$0(2);
            }
            InspectionResult inspectionResult = new InspectionResult(node);
            if (inspectionResult == null) {
                InspectionResult.$$$reportNull$$$0(3);
            }
            return inspectionResult;
        }

        @NotNull
        public static InspectionResult invalidWithoutNode() {
            InspectionResult inspectionResult = INVALID_RESULT_NO_NODE;
            if (inspectionResult == null) {
                InspectionResult.$$$reportNull$$$0(4);
            }
            return inspectionResult;
        }

        @NotNull
        public static InspectionResult valid() {
            InspectionResult inspectionResult = VALID_RESULT;
            if (inspectionResult == null) {
                InspectionResult.$$$reportNull$$$0(5);
            }
            return inspectionResult;
        }

        @NotNull
        public static InspectionResult uncertain() {
            InspectionResult inspectionResult = UNCERTAIN_RESULT;
            if (inspectionResult == null) {
                InspectionResult.$$$reportNull$$$0(6);
            }
            return inspectionResult;
        }

        public boolean isValid() {
            return this.myStatus == Status.VALID;
        }

        public boolean isInvalid() {
            return this.myStatus == Status.INVALID && this.myErrorNode != null;
        }

        public boolean isUncertain() {
            return this.myStatus == Status.UNCERTAIN || this.myStatus == Status.INVALID && this.myErrorNode == null;
        }

        @NotNull
        public InspectionResult useErrorNode(@NotNull PsiExpression errorNode) {
            if (errorNode == null) {
                InspectionResult.$$$reportNull$$$0(7);
            }
            if (this.myStatus == Status.INVALID && errorNode != this.myErrorNode) {
                InspectionResult inspectionResult = InspectionResult.invalid(errorNode);
                if (inspectionResult == null) {
                    InspectionResult.$$$reportNull$$$0(8);
                }
                return inspectionResult;
            }
            InspectionResult inspectionResult = this;
            if (inspectionResult == null) {
                InspectionResult.$$$reportNull$$$0(9);
            }
            return inspectionResult;
        }

        @NotNull
        public PsiExpression getErrorNode() {
            if (!this.isInvalid() || this.myErrorNode == null) {
                throw new IllegalStateException();
            }
            PsiExpression psiExpression = this.myErrorNode;
            if (psiExpression == null) {
                InspectionResult.$$$reportNull$$$0(10);
            }
            return psiExpression;
        }

        public String toString() {
            return this.myStatus.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/ResourceTypeInspection$InspectionResult";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/ResourceTypeInspection$InspectionResult";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "invalid";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "invalidWithoutNode";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "valid";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uncertain";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "useErrorNode";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "invalid";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "useErrorNode";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static enum Status {
            VALID,
            INVALID,
            UNCERTAIN;

        }
    }
}

