/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import org.jetbrains.android.inspections.FloatRangeConstraint;
import org.jetbrains.android.inspections.RangeAllowedValues;
import org.jetbrains.android.inspections.ResourceTypeInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IntRangeConstraint
extends RangeAllowedValues {
    final long from;
    final long to;

    public IntRangeConstraint(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            IntRangeConstraint.$$$reportNull$$$0(0);
        }
        PsiAnnotationMemberValue fromValue = annotation.findDeclaredAttributeValue("from");
        PsiAnnotationMemberValue toValue = annotation.findDeclaredAttributeValue("to");
        this.from = ResourceTypeInspection.getLongValue((PsiElement)fromValue, Long.MIN_VALUE);
        this.to = ResourceTypeInspection.getLongValue((PsiElement)toValue, Long.MAX_VALUE);
    }

    IntRangeConstraint(long from, long to) {
        this.from = from;
        this.to = to;
    }

    @Override
    public ResourceTypeInspection.InspectionResult isValid(@NotNull PsiExpression argument) {
        Number literalValue;
        if (argument == null) {
            IntRangeConstraint.$$$reportNull$$$0(1);
        }
        if ((literalValue = this.guessSize(argument)) != null) {
            long value = literalValue.longValue();
            return value >= this.from && value <= this.to ? ResourceTypeInspection.InspectionResult.valid() : ResourceTypeInspection.InspectionResult.invalid(argument);
        }
        return ResourceTypeInspection.InspectionResult.uncertain();
    }

    @Override
    @NotNull
    public String describe(@Nullable PsiExpression argument) {
        Number actual;
        StringBuilder sb = new StringBuilder(20);
        if (this.to == Long.MAX_VALUE) {
            sb.append("Value must be \u2265 ");
            sb.append(Long.toString(this.from));
        } else if (this.from == Long.MIN_VALUE) {
            sb.append("Value must be \u2264 ");
            sb.append(Long.toString(this.to));
        } else {
            sb.append("Value must be \u2265 ");
            sb.append(Long.toString(this.from));
            sb.append(" and \u2264 ");
            sb.append(Long.toString(this.to));
        }
        if (argument != null && (actual = this.guessSize(argument)) != null) {
            sb.append(" (was ").append(Integer.toString(actual.intValue())).append(')');
        }
        String string = sb.toString();
        if (string == null) {
            IntRangeConstraint.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String toString() {
        return this.describe(null);
    }

    @Override
    public ResourceTypeInspection.InspectionResult contains(@NotNull RangeAllowedValues other) {
        if (other == null) {
            IntRangeConstraint.$$$reportNull$$$0(3);
        }
        if (other instanceof IntRangeConstraint) {
            IntRangeConstraint otherRange = (IntRangeConstraint)other;
            return otherRange.from >= this.from && otherRange.to <= this.to ? ResourceTypeInspection.InspectionResult.valid() : ResourceTypeInspection.InspectionResult.invalidWithoutNode();
        }
        if (other instanceof FloatRangeConstraint) {
            FloatRangeConstraint otherRange = (FloatRangeConstraint)other;
            if (!otherRange.fromInclusive && otherRange.from == (double)this.from) {
                return ResourceTypeInspection.InspectionResult.invalidWithoutNode();
            }
            if (!otherRange.toInclusive && otherRange.to == (double)this.to) {
                return ResourceTypeInspection.InspectionResult.invalidWithoutNode();
            }
            return otherRange.from >= (double)this.from && otherRange.to <= (double)this.to ? ResourceTypeInspection.InspectionResult.valid() : ResourceTypeInspection.InspectionResult.invalidWithoutNode();
        }
        return ResourceTypeInspection.InspectionResult.uncertain();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/IntRangeConstraint";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/IntRangeConstraint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

