/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.intellij.codeInsight.daemon.impl.quickfix.ConvertSwitchToIfIntention;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.switchtoif.ReplaceSwitchWithIfIntention;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AndroidNonConstantResIdsInSwitchInspection
extends LocalInspectionTool {
    private final ReplaceSwitchWithIfIntention myBaseIntention = new ReplaceSwitchWithIfIntention();

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AndroidBundle.message("android.inspections.group.name", new Object[0]);
        if (string == null) {
            AndroidNonConstantResIdsInSwitchInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AndroidBundle.message("android.inspections.non.constant.res.ids.in.switch.name", new Object[0]);
        if (string == null) {
            AndroidNonConstantResIdsInSwitchInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("AndroidNonConstantResIdsInSwitch" == null) {
            AndroidNonConstantResIdsInSwitchInspection.$$$reportNull$$$0(2);
        }
        return "AndroidNonConstantResIdsInSwitch";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AndroidNonConstantResIdsInSwitchInspection.$$$reportNull$$$0(3);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
                AndroidFacet facet = AndroidFacet.getInstance((PsiElement)statement);
                if (facet == null || facet.isAppProject()) {
                    return;
                }
                PsiExpression caseValue = statement.getCaseValue();
                if (!(caseValue instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiSwitchStatement.class);
                if (switchStatement == null || !ReplaceSwitchWithIfIntention.canProcess((PsiSwitchStatement)switchStatement)) {
                    return;
                }
                PsiElement resolvedElement = ((PsiReferenceExpression)caseValue).resolve();
                if (resolvedElement == null || !(resolvedElement instanceof PsiField)) {
                    return;
                }
                PsiField resolvedField = (PsiField)resolvedElement;
                if (!AndroidResourceUtil.isResourceField(resolvedField)) {
                    return;
                }
                PsiModifierList modifierList = resolvedField.getModifierList();
                if (modifierList == null || !modifierList.hasModifierProperty("final")) {
                    holder.registerProblem((PsiElement)caseValue, AndroidBundle.message("android.inspections.non.constant.res.ids.in.switch.message", new Object[0]), new LocalQuickFix[]{new MyQuickFix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            AndroidNonConstantResIdsInSwitchInspection.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    public String getQuickFixName() {
        return this.myBaseIntention.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyQuickFix
    implements LocalQuickFix {
        private MyQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = AndroidNonConstantResIdsInSwitchInspection.this.getQuickFixName();
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) == null) {
                return;
            }
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiSwitchStatement.class);
            if (switchStatement == null) {
                return;
            }
            ConvertSwitchToIfIntention.doProcessIntention((PsiSwitchStatement)switchStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection$MyQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

