/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.resources;

import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceValue {
    private static final String PLUS_ID = "+id";
    private String myValue;
    private char myPrefix = '\u0000';
    private String myNamespace;
    private String myResourceType;
    private String myResourceName;
    public static final ResourceValue INVALID = new ResourceValue();

    private ResourceValue() {
    }

    public char getPrefix() {
        return this.myPrefix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceValue that = (ResourceValue)o;
        if (this.myPrefix != that.myPrefix) {
            return false;
        }
        if (this.myNamespace != null ? !this.myNamespace.equals(that.myNamespace) : that.myNamespace != null) {
            return false;
        }
        if (this.myResourceName != null ? !this.myResourceName.equals(that.myResourceName) : that.myResourceName != null) {
            return false;
        }
        if (this.myResourceType != null ? !this.myResourceType.equals(that.myResourceType) : that.myResourceType != null) {
            return false;
        }
        return !(this.myValue != null ? !this.myValue.equals(that.myValue) : that.myValue != null);
    }

    public int hashCode() {
        int result = this.myValue != null ? this.myValue.hashCode() : 0;
        result = 31 * result + this.myPrefix;
        result = 31 * result + (this.myNamespace != null ? this.myNamespace.hashCode() : 0);
        result = 31 * result + (this.myResourceType != null ? this.myResourceType.hashCode() : 0);
        result = 31 * result + (this.myResourceName != null ? this.myResourceName.hashCode() : 0);
        return result;
    }

    @Nullable
    public static ResourceValue parse(@Nullable String s, boolean withLiterals, boolean withPrefix, boolean requireValid) {
        ResourceValue reference;
        if (s == null) {
            return null;
        }
        if ((s.startsWith("@") || s.startsWith("?")) && !DataBindingUtil.isBindingExpression(s)) {
            ResourceValue reference2 = ResourceValue.reference(s, true);
            return reference2 != null && (!requireValid || reference2.isValidReference()) ? reference2 : null;
        }
        if (!withPrefix && (reference = ResourceValue.reference(s, false)) != null) {
            return reference;
        }
        return withLiterals ? ResourceValue.literal(s) : null;
    }

    public static ResourceValue literal(String value) {
        ResourceValue result = new ResourceValue();
        result.myValue = value;
        return result;
    }

    @Nullable
    public static ResourceValue reference(String value) {
        return ResourceValue.reference(value, true);
    }

    @Nullable
    public static ResourceValue reference(String value, boolean withPrefix) {
        ResourceValue result = new ResourceValue();
        if (withPrefix) {
            assert (value.length() > 0);
            result.myPrefix = value.charAt(0);
        }
        int startIndex = withPrefix ? 1 : 0;
        int pos = value.indexOf(47);
        if (pos > 0) {
            String resType = value.substring(startIndex, pos);
            int colonIndex = resType.indexOf(58);
            if (colonIndex > 0) {
                result.myNamespace = resType.substring(0, colonIndex);
                result.myResourceType = resType.substring(colonIndex + 1);
            } else {
                result.myResourceType = resType;
            }
            if (result.myResourceType.startsWith("+") && !result.myResourceType.equals(PLUS_ID)) {
                return null;
            }
            String suffix = value.substring(pos + 1);
            colonIndex = suffix.indexOf(58);
            if (colonIndex > 0) {
                String aPackage = suffix.substring(0, colonIndex);
                if (result.myNamespace == null || result.myNamespace.length() == 0 || aPackage.equals(result.myNamespace)) {
                    result.myNamespace = aPackage;
                    result.myResourceName = suffix.substring(colonIndex + 1);
                } else {
                    result.myResourceName = suffix;
                }
            } else {
                result.myResourceName = suffix;
            }
        } else {
            int colonIndex = value.indexOf(58);
            if (colonIndex > startIndex) {
                result.myNamespace = value.substring(startIndex, colonIndex);
                result.myResourceName = value.substring(colonIndex + 1);
            } else {
                result.myResourceName = value.substring(startIndex);
            }
        }
        return result;
    }

    public static ResourceValue referenceTo(char prefix, @Nullable String resPackage, @Nullable String resourceType, String resourceName) {
        ResourceValue result = new ResourceValue();
        result.myPrefix = prefix;
        result.myNamespace = resPackage;
        result.myResourceType = resourceType;
        result.myResourceName = resourceName;
        return result;
    }

    public boolean isReference() {
        return this.myValue == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidReference() {
        ResourceType type;
        if ("null".equals(this.myResourceName)) {
            if (this.myResourceType != null) return false;
            if (this.myPrefix != '@') return false;
            return true;
        }
        if (this.myResourceName == null) return false;
        if (this.myResourceName.isEmpty()) {
            return false;
        }
        if (this.myResourceType == null) {
            if (this.myPrefix != '?') return false;
            type = ResourceType.ATTR;
        } else if (PLUS_ID.equals(this.myResourceType)) {
            type = ResourceType.ID;
        } else {
            type = ResourceType.getEnum((String)this.myResourceType);
            if (type == null) {
                return false;
            }
        }
        if (AndroidUtils.isIdentifier(this.myResourceName)) return true;
        if (!FolderTypeRelationship.getRelatedFolders((ResourceType)type).contains(ResourceFolderType.VALUES)) return false;
        if (!AndroidUtils.isIdentifier(AndroidResourceUtil.getFieldNameByResourceName(this.myResourceName))) return false;
        return true;
    }

    @Nullable
    public String getErrorMessage() {
        ResourceType type;
        if ("null".equals(this.myResourceName) && this.myResourceType == null && this.myPrefix == '@') {
            return null;
        }
        if (this.myResourceName == null || this.myResourceName.isEmpty()) {
            if (this.myResourceType == null && (this.myPrefix == '@' || this.myPrefix == '?')) {
                return "Missing resource type";
            }
            return "Missing resource name";
        }
        if (this.myResourceType == null) {
            if (this.myPrefix != '?') {
                if (this.myPrefix == '@' && this.myResourceName.indexOf(47) == -1) {
                    return "Missing /";
                }
                return "Missing resource type";
            }
            type = ResourceType.ATTR;
        } else if (PLUS_ID.equals(this.myResourceType)) {
            type = ResourceType.ID;
        } else {
            type = ResourceType.getEnum((String)this.myResourceType);
            if (type == null) {
                return "Unknown resource type " + this.myResourceType;
            }
        }
        String name = this.myResourceName;
        if (FolderTypeRelationship.getRelatedFolders((ResourceType)type).contains(ResourceFolderType.VALUES)) {
            name = AndroidResourceUtil.getFieldNameByResourceName(name);
        }
        if (!AndroidUtils.isIdentifier(name)) {
            if (JavaLexer.isKeyword((String)name, (LanguageLevel)LanguageLevel.JDK_1_5)) {
                return "Resource name cannot be a Java keyword (" + name + ")";
            }
            if (!Character.isJavaIdentifierStart(name.charAt(0))) {
                return "The resource name must begin with a character";
            }
            int n = name.length();
            for (int i = 1; i < n; ++i) {
                char c = name.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                return String.format("'%1$c' is not a valid resource name character", Character.valueOf(c));
            }
            return "Resource name '" + name + "' must be a valid Java identifier";
        }
        return null;
    }

    @Nullable
    public String getValue() {
        return this.myValue;
    }

    @Nullable
    public String getResourceType() {
        return this.myResourceType;
    }

    @Nullable
    public ResourceType getType() {
        if (this.myResourceType == null) {
            return null;
        }
        if (this.myResourceType.startsWith("+")) {
            assert (PLUS_ID.equals(this.myResourceType)) : this.myResourceType;
            return ResourceType.ID;
        }
        return ResourceType.getEnum((String)this.myResourceType);
    }

    @Nullable
    public String getResourceName() {
        return this.myResourceName;
    }

    @Nullable
    public String getNamespace() {
        return this.myNamespace;
    }

    @NotNull
    public String toString() {
        if (this.myValue != null) {
            String string = this.myValue;
            if (string == null) {
                ResourceValue.$$$reportNull$$$0(0);
            }
            return string;
        }
        StringBuilder builder = new StringBuilder();
        if (this.myPrefix != '\u0000') {
            builder.append(this.myPrefix);
        }
        if (this.myNamespace != null) {
            builder.append(this.myNamespace).append(":");
        }
        if (this.myResourceType != null) {
            builder.append(this.myResourceType).append("/");
        }
        builder.append(this.myResourceName);
        String string = builder.toString();
        if (string == null) {
            ResourceValue.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setResourceType(String resourceType) {
        this.myResourceType = resourceType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/resources/ResourceValue", "toString"));
    }
}

