/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.res2.DataBindingResourceType;
import com.android.tools.idea.lang.databinding.DataBindingXmlReferenceContributor;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.layout.AndroidLayoutUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingConverter
extends ResolvingConverter<PsiClass>
implements CustomReferenceConverter<PsiClass> {
    public static String getQualifiedType(@Nullable String nameOrAlias, @Nullable DataBindingInfo dataBindingInfo) {
        String type;
        if (nameOrAlias == null) {
            return null;
        }
        nameOrAlias = nameOrAlias.replace('$', '.');
        if (dataBindingInfo == null) {
            return nameOrAlias;
        }
        int i = nameOrAlias.indexOf(46);
        String alias = i >= 0 ? nameOrAlias.substring(0, i) : nameOrAlias;
        PsiDataBindingResourceItem imp = DataBindingConverter.getImport(alias, dataBindingInfo);
        if (imp != null && (type = imp.getTypeDeclaration()) != null) {
            return nameOrAlias.equals(alias) ? type : type + nameOrAlias.substring(alias.length());
        }
        return nameOrAlias;
    }

    private static PsiDataBindingResourceItem getImport(@NotNull String alias, @NotNull DataBindingInfo dataBindingInfo) {
        if (alias == null) {
            DataBindingConverter.$$$reportNull$$$0(0);
        }
        if (dataBindingInfo == null) {
            DataBindingConverter.$$$reportNull$$$0(1);
        }
        for (PsiDataBindingResourceItem anImport : dataBindingInfo.getItems(DataBindingResourceType.IMPORT)) {
            if (!alias.equals(AndroidLayoutUtil.getAlias(anImport))) continue;
            return anImport;
        }
        return null;
    }

    @NotNull
    public Collection<? extends PsiClass> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            DataBindingConverter.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public PsiClass fromString(@Nullable @NonNls String s, ConvertContext context) {
        DataBindingInfo bindingInfo = DataBindingConverter.getDataBindingInfo(context);
        String qualifiedName = DataBindingConverter.getQualifiedType(s, bindingInfo);
        if (qualifiedName == null) {
            return null;
        }
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        Project project = context.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
        if (qualifiedName.length() > 0 && qualifiedName.indexOf(46) < 0) {
            if (Character.isLowerCase(qualifiedName.charAt(0))) {
                PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType((String)qualifiedName);
                if (primitiveType != null) {
                    PsiClassType boxedType = primitiveType.getBoxedType(PsiManager.getInstance((Project)project), scope);
                    if (boxedType != null) {
                        return boxedType.resolve();
                    }
                    return null;
                }
            } else {
                PsiClass aClass = psiFacade.findClass("java.lang." + qualifiedName, scope);
                if (aClass != null) {
                    return aClass;
                }
            }
        }
        return psiFacade.findClass(qualifiedName, scope);
    }

    @Nullable
    public String toString(@Nullable PsiClass psiClass, ConvertContext context) {
        if (psiClass == null) {
            return null;
        }
        String qualifiedName = psiClass.getName();
        DataBindingInfo bindingInfo = DataBindingConverter.getDataBindingInfo(context);
        if (bindingInfo != null) {
            int longestPrefix = 0;
            PsiDataBindingResourceItem longestImport = null;
            for (PsiDataBindingResourceItem anImport : bindingInfo.getItems(DataBindingResourceType.IMPORT)) {
                String prefix = DataBindingConverter.getLongestPrefix(anImport.getTypeDeclaration(), qualifiedName);
                if (prefix.length() <= longestPrefix) continue;
                if (qualifiedName.length() == prefix.length()) {
                    return AndroidLayoutUtil.getAlias(anImport);
                }
                char c = qualifiedName.charAt(prefix.length());
                if (c != '.') continue;
                longestPrefix = prefix.length();
                longestImport = anImport;
            }
            if (longestImport != null) {
                return AndroidLayoutUtil.getAlias(longestImport) + qualifiedName.substring(longestPrefix);
            }
        }
        if (qualifiedName.startsWith("java.lang.")) {
            return qualifiedName.substring("java.lang.".length());
        }
        return qualifiedName;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiClass> value, PsiElement element, ConvertContext context) {
        assert (element instanceof XmlAttributeValue);
        XmlAttributeValue attrValue = (XmlAttributeValue)element;
        String strValue = attrValue.getValue();
        int start = attrValue.getValueTextRange().getStartOffset() - attrValue.getTextRange().getStartOffset();
        ArrayList<PsiReferenceBase> result = new ArrayList<PsiReferenceBase>();
        String[] nameParts = strValue.split("[$.]");
        Module module = context.getModule();
        if (nameParts.length == 0 || module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DataBindingConverter.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int offset = start;
        DataBindingInfo bindingInfo = DataBindingConverter.getDataBindingInfo(context);
        int idx = 0;
        int diff = 0;
        String fullType = strValue.replace('$', '.');
        if (bindingInfo != null) {
            String alias = nameParts[idx];
            PsiDataBindingResourceItem anImport = DataBindingConverter.getImport(alias, bindingInfo);
            if (anImport != null) {
                ++idx;
                TextRange range = new TextRange(offset, offset += alias.length());
                ++offset;
                String type = anImport.getTypeDeclaration();
                result.add(new AliasedReference(element, range, type, module));
                fullType = type + fullType.substring(alias.length());
                diff = type.length() - alias.length();
            } else if (nameParts.length == 1 && alias.length() > 0) {
                if (Character.isLowerCase(alias.charAt(0))) {
                    PsiPrimitiveType primitive = PsiJavaParserFacadeImpl.getPrimitiveType((String)alias);
                    if (primitive != null) {
                        result.add(new PsiReferenceBase<PsiElement>(element, true){

                            @Nullable
                            public PsiElement resolve() {
                                return this.myElement;
                            }

                            @NotNull
                            public Object[] getVariants() {
                                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return ArrayUtil.EMPTY_OBJECT_ARRAY;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/DataBindingConverter$1", "getVariants"));
                            }
                        });
                    }
                } else {
                    PsiClass aClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass("java.lang." + alias, GlobalSearchScope.moduleWithLibrariesScope((Module)module));
                    if (aClass != null) {
                        TextRange range = new TextRange(offset, offset += alias.length());
                        result.add(new ClassReference(element, range, (PsiElement)aClass));
                    }
                }
                ++idx;
            }
        }
        while (idx < nameParts.length) {
            String packageName = nameParts[idx];
            if (packageName.length() > 0) {
                TextRange range = new TextRange(offset, offset += packageName.length());
                result.add(new AliasedReference(element, range, fullType.substring(0, diff + offset - start), module));
            }
            ++idx;
            ++offset;
        }
        PsiReference[] psiReferenceArray = result.toArray(new PsiReference[result.size()]);
        if (psiReferenceArray == null) {
            DataBindingConverter.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    @Nullable
    private static DataBindingInfo getDataBindingInfo(@NotNull ConvertContext context) {
        if (context == null) {
            DataBindingConverter.$$$reportNull$$$0(5);
        }
        return DataBindingXmlReferenceContributor.getDataBindingInfo((PsiElement)context.getFile());
    }

    private static String getLongestPrefix(@Nullable String a, @Nullable String b) {
        int i;
        if (a == null || b == null) {
            return "";
        }
        String shorter = a.length() > b.length() ? b : a;
        String longer = a.length() > b.length() ? a : b;
        for (i = 0; i < shorter.length() && shorter.charAt(i) == longer.charAt(i); ++i) {
        }
        return shorter.substring(0, i);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataBindingInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/DataBindingConverter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/DataBindingConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getImport";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDataBindingInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClassReference
    extends PsiReferenceBase<PsiElement> {
        @NotNull
        private final PsiElement myResolveTo;

        public ClassReference(@NotNull PsiElement element, @NotNull TextRange range, @NotNull PsiElement resolveTo) {
            if (element == null) {
                ClassReference.$$$reportNull$$$0(0);
            }
            if (range == null) {
                ClassReference.$$$reportNull$$$0(1);
            }
            if (resolveTo == null) {
                ClassReference.$$$reportNull$$$0(2);
            }
            super(element, range);
            this.myResolveTo = resolveTo;
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.Resolver(){

                public PsiElement resolve(@NotNull PsiReference psiReference, boolean incompleteCode) {
                    if (psiReference == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return this.resolveInner();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiReference", "org/jetbrains/android/dom/converters/DataBindingConverter$ClassReference$1", "resolve"));
                }
            }, false, false);
        }

        private PsiElement resolveInner() {
            return this.myResolveTo;
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                ClassReference.$$$reportNull$$$0(3);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolveTo";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/converters/DataBindingConverter$ClassReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/converters/DataBindingConverter$ClassReference";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AliasedReference
    extends PsiReferenceBase<PsiElement> {
        private final String myReferenceTo;
        private final Module myModule;

        public AliasedReference(PsiElement referenceFrom, TextRange range, String referenceTo, Module module) {
            super(referenceFrom, range, true);
            this.myReferenceTo = referenceTo;
            this.myModule = module;
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.Resolver(){

                public PsiElement resolve(@NotNull PsiReference psiReference, boolean incompleteCode) {
                    if (psiReference == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return this.resolveInner();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiReference", "org/jetbrains/android/dom/converters/DataBindingConverter$AliasedReference$1", "resolve"));
                }
            }, false, false);
        }

        private PsiElement resolveInner() {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myElement.getProject());
            PsiPackage aPackage = facade.findPackage(this.myReferenceTo);
            if (aPackage != null) {
                return aPackage;
            }
            PsiClass aClass = facade.findClass(this.myReferenceTo, this.myModule != null ? this.myModule.getModuleWithDependenciesAndLibrariesScope(false) : this.myElement.getResolveScope());
            if (aClass != null) {
                return aClass;
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                AliasedReference.$$$reportNull$$$0(0);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myReferenceTo;
            if (string == null) {
                AliasedReference.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/android/dom/converters/DataBindingConverter$AliasedReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

