/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidResourceDomFileDescription<T extends DomElement>
extends DomFileDescription<T> {
    protected final ResourceFolderType myResourceType;

    public AndroidResourceDomFileDescription(Class<T> rootElementClass, @NonNls String rootTagName, @NotNull ResourceFolderType resourceType) {
        if (resourceType == null) {
            AndroidResourceDomFileDescription.$$$reportNull$$$0(0);
        }
        super(rootElementClass, rootTagName, new String[0]);
        this.myResourceType = resourceType;
    }

    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        if (file == null) {
            AndroidResourceDomFileDescription.$$$reportNull$$$0(1);
        }
        return AndroidResourceDomFileDescription.doIsMyFile(file, this.myResourceType);
    }

    public static boolean doIsMyFile(final XmlFile file, final ResourceFolderType resourceType) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (file.getProject().isDisposed()) {
                    return false;
                }
                if (AndroidResourceUtil.isInResourceSubdirectory((PsiFile)file, resourceType.getName())) {
                    return AndroidFacet.getInstance((PsiElement)file) != null;
                }
                return false;
            }
        });
    }

    protected void initializeFileDescription() {
        this.registerNamespacePolicy("android", new String[]{"http://schemas.android.com/apk/res/android"});
    }

    @NotNull
    public ResourceFolderType getResourceType() {
        ResourceFolderType resourceFolderType = this.myResourceType;
        if (resourceFolderType == null) {
            AndroidResourceDomFileDescription.$$$reportNull$$$0(2);
        }
        return resourceFolderType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/AndroidResourceDomFileDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/AndroidResourceDomFileDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMyFile";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

