/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import java.lang.reflect.Type;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.dom.SubtagsProcessingUtil;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDomExtender
extends DomExtender<AndroidDomElement> {
    public boolean supportsStubs() {
        return false;
    }

    @NotNull
    private static Class getValueClass(@Nullable AttributeFormat format) {
        if (format == null) {
            if (String.class == null) {
                AndroidDomExtender.$$$reportNull$$$0(0);
            }
            return String.class;
        }
        switch (format) {
            case Boolean: {
                Class<Boolean> clazz = Boolean.TYPE;
                if (clazz == null) {
                    AndroidDomExtender.$$$reportNull$$$0(1);
                }
                return clazz;
            }
            case Reference: 
            case Dimension: 
            case Color: {
                if (ResourceValue.class == null) {
                    AndroidDomExtender.$$$reportNull$$$0(2);
                }
                return ResourceValue.class;
            }
        }
        if (String.class == null) {
            AndroidDomExtender.$$$reportNull$$$0(3);
        }
        return String.class;
    }

    public void registerExtensions(@NotNull AndroidDomElement element, @NotNull DomExtensionsRegistrar registrar) {
        AndroidFacet facet;
        if (element == null) {
            AndroidDomExtender.$$$reportNull$$$0(4);
        }
        if (registrar == null) {
            AndroidDomExtender.$$$reportNull$$$0(5);
        }
        if ((facet = AndroidFacet.getInstance(element)) == null) {
            return;
        }
        AttributeProcessingUtil.processAttributes(element, facet, true, (xmlName, attrDef, parentStyleableName) -> {
            Set<AttributeFormat> formats;
            if (registrar == null) {
                AndroidDomExtender.$$$reportNull$$$0(6);
            }
            Class valueClass = (formats = attrDef.getFormats()).size() == 1 ? AndroidDomExtender.getValueClass(formats.iterator().next()) : String.class;
            registrar.registerAttributeChildExtension(xmlName, GenericAttributeValue.class);
            return registrar.registerGenericAttributeValueChildExtension(xmlName, (Type)valueClass);
        });
        SubtagsProcessingUtil.processSubtags(facet, element, (arg_0, arg_1) -> ((DomExtensionsRegistrar)registrar).registerCollectionChildrenExtension(arg_0, arg_1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/AndroidDomExtender";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueClass";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/AndroidDomExtender";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerExtensions$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

