/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.converter;

import com.intellij.conversion.ArtifactsSettings;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectConverter;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.Processor;
import java.util.ArrayList;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.android.converter.AndroidConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProguardOptionsConverterProvider
extends ConverterProvider {
    protected AndroidProguardOptionsConverterProvider() {
        super("android-proguard-options");
    }

    @NotNull
    public String getConversionDescription() {
        if ("Android ProGuard options will be converted to new format" == null) {
            AndroidProguardOptionsConverterProvider.$$$reportNull$$$0(0);
        }
        return "Android ProGuard options will be converted to new format";
    }

    @NotNull
    public ProjectConverter createConverter(@NotNull ConversionContext context) {
        if (context == null) {
            AndroidProguardOptionsConverterProvider.$$$reportNull$$$0(1);
        }
        MyProjectConverter myProjectConverter = new MyProjectConverter();
        if (myProjectConverter == null) {
            AndroidProguardOptionsConverterProvider.$$$reportNull$$$0(2);
        }
        return myProjectConverter;
    }

    public boolean canDetermineIfConversionAlreadyPerformedByProjectFiles() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/converter/AndroidProguardOptionsConverterProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConversionDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/converter/AndroidProguardOptionsConverterProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConverter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyArtifactsConverter
    extends ConversionProcessor<ArtifactsSettings> {
        private static final String RUN_PROGUARD_OPTION_NAME = "runProGuard";

        private MyArtifactsConverter() {
        }

        public boolean isConversionNeeded(ArtifactsSettings settings) {
            return MyArtifactsConverter.processAndroidPropertiesElements(settings, new Processor<Element>(){

                public boolean process(Element element) {
                    return Boolean.parseBoolean(AndroidConversionUtil.getOptionValue(element, MyArtifactsConverter.RUN_PROGUARD_OPTION_NAME));
                }
            });
        }

        public void process(ArtifactsSettings settings) throws CannotConvertException {
            MyArtifactsConverter.processAndroidPropertiesElements(settings, new Processor<Element>(){

                public boolean process(Element element) {
                    if (Boolean.parseBoolean(AndroidConversionUtil.getOptionValue(element, MyArtifactsConverter.RUN_PROGUARD_OPTION_NAME))) {
                        MyArtifactsConverter.doConvertArtifact(element);
                    }
                    return false;
                }
            });
        }

        private static void doConvertArtifact(@NotNull Element element) {
            Element proguardCfgOptionElement;
            if (element == null) {
                MyArtifactsConverter.$$$reportNull$$$0(0);
            }
            String proguardCfgFileUrl = (proguardCfgOptionElement = AndroidConversionUtil.getOptionElement(element, "proGuardCfgFileUrl")) != null ? proguardCfgOptionElement.getAttributeValue("value") : null;
            Element includeSystemCfgElement = AndroidConversionUtil.getOptionElement(element, "includeSystemProGuardCfgFile");
            String includeSystemCfgStr = includeSystemCfgElement != null ? includeSystemCfgElement.getAttributeValue("value") : null;
            element.removeContent((Content)proguardCfgOptionElement);
            if (includeSystemCfgElement != null) {
                element.removeContent((Content)includeSystemCfgElement);
            }
            ArrayList<String> proguardCfgUrls = new ArrayList<String>();
            if (Boolean.parseBoolean(includeSystemCfgStr)) {
                proguardCfgUrls.add("file://%MODULE_SDK_HOME%/tools/proguard/proguard-android.txt");
            }
            if (proguardCfgFileUrl != null && proguardCfgFileUrl.length() > 0) {
                proguardCfgUrls.add(proguardCfgFileUrl);
            }
            if (proguardCfgUrls.size() == 0) {
                return;
            }
            Element listElement = new Element("list");
            for (String url : proguardCfgUrls) {
                Element fileElement = new Element("option");
                fileElement.setAttribute("value", url);
                listElement.addContent(fileElement);
            }
            Element newElement = new Element("option");
            newElement.setAttribute("name", "proGuardCfgFiles");
            newElement.addContent(listElement);
            element.addContent(newElement);
        }

        private static boolean processAndroidPropertiesElements(ArtifactsSettings settings, Processor<Element> processor) {
            for (Element artifactElement : settings.getArtifacts()) {
                for (Element propertiesElement : artifactElement.getChildren("properties")) {
                    Element optionsElement;
                    String propertiesId = propertiesElement.getAttributeValue("id");
                    if (!"android-properties".equals(propertiesId) || (optionsElement = propertiesElement.getChild("options")) == null || !processor.process((Object)optionsElement)) continue;
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/converter/AndroidProguardOptionsConverterProvider$MyArtifactsConverter", "doConvertArtifact"));
        }
    }

    private static class MyModuleFileConverter
    extends ConversionProcessor<ModuleSettings> {
        private static final String PROGUARD_CFG_PATH_OPTION = "PROGUARD_CFG_PATH";

        private MyModuleFileConverter() {
        }

        public boolean isConversionNeeded(ModuleSettings settings) {
            Element confElement = AndroidConversionUtil.findAndroidFacetConfigurationElement(settings);
            return confElement != null && Boolean.parseBoolean(AndroidConversionUtil.getOptionValue(confElement, "RUN_PROGUARD"));
        }

        public void process(ModuleSettings settings) throws CannotConvertException {
            String includeSystemCfgStr;
            String proguardCfgRelPath;
            Element confElement = AndroidConversionUtil.findAndroidFacetConfigurationElement(settings);
            if (confElement == null) {
                return;
            }
            Element proguardCfgOptionElement = AndroidConversionUtil.getOptionElement(confElement, PROGUARD_CFG_PATH_OPTION);
            String string = proguardCfgRelPath = proguardCfgOptionElement != null ? proguardCfgOptionElement.getAttributeValue("value") : null;
            if (proguardCfgRelPath == null || proguardCfgRelPath.length() == 0) {
                proguardCfgRelPath = "/proguard-project.txt";
            }
            if (proguardCfgOptionElement != null) {
                confElement.removeContent((Content)proguardCfgOptionElement);
            }
            String proguardCfgFileUrl = VfsUtilCore.pathToUrl((String)("$MODULE_DIR$" + proguardCfgRelPath));
            Element includeSystemCfgElement = confElement.getChild("includeSystemProguardFile");
            String string2 = includeSystemCfgStr = includeSystemCfgElement != null ? includeSystemCfgElement.getText() : null;
            if (includeSystemCfgElement != null) {
                confElement.removeContent((Content)includeSystemCfgElement);
            }
            ArrayList<String> proguardCfgUrls = new ArrayList<String>();
            if (!Boolean.FALSE.toString().equals(includeSystemCfgStr)) {
                proguardCfgUrls.add("file://%MODULE_SDK_HOME%/tools/proguard/proguard-android.txt");
            }
            proguardCfgUrls.add(proguardCfgFileUrl);
            Element newElement = new Element("proGuardCfgFiles");
            for (String url : proguardCfgUrls) {
                Element fileElement = new Element("file");
                fileElement.setText(url);
                newElement.addContent(fileElement);
            }
            confElement.addContent(newElement);
        }
    }

    private static class MyProjectConverter
    extends ProjectConverter {
        private MyProjectConverter() {
        }

        @Nullable
        public ConversionProcessor<ModuleSettings> createModuleFileConverter() {
            return new MyModuleFileConverter();
        }

        @Nullable
        public ConversionProcessor<ArtifactsSettings> createArtifactsConverter() {
            return new MyArtifactsConverter();
        }
    }
}

