/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.util;

import java.math.BigInteger;
import javax.swing.SpinnerNumberModel;

public class BigSpinnerNumberModel
extends SpinnerNumberModel {
    public BigSpinnerNumberModel(BigInteger value, Comparable minimum, Comparable maximum, Number stepSize) {
        super(value, minimum, maximum, stepSize);
    }

    private Number incrValue(int dir) {
        BigInteger value = (BigInteger)this.getNumber();
        Comparable<?> maximum = this.getMaximum();
        Comparable<?> minimum = this.getMinimum();
        BigInteger newValue = value.add(BigInteger.valueOf(this.getStepSize().longValue() * (long)dir));
        if (maximum != null && maximum.compareTo(newValue) < 0) {
            return null;
        }
        if (minimum != null && minimum.compareTo(newValue) > 0) {
            return null;
        }
        return newValue;
    }

    @Override
    public Object getNextValue() {
        return this.incrValue(1);
    }

    @Override
    public Object getPreviousValue() {
        return this.incrValue(-1);
    }
}

