/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.math.BigInteger;
import javax.swing.JScrollPane;

public class InfiniteScrollPane
extends JScrollPane {
    private InfinitePanel myInfinitePanel;

    public InfiniteScrollPane(Component panel) {
        this.setViewportView(panel);
        this.getVerticalScrollBar().addAdjustmentListener(e -> {
            if (!e.getValueIsAdjusting() && this.myInfinitePanel != null) {
                int value = e.getValue();
                int viewHeight = this.getViewport().getViewSize().height;
                int viewportHeight = this.getViewport().getExtentSize().height;
                BigInteger oldYOffset = this.myInfinitePanel.getYOffset();
                BigInteger newYOffset = this.checkYOffsetBounds(oldYOffset.add(BigInteger.valueOf(value - (viewHeight - viewportHeight) / 2)));
                if (!newYOffset.equals(oldYOffset)) {
                    this.myInfinitePanel.setYOffset(newYOffset);
                    this.getViewport().setViewPosition(new Point(0, this.getViewport().getViewPosition().y + oldYOffset.subtract(newYOffset).intValueExact()));
                    this.repaint();
                }
            }
        });
    }

    @Override
    public void setViewportView(Component view) {
        super.setViewportView(view);
        this.myInfinitePanel = view instanceof InfinitePanel ? (InfinitePanel)((Object)view) : null;
        this.updateViewPortSize();
    }

    public void setViewPosition(int x, BigInteger y) {
        int viewHeight = this.getViewport().getViewSize().height;
        int viewportHeight = this.getViewport().getExtentSize().height;
        BigInteger yOffset = this.checkYOffsetBounds(y.subtract(BigInteger.valueOf((viewHeight - viewportHeight) / 2)));
        this.myInfinitePanel.setYOffset(yOffset);
        this.getViewport().setViewPosition(new Point(x, y.subtract(yOffset).intValueExact()));
    }

    private BigInteger checkYOffsetBounds(BigInteger yOffset) {
        int viewHeight = this.getViewport().getViewSize().height;
        if (yOffset.compareTo(this.myInfinitePanel.getFullHeight().subtract(BigInteger.valueOf(viewHeight))) > 0) {
            yOffset = this.myInfinitePanel.getFullHeight().subtract(BigInteger.valueOf(viewHeight));
        }
        if (yOffset.compareTo(BigInteger.ZERO) < 0) {
            yOffset = BigInteger.ZERO;
        }
        return yOffset;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.updateViewPortSize();
    }

    private void updateViewPortSize() {
        if (this.myInfinitePanel != null) {
            Component view = this.getViewport().getView();
            Dimension viewPortSize = this.getViewport().getExtentSize();
            Dimension size = new Dimension(this.myInfinitePanel.getFullWidth(), this.myInfinitePanel.getFullHeight().min(BigInteger.valueOf(Math.max(500, viewPortSize.height) * 100)).intValueExact());
            assert (size.width > 0);
            assert (size.height > 0);
            size.width = Math.max(viewPortSize.width, size.width);
            size.height = Math.max(viewPortSize.height, size.height);
            view.setPreferredSize(size);
            view.setMinimumSize(size);
            view.setMaximumSize(size);
            view.setSize(size);
        }
    }

    public static interface InfinitePanel {
        public int getFullWidth();

        public BigInteger getFullHeight();

        public void setYOffset(BigInteger var1);

        public BigInteger getYOffset();
    }
}

