/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.layoutlib;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.RenderParamsFlags;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.RenderSecurityManagerFactory;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.AssetRepositoryImpl;
import com.android.tools.swing.layoutlib.AlreadyDisposedException;
import com.android.tools.swing.layoutlib.FakeImageFactory;
import com.android.tools.swing.layoutlib.InitializationException;
import com.android.tools.swing.layoutlib.UnsupportedLayoutlibException;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphicsLayoutRenderer {
    private static final Logger LOG = Logger.getInstance(GraphicsLayoutRenderer.class);
    private static final int MIN_LAYOUTLIB_API_VERSION = 15;
    private final FakeImageFactory myImageFactory;
    private final DynamicHardwareConfig myHardwareConfig;
    private final Object myCredential;
    private final RenderSecurityManager mySecurityManager;
    private boolean myInvalidate;
    private final List<ResourceValue> myResourceLookupChain;
    private final ReentrantReadWriteLock myRenderSessionLock;
    private RenderSession myRenderSession;
    private double myScale;

    private GraphicsLayoutRenderer(@NotNull LayoutLibrary layoutLib, @NotNull SessionParams sessionParams, @Nullable RenderSecurityManager securityManager, @NotNull DynamicHardwareConfig hardwareConfig, @NotNull List<ResourceValue> resourceLookupChain, @NotNull Object credential) {
        if (layoutLib == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(0);
        }
        if (sessionParams == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(1);
        }
        if (hardwareConfig == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(2);
        }
        if (resourceLookupChain == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(3);
        }
        if (credential == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(4);
        }
        this.myRenderSessionLock = new ReentrantReadWriteLock();
        this.myScale = 1.0;
        this.mySecurityManager = securityManager;
        this.myHardwareConfig = hardwareConfig;
        this.myImageFactory = new FakeImageFactory();
        this.myResourceLookupChain = resourceLookupChain;
        this.myCredential = credential;
        sessionParams.setFlag(RenderParamsFlags.FLAG_KEY_DISABLE_BITMAP_CACHING, (Object)Boolean.TRUE);
        sessionParams.setImageFactory((IImageFactory)this.myImageFactory);
        this.myRenderSession = GraphicsLayoutRenderer.initRenderSession(layoutLib, sessionParams, this.mySecurityManager, this.myCredential);
    }

    @VisibleForTesting
    @NotNull
    static GraphicsLayoutRenderer create(@NotNull AndroidFacet facet, @NotNull AndroidPlatform platform, @NotNull Project project, @NotNull Configuration configuration, @NotNull ILayoutPullParser parser, @Nullable Color backgroundColor, @NotNull SessionParams.RenderingMode renderingMode, boolean useSecurityManager) throws InitializationException {
        LayoutLibrary layoutLib;
        if (facet == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(5);
        }
        if (platform == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(8);
        }
        if (parser == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(9);
        }
        if (renderingMode == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(10);
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        try {
            IAndroidTarget latestTarget = configuration.getConfigurationManager().getHighestApiTarget();
            if (latestTarget == null) {
                throw new UnsupportedLayoutlibException("GraphicsLayoutRenderer requires at least layoutlib version 15");
            }
            layoutLib = platform.getSdkData().getTargetData(latestTarget).getLayoutLibrary(project);
            if (layoutLib == null) {
                throw new InitializationException("getLayoutLibrary() returned null");
            }
        }
        catch (RenderingException e) {
            throw new InitializationException(e);
        }
        catch (IOException e) {
            throw new InitializationException(e);
        }
        if (layoutLib.getApiLevel() < 15) {
            throw new UnsupportedLayoutlibException("GraphicsLayoutRenderer requires at least layoutlib version 15");
        }
        AppResourceRepository appResources = AppResourceRepository.getAppResources(facet, true);
        final Module module = facet.getModule();
        Object credential = new Object();
        RenderLogger logger = new RenderLogger("theme_editor", module, credential);
        final ActionBarCallback actionBarCallback = new ActionBarCallback();
        final LayoutlibCallbackImpl layoutlibCallback = new LayoutlibCallbackImpl(null, layoutLib, appResources, module, facet, logger, credential, null){

            @Override
            public ActionBarCallback getActionBarCallback() {
                return actionBarCallback;
            }
        };
        boolean loadRResult = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (module.isDisposed()) {
                    return false;
                }
                layoutlibCallback.loadAndParseRClass();
                return true;
            }
        });
        if (!loadRResult) {
            throw new AlreadyDisposedException("Module was already disposed");
        }
        IAndroidTarget target = configuration.getTarget();
        if (target == null) {
            throw new InitializationException("Unable to get IAndroidTarget");
        }
        Device device = configuration.getDevice();
        assert (device != null);
        HardwareConfigHelper hardwareConfigHelper = new HardwareConfigHelper(device);
        DynamicHardwareConfig hardwareConfig = new DynamicHardwareConfig(hardwareConfigHelper.getConfig());
        ArrayList<ResourceValue> resourceLookupChain = new ArrayList<ResourceValue>();
        ResourceResolver resourceResolver = ResourceResolver.copy((ResourceResolver)configuration.getResourceResolver());
        assert (resourceResolver != null);
        ResourceResolver recordingResourceResolver = resourceResolver.createRecorder(resourceLookupChain);
        SessionParams params = new SessionParams(parser, renderingMode, (Object)module, (HardwareConfig)hardwareConfig, (RenderResources)recordingResourceResolver, (LayoutlibCallback)layoutlibCallback, moduleInfo.getMinSdkVersion().getApiLevel(), moduleInfo.getTargetSdkVersion().getApiLevel(), (LayoutLog)logger, target instanceof CompatibilityRenderTarget ? target.getVersion().getApiLevel() : 0);
        params.setForceNoDecor();
        params.setAssetRepository((AssetRepository)new AssetRepositoryImpl(facet));
        params.setAppLabel("");
        if (backgroundColor != null) {
            params.setOverrideBgColor(backgroundColor.getRGB());
        }
        RenderSecurityManager mySecurityManager = useSecurityManager ? RenderSecurityManagerFactory.create(module, platform) : null;
        GraphicsLayoutRenderer graphicsLayoutRenderer = new GraphicsLayoutRenderer(layoutLib, params, mySecurityManager, hardwareConfig, resourceLookupChain, credential);
        if (graphicsLayoutRenderer == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(11);
        }
        return graphicsLayoutRenderer;
    }

    @NotNull
    public static GraphicsLayoutRenderer create(@NotNull Configuration configuration, @NotNull ILayoutPullParser parser, @Nullable Color backgroundColor, boolean hasHorizontalScroll, boolean hasVerticalScroll) throws InitializationException {
        Module module;
        if (configuration == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(12);
        }
        if (parser == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(13);
        }
        if ((module = configuration.getModule()).isDisposed()) {
            throw new AlreadyDisposedException("Module was already disposed");
        }
        AndroidFacet facet = AndroidFacet.getInstance(configuration.getModule());
        if (facet == null) {
            throw new InitializationException("Unable to get AndroidFacet");
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null) {
            throw new UnsupportedLayoutlibException("No Android SDK found.");
        }
        SessionParams.RenderingMode renderingMode = hasVerticalScroll && hasHorizontalScroll ? SessionParams.RenderingMode.FULL_EXPAND : (hasVerticalScroll ? SessionParams.RenderingMode.V_SCROLL : (hasHorizontalScroll ? SessionParams.RenderingMode.H_SCROLL : SessionParams.RenderingMode.NORMAL));
        GraphicsLayoutRenderer graphicsLayoutRenderer = GraphicsLayoutRenderer.create(facet, platform, module.getProject(), configuration, parser, backgroundColor, renderingMode, true);
        if (graphicsLayoutRenderer == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(14);
        }
        return graphicsLayoutRenderer;
    }

    @NotNull
    private Dimension modelToView(int width, int height) {
        Dimension dimension = new Dimension((int)((double)width * this.myScale), (int)((double)height * this.myScale));
        if (dimension == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(15);
        }
        return dimension;
    }

    @NotNull
    private Dimension viewToModel(int width, int height) {
        Dimension dimension = new Dimension((int)((double)width / this.myScale), (int)((double)height / this.myScale));
        if (dimension == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(16);
        }
        return dimension;
    }

    @NotNull
    private Point viewToModel(@NotNull Point p) {
        if (p == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(17);
        }
        Point point = new Point((int)((double)p.x / this.myScale), (int)((double)p.y / this.myScale));
        if (point == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(18);
        }
        return point;
    }

    public void setScale(double scale) {
        this.myScale = scale;
        this.setSize(new Dimension(this.myHardwareConfig.getScreenWidth(), this.myHardwareConfig.getScreenHeight()));
    }

    public void setSize(int width, int height) {
        Dimension dimen = this.viewToModel(width, height);
        this.myHardwareConfig.setScreenSize(Math.max(dimen.width, 1), Math.max(dimen.height, 1));
        this.myInvalidate = true;
    }

    public void setSize(Dimension dimen) {
        this.setSize(dimen.width, dimen.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render(@NotNull Graphics2D graphics) {
        if (graphics == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(19);
        }
        this.myRenderSessionLock.readLock().lock();
        try {
            if (!SystemInfo.isMac) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.myImageFactory.setGraphics(graphics);
            AffineTransform oldTransform = graphics.getTransform();
            if (this.myScale != 1.0) {
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                AffineTransform scaleTransform = new AffineTransform(oldTransform);
                scaleTransform.scale(this.myScale, this.myScale);
                graphics.setTransform(scaleTransform);
            }
            Result result = null;
            try {
                result = RenderService.runRenderAction(new Callable<Result>(){

                    @Override
                    public Result call() {
                        if (GraphicsLayoutRenderer.this.mySecurityManager != null) {
                            GraphicsLayoutRenderer.this.mySecurityManager.setActive(true, GraphicsLayoutRenderer.this.myCredential);
                        }
                        try {
                            Result result = GraphicsLayoutRenderer.this.myRenderSession.render(250L, GraphicsLayoutRenderer.this.myInvalidate);
                            return result;
                        }
                        finally {
                            if (GraphicsLayoutRenderer.this.mySecurityManager != null) {
                                GraphicsLayoutRenderer.this.mySecurityManager.setActive(false, GraphicsLayoutRenderer.this.myCredential);
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                LOG.warn("Exception running render action", (Throwable)e);
            }
            if (this.myScale != 1.0) {
                graphics.setTransform(oldTransform);
            }
            if (result != null && result.getStatus() != Result.Status.SUCCESS) {
                if (result.getException() != null) {
                    LOG.warn(result.getException());
                } else {
                    LOG.warn("Render error (no exception). Status=" + result.getStatus().name());
                }
                boolean bl = false;
                return bl;
            }
            this.myInvalidate = false;
            boolean bl = true;
            return bl;
        }
        finally {
            this.myRenderSessionLock.readLock().unlock();
        }
    }

    @Nullable
    private static RenderSession initRenderSession(final @NotNull LayoutLibrary layoutLibrary, final @NotNull SessionParams sessionParams, final @Nullable RenderSecurityManager securityManager, final @NotNull Object credential) {
        if (layoutLibrary == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(20);
        }
        if (sessionParams == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(21);
        }
        if (credential == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(22);
        }
        try {
            Result result;
            RenderSession session = RenderService.runRenderAction(new Callable<RenderSession>(){

                @Override
                public RenderSession call() {
                    if (securityManager != null) {
                        securityManager.setActive(true, credential);
                    }
                    try {
                        RenderSession renderSession = (RenderSession)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RenderSession>(){

                            public RenderSession compute() {
                                return layoutLibrary.createSession(sessionParams);
                            }
                        });
                        return renderSession;
                    }
                    finally {
                        if (securityManager != null) {
                            securityManager.setActive(false, credential);
                        }
                    }
                }
            });
            if (session == null) {
                LOG.warn("initRenderSession failed (returned null)");
                return null;
            }
            if (layoutLibrary.supports(17)) {
                session.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(500L));
            }
            if ((result = session.getResult()) != null && result.getStatus() != Result.Status.SUCCESS) {
                if (result.getException() != null) {
                    LOG.warn(result.getException());
                } else {
                    LOG.warn("Render error (no exception). Status=" + result.getStatus().name());
                }
            }
            return session;
        }
        catch (Exception e) {
            LOG.warn("initRenderSession failed", (Throwable)e);
            return null;
        }
    }

    @NotNull
    public Set<String> getUsedAttrs() {
        HashSet<String> usedAttrs = new HashSet<String>();
        for (ResourceValue value : this.myResourceLookupChain) {
            if (!(value instanceof ItemResourceValue) || value.getName() == null) continue;
            ItemResourceValue itemValue = (ItemResourceValue)value;
            usedAttrs.add((itemValue.isFrameworkAttr() ? "android:" : "") + itemValue.getName());
        }
        Set<String> set = Collections.unmodifiableSet(usedAttrs);
        if (set == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(23);
        }
        return set;
    }

    @Nullable
    private static ViewInfo viewAtPoint(@NotNull Point parentPosition, @NotNull ViewInfo view, @NotNull Point p) {
        int y;
        ViewInfo bounds;
        int x;
        Rectangle rect;
        if (parentPosition == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(24);
        }
        if (view == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(25);
        }
        if (p == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(26);
        }
        if ((rect = new Rectangle(x = parentPosition.x + (bounds = RenderService.getSafeBounds(view)).getLeft(), y = parentPosition.y + bounds.getTop(), bounds.getRight() - bounds.getLeft(), bounds.getBottom() - bounds.getTop())).contains(p)) {
            for (ViewInfo childView : view.getChildren()) {
                ViewInfo hitView;
                if (childView.getCookie() == null || (hitView = GraphicsLayoutRenderer.viewAtPoint(rect.getLocation(), childView, p)) == null) continue;
                return hitView;
            }
            return view;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ViewInfo findViewAtPoint(@NotNull Point p) {
        if (p == null) {
            GraphicsLayoutRenderer.$$$reportNull$$$0(27);
        }
        this.myRenderSessionLock.readLock().lock();
        try {
            if (this.myRenderSession == null) {
                ViewInfo viewInfo = null;
                return viewInfo;
            }
            p = this.viewToModel(p);
            List rootViews = this.myRenderSession.getRootViews();
            if (rootViews == null) {
                ViewInfo viewInfo = null;
                return viewInfo;
            }
            Point base = new Point();
            for (ViewInfo view : rootViews) {
                ViewInfo hitView = GraphicsLayoutRenderer.viewAtPoint(base, view, p);
                if (hitView == null) continue;
                ViewInfo viewInfo = hitView;
                return viewInfo;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.myRenderSessionLock.readLock().unlock();
        }
    }

    public Dimension getPreferredSize() {
        return this.modelToView(this.myImageFactory.getRequestedWidth(), this.myImageFactory.getRequestedHeight());
    }

    public void dispose() {
        this.myRenderSessionLock.writeLock().lock();
        try {
            if (this.myRenderSession != null) {
                this.myImageFactory.setGraphics(null);
                RenderService.runRenderAction(() -> ((RenderSession)this.myRenderSession).dispose());
                this.myRenderSession = null;
            }
        }
        catch (Exception e) {
            LOG.error("Error while disposing the session", (Throwable)e);
        }
        finally {
            this.myRenderSessionLock.writeLock().unlock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutLib";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionParams";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hardwareConfig";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceLookupChain";
                break;
            }
            case 4: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credential";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderingMode";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer";
                break;
            }
            case 17: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutLibrary";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPosition";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "modelToView";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "viewToModel";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedAttrs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 23: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "viewToModel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "initRenderSession";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "viewAtPoint";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findViewAtPoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class DynamicHardwareConfig
    extends HardwareConfig {
        private int myWidth;
        private int myHeight;

        public DynamicHardwareConfig(HardwareConfig delegate) {
            super(delegate.getScreenWidth(), delegate.getScreenHeight(), delegate.getDensity(), delegate.getXdpi(), delegate.getYdpi(), delegate.getScreenSize(), delegate.getOrientation(), delegate.getScreenRoundness(), delegate.hasSoftwareButtons());
            this.myWidth = delegate.getScreenWidth();
            this.myHeight = delegate.getScreenHeight();
        }

        public void setScreenSize(int width, int height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public int getScreenWidth() {
            return this.myWidth;
        }

        public int getScreenHeight() {
            return this.myHeight;
        }
    }
}

