/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.google.common.collect.Maps;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogEarthquakeShaker;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialogWrapperHost
extends DialogWrapper
implements DynamicWizardHost {
    protected Action myPreviousAction = new PreviousAction();
    protected Action myNextAction = new NextAction();
    protected Action myFinishAction = new FinishAction();
    private DynamicWizard myWizard;
    private TallImageComponent myIcon = new TallImageComponent(null);
    private AtomicReference<ProgressIndicator> myCurrentProgressIndicator = new AtomicReference();
    private JPanel myCenterPanel;
    private Map<Action, JButton> myActionToButtonMap = Maps.newHashMapWithExpectedSize((int)5);

    public DialogWrapperHost(@Nullable Project project, DialogWrapper.IdeModalityType modalityType) {
        super(project, true, modalityType);
    }

    public DialogWrapperHost(@Nullable Project project) {
        super(project);
    }

    @Override
    public void init(@NotNull DynamicWizard wizard) {
        Container rootPanel;
        Window window;
        if (wizard == null) {
            DialogWrapperHost.$$$reportNull$$$0(0);
        }
        if ((window = this.getWindow()) == null) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
        } else {
            window.setMinimumSize(WizardConstants.DEFAULT_WIZARD_WINDOW_SIZE);
        }
        this.myWizard = wizard;
        super.init();
        Container centerRootPanel = this.myCenterPanel.getParent();
        if (centerRootPanel != null && (rootPanel = centerRootPanel.getParent()) instanceof JPanel) {
            ((JPanel)rootPanel).setBorder((Border)JBUI.Borders.empty());
        }
    }

    @Override
    public void close(@NotNull DynamicWizardHost.CloseAction action) {
        if (action == null) {
            DialogWrapperHost.$$$reportNull$$$0(1);
        }
        if (action == DynamicWizardHost.CloseAction.FINISH) {
            this.doOKAction();
        } else if (action == DynamicWizardHost.CloseAction.CANCEL) {
            this.dialogWrapperCancel();
        }
    }

    private void dialogWrapperCancel() {
        super.doCancelAction();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent focusedComponent = this.myWizard.getPreferredFocusedComponent();
        return focusedComponent == null ? this.getNextButton() : focusedComponent;
    }

    @Override
    public void shakeWindow() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DialogEarthquakeShaker.shake((Window)((JDialog)this.getPeer().getWindow()));
        }
    }

    @NotNull
    protected Action[] createActions() {
        if (this.getHelpId() == null) {
            if (SystemInfo.isMac) {
                Action[] actionArray = new Action[]{this.getCancelAction(), this.myPreviousAction, this.myNextAction, this.myFinishAction};
                if (actionArray == null) {
                    DialogWrapperHost.$$$reportNull$$$0(2);
                }
                return actionArray;
            }
            Action[] actionArray = new Action[]{this.myPreviousAction, this.myNextAction, this.getCancelAction(), this.myFinishAction};
            if (actionArray == null) {
                DialogWrapperHost.$$$reportNull$$$0(3);
            }
            return actionArray;
        }
        if (SystemInfo.isMac) {
            Action[] actionArray = new Action[]{this.getHelpAction(), this.getCancelAction(), this.myPreviousAction, this.myNextAction, this.myFinishAction};
            if (actionArray == null) {
                DialogWrapperHost.$$$reportNull$$$0(4);
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.myPreviousAction, this.myNextAction, this.getCancelAction(), this.myFinishAction, this.getHelpAction()};
        if (actionArray == null) {
            DialogWrapperHost.$$$reportNull$$$0(5);
        }
        return actionArray;
    }

    @Override
    public void setIcon(@Nullable Icon icon) {
        this.myIcon.setIcon(icon);
        this.myIcon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
    }

    @Override
    public void runSensitiveOperation(@NotNull ProgressIndicator progressIndicator, boolean cancellable, final @NotNull Runnable operation) {
        if (progressIndicator == null) {
            DialogWrapperHost.$$$reportNull$$$0(6);
        }
        if (operation == null) {
            DialogWrapperHost.$$$reportNull$$$0(7);
        }
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (!this.myCurrentProgressIndicator.compareAndSet(null, progressIndicator)) {
            throw new IllegalStateException("Submitting an operation while another is in progress.");
        }
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(null);
        this.updateButtons(false, false, true, false);
        Task.Backgroundable task = new Task.Backgroundable(null, this.myWizard.getWizardActionDescription(), cancellable){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                operation.run();
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DialogWrapperHost.this.updateButtons(false, false, false, true);
                        DialogWrapperHost.this.myCurrentProgressIndicator.set(null);
                    }
                }, ModalityState.stateForComponent((Component)DialogWrapperHost.this.myWizard.getContentPane()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/wizard/dynamic/DialogWrapperHost$1", "run"));
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, progressIndicator);
    }

    protected final JButton createJButtonForAction(Action action) {
        JButton button = super.createJButtonForAction(action);
        this.myActionToButtonMap.put(action, button);
        return button;
    }

    protected void doHelpAction() {
    }

    @Nullable
    protected JComponent createSouthPanel() {
        JPanel southPanel = (JPanel)super.createSouthPanel();
        assert (southPanel != null);
        southPanel.setBorder(new EmptyBorder(WizardConstants.STUDIO_WIZARD_INSETS));
        return southPanel;
    }

    public final void doCancelAction() {
        ProgressIndicator indicator = this.myCurrentProgressIndicator.get();
        if (indicator != null) {
            indicator.cancel();
        } else {
            this.myWizard.doCancelAction();
        }
    }

    @Override
    public void updateButtons(boolean canGoPrev, boolean canGoNext, boolean canCancel, boolean canFinish) {
        JButton next;
        JButton prev = this.getPreviousButton();
        if (prev != null) {
            prev.setEnabled(canGoPrev);
        }
        if ((next = this.getNextButton()) != null) {
            next.setEnabled(canGoNext);
        }
        this.getFinishButton().setEnabled(canFinish);
        this.getCancelButton().setEnabled(canCancel);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getRootPane().setDefaultButton(canFinish ? this.getFinishButton() : this.getNextButton());
        }
    }

    @Nullable
    protected final JComponent createCenterPanel() {
        this.myCenterPanel = new JPanel(new BorderLayout());
        this.myCenterPanel.add(this.myWizard.getContentPane(), "Center");
        this.myCenterPanel.add((Component)((Object)this.myIcon), "West");
        return this.myCenterPanel;
    }

    @Nullable
    protected JButton getNextButton() {
        return this.myActionToButtonMap.get(this.myNextAction);
    }

    @Nullable
    protected JButton getPreviousButton() {
        return this.myActionToButtonMap.get(this.myPreviousAction);
    }

    @NotNull
    protected JButton getFinishButton() {
        JButton jButton = this.myActionToButtonMap.get(this.myFinishAction);
        if (jButton == null) {
            DialogWrapperHost.$$$reportNull$$$0(8);
        }
        return jButton;
    }

    @NotNull
    protected JButton getCancelButton() {
        JButton jButton = this.myActionToButtonMap.get(this.myCancelAction);
        if (jButton == null) {
            DialogWrapperHost.$$$reportNull$$$0(9);
        }
        return jButton;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    @Override
    public void setPreferredWindowSize(Dimension dimension) {
        this.getContentPanel().setPreferredSize(dimension);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/wizard/dynamic/DialogWrapperHost";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/wizard/dynamic/DialogWrapperHost";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinishButton";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancelButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "close";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runSensitiveOperation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class FinishAction
    extends DialogWrapper.DialogWrapperAction {
        protected FinishAction() {
            super((DialogWrapper)DialogWrapperHost.this, IdeBundle.message((String)"button.finish", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            DialogWrapperHost.this.myWizard.doFinishAction();
        }
    }

    protected class PreviousAction
    extends DialogWrapper.DialogWrapperAction {
        protected PreviousAction() {
            super((DialogWrapper)DialogWrapperHost.this, IdeBundle.message((String)"button.wizard.previous", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            DialogWrapperHost.this.myWizard.doPreviousAction();
        }
    }

    protected class NextAction
    extends DialogWrapper.DialogWrapperAction {
        protected NextAction() {
            super((DialogWrapper)DialogWrapperHost.this, IdeBundle.message((String)"button.wizard.next", (Object[])new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        protected void doAction(ActionEvent e) {
            DialogWrapperHost.this.myWizard.doNextAction();
        }
    }

    public static class TallImageComponent
    extends OpaquePanel {
        @Nullable
        private Icon myIcon;

        public TallImageComponent(@Nullable Icon icon) {
            this.myIcon = icon;
        }

        protected void paintChildren(Graphics g) {
            if (this.myIcon == null) {
                return;
            }
            this.paintIcon(g);
        }

        public void paintIcon(Graphics g) {
            if (this.myIcon == null) {
                return;
            }
            BufferedImage image = UIUtil.createImage((int)this.myIcon.getIconWidth(), (int)this.myIcon.getIconHeight(), (int)2);
            Graphics2D gg = image.createGraphics();
            this.myIcon.paintIcon((Component)((Object)this), gg, 0, 0);
            Rectangle bounds = g.getClipBounds();
            for (int y = this.myIcon.getIconHeight() - 1; y < bounds.y + bounds.height; ++y) {
                g.drawImage(image, bounds.x, y, bounds.x + bounds.width, y + 1, 0, this.myIcon.getIconHeight() - 1, bounds.width, this.myIcon.getIconHeight(), (ImageObserver)((Object)this));
            }
            g.drawImage(image, 0, 0, (ImageObserver)((Object)this));
        }

        public void setIcon(@Nullable Icon icon) {
            this.myIcon = icon;
            this.revalidate();
            this.repaint();
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.myIcon != null ? this.myIcon.getIconWidth() : 0, 0);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.myIcon != null ? this.myIcon.getIconWidth() : 0, 0);
        }
    }
}

