/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.WelcomeUIUtils;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.templates.github.ZipUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class UnpackOperation
extends InstallOperation<File, File> {
    public static final String EXTRACT_OPERATION_OUTPUT = "x ";
    public static final String TAR_FLAGS_EXTRACT_UNPACK_VERBOSE_FILENAME_TARGETDIR = "xzvfC";
    public static final String DEFAULT_TAR_EXECUTABLE_PATH = "/usr/bin/tar";
    private final InstallContext myContext;

    public UnpackOperation(@NotNull InstallContext context, double progressShare) {
        if (context == null) {
            UnpackOperation.$$$reportNull$$$0(0);
        }
        super(context, progressShare);
        this.myContext = context;
    }

    @NotNull
    private static File unzip(File archive, File destination, @NotNull InstallContext context, ProgressIndicator progressIndicator) throws IOException {
        if (context == null) {
            UnpackOperation.$$$reportNull$$$0(1);
        }
        ZipUtil.unzip((ProgressIndicator)progressIndicator, (File)destination, (File)archive, null, null, (boolean)true);
        if (archive.getCanonicalPath().startsWith(context.getTempDirectory().getCanonicalPath())) {
            FileUtil.delete((File)archive);
        }
        File file = destination;
        if (file == null) {
            UnpackOperation.$$$reportNull$$$0(2);
        }
        return file;
    }

    @NotNull
    private static File untar(File archive, File destination, final InstallContext context, final ProgressIndicator indicator) throws IOException, WizardException {
        File file;
        if (!destination.mkdirs()) {
            throw new WizardException("Cannot create temporary directory to extract files");
        }
        indicator.start();
        indicator.setFraction(0.0);
        try {
            GeneralCommandLine line = new GeneralCommandLine(new String[]{UnpackOperation.getTarExecutablePath(), TAR_FLAGS_EXTRACT_UNPACK_VERBOSE_FILENAME_TARGETDIR, archive.getAbsolutePath(), destination.getAbsolutePath()});
            CapturingAnsiEscapesAwareProcessHandler handler = new CapturingAnsiEscapesAwareProcessHandler(line);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    String string;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)(string = event.getText()))) {
                        if (string.startsWith(UnpackOperation.EXTRACT_OPERATION_OUTPUT)) {
                            String fileName = string.substring(UnpackOperation.EXTRACT_OPERATION_OUTPUT.length()).trim();
                            indicator.setText(fileName);
                        } else if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
                            indicator.setText(string.trim());
                        } else {
                            context.print(string, ConsoleViewContentType.getConsoleViewType((Key)outputType));
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/idea/welcome/install/UnpackOperation$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (handler.runProcess().getExitCode() != 0) {
                throw new IOException("Unable to unpack archive file");
            }
            File file2 = destination;
            file = file2;
        }
        catch (ExecutionException e) {
            throw new WizardException("Unable to run tar utility");
        }
        finally {
            indicator.setFraction(1.0);
            indicator.stop();
        }
        if (file == null) {
            UnpackOperation.$$$reportNull$$$0(3);
        }
        return file;
    }

    @NotNull
    private static String getTarExecutablePath() {
        File file = new File(DEFAULT_TAR_EXECUTABLE_PATH);
        if (file.isFile()) {
            String string = file.getAbsolutePath();
            if (string == null) {
                UnpackOperation.$$$reportNull$$$0(4);
            }
            return string;
        }
        if ("tar" == null) {
            UnpackOperation.$$$reportNull$$$0(5);
        }
        return "tar";
    }

    @Override
    @NotNull
    protected File perform(@NotNull ProgressIndicator indicator, @NotNull File archive) throws WizardException {
        if (indicator == null) {
            UnpackOperation.$$$reportNull$$$0(6);
        }
        if (archive == null) {
            UnpackOperation.$$$reportNull$$$0(7);
        }
        String fileName = archive.getName();
        ArchiveType archiveType = ArchiveType.fromFileName(fileName);
        this.myContext.print(String.format("Unpacking %s\n", fileName), ConsoleViewContentType.SYSTEM_OUTPUT);
        File dir = new File(this.myContext.getTempDirectory(), fileName + "-unpacked");
        while (true) {
            File file;
            try {
                file = archiveType.unpack(archive, dir, this.myContext, indicator);
            }
            catch (IOException e) {
                String failure = String.format("Unable to unpack file %1$s", fileName);
                String message = WelcomeUIUtils.getMessageWithDetails(failure, e.getMessage());
                this.promptToRetry(message + " Make sure you have enough disk space on destination drive and retry.", message, e);
                continue;
            }
            if (file == null) {
                UnpackOperation.$$$reportNull$$$0(8);
            }
            return file;
        }
    }

    @Override
    public void cleanup(@NotNull File result) {
        if (result == null) {
            UnpackOperation.$$$reportNull$$$0(9);
        }
        if (result.exists()) {
            FileUtil.delete((File)result);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/welcome/install/UnpackOperation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archive";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/welcome/install/UnpackOperation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "unzip";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "untar";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarExecutablePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "unzip";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ArchiveType {
        ZIP,
        TAR,
        NOT_AN_ARCHIVE;

        private static final String[] TAR_EXTENSIONS;
        private static final String[] ZIP_EXTENSIONS;

        @NotNull
        public static ArchiveType fromFileName(@NotNull String fileName) {
            String lowerCaseName;
            if (fileName == null) {
                ArchiveType.$$$reportNull$$$0(0);
            }
            if (ArchiveType.extensionIsOneOf(lowerCaseName = fileName.toLowerCase(), TAR_EXTENSIONS)) {
                ArchiveType archiveType = TAR;
                if (archiveType == null) {
                    ArchiveType.$$$reportNull$$$0(1);
                }
                return archiveType;
            }
            if (ArchiveType.extensionIsOneOf(lowerCaseName, ZIP_EXTENSIONS)) {
                ArchiveType archiveType = ZIP;
                if (archiveType == null) {
                    ArchiveType.$$$reportNull$$$0(2);
                }
                return archiveType;
            }
            ArchiveType archiveType = NOT_AN_ARCHIVE;
            if (archiveType == null) {
                ArchiveType.$$$reportNull$$$0(3);
            }
            return archiveType;
        }

        private static boolean extensionIsOneOf(@NotNull String name, @NotNull String[] extensions) {
            if (name == null) {
                ArchiveType.$$$reportNull$$$0(4);
            }
            if (extensions == null) {
                ArchiveType.$$$reportNull$$$0(5);
            }
            for (String extension : extensions) {
                if (!FileUtilRt.extensionEquals((String)name, (String)extension)) continue;
                return true;
            }
            return false;
        }

        public File unpack(@NotNull File archive, @NotNull File destination, @NotNull InstallContext context, @NotNull ProgressIndicator indicator) throws IOException, WizardException {
            if (archive == null) {
                ArchiveType.$$$reportNull$$$0(6);
            }
            if (destination == null) {
                ArchiveType.$$$reportNull$$$0(7);
            }
            if (context == null) {
                ArchiveType.$$$reportNull$$$0(8);
            }
            if (indicator == null) {
                ArchiveType.$$$reportNull$$$0(9);
            }
            switch (this) {
                case ZIP: {
                    return UnpackOperation.unzip(archive, destination, context, indicator);
                }
                case TAR: {
                    return UnpackOperation.untar(archive, destination, context, indicator);
                }
                case NOT_AN_ARCHIVE: {
                    throw new WizardException(String.format("Unrecognized archive file format for file %s", archive.getName()));
                }
            }
            throw new IllegalArgumentException(String.format("Archive %s has format %s", archive.getName(), this.name()));
        }

        static {
            TAR_EXTENSIONS = new String[]{"tgz", "tar", "tar.gz"};
            ZIP_EXTENSIONS = new String[]{"zip"};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/welcome/install/UnpackOperation$ArchiveType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensions";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "archive";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destination";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/welcome/install/UnpackOperation$ArchiveType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromFileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromFileName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extensionIsOneOf";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "unpack";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

