/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenViewLayer
extends Layer {
    private final ScreenView myScreenView;
    @Nullable
    private ImagePool.Image myImage;
    @Nullable
    private BufferedImage myScaledImage;
    @Nullable
    private RenderResult myLastRenderResult;
    private double myCachedScale;
    private Rectangle mySizeRectangle;
    private Dimension myScreenViewSize;

    public ScreenViewLayer(@NotNull ScreenView screenView) {
        if (screenView == null) {
            ScreenViewLayer.$$$reportNull$$$0(0);
        }
        this.mySizeRectangle = new Rectangle();
        this.myScreenViewSize = new Dimension();
        this.myScreenView = screenView;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static BufferedImage getRetinaScaledImage(@NotNull BufferedImage original, double scale, boolean bl) {
        if (original == null) {
            ScreenViewLayer.$$$reportNull$$$0(1);
        }
        if (scale > 1.01) {
            return null;
        }
        if (Math.abs(scale - 0.5) > 0.001) {
            void fastScaling;
            double retinaScale = 2.0 * scale;
            original = fastScaling != false ? ImageUtils.lowQualityFastScale(original, retinaScale, retinaScale) : ImageUtils.scale(original, retinaScale, retinaScale);
        }
        return ImageUtils.convertToRetina(original);
    }

    private void setNewImage(@NotNull ImagePool.Image newImage, double newScale) {
        if (newImage == null) {
            ScreenViewLayer.$$$reportNull$$$0(2);
        }
        this.myCachedScale = newScale;
        this.myImage = newImage;
        this.myScaledImage = null;
        boolean fastScaling = this.myScreenView.getSurface().isCanvasResizing();
        if (UIUtil.isRetina() && ImageUtils.supportsRetina()) {
            this.myScaledImage = ScreenViewLayer.getRetinaScaledImage(newImage.getCopy(), newScale, fastScaling);
        }
        if (this.myScaledImage == null) {
            this.myScaledImage = fastScaling ? ImageUtils.lowQualityFastScale(newImage.getCopy(), newScale, newScale) : ImageUtils.scale(newImage.getCopy(), newScale, newScale);
        }
    }

    @Override
    public void paint(@NotNull Graphics2D g) {
        if (g == null) {
            ScreenViewLayer.$$$reportNull$$$0(3);
        }
        this.myScreenViewSize = this.myScreenView.getSize(this.myScreenViewSize);
        this.mySizeRectangle.setBounds(this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
        Rectangle2D.intersect(this.mySizeRectangle, g.getClipBounds(), this.mySizeRectangle);
        if (this.mySizeRectangle.isEmpty()) {
            return;
        }
        RenderResult renderResult = this.myScreenView.getModel().getRenderResult();
        if (renderResult != null && renderResult.hasImage() && renderResult != this.myLastRenderResult) {
            this.myLastRenderResult = renderResult;
            this.myImage = renderResult.getRenderedImage();
            this.myScaledImage = null;
        }
        if (this.myImage == null) {
            return;
        }
        double scale = this.myScreenView.getScale();
        if (this.myScaledImage == null || this.myCachedScale != scale) {
            this.setNewImage(this.myImage, scale);
        }
        Shape prevClip = null;
        Shape screenShape = this.myScreenView.getScreenShape();
        if (screenShape != null) {
            prevClip = g.getClip();
            g.clip(screenShape);
        }
        UIUtil.drawImage((Graphics)g, (Image)this.myScaledImage, (int)this.myScreenView.getX(), (int)this.myScreenView.getY(), null);
        if (prevClip != null) {
            g.setClip(prevClip);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newImage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/surface/ScreenViewLayer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRetinaScaledImage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setNewImage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

