/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.scene.Display;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class SceneLayer
extends Layer {
    private final ScreenView myScreenView;
    private final Dimension myScreenViewSize;
    private final Rectangle mySizeRectangle;
    private final Display myDisplay;
    private boolean myShowOnHover;
    private boolean myShowAlways;

    public SceneLayer(@NotNull ScreenView view, boolean showAlways) {
        if (view == null) {
            SceneLayer.$$$reportNull$$$0(0);
        }
        this.myScreenViewSize = new Dimension();
        this.mySizeRectangle = new Rectangle();
        this.myDisplay = new Display();
        this.myShowOnHover = false;
        this.myShowAlways = true;
        this.myScreenView = view;
        this.myShowAlways = showAlways;
    }

    @Override
    public void paint(@NotNull Graphics2D g2) {
        if (g2 == null) {
            SceneLayer.$$$reportNull$$$0(1);
        }
        if (!this.myShowOnHover && !this.myShowAlways) {
            return;
        }
        Graphics2D g = (Graphics2D)g2.create();
        try {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.myScreenView.getSize(this.myScreenViewSize);
            this.mySizeRectangle.setBounds(this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
            Rectangle2D.intersect(this.mySizeRectangle, g.getClipBounds(), this.mySizeRectangle);
            if (this.mySizeRectangle.isEmpty()) {
                return;
            }
            if (this.myShowAlways) {
                g.setColor(NlConstants.BLUEPRINT_BG_COLOR);
                g.fillRect(this.mySizeRectangle.x, this.mySizeRectangle.y, this.mySizeRectangle.width, this.mySizeRectangle.height);
            }
            this.myDisplay.draw(SceneContext.get(this.myScreenView), g, this.myScreenView.getScene());
        }
        finally {
            g.dispose();
        }
    }

    public boolean isShowOnHover() {
        return this.myShowOnHover;
    }

    public void setShowOnHover(boolean value) {
        this.myShowOnHover = value;
    }

    public ScreenView getScreenView() {
        return this.myScreenView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/surface/SceneLayer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

