/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class ConstraintsLayer
extends Layer {
    private final ScreenView myScreenView;
    private final DesignSurface myDesignSurface;
    private Dimension myScreenViewSize;
    private Rectangle mySizeRectangle;
    private final boolean showOnSelection;
    private boolean myShowOnHover;

    public ConstraintsLayer(DesignSurface designSurface, @NotNull ScreenView screenView, boolean showOnSelection) {
        if (screenView == null) {
            ConstraintsLayer.$$$reportNull$$$0(0);
        }
        this.myScreenViewSize = new Dimension();
        this.mySizeRectangle = new Rectangle();
        this.myShowOnHover = false;
        this.myDesignSurface = designSurface;
        this.myScreenView = screenView;
        this.showOnSelection = showOnSelection;
    }

    public boolean isShowOnHover() {
        return this.myShowOnHover;
    }

    public void setShowOnHover(boolean value) {
        this.myShowOnHover = value;
    }

    public ScreenView getScreenView() {
        return this.myScreenView;
    }

    @Override
    public void paint(@NotNull Graphics2D gc) {
        if (gc == null) {
            ConstraintsLayer.$$$reportNull$$$0(1);
        }
        this.myScreenView.getSize(this.myScreenViewSize);
        this.mySizeRectangle.setBounds(this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
        Rectangle2D.intersect(this.mySizeRectangle, gc.getClipBounds(), this.mySizeRectangle);
        if (this.mySizeRectangle.isEmpty()) {
            return;
        }
        NlModel myModel = this.myScreenView.getModel();
        if (!this.myShowOnHover && this.showOnSelection) {
            return;
        }
        if (myModel.getComponents().size() == 0) {
            return;
        }
        NlComponent component = myModel.getComponents().get(0);
        component = component.getRoot();
        Graphics2D g = (Graphics2D)gc.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.drawComponent(g, component, false)) {
            Dimension size = this.myScreenView.getSize();
            if (size.width != 0 && size.height != 0) {
                this.myDesignSurface.repaint(this.myScreenView.getX(), this.myScreenView.getY(), size.width, size.height);
            } else {
                this.myDesignSurface.repaint();
            }
        }
        g.dispose();
    }

    private boolean drawComponent(@NotNull Graphics2D gc, @NotNull NlComponent component, boolean parentHandlesPainting) {
        if (gc == null) {
            ConstraintsLayer.$$$reportNull$$$0(2);
        }
        if (component == null) {
            ConstraintsLayer.$$$reportNull$$$0(3);
        }
        if (component.viewInfo != null) {
            ViewGroupHandler viewGroupHandler;
            ViewHandler handler = component.getViewHandler();
            boolean handlesPainting = false;
            if (handler != null && handler instanceof ViewGroupHandler && (viewGroupHandler = (ViewGroupHandler)handler).handlesPainting()) {
                viewGroupHandler.drawGroup(gc, this.myScreenView, component);
                handlesPainting = true;
            }
            if (handler != null) {
                handler.paintConstraints(this.myScreenView, gc, component);
            }
        }
        boolean needsRepaint = false;
        for (NlComponent child : component.getChildren()) {
            needsRepaint |= this.drawComponent(gc, child, parentHandlesPainting);
        }
        return needsRepaint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gc";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/surface/ConstraintsLayer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "drawComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

