/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreeTransferHandler
extends TransferHandler {
    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        NlComponentTree tree = (NlComponentTree)((Object)c);
        this.setDragImage(TreeTransferHandler.getDragImageOfSelection(tree));
        NlModel model = tree.getDesignerModel();
        if (model == null || model.getSelectionModel().isEmpty()) {
            return null;
        }
        return model.getSelectionAsTransferable();
    }

    @Override
    protected void exportDone(JComponent c, Transferable transferable, int dropAction) {
        if (dropAction == 2) {
            NlComponentTree tree = (NlComponentTree)((Object)c);
            NlModel model = tree.getDesignerModel();
            assert (model != null);
            model.delete(tree.getSelectedComponents());
        }
    }

    @Nullable
    private static Image getDragImageOfSelection(@NotNull NlComponentTree tree) {
        TreePath[] paths;
        if (tree == null) {
            TreeTransferHandler.$$$reportNull$$$0(0);
        }
        if ((paths = tree.getSelectionPaths()) == null) {
            return null;
        }
        int width = 0;
        int height = 0;
        for (TreePath path : paths) {
            int row = tree.getRowForPath(path);
            Component component = tree.getCellRenderer().getTreeCellRendererComponent((JTree)((Object)tree), path.getLastPathComponent(), false, true, true, row, false);
            Dimension size = component.getPreferredSize();
            width = Math.max(width, size.width);
            height += size.height;
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        for (TreePath path : paths) {
            int row = tree.getRowForPath(path);
            Component component = tree.getCellRenderer().getTreeCellRendererComponent((JTree)((Object)tree), path.getLastPathComponent(), false, true, true, row, false);
            Dimension size = component.getPreferredSize();
            component.setSize(size);
            g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
            component.paint(g2);
            g2.translate(0, size.height);
        }
        g2.dispose();
        return image;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/uibuilder/structure/TreeTransferHandler", "getDragImageOfSelection"));
    }
}

