/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.scene.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.scene.Scene;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawAnchor;
import com.android.tools.idea.uibuilder.scene.target.ConstraintTarget;
import com.android.tools.idea.uibuilder.scene.target.Target;
import com.android.tools.sherpa.scout.Scout;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnchorTarget
extends ConstraintTarget {
    private static final boolean DEBUG_RENDERER = false;
    private final boolean myVisibility;
    protected final int mySize = 3;
    private final int myExpandSize = 200;
    private final Type myType;
    private boolean myExpandArea;
    private int myLastX;
    private int myLastY;
    private int myConnectedX;
    private int myConnectedY;
    private HashMap<String, String> mPreviousAttributes;

    public AnchorTarget(@NotNull Type type, boolean visible) {
        if (type == null) {
            AnchorTarget.$$$reportNull$$$0(0);
        }
        this.mySize = 3;
        this.myExpandSize = 200;
        this.myExpandArea = false;
        this.myLastX = -1;
        this.myLastY = -1;
        this.myConnectedX = -1;
        this.myConnectedY = -1;
        this.mPreviousAttributes = new HashMap();
        this.myType = type;
        this.myVisibility = visible;
    }

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    public Type getType() {
        return this.myType;
    }

    public void setExpandSize(boolean expand) {
        this.myExpandArea = expand;
    }

    public boolean isHorizontalAnchor() {
        return this.myType == Type.LEFT || this.myType == Type.RIGHT;
    }

    public boolean isVerticalAnchor() {
        return this.myType == Type.TOP || this.myType == Type.BOTTOM;
    }

    @Override
    public void setOver(boolean over) {
        if (over != this.mIsOver) {
            this.mIsOver = over;
            this.myComponent.getScene().needsRebuildList();
            this.myComponent.getScene().repaint();
        }
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        float d;
        float ratio;
        if (sceneTransform == null) {
            AnchorTarget.$$$reportNull$$$0(1);
        }
        if ((ratio = 1.0f / (float)sceneTransform.getScale()) > 2.0f) {
            ratio = 2.0f;
        }
        float size = 3.0f * ratio;
        float minWidth = 4.0f * size;
        float minHeight = 4.0f * size;
        if ((float)(r - l) < minWidth) {
            d = (minWidth - (float)(r - l)) / 2.0f;
            l = (int)((float)l - d);
            r = (int)((float)r + d);
        }
        if ((float)(b - t) < minHeight) {
            d = (minHeight - (float)(b - t)) / 2.0f;
            t = (int)((float)t - d);
            b = (int)((float)b + d);
        }
        int w = r - l;
        int h = b - t;
        int mw = l + w / 2;
        int mh = t + h / 2;
        switch (this.myType) {
            case LEFT: {
                this.myLeft = (float)l - size;
                this.myTop = (float)mh - size;
                this.myRight = (float)l + size;
                this.myBottom = (float)mh + size;
                if (!this.myExpandArea) break;
                this.myLeft = l - 200;
                this.myTop = t;
                this.myBottom = b;
                break;
            }
            case TOP: {
                this.myLeft = (float)mw - size;
                this.myTop = (float)t - size;
                this.myRight = (float)mw + size;
                this.myBottom = (float)t + size;
                if (!this.myExpandArea) break;
                this.myTop = t - 200;
                this.myLeft = l;
                this.myRight = r;
                break;
            }
            case RIGHT: {
                this.myLeft = (float)r - size;
                this.myTop = (float)mh - size;
                this.myRight = (float)r + size;
                this.myBottom = (float)mh + size;
                if (!this.myExpandArea) break;
                this.myRight = r + 200;
                this.myTop = t;
                this.myBottom = b;
                break;
            }
            case BOTTOM: {
                this.myLeft = (float)mw - size;
                this.myTop = (float)b - size;
                this.myRight = (float)mw + size;
                this.myBottom = (float)b + size;
                if (!this.myExpandArea) break;
                this.myBottom = b + 200;
                this.myLeft = l;
                this.myRight = r;
                break;
            }
            case BASELINE: {
                this.myLeft = (float)l + size;
                this.myTop = (float)(t + this.myComponent.getBaseline()) - size / 2.0f;
                this.myRight = (float)r - size;
                this.myBottom = (float)(t + this.myComponent.getBaseline()) + size / 2.0f;
            }
        }
        return false;
    }

    private boolean isConnected(AnchorTarget target) {
        if (target == null) {
            return false;
        }
        if (!this.isConnected()) {
            return false;
        }
        String attribute = null;
        switch (this.myType) {
            case LEFT: {
                attribute = this.getConnectionId(this.myComponent.getNlComponent(), "http://schemas.android.com/apk/res-auto", ourLeftAttributes);
                break;
            }
            case RIGHT: {
                attribute = this.getConnectionId(this.myComponent.getNlComponent(), "http://schemas.android.com/apk/res-auto", ourRightAttributes);
                break;
            }
            case TOP: {
                attribute = this.getConnectionId(this.myComponent.getNlComponent(), "http://schemas.android.com/apk/res-auto", ourTopAttributes);
                break;
            }
            case BOTTOM: {
                attribute = this.getConnectionId(this.myComponent.getNlComponent(), "http://schemas.android.com/apk/res-auto", ourBottomAttributes);
                break;
            }
            case BASELINE: {
                attribute = this.myComponent.getNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf");
                if (attribute == null) break;
                attribute = NlComponent.extractId(attribute);
            }
        }
        if (attribute == null) {
            return false;
        }
        return attribute.equalsIgnoreCase((String)target.getComponent().getId());
    }

    private boolean isConnected() {
        NlComponent component = this.myComponent.getNlComponent();
        switch (this.myType) {
            case LEFT: {
                return this.hasAttributes(component, "http://schemas.android.com/apk/res-auto", ourLeftAttributes);
            }
            case TOP: {
                return this.hasAttributes(component, "http://schemas.android.com/apk/res-auto", ourTopAttributes);
            }
            case RIGHT: {
                return this.hasAttributes(component, "http://schemas.android.com/apk/res-auto", ourRightAttributes);
            }
            case BOTTOM: {
                return this.hasAttributes(component, "http://schemas.android.com/apk/res-auto", ourBottomAttributes);
            }
            case BASELINE: {
                return component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
            }
        }
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            AnchorTarget.$$$reportNull$$$0(2);
        }
        if (sceneContext == null) {
            AnchorTarget.$$$reportNull$$$0(3);
        }
        if (!this.myVisibility) {
            return;
        }
        if (!this.myComponent.getScene().allowsTarget(this)) {
            return;
        }
        DrawAnchor.add(list, sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom, this.myType == Type.BASELINE ? 1 : 0, this.isConnected(), this.mIsOver ? 1 : 0);
        if (this.myLastX != -1 && this.myLastY != -1 && (this.myConnectedX == -1 && this.myConnectedY == -1 || this.myLastX != this.myConnectedX || this.myLastY != this.myConnectedY)) {
            float x = this.myLeft + (this.myRight - this.myLeft) / 2.0f;
            float y = this.myTop + (this.myBottom - this.myTop) / 2.0f;
            list.addConnection(sceneContext, x, y, this.myLastX, this.myLastY, this.myType.ordinal());
        }
    }

    private void clearMe(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            AnchorTarget.$$$reportNull$$$0(4);
        }
        switch (this.myType) {
            case LEFT: {
                this.clearAttributes("http://schemas.android.com/apk/res-auto", ourLeftAttributes, transaction);
                break;
            }
            case RIGHT: {
                this.clearAttributes("http://schemas.android.com/apk/res-auto", ourRightAttributes, transaction);
                break;
            }
            case TOP: {
                this.clearAttributes("http://schemas.android.com/apk/res-auto", ourTopAttributes, transaction);
                break;
            }
            case BOTTOM: {
                this.clearAttributes("http://schemas.android.com/apk/res-auto", ourBottomAttributes, transaction);
                break;
            }
            case BASELINE: {
                transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf", null);
            }
        }
    }

    private void rememberPreviousAttribute(@NotNull String uri, @NotNull ArrayList<String> attributes) {
        if (uri == null) {
            AnchorTarget.$$$reportNull$$$0(5);
        }
        if (attributes == null) {
            AnchorTarget.$$$reportNull$$$0(6);
        }
        NlComponent component = this.myComponent.getNlComponent();
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            this.mPreviousAttributes.put(attribute, component.getLiveAttribute(uri, attribute));
        }
    }

    private String getAttribute(@NotNull Target target) {
        if (target == null) {
            AnchorTarget.$$$reportNull$$$0(7);
        }
        if (!(target instanceof AnchorTarget)) {
            return null;
        }
        AnchorTarget anchorTarget = (AnchorTarget)target;
        switch (this.myType) {
            case LEFT: {
                if (anchorTarget.myType == Type.LEFT) {
                    return "layout_constraintLeft_toLeftOf";
                }
                if (anchorTarget.myType != Type.RIGHT) break;
                return "layout_constraintLeft_toRightOf";
            }
            case RIGHT: {
                if (anchorTarget.myType == Type.LEFT) {
                    return "layout_constraintRight_toLeftOf";
                }
                if (anchorTarget.myType != Type.RIGHT) break;
                return "layout_constraintRight_toRightOf";
            }
            case TOP: {
                if (anchorTarget.myType == Type.TOP) {
                    return "layout_constraintTop_toTopOf";
                }
                if (anchorTarget.myType != Type.BOTTOM) break;
                return "layout_constraintTop_toBottomOf";
            }
            case BOTTOM: {
                if (anchorTarget.myType == Type.TOP) {
                    return "layout_constraintBottom_toTopOf";
                }
                if (anchorTarget.myType != Type.BOTTOM) break;
                return "layout_constraintBottom_toBottomOf";
            }
            case BASELINE: {
                return "layout_constraintBaseline_toBaselineOf";
            }
        }
        return null;
    }

    private void revertToPreviousState() {
        NlComponent component = this.myComponent.getNlComponent();
        AttributesTransaction attributes = component.startAttributeTransaction();
        attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf", null);
        for (String key : this.mPreviousAttributes.keySet()) {
            if (key.equalsIgnoreCase("layout_editor_absoluteX")) {
                attributes.setAttribute("http://schemas.android.com/tools", key, this.mPreviousAttributes.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("layout_editor_absoluteY")) {
                attributes.setAttribute("http://schemas.android.com/tools", key, this.mPreviousAttributes.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("layout_marginTop")) {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", key, this.mPreviousAttributes.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("layout_marginBottom")) {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", key, this.mPreviousAttributes.get(key));
                continue;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", key, this.mPreviousAttributes.get(key));
        }
        attributes.apply();
        this.myComponent.getScene().needsLayout(2);
    }

    private AttributesTransaction connectMe(NlComponent component, String attribute, NlComponent targetComponent) {
        AttributesTransaction attributes = component.startAttributeTransaction();
        String targetId = null;
        targetId = targetComponent == component.getParent() ? "parent" : "@+id/" + targetComponent.ensureLiveId();
        attributes.setAttribute("http://schemas.android.com/apk/res-auto", attribute, targetId);
        if (this.myType == Type.BASELINE) {
            this.clearAttributes("http://schemas.android.com/apk/res-auto", ourTopAttributes, attributes);
            this.clearAttributes("http://schemas.android.com/apk/res-auto", ourBottomAttributes, attributes);
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
        } else if (ourReciprocalAttributes.get(attribute) != null) {
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", (String)ourReciprocalAttributes.get(attribute), null);
        }
        if (ourMapMarginAttributes.get(attribute) != null) {
            Scene scene = this.myComponent.getScene();
            int marginValue = this.getDistance(attribute, targetComponent, scene);
            marginValue = !scene.isControlDown() ? (marginValue < 0 ? 0 : Scout.getMargin()) : Math.max(marginValue, 0);
            String margin = String.format("%ddp", marginValue);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", (String)ourMapMarginAttributes.get(attribute), margin);
            scene.needsRebuildList();
            this.myConnectedX = this.myLastX;
            this.myConnectedY = this.myLastY;
        }
        this.cleanup(attributes);
        attributes.apply();
        this.myComponent.getScene().needsLayout(2);
        return attributes;
    }

    private int getDistance(String attribute, NlComponent targetComponent, Scene scene) {
        int marginValue;
        AnchorTarget targetAnchor = ConstraintComponentUtilities.getTargetAnchor(scene, targetComponent, attribute);
        block0 : switch (this.myType) {
            case LEFT: {
                switch (targetAnchor.getType()) {
                    case LEFT: 
                    case RIGHT: {
                        marginValue = (int)(this.getCenterX() - targetAnchor.getCenterX());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            case RIGHT: {
                switch (targetAnchor.getType()) {
                    case LEFT: 
                    case RIGHT: {
                        marginValue = (int)(targetAnchor.getCenterX() - this.getCenterX());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            case TOP: {
                switch (targetAnchor.getType()) {
                    case TOP: 
                    case BOTTOM: {
                        marginValue = (int)(this.getCenterY() - targetAnchor.getCenterY());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            case BOTTOM: {
                switch (targetAnchor.getType()) {
                    case TOP: 
                    case BOTTOM: {
                        marginValue = (int)(targetAnchor.getCenterY() - this.getCenterY());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            default: {
                marginValue = 0;
            }
        }
        return marginValue;
    }

    private void disconnectMe(NlComponent component) {
        String label = "Constraint Disconnected";
        NlModel nlModel = component.getModel();
        Project project = nlModel.getProject();
        XmlFile file = nlModel.getFile();
        final AttributesTransaction attributes = component.startAttributeTransaction();
        this.clearMe(attributes);
        this.cleanup(attributes);
        attributes.apply();
        WriteCommandAction action = new WriteCommandAction(project, label, new PsiFile[]{file}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                attributes.commit();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/scene/target/AnchorTarget$1", "run"));
            }
        };
        action.execute();
        this.myComponent.getScene().needsLayout(2);
    }

    @Override
    public int getPreferenceLevel() {
        return 60;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myLastX = -1;
        this.myLastY = -1;
        this.myConnectedX = -1;
        this.myConnectedY = -1;
        NlComponent component = this.myComponent.getNlComponent();
        this.mPreviousAttributes.clear();
        this.mPreviousAttributes.put("layout_editor_absoluteX", component.getLiveAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX"));
        this.mPreviousAttributes.put("layout_editor_absoluteY", component.getLiveAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY"));
        this.mPreviousAttributes.put("layout_constraintBaseline_toBaselineOf", component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf"));
        if (this.myComponent.getParent() != null) {
            this.myComponent.getParent().setExpandTargetArea(true);
        }
        switch (this.myType) {
            case LEFT: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ourLeftAttributes);
                break;
            }
            case RIGHT: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ourRightAttributes);
                break;
            }
            case TOP: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ourTopAttributes);
                break;
            }
            case BOTTOM: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ourBottomAttributes);
                break;
            }
            case BASELINE: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ourTopAttributes);
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ourBottomAttributes);
                this.mPreviousAttributes.put("layout_marginTop", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop"));
                this.mPreviousAttributes.put("layout_marginBottom", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom"));
                this.mPreviousAttributes.put("layout_constraintVertical_bias", component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias"));
            }
        }
    }

    @Override
    public void mouseDrag(int x, int y, @Nullable Target closestTarget) {
        this.myLastX = x;
        this.myLastY = y;
        if (closestTarget != null && closestTarget instanceof AnchorTarget) {
            NlComponent component = this.myComponent.getNlComponent();
            String attribute = this.getAttribute(closestTarget);
            if (attribute != null) {
                AnchorTarget targetAnchor = (AnchorTarget)closestTarget;
                if (targetAnchor.myComponent != this.myComponent && !targetAnchor.isConnected(this)) {
                    NlComponent targetComponent = targetAnchor.myComponent.getNlComponent();
                    this.connectMe(component, attribute, targetComponent);
                    return;
                }
            }
        }
        this.revertToPreviousState();
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable Target closestTarget) {
        this.myLastX = -1;
        this.myLastY = -1;
        if (this.myComponent.getParent() != null) {
            this.myComponent.getParent().setExpandTargetArea(false);
        }
        if (closestTarget != null && closestTarget instanceof AnchorTarget && !((AnchorTarget)closestTarget).isConnected(this)) {
            NlComponent component = this.myComponent.getNlComponent();
            if (closestTarget == this) {
                this.disconnectMe(component);
            } else {
                String attribute = this.getAttribute(closestTarget);
                if (attribute != null) {
                    AnchorTarget targetAnchor = (AnchorTarget)closestTarget;
                    NlComponent targetComponent = targetAnchor.myComponent.getNlComponent();
                    final AttributesTransaction attributes = this.connectMe(component, attribute, targetComponent);
                    NlModel nlModel = component.getModel();
                    Project project = nlModel.getProject();
                    XmlFile file = nlModel.getFile();
                    String label = "Constraint Connected";
                    WriteCommandAction action = new WriteCommandAction(project, label, new PsiFile[]{file}){

                        protected void run(@NotNull Result result) throws Throwable {
                            if (result == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            attributes.commit();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/scene/target/AnchorTarget$2", "run"));
                        }
                    };
                    action.execute();
                    this.myComponent.getScene().needsLayout(2);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/scene/target/AnchorTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "layout";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "clearMe";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "rememberPreviousAttribute";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getAttribute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Type {
        LEFT,
        TOP,
        RIGHT,
        BOTTOM,
        BASELINE;

    }
}

