/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawHorizontalNotch;
import com.android.tools.idea.uibuilder.scene.draw.DrawVerticalNotch;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Notch {
    SceneComponent myOwner;
    int myNotchValue;
    int myDisplayValue;
    int myGap;
    Action myAction;
    boolean myDidApply;

    private Notch() {
        this.myGap = 8;
        this.myDidApply = false;
    }

    private Notch(@NotNull SceneComponent owner, int value, int displayValue) {
        if (owner == null) {
            Notch.$$$reportNull$$$0(0);
        }
        this.myGap = 8;
        this.myDidApply = false;
        this.myOwner = owner;
        this.myNotchValue = value;
        this.myDisplayValue = displayValue;
    }

    private Notch(@NotNull SceneComponent owner, int value, int displayValue, @NotNull Action action) {
        if (owner == null) {
            Notch.$$$reportNull$$$0(1);
        }
        if (action == null) {
            Notch.$$$reportNull$$$0(2);
        }
        this.myGap = 8;
        this.myDidApply = false;
        this.myOwner = owner;
        this.myNotchValue = value;
        this.myDisplayValue = displayValue;
        this.myAction = action;
    }

    public void setAction(@Nullable Action action) {
        this.myAction = action;
    }

    public void apply(AttributesTransaction attributes) {
        if (this.myDidApply && this.myAction != null) {
            this.myAction.apply(attributes);
        }
    }

    public boolean didApply() {
        return this.myDidApply;
    }

    public int apply(int value) {
        this.myDidApply = false;
        if (Math.abs(value - this.myNotchValue) <= this.myGap) {
            this.myDidApply = true;
            return this.myNotchValue;
        }
        return value;
    }

    public abstract void render(@NotNull DisplayList var1, @NotNull SceneContext var2, @NotNull SceneComponent var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "owner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "action";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/uibuilder/scene/draw/Notch";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SmallVertical
    extends Notch {
        public SmallVertical(@NotNull SceneComponent owner, int value, int displayValue) {
            if (owner == null) {
                SmallVertical.$$$reportNull$$$0(0);
            }
            super(owner, value, displayValue);
            this.myGap = 6;
        }

        public SmallVertical(@NotNull SceneComponent owner, int value, int displayValue, @NotNull Action action) {
            if (owner == null) {
                SmallVertical.$$$reportNull$$$0(1);
            }
            if (action == null) {
                SmallVertical.$$$reportNull$$$0(2);
            }
            super(owner, value, displayValue, action);
            this.myGap = 6;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component) {
            if (list == null) {
                SmallVertical.$$$reportNull$$$0(3);
            }
            if (context == null) {
                SmallVertical.$$$reportNull$$$0(4);
            }
            if (component == null) {
                SmallVertical.$$$reportNull$$$0(5);
            }
            int gap = 16;
            int x1 = Math.min(this.myOwner.getDrawX(), component.getDrawX()) - gap;
            int x2 = Math.max(this.myOwner.getDrawX() + this.myOwner.getDrawWidth(), component.getDrawX() + component.getDrawWidth()) + gap;
            DrawHorizontalNotch.add(list, context, x1, this.myDisplayValue, x2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/scene/draw/Notch$SmallVertical";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SmallHorizontal
    extends Notch {
        public SmallHorizontal(@NotNull SceneComponent owner, int value, int displayValue) {
            if (owner == null) {
                SmallHorizontal.$$$reportNull$$$0(0);
            }
            super(owner, value, displayValue);
            this.myGap = 6;
        }

        public SmallHorizontal(@NotNull SceneComponent owner, int value, int displayValue, @NotNull Action action) {
            if (owner == null) {
                SmallHorizontal.$$$reportNull$$$0(1);
            }
            if (action == null) {
                SmallHorizontal.$$$reportNull$$$0(2);
            }
            super(owner, value, displayValue, action);
            this.myGap = 6;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component) {
            if (list == null) {
                SmallHorizontal.$$$reportNull$$$0(3);
            }
            if (context == null) {
                SmallHorizontal.$$$reportNull$$$0(4);
            }
            if (component == null) {
                SmallHorizontal.$$$reportNull$$$0(5);
            }
            SceneComponent parent = component.getParent();
            int gap = 16;
            int y1 = Math.min(this.myOwner.getDrawY(), component.getDrawY()) - gap;
            int y2 = Math.max(this.myOwner.getDrawY() + this.myOwner.getDrawHeight(), component.getDrawY() + component.getDrawHeight()) + gap;
            DrawVerticalNotch.add(list, context, this.myDisplayValue, y1, y2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/scene/draw/Notch$SmallHorizontal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Vertical
    extends Notch {
        public Vertical(@NotNull SceneComponent owner, int value, int displayValue) {
            if (owner == null) {
                Vertical.$$$reportNull$$$0(0);
            }
            super(owner, value, displayValue);
        }

        public Vertical(@NotNull SceneComponent owner, int value, int displayValue, @NotNull Action action) {
            if (owner == null) {
                Vertical.$$$reportNull$$$0(1);
            }
            if (action == null) {
                Vertical.$$$reportNull$$$0(2);
            }
            super(owner, value, displayValue, action);
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component) {
            if (list == null) {
                Vertical.$$$reportNull$$$0(3);
            }
            if (context == null) {
                Vertical.$$$reportNull$$$0(4);
            }
            if (component == null) {
                Vertical.$$$reportNull$$$0(5);
            }
            SceneComponent parent = component.getParent();
            DrawHorizontalNotch.add(list, context, parent.getDrawX(), this.myDisplayValue, parent.getDrawX() + parent.getDrawWidth());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/scene/draw/Notch$Vertical";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Horizontal
    extends Notch {
        public Horizontal(@NotNull SceneComponent owner, int value, int displayValue) {
            if (owner == null) {
                Horizontal.$$$reportNull$$$0(0);
            }
            super(owner, value, displayValue);
        }

        public Horizontal(@NotNull SceneComponent owner, int value, int displayValue, @NotNull Action action) {
            if (owner == null) {
                Horizontal.$$$reportNull$$$0(1);
            }
            if (action == null) {
                Horizontal.$$$reportNull$$$0(2);
            }
            super(owner, value, displayValue, action);
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component) {
            if (list == null) {
                Horizontal.$$$reportNull$$$0(3);
            }
            if (context == null) {
                Horizontal.$$$reportNull$$$0(4);
            }
            if (component == null) {
                Horizontal.$$$reportNull$$$0(5);
            }
            SceneComponent parent = component.getParent();
            DrawVerticalNotch.add(list, context, this.myDisplayValue, parent.getDrawY(), parent.getDrawY() + parent.getDrawHeight());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/scene/draw/Notch$Horizontal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Provider {
        public void fill(@NotNull SceneComponent var1, @NotNull SceneComponent var2, @NotNull ArrayList<Notch> var3, @NotNull ArrayList<Notch> var4);
    }

    public static interface Action {
        public void apply(@NotNull AttributesTransaction var1);
    }
}

