/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawConnectionUtils;
import com.android.tools.idea.uibuilder.scene.draw.DrawRegion;
import com.android.tools.sherpa.drawing.ColorSet;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class DrawHorizontalGuideline
extends DrawRegion {
    private static final int GAP = 40;
    private int myBegin;
    private int myEnd;
    private float myPercent;
    private int myOriginX;
    private int myOriginY;
    private int myOriginHeight;
    private boolean myIsSelected;
    protected Font mFont = new Font("Helvetica", 0, 14);

    public DrawHorizontalGuideline(String s) {
        super(s);
    }

    public DrawHorizontalGuideline(int x, int y, int width, int originX, int originY, int originHeight, int begin, int end, float percent, boolean selected) {
        super(x, y, width, x);
        this.myBegin = begin;
        this.myEnd = end;
        this.myPercent = percent;
        this.myOriginX = originX;
        this.myOriginY = originY;
        this.myOriginHeight = originHeight;
        this.myIsSelected = selected;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        if (this.myIsSelected) {
            g.setColor(colorSet.getSelectedFrames());
        } else {
            g.setColor(colorSet.getFrames());
        }
        Stroke stroke = g.getStroke();
        g.setStroke(DrawConnectionUtils.sDashedStroke);
        g.drawLine(this.x, this.y, this.x + this.width, this.y);
        g.setStroke(stroke);
        int gap = 48;
        if (this.myIsSelected) {
            if (this.myBegin != -1) {
                DrawConnectionUtils.drawVerticalMarginIndicator(g, String.valueOf(this.myBegin), false, this.x + 40, this.myOriginY, this.y);
            } else if (this.myEnd != -1) {
                DrawConnectionUtils.drawVerticalMarginIndicator(g, String.valueOf(this.myEnd), false, this.x + 40, this.y, this.myOriginY + this.myOriginHeight);
            } else {
                String percent = String.valueOf((int)(this.myPercent * 100.0f)) + " %";
                g.setColor(colorSet.getFrames());
                DrawConnectionUtils.drawRoundRectText(g, this.mFont, colorSet.getText(), percent, this.x + gap, this.y);
            }
        }
    }

    public static void add(DisplayList list, SceneContext transform, float left, float top, float right, float originX, float originY, float originHeight, int begin, int end, float percent, boolean selected) {
        int l = transform.getSwingX(left);
        int t = transform.getSwingY(top);
        int w = transform.getSwingDimension(right - left);
        int ox = transform.getSwingX(originX);
        int oy = transform.getSwingY(originY);
        int oh = transform.getSwingDimension(originHeight);
        list.add(new DrawHorizontalGuideline(l, t, w, ox, oy, oh, begin, end, percent, selected));
    }
}

