/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.renderer.NlAttributeRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColorIcon;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.android.AndroidColorAnnotator;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDefaultRenderer
extends NlAttributeRenderer {
    public static final int ICON_SIZE = 14;
    private final SimpleColoredComponent myLabel;

    public NlDefaultRenderer() {
        JPanel panel = this.getContentPanel();
        this.myLabel = new SimpleColoredComponent();
        panel.add((Component)this.myLabel, "Center");
    }

    @Override
    public void customizeRenderContent(@NotNull JTable table, @NotNull NlProperty p, boolean selected, boolean hasFocus, int row, int col) {
        if (table == null) {
            NlDefaultRenderer.$$$reportNull$$$0(0);
        }
        if (p == null) {
            NlDefaultRenderer.$$$reportNull$$$0(1);
        }
        this.myLabel.clear();
        this.customize(p, col);
    }

    void customize(NlProperty property, int column) {
        if (column == 0) {
            this.appendName(property);
        } else {
            this.appendValue(property);
        }
    }

    private void appendValue(@NotNull NlProperty property) {
        if (property == null) {
            NlDefaultRenderer.$$$reportNull$$$0(2);
        }
        String value = property.getValue();
        String text = StringUtil.notNullize((String)value);
        Icon icon = NlDefaultRenderer.getIcon(property);
        if (icon != null) {
            this.myLabel.setIcon(icon);
        }
        if (!property.isDefaultValue(value)) {
            this.myLabel.setForeground((Color)JBColor.BLUE);
        }
        this.myLabel.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.myLabel.setToolTipText(text);
    }

    @Nullable
    public static Icon getIcon(@NotNull NlProperty property) {
        String text;
        if (property == null) {
            NlDefaultRenderer.$$$reportNull$$$0(3);
        }
        if ((text = property.getResolvedValue()) == null) {
            return null;
        }
        if (NlDefaultRenderer.isColorValue(text)) {
            return NlDefaultRenderer.getColorIcon(text);
        }
        Configuration configuration = property.getModel().getConfiguration();
        if (configuration == null) {
            return null;
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        if (resolver == null) {
            return null;
        }
        if (text.startsWith("@color/") || text.startsWith("@android:color/")) {
            return NlDefaultRenderer.getColorIcon(resolver, property, text);
        }
        if (text.startsWith("@drawable/") || text.startsWith("@android:drawable/") || text.startsWith("@mipmap/")) {
            return NlDefaultRenderer.getDrawableIcon(resolver, property, text);
        }
        return null;
    }

    @Nullable
    private static Icon getDrawableIcon(@NotNull ResourceResolver resolver, @NotNull NlProperty property, @NotNull String value) {
        if (resolver == null) {
            NlDefaultRenderer.$$$reportNull$$$0(4);
        }
        if (property == null) {
            NlDefaultRenderer.$$$reportNull$$$0(5);
        }
        if (value == null) {
            NlDefaultRenderer.$$$reportNull$$$0(6);
        }
        boolean isFrameworkRes = value.startsWith("@android:");
        ResourceType type = value.startsWith("@mipmap/") ? ResourceType.MIPMAP : ResourceType.DRAWABLE;
        ResourceValue drawable = resolver.resolveValue(type, property.getName(), value, isFrameworkRes);
        if (drawable == null) {
            return null;
        }
        File file = AndroidColorAnnotator.pickBestBitmap(ResourceHelper.resolveDrawable((RenderResources)resolver, drawable, property.getModel().getProject()));
        return file == null ? null : GutterIconCache.getInstance().getIcon(file.getPath(), resolver);
    }

    @Nullable
    private static Icon getColorIcon(@NotNull ResourceResolver resolver, @NotNull NlProperty property, @NotNull String value) {
        if (resolver == null) {
            NlDefaultRenderer.$$$reportNull$$$0(7);
        }
        if (property == null) {
            NlDefaultRenderer.$$$reportNull$$$0(8);
        }
        if (value == null) {
            NlDefaultRenderer.$$$reportNull$$$0(9);
        }
        boolean isFrameworkRes = value.startsWith("@android:color/");
        ResourceValue resourceValue = resolver.resolveValue(ResourceType.COLOR, property.getName(), value, isFrameworkRes);
        if (resourceValue == null) {
            return null;
        }
        String resolvedValue = resourceValue.getValue();
        if (NlDefaultRenderer.isColorValue(resolvedValue)) {
            return NlDefaultRenderer.getColorIcon(resolvedValue);
        }
        return null;
    }

    private static boolean isColorValue(@Nullable String value) {
        return value != null && value.startsWith("#") && value.matches("#\\p{XDigit}+");
    }

    @Nullable
    private static Icon getColorIcon(@NotNull String hexColor) {
        Color color;
        if (hexColor == null) {
            NlDefaultRenderer.$$$reportNull$$$0(10);
        }
        return (color = ResourceHelper.parseColor(hexColor)) == null ? null : new ColorIcon(14, color, true);
    }

    private void appendName(@NotNull NlProperty property) {
        if (property == null) {
            NlDefaultRenderer.$$$reportNull$$$0(11);
        }
        this.myLabel.append(property.getName());
        this.myLabel.setToolTipText(property.getTooltipText());
    }

    @Override
    public boolean canRender(@NotNull NlProperty p, @NotNull Set<AttributeFormat> formats) {
        if (p == null) {
            NlDefaultRenderer.$$$reportNull$$$0(12);
        }
        if (formats == null) {
            NlDefaultRenderer.$$$reportNull$$$0(13);
        }
        return true;
    }

    SimpleColoredComponent getLabel() {
        return this.myLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hexColor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/property/renderer/NlDefaultRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeRenderContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getDrawableIcon";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getColorIcon";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "appendName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "canRender";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

