/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.ptable.renderers;

import com.android.tools.idea.uibuilder.property.ptable.PTable;
import com.android.tools.idea.uibuilder.property.ptable.PTableItem;
import com.android.tools.idea.uibuilder.property.ptable.StarState;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PNameRenderer
implements TableCellRenderer {
    private static final int BEFORE_STAR_SPACING = 2;
    private static final int STAR_SIZE = 16;
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final JLabel myStarLabel = new JBLabel();
    private final ColoredTableCellRenderer myRenderer = new Renderer();

    public PNameRenderer() {
        this.myStarLabel.setPreferredSize(new Dimension(18, 16));
        this.myStarLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.myPanel.add((Component)this.myStarLabel, "West");
        this.myPanel.add((Component)this.myRenderer, "Center");
    }

    @Override
    public Component getTableCellRendererComponent(@NotNull JTable table, @NotNull Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
        if (table == null) {
            PNameRenderer.$$$reportNull$$$0(0);
        }
        if (value == null) {
            PNameRenderer.$$$reportNull$$$0(1);
        }
        this.myRenderer.clear();
        PTable ptable = (PTable)((Object)table);
        PTableItem item = (PTableItem)value;
        this.myRenderer.getTableCellRendererComponent(table, value, isSelected, cellHasFocus, row, column);
        this.myRenderer.setBackground(isSelected ? UIUtil.getTableSelectionBackground() : table.getBackground());
        boolean hoveringOnStar = ptable.isHover(row, column) && PNameRenderer.hitTestStarIcon(ptable.getHoverPosition().x);
        this.myStarLabel.setIcon(PNameRenderer.getStar(item.getStarState(), isSelected, hoveringOnStar));
        this.myPanel.setBackground(isSelected ? UIUtil.getTableSelectionBackground() : table.getBackground());
        SimpleTextAttributes attr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        SearchUtil.appendFragments((String)((PTable)((Object)table)).getSpeedSearch().getEnteredPrefix(), (String)item.getName(), (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)this.myRenderer);
        this.myRenderer.setToolTipText(item.getTooltipText());
        return this.myPanel;
    }

    @Nullable
    private static Icon getStar(@NotNull StarState state, boolean isSelected, boolean isHovering) {
        if (state == null) {
            PNameRenderer.$$$reportNull$$$0(2);
        }
        switch (state) {
            case STARRED: {
                return isSelected ? AndroidIcons.NeleIcons.FavoritesSelected : AndroidIcons.NeleIcons.Favorites;
            }
            case STAR_ABLE: {
                return isHovering ? AndroidIcons.NeleIcons.FavoritesHoverOutline : null;
            }
        }
        return null;
    }

    public static boolean hitTestStarIcon(int x) {
        return x >= 2 && x < 18;
    }

    public static boolean hitTestTreeNodeIcon(@NotNull PTableItem item, int x) {
        if (item == null) {
            PNameRenderer.$$$reportNull$$$0(3);
        }
        Icon icon = UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)true, (boolean)true);
        int beforeIcon = 18 + PNameRenderer.getBeforeIconSpacing(PNameRenderer.getDepth(item), icon.getIconWidth());
        return x >= beforeIcon && x <= beforeIcon + icon.getIconWidth();
    }

    private static int getBeforeIconSpacing(int depth, int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - iconWidth / 2);
        return nodeIndent * depth + leftIconOffset;
    }

    private static int getAfterIconSpacing(int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - iconWidth / 2);
        return Math.max(0, nodeIndent - leftIconOffset - iconWidth);
    }

    private static int getDepth(@NotNull PTableItem item) {
        if (item == null) {
            PNameRenderer.$$$reportNull$$$0(4);
        }
        int result = 0;
        while (item.getParent() != null) {
            ++result;
            item = item.getParent();
            assert (item != null);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/property/ptable/renderers/PNameRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTableCellRendererComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getStar";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hitTestTreeNodeIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDepth";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Renderer
    extends ColoredTableCellRenderer {
        private Renderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.setIcon((PTableItem)value, selected, hasFocus);
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
        }

        private void setIcon(PTableItem item, boolean selected, boolean hasFocus) {
            int textGap;
            int indent;
            Icon icon;
            Icon groupIcon = UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)selected, (boolean)hasFocus);
            int beforeGroupIcon = PNameRenderer.getBeforeIconSpacing(PNameRenderer.getDepth(item), groupIcon.getIconWidth());
            int afterGroupIcon = PNameRenderer.getAfterIconSpacing(groupIcon.getIconWidth());
            if (item.hasChildren()) {
                icon = groupIcon;
                indent = beforeGroupIcon;
                textGap = afterGroupIcon;
            } else {
                icon = null;
                indent = beforeGroupIcon + groupIcon.getIconWidth() + afterGroupIcon;
                textGap = 0;
            }
            if ("http://schemas.android.com/tools".equals(item.getNamespace())) {
                if (icon == null) {
                    icon = AndroidIcons.NeleIcons.DesignProperty;
                } else {
                    LayeredIcon layered = new LayeredIcon(new Icon[]{icon, AndroidIcons.NeleIcons.DesignProperty});
                    layered.setIcon(AndroidIcons.NeleIcons.DesignProperty, 1, afterGroupIcon + icon.getIconWidth(), 0);
                    icon = layered;
                }
                textGap = 4;
            }
            this.setIcon(icon);
            this.setIconTextGap(textGap);
            this.setIpad((Insets)JBUI.insetsLeft((int)indent));
        }
    }
}

