/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlBooleanEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.ptable.PTable;
import com.android.tools.idea.uibuilder.property.ptable.PTableCellEditor;
import com.android.tools.idea.uibuilder.property.ptable.PTableItem;
import com.android.tools.idea.uibuilder.property.ptable.PTableModel;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlTableCellEditor
extends PTableCellEditor
implements NlEditingListener,
BrowsePanel.Context {
    private NlComponentEditor myEditor;
    private JTable myTable;
    private int myRow;

    public void init(@NotNull NlComponentEditor editor) {
        if (editor == null) {
            NlTableCellEditor.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        assert (value instanceof NlProperty);
        this.myEditor.setProperty((NlProperty)value);
        this.myTable = table;
        this.myRow = row;
        return this.myEditor.getComponent();
    }

    public boolean stopCellEditing() {
        this.myTable.requestFocus();
        return super.stopCellEditing();
    }

    @Override
    public boolean isBooleanEditor() {
        return this.myEditor instanceof NlBooleanEditor;
    }

    @Override
    public void activate() {
        this.myEditor.activate();
    }

    public Object getCellEditorValue() {
        return this.myEditor.getValue();
    }

    @Override
    public void stopEditing(@NotNull NlComponentEditor editor, @Nullable Object value) {
        if (editor == null) {
            NlTableCellEditor.$$$reportNull$$$0(1);
        }
        this.stopCellEditing();
    }

    @Override
    public void cancelEditing(@NotNull NlComponentEditor editor) {
        if (editor == null) {
            NlTableCellEditor.$$$reportNull$$$0(2);
        }
        this.cancelCellEditing();
    }

    @Override
    @Nullable
    public NlProperty getProperty() {
        return NlTableCellEditor.getPropertyAt(this.myTable, this.myRow);
    }

    @Override
    @Nullable
    public NlProperty getDesignProperty() {
        return NlTableCellEditor.getDesignProperty(this.myTable, this.myRow);
    }

    @Override
    @Nullable
    public NlProperty getRuntimeProperty() {
        return NlTableCellEditor.getRuntimeProperty(this.myTable, this.myRow);
    }

    @Override
    public void cancelEditing() {
        this.cancelCellEditing();
    }

    @Override
    public void addDesignProperty() {
        this.cancelEditing();
        NlTableCellEditor.addDesignProperty(this.myTable, this.myRow);
    }

    @Override
    public void removeDesignProperty() {
        this.cancelEditing();
        NlTableCellEditor.removeDesignProperty(this.myTable, this.myRow);
    }

    @Nullable
    public static NlPropertyItem getPropertyAt(@NotNull JTable table, int row) {
        if (table == null) {
            NlTableCellEditor.$$$reportNull$$$0(3);
        }
        if (!(table instanceof PTable) || row < 0 || row >= table.getRowCount()) {
            return null;
        }
        Object value = table.getValueAt(row, 1);
        if (value instanceof NlPropertyItem) {
            return (NlPropertyItem)value;
        }
        return null;
    }

    @Nullable
    public static NlProperty getRuntimeProperty(@NotNull JTable table, int row) {
        if (table == null) {
            NlTableCellEditor.$$$reportNull$$$0(4);
        }
        NlPropertyItem currentProperty = NlTableCellEditor.getPropertyAt(table, row);
        NlPropertyItem previousProperty = NlTableCellEditor.getPropertyAt(table, NlTableCellEditor.getPreviousPropertyRow(currentProperty, table, row));
        if (currentProperty != null && previousProperty != null && previousProperty.getName().equals(currentProperty.getName()) && "http://schemas.android.com/tools".equals(currentProperty.getNamespace()) && !"http://schemas.android.com/tools".equals(previousProperty.getNamespace())) {
            return previousProperty;
        }
        return null;
    }

    @Nullable
    public static NlProperty getDesignProperty(@NotNull JTable table, int row) {
        if (table == null) {
            NlTableCellEditor.$$$reportNull$$$0(5);
        }
        NlPropertyItem currentProperty = NlTableCellEditor.getPropertyAt(table, row);
        NlPropertyItem nextProperty = NlTableCellEditor.getPropertyAt(table, NlTableCellEditor.getNextPropertyRow(currentProperty, row));
        if (currentProperty != null && nextProperty != null && nextProperty.getName().equals(currentProperty.getName()) && !"http://schemas.android.com/tools".equals(currentProperty.getNamespace()) && "http://schemas.android.com/tools".equals(nextProperty.getNamespace())) {
            return nextProperty;
        }
        return null;
    }

    public static void addDesignProperty(@NotNull JTable table, int row) {
        if (table == null) {
            NlTableCellEditor.$$$reportNull$$$0(6);
        }
        NlPropertyItem property = NlTableCellEditor.getPropertyAt(table, row);
        assert (property != null && !"http://schemas.android.com/tools".equals(property.getNamespace()));
        assert (NlTableCellEditor.getDesignProperty(table, row) == null);
        PTableModel model = (PTableModel)table.getModel();
        int nextRow = NlTableCellEditor.getNextPropertyRow(property, row);
        model.insertRow(nextRow, property.getDesignTimeProperty());
        if (property.isExpanded()) {
            model.expand(nextRow);
        }
        SwingUtilities.invokeLater(() -> {
            if (table == null) {
                NlTableCellEditor.$$$reportNull$$$0(10);
            }
            table.editCellAt(row + 1, 1);
        });
    }

    public static void removeDesignProperty(@NotNull JTable table, int row) {
        if (table == null) {
            NlTableCellEditor.$$$reportNull$$$0(7);
        }
        NlPropertyItem designProperty = NlTableCellEditor.getPropertyAt(table, row);
        assert (designProperty != null && "http://schemas.android.com/tools".equals(designProperty.getNamespace()));
        int previousRow = NlTableCellEditor.getPreviousPropertyRow(designProperty, table, row);
        PTableModel model = (PTableModel)table.getModel();
        designProperty.setValue(null);
        designProperty.delete();
        model.collapse(row);
        model.deleteRow(row);
        SwingUtilities.invokeLater(() -> {
            if (table == null) {
                NlTableCellEditor.$$$reportNull$$$0(9);
            }
            table.editCellAt(previousRow, 1);
        });
    }

    private static int getNextPropertyRow(@Nullable NlPropertyItem currentProperty, int row) {
        if (currentProperty == null) {
            return -1;
        }
        return row + 1 + (currentProperty.isExpanded() ? currentProperty.getChildren().size() : 0);
    }

    private static int getPreviousPropertyRow(@Nullable NlPropertyItem currentProperty, @NotNull JTable table, int row) {
        if (table == null) {
            NlTableCellEditor.$$$reportNull$$$0(8);
        }
        if (currentProperty == null || row == 0) {
            return -1;
        }
        PTableItem previous = (PTableItem)table.getValueAt(row - 1, 1);
        if (previous.getParent() != null && currentProperty.getParent() == null) {
            return row - previous.getParent().getChildren().size() - 1;
        }
        return row - 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/NlTableCellEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "stopEditing";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelEditing";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyAt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRuntimeProperty";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getDesignProperty";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addDesignProperty";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDesignProperty";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreviousPropertyRow";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$removeDesignProperty$1";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addDesignProperty$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

