/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.resources.ResourceType;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.module.Module;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowsePanel
extends JPanel {
    private final Context myContext;
    private final ActionButton myBrowseButton;
    private final ActionButton myDesignButton;

    public BrowsePanel(@NotNull Context context) {
        if (context == null) {
            BrowsePanel.$$$reportNull$$$0(0);
        }
        this(context, true);
    }

    public BrowsePanel(@NotNull Context context, boolean showDesignButton) {
        if (context == null) {
            BrowsePanel.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myBrowseButton = BrowsePanel.createActionButton(new BrowseAction(context));
        this.myDesignButton = showDesignButton ? BrowsePanel.createActionButton(this.createDesignAction()) : null;
        this.setLayout(new BoxLayout(this, 0));
        this.add((Component)this.myBrowseButton);
        this.myBrowseButton.setFocusable(true);
        if (this.myDesignButton != null) {
            this.add((Component)this.myDesignButton);
            this.myDesignButton.setFocusable(true);
        }
    }

    public void setProperty(@NotNull NlProperty property) {
        if (property == null) {
            BrowsePanel.$$$reportNull$$$0(2);
        }
        this.myBrowseButton.setVisible(BrowsePanel.hasResourceChooser(property));
    }

    public void mousePressed(@NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        if (event == null) {
            BrowsePanel.$$$reportNull$$$0(3);
        }
        if (rectRightColumn == null) {
            BrowsePanel.$$$reportNull$$$0(4);
        }
        if ((double)event.getX() > rectRightColumn.getX() + rectRightColumn.getWidth() - (double)this.myDesignButton.getWidth()) {
            this.myDesignButton.click();
        } else if ((double)event.getX() > rectRightColumn.getX() + rectRightColumn.getWidth() - (double)this.myDesignButton.getWidth() - (double)this.myBrowseButton.getWidth()) {
            this.myBrowseButton.click();
        }
    }

    private static ActionButton createActionButton(@NotNull AnAction action) {
        if (action == null) {
            BrowsePanel.$$$reportNull$$$0(5);
        }
        return new ActionButton(action, action.getTemplatePresentation().clone(), "unknown", ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
    }

    public static ChooseResourceDialog showResourceChooser(@NotNull NlProperty property) {
        if (property == null) {
            BrowsePanel.$$$reportNull$$$0(6);
        }
        Module module = property.getModel().getModule();
        AttributeDefinition definition = property.getDefinition();
        EnumSet<ResourceType> types = BrowsePanel.getResourceTypes(property.getName(), definition);
        return ChooseResourceDialog.builder().setModule(module).setTypes(types).setCurrentValue(property.getValue()).setTag(property.getTag()).build();
    }

    public static boolean hasResourceChooser(@NotNull NlProperty property) {
        if (property == null) {
            BrowsePanel.$$$reportNull$$$0(7);
        }
        return !BrowsePanel.getResourceTypes(property.getName(), property.getDefinition()).isEmpty();
    }

    @NotNull
    public static EnumSet<ResourceType> getResourceTypes(@NotNull String propertyName, @Nullable AttributeDefinition definition) {
        if (propertyName == null) {
            BrowsePanel.$$$reportNull$$$0(8);
        }
        Set<AttributeFormat> formats = definition != null ? definition.getFormats() : EnumSet.allOf(AttributeFormat.class);
        ResourceType type = AndroidDomUtil.SPECIAL_RESOURCE_TYPES.get(propertyName);
        EnumSet<ResourceType> enumSet = type == null ? AttributeFormat.convertTypes(formats) : EnumSet.of(type);
        if (enumSet == null) {
            BrowsePanel.$$$reportNull$$$0(9);
        }
        return enumSet;
    }

    private AnAction createDesignAction() {
        return new AnAction(){

            public void update(AnActionEvent event) {
                Presentation presentation = event.getPresentation();
                switch (this.checkDesignState()) {
                    case MISSING_DESIGN_PROPERTY: {
                        presentation.setIcon(AndroidIcons.NeleIcons.DesignProperty);
                        presentation.setText("Specify Design Property");
                        presentation.setVisible(true);
                        presentation.setEnabled(true);
                        break;
                    }
                    case IS_REMOVABLE_DESIGN_PROPERTY: {
                        presentation.setIcon(AllIcons.Actions.Delete);
                        presentation.setText("Remove this Design Property");
                        presentation.setVisible(true);
                        presentation.setEnabled(true);
                        break;
                    }
                    default: {
                        presentation.setIcon(null);
                        presentation.setText(null);
                        presentation.setVisible(false);
                        presentation.setEnabled(false);
                    }
                }
            }

            public void actionPerformed(AnActionEvent event) {
                switch (this.checkDesignState()) {
                    case MISSING_DESIGN_PROPERTY: {
                        BrowsePanel.this.myContext.addDesignProperty();
                        break;
                    }
                    case IS_REMOVABLE_DESIGN_PROPERTY: {
                        BrowsePanel.this.myContext.removeDesignProperty();
                        break;
                    }
                }
            }

            private DesignState checkDesignState() {
                NlProperty property = BrowsePanel.this.myContext.getProperty();
                if (property == null || BrowsePanel.this.myDesignButton == null) {
                    return DesignState.NOT_APPLICABLE;
                }
                if ("http://schemas.android.com/tools".equals(property.getNamespace())) {
                    NlProperty runtimeProperty = BrowsePanel.this.myContext.getRuntimeProperty();
                    return runtimeProperty != null ? DesignState.IS_REMOVABLE_DESIGN_PROPERTY : DesignState.NOT_APPLICABLE;
                }
                NlProperty designProperty = BrowsePanel.this.myContext.getDesignProperty();
                return designProperty != null ? DesignState.HAS_DESIGN_PROPERTY : DesignState.MISSING_DESIGN_PROPERTY;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectRightColumn";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/BrowsePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/BrowsePanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mousePressed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createActionButton";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showResourceChooser";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasResourceChooser";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getResourceTypes";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum DesignState {
        NOT_APPLICABLE,
        IS_REMOVABLE_DESIGN_PROPERTY,
        HAS_DESIGN_PROPERTY,
        MISSING_DESIGN_PROPERTY;

    }

    private static class BrowseAction
    extends AnAction {
        private final Context myContext;

        private BrowseAction(@NotNull Context context) {
            if (context == null) {
                BrowseAction.$$$reportNull$$$0(0);
            }
            this.myContext = context;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.General.Ellipsis);
            presentation.setText("Pick a Resource");
        }

        public void actionPerformed(AnActionEvent event) {
            NlProperty property = this.myContext.getProperty();
            if (property == null) {
                return;
            }
            ChooseResourceDialog dialog = BrowsePanel.showResourceChooser(property);
            this.myContext.cancelEditing();
            if (dialog.showAndGet()) {
                this.myContext.stopEditing(dialog.getResourceName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/uibuilder/property/editors/BrowsePanel$BrowseAction", "<init>"));
        }
    }

    public static class ContextDelegate
    implements Context {
        private NlComponentEditor myEditor;

        @Override
        @Nullable
        public NlProperty getProperty() {
            return this.myEditor != null ? this.myEditor.getProperty() : null;
        }

        public void setEditor(@NotNull NlComponentEditor editor) {
            if (editor == null) {
                ContextDelegate.$$$reportNull$$$0(0);
            }
            this.myEditor = editor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/property/editors/BrowsePanel$ContextDelegate", "setEditor"));
        }
    }

    public static interface Context {
        @Nullable
        public NlProperty getProperty();

        @Nullable
        default public NlProperty getDesignProperty() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        default public NlProperty getRuntimeProperty() {
            throw new UnsupportedOperationException();
        }

        default public void cancelEditing() {
        }

        default public void stopEditing(@Nullable Object newValue) {
            NlProperty property = this.getProperty();
            if (property != null) {
                property.setValue(newValue);
            }
        }

        default public void addDesignProperty() {
            throw new UnsupportedOperationException();
        }

        default public void removeDesignProperty() {
            throw new UnsupportedOperationException();
        }
    }
}

