/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlLayoutType;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.google.common.base.Charsets;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.EnumMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;

public class NlPaletteModel {
    public static final String ANDROID_PALETTE = "android-palette";
    public static final String PALETTE_VERSION = "v1";
    private final Map<NlLayoutType, Palette> myTypeToPalette;
    private final Project myProject;

    public static NlPaletteModel get(@NotNull Project project) {
        if (project == null) {
            NlPaletteModel.$$$reportNull$$$0(0);
        }
        return (NlPaletteModel)project.getComponent(NlPaletteModel.class);
    }

    private NlPaletteModel(@NotNull Project project) {
        if (project == null) {
            NlPaletteModel.$$$reportNull$$$0(1);
        }
        this.myTypeToPalette = new EnumMap<NlLayoutType, Palette>(NlLayoutType.class);
        this.myProject = project;
    }

    @NotNull
    Palette getPalette(@NotNull NlLayoutType type) {
        if (type == null) {
            NlPaletteModel.$$$reportNull$$$0(2);
        }
        assert (type.isSupportedByDesigner());
        Palette palette = this.myTypeToPalette.get((Object)type);
        if (palette == null) {
            this.loadPalette(type);
            Palette palette2 = this.myTypeToPalette.get((Object)type);
            if (palette2 == null) {
                NlPaletteModel.$$$reportNull$$$0(3);
            }
            return palette2;
        }
        Palette palette3 = palette;
        if (palette3 == null) {
            NlPaletteModel.$$$reportNull$$$0(4);
        }
        return palette3;
    }

    private void loadPalette(@NotNull NlLayoutType type) {
        if (type == null) {
            NlPaletteModel.$$$reportNull$$$0(5);
        }
        try {
            String metadata = type.getPaletteFileName();
            URL url = NlPaletteModel.class.getResource(metadata);
            URLConnection connection = url.openConnection();
            try (InputStreamReader reader = new InputStreamReader(connection.getInputStream(), Charsets.UTF_8);){
                this.loadPalette(reader, type);
            }
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    void loadPalette(@NotNull Reader reader, @NotNull NlLayoutType type) throws JAXBException {
        if (reader == null) {
            NlPaletteModel.$$$reportNull$$$0(6);
        }
        if (type == null) {
            NlPaletteModel.$$$reportNull$$$0(7);
        }
        Palette palette = Palette.parse(reader, ViewHandlerManager.get(this.myProject));
        this.myTypeToPalette.put(type, palette);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette/NlPaletteModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/NlPaletteModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPalette";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPalette";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadPalette";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

