/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Lists;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.imageio.ImageIO;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconPreviewFactory
implements Disposable {
    private static final Logger LOG = Logger.getInstance(IconPreviewFactory.class);
    private static final int SHADOW_SIZE = 6;
    private static final int PREVIEW_LIMIT = 4000;
    private static final int DEFAULT_X_DIMENSION = 1080;
    private static final int DEFAULT_Y_DIMENSION = 1920;
    private static final String DEFAULT_THEME = "AppTheme";
    private static final String PREVIEW_PLACEHOLDER_FILE = "preview.xml";
    private static final String CONTAINER_ID = "TopLevelContainer";
    private static final String LINEAR_LAYOUT = "<LinearLayout\n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:app=\"http://schemas.android.com/apk/res-auto\"\n    android:id=\"@+id/%1$s\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"wrap_content\"\n    android:orientation=\"vertical\">\n  %2$s\n</LinearLayout>\n";
    final ExecutorService myExecutorService = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    long myRenderTimeoutSeconds = 1L;
    private RenderTask myRenderTask;

    @Nullable
    public BufferedImage getImage(@NotNull Palette.Item item, @NotNull Configuration configuration, double scale) {
        BufferedImage image;
        if (item == null) {
            IconPreviewFactory.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            IconPreviewFactory.$$$reportNull$$$0(1);
        }
        if ((image = IconPreviewFactory.readImage(item.getId(), configuration)) == null) {
            return null;
        }
        if (scale != 1.0) {
            image = ImageUtils.scale(image, scale);
        }
        return image;
    }

    @Nullable
    private RenderTask getRenderTask(Configuration configuration) {
        if (this.myRenderTask == null || this.myRenderTask.getModule() != configuration.getModule()) {
            AndroidFacet facet;
            if (this.myRenderTask != null) {
                this.myRenderTask.dispose();
            }
            if ((facet = AndroidFacet.getInstance(configuration.getModule())) == null) {
                return null;
            }
            RenderService renderService = RenderService.get(facet);
            RenderLogger logger = renderService.createLogger();
            this.myRenderTask = renderService.createTask(null, configuration, logger, null);
        }
        return this.myRenderTask;
    }

    @Nullable
    public BufferedImage renderDragImage(@NotNull Palette.Item item, @NotNull ScreenView screenView) {
        XmlTag tag;
        if (item == null) {
            IconPreviewFactory.$$$reportNull$$$0(2);
        }
        if (screenView == null) {
            IconPreviewFactory.$$$reportNull$$$0(3);
        }
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)screenView.getModel().getProject());
        String xml = item.getDragPreviewXml();
        if (xml.equals("")) {
            return null;
        }
        try {
            tag = elementFactory.createTagFromText((CharSequence)xml);
        }
        catch (IncorrectOperationException exception) {
            return null;
        }
        NlModel model = screenView.getModel();
        NlComponent component = (NlComponent)ApplicationManager.getApplication().runWriteAction(() -> {
            if (screenView == null) {
                IconPreviewFactory.$$$reportNull$$$0(20);
            }
            return model.createComponent(screenView, tag, null, null, InsertType.CREATE_PREVIEW);
        });
        if (component == null) {
            return null;
        }
        xml = String.format(LINEAR_LAYOUT, CONTAINER_ID, component.getTag().getText());
        RenderResult result = IconPreviewFactory.renderImage(this.myExecutorService, this.myRenderTimeoutSeconds, this.getRenderTask(model.getConfiguration()), xml);
        if (result == null || !result.hasImage()) {
            return null;
        }
        ImagePool.Image image = result.getRenderedImage();
        List infos = result.getRootViews();
        if (infos.isEmpty()) {
            return null;
        }
        if ((infos = infos.get(0).getChildren()) == null || infos.isEmpty()) {
            return null;
        }
        ViewInfo view = (ViewInfo)infos.get(0);
        if (image.getHeight() < view.getBottom() || image.getWidth() < view.getRight() || view.getBottom() <= view.getTop() || view.getRight() <= view.getLeft()) {
            return null;
        }
        int shadowWitdh = 6 * screenView.getConfiguration().getDensity().getDpiValue() / 160;
        int shadowIncrement = 1 + Coordinates.getSwingDimension(screenView, shadowWitdh);
        BufferedImage imageCopy = image.getCopy();
        if (imageCopy == null) {
            return null;
        }
        return imageCopy.getSubimage(view.getLeft(), view.getTop(), Math.min(view.getRight() + shadowIncrement, image.getWidth()), Math.min(view.getBottom() + shadowIncrement, image.getHeight()));
    }

    private static BufferedImage readImage(@NotNull String id, @NotNull Configuration configuration) {
        File file;
        if (id == null) {
            IconPreviewFactory.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            IconPreviewFactory.$$$reportNull$$$0(5);
        }
        if (!(file = new File(IconPreviewFactory.getPreviewCacheDirForConfiguration(configuration), id + ".png")).exists()) {
            return null;
        }
        try {
            return ImageIO.read(file);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void dropCache() {
        FileUtil.delete((File)IconPreviewFactory.getPreviewCacheDir());
    }

    public boolean load(@NotNull Configuration configuration, @NotNull Palette palette, boolean reload) {
        if (configuration == null) {
            IconPreviewFactory.$$$reportNull$$$0(6);
        }
        if (palette == null) {
            IconPreviewFactory.$$$reportNull$$$0(7);
        }
        return this.load(configuration, palette, reload, null, null);
    }

    boolean load(final @NotNull Configuration configuration, final @NotNull Palette palette, boolean reload, final @Nullable List<String> requestedIds, final @Nullable List<String> generatedIds) {
        File cacheDir;
        String[] files;
        if (configuration == null) {
            IconPreviewFactory.$$$reportNull$$$0(8);
        }
        if (palette == null) {
            IconPreviewFactory.$$$reportNull$$$0(9);
        }
        if ((files = (cacheDir = IconPreviewFactory.getPreviewCacheDirForConfiguration(configuration)).list()) != null && files.length > 0) {
            if (!reload) {
                return false;
            }
            FileUtil.delete((File)cacheDir);
        }
        ApplicationManager.getApplication().runReadAction((Computable)new Computable<Void>(){

            public Void compute() {
                ArrayList sources = Lists.newArrayList();
                IconPreviewFactory.loadSources(sources, requestedIds, palette.getItems());
                for (StringBuilder source : sources) {
                    String preview = String.format(IconPreviewFactory.LINEAR_LAYOUT, IconPreviewFactory.CONTAINER_ID, source);
                    IconPreviewFactory.addResultToCache(IconPreviewFactory.renderImage(IconPreviewFactory.this.myExecutorService, IconPreviewFactory.this.myRenderTimeoutSeconds, IconPreviewFactory.this.getRenderTask(configuration), preview), generatedIds, configuration);
                }
                return null;
            }
        });
        return true;
    }

    private static void loadSources(@NotNull List<StringBuilder> sources, @Nullable List<String> ids, List<Palette.BaseItem> items) {
        if (sources == null) {
            IconPreviewFactory.$$$reportNull$$$0(10);
        }
        boolean previousRenderedSeparately = false;
        for (Palette.BaseItem base : items) {
            StringBuilder last;
            Palette.Item item;
            String preview;
            if (base instanceof Palette.Group) {
                Palette.Group group = (Palette.Group)base;
                IconPreviewFactory.loadSources(sources, ids, group.getItems());
                continue;
            }
            if (!(base instanceof Palette.Item) || (preview = (item = (Palette.Item)base).getPreviewXml()).equals("")) continue;
            StringBuilder stringBuilder = last = sources.isEmpty() ? null : sources.get(sources.size() - 1);
            if (last == null || last.length() > 4000 || last.length() > 0 && (item.isPreviewRenderedSeparately() || previousRenderedSeparately)) {
                last = new StringBuilder();
                sources.add(last);
            }
            previousRenderedSeparately = item.isPreviewRenderedSeparately();
            last.append(preview);
            if (ids == null) continue;
            ids.add(item.getId());
        }
    }

    @NotNull
    private static File getPreviewCacheDir() {
        File file = new File(PathUtil.getCanonicalPath((String)PathManager.getSystemPath()) + File.separator + "android-palette" + File.separator + "v1" + File.separator + "image-cache");
        if (file == null) {
            IconPreviewFactory.$$$reportNull$$$0(11);
        }
        return file;
    }

    @NotNull
    private static File getPreviewCacheDirForConfiguration(@NotNull Configuration configuration) {
        ScreenOrientation orientation;
        if (configuration == null) {
            IconPreviewFactory.$$$reportNull$$$0(12);
        }
        int density = configuration.getDensity().getDpiValue();
        State state = configuration.getDeviceState();
        Screen screen = state != null ? state.getHardware().getScreen() : null;
        int xDimension = 1080;
        int yDimension = 1920;
        if (screen != null) {
            xDimension = screen.getXDimension();
            yDimension = screen.getYDimension();
            density = screen.getPixelDensity().getDpiValue();
        }
        ScreenOrientation screenOrientation = orientation = state != null ? state.getOrientation() : ScreenOrientation.PORTRAIT;
        if (orientation == ScreenOrientation.LANDSCAPE && xDimension < yDimension || orientation == ScreenOrientation.PORTRAIT && xDimension > yDimension) {
            int temp = xDimension;
            xDimension = yDimension;
            yDimension = temp;
        }
        String theme = IconPreviewFactory.getTheme(configuration);
        String apiVersion = IconPreviewFactory.getApiVersion(configuration);
        String cacheFolder = theme + File.separator + xDimension + "x" + yDimension + "-" + density + "-" + apiVersion;
        File file = new File(IconPreviewFactory.getPreviewCacheDir(), cacheFolder);
        if (file == null) {
            IconPreviewFactory.$$$reportNull$$$0(13);
        }
        return file;
    }

    @NotNull
    private static String getTheme(@NotNull Configuration configuration) {
        String theme;
        if (configuration == null) {
            IconPreviewFactory.$$$reportNull$$$0(14);
        }
        if ((theme = configuration.getTheme()) == null) {
            theme = DEFAULT_THEME;
        }
        theme = StringUtil.trimStart((String)theme, (String)"@style/");
        String string = theme = StringUtil.trimStart((String)theme, (String)"@android:style/");
        if (string == null) {
            IconPreviewFactory.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static String getApiVersion(@NotNull Configuration configuration) {
        IAndroidTarget target;
        if (configuration == null) {
            IconPreviewFactory.$$$reportNull$$$0(16);
        }
        return (target = configuration.getTarget()) == null ? "25U" : target.getVersion().getApiString();
    }

    @Nullable
    private static BufferedImage addResultToCache(@Nullable RenderResult result, @Nullable List<String> ids, @NotNull Configuration configuration) {
        if (configuration == null) {
            IconPreviewFactory.$$$reportNull$$$0(17);
        }
        if (result == null || result.getRenderedImage() == null || result.getRootViews().isEmpty()) {
            return null;
        }
        ImageAccumulator accumulator = new ImageAccumulator(result.getRenderedImage().getCopy(), ids, configuration);
        accumulator.run(result.getRootViews(), 0, null);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static RenderResult renderImage(@NotNull ExecutorService executorService, long timeoutSeconds, @Nullable RenderTask renderTask, @NotNull String string) {
        void xml;
        if (executorService == null) {
            IconPreviewFactory.$$$reportNull$$$0(18);
        }
        if (string == null) {
            IconPreviewFactory.$$$reportNull$$$0(19);
        }
        if (renderTask == null) {
            return null;
        }
        PsiFile file = PsiFileFactory.getInstance((Project)renderTask.getModule().getProject()).createFileFromText(PREVIEW_PLACEHOLDER_FILE, (FileType)XmlFileType.INSTANCE, (CharSequence)xml);
        renderTask.setPsiFile(file);
        renderTask.setOverrideBgColor(UIUtil.TRANSPARENT_COLOR.getRGB());
        renderTask.setDecorations(false);
        renderTask.setRenderingMode(SessionParams.RenderingMode.V_SCROLL);
        renderTask.setFolderType(ResourceFolderType.LAYOUT);
        try {
            return executorService.submit(() -> {
                renderTask.inflate();
                return renderTask.render();
            }).get(timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    public void dispose() {
        if (this.myRenderTask != null) {
            this.myRenderTask.dispose();
            this.myRenderTask = null;
        }
        this.myExecutorService.shutdown();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "palette";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette/IconPreviewFactory";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorService";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/IconPreviewFactory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewCacheDir";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewCacheDirForConfiguration";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getImage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "renderDragImage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readImage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadSources";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewCacheDirForConfiguration";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTheme";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getApiVersion";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addResultToCache";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "renderImage";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$renderDragImage$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface RenderResultHandler {
        @Nullable
        public BufferedImage handle(@NotNull RenderResult var1);
    }

    private static class ImageAccumulator {
        private final BufferedImage myImage;
        private final List<String> myIds;
        private final File myCacheDir;
        private final int myHeight;
        private final int myWidth;

        private ImageAccumulator(@NotNull BufferedImage image, @Nullable List<String> ids, @NotNull Configuration configuration) {
            if (image == null) {
                ImageAccumulator.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                ImageAccumulator.$$$reportNull$$$0(1);
            }
            this.myImage = image;
            this.myIds = ids;
            this.myCacheDir = IconPreviewFactory.getPreviewCacheDirForConfiguration(configuration);
            this.myHeight = image.getRaster().getHeight();
            this.myWidth = image.getRaster().getWidth();
        }

        private void run(@NotNull List<ViewInfo> views, int top, @Nullable String parentId) {
            if (views == null) {
                ImageAccumulator.$$$reportNull$$$0(2);
            }
            for (ViewInfo info : views) {
                String id = null;
                XmlTag tag = RenderService.getXmlTag(info);
                if (tag != null) {
                    id = ImageAccumulator.getId(tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android"));
                    if (IconPreviewFactory.CONTAINER_ID.equals(parentId)) {
                        if (info.getBottom() + top <= this.myHeight && info.getRight() <= this.myWidth && info.getBottom() > info.getTop()) {
                            Rectangle bounds = new Rectangle(info.getLeft(), info.getTop() + top, info.getRight() - info.getLeft(), info.getBottom() - info.getTop());
                            BufferedImage image = this.myImage.getSubimage(bounds.x, bounds.y, bounds.width, bounds.height);
                            if (id == null) {
                                id = tag.getName();
                            }
                            this.saveImage(id, image);
                            if (this.myIds != null) {
                                this.myIds.add(id);
                            }
                        } else {
                            LOG.warn(String.format("Dimensions of %1$s is out of range", id));
                        }
                    }
                }
                if (info.getChildren().isEmpty() || IconPreviewFactory.CONTAINER_ID.equals(parentId)) continue;
                this.run(info.getChildren(), top + info.getTop(), id);
            }
        }

        @Nullable
        private static String getId(@Nullable String id) {
            if (id != null) {
                if (id.startsWith("@+id/")) {
                    return id.substring("@+id/".length());
                }
                if (id.startsWith("@id/")) {
                    return id.substring("@id/".length());
                }
            }
            return id;
        }

        private void saveImage(@NotNull String id, @NotNull BufferedImage image) {
            block4: {
                if (id == null) {
                    ImageAccumulator.$$$reportNull$$$0(3);
                }
                if (image == null) {
                    ImageAccumulator.$$$reportNull$$$0(4);
                }
                this.myCacheDir.mkdirs();
                File file = new File(this.myCacheDir, id + ".png");
                try {
                    ImageIO.write((RenderedImage)image, "PNG", file);
                }
                catch (IOException e) {
                    if (!file.exists()) break block4;
                    file.delete();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "views";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/palette/IconPreviewFactory$ImageAccumulator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveImage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

