/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.tools;

import com.android.tools.idea.ui.resourcechooser.ColorPicker;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ExtractedColor;
import com.intellij.ui.ColorPickerListener;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class ColorPanel {
    public static final JBColor BACKGROUND = new JBColor(JBColor.background().darker(), JBColor.background().brighter());
    private final ExtractedColor myExtractedColor;
    private JTextField myColorCode;
    private JTextField myColorName;
    private JButton mySaveButton;
    private JButton mySetAsBackgroundButton;
    private JPanel myColorFrame;
    private JPanel myContentPane;
    private List<ColorHoveredListener> myListeners;

    public ColorPanel(ExtractedColor extractedColor) {
        this.$$$setupUI$$$();
        Color color = new Color(extractedColor.getColor());
        this.initColorFrame(color);
        this.myExtractedColor = extractedColor;
        this.myColorCode.setText(this.getColorHexString(extractedColor.getColor()));
        this.myColorName.setText(this.findColorName(extractedColor.getColor()));
        this.initSaveButton();
        this.initBackgroundButton();
        this.myContentPane.setBackground((Color)BACKGROUND);
        this.myListeners = new ArrayList<ColorHoveredListener>(1);
    }

    private String getColorHexString(int rgb) {
        return String.format(Locale.US, "#%05X", rgb);
    }

    private void initColorFrame(final Color color) {
        this.myColorFrame.setBackground(color);
        this.myColorFrame.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                ColorPicker.showDialog(ColorPanel.this.myContentPane, "Edit color", color, true, new ColorPickerListener[]{new ColorPickerListener(){

                    public void colorChanged(Color color) {
                    }

                    public void closed(@Nullable Color color) {
                        if (color != null) {
                            ColorPanel.this.myColorName.setText(ColorPanel.this.getColorHexString(color.getRGB()));
                        }
                    }
                }}, true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                System.out.println("ColorPanel.mouseEntered");
                for (int i = 0; i < ColorPanel.this.myListeners.size(); ++i) {
                    ((ColorHoveredListener)ColorPanel.this.myListeners.get(i)).entered(ColorPanel.this.myExtractedColor);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                for (int i = 0; i < ColorPanel.this.myListeners.size(); ++i) {
                    ((ColorHoveredListener)ColorPanel.this.myListeners.get(i)).exited();
                }
            }
        });
    }

    private void initBackgroundButton() {
        this.mySetAsBackgroundButton.setOpaque(false);
    }

    private void initSaveButton() {
        this.mySaveButton.setOpaque(false);
    }

    private String findColorName(int color) {
        return "Color name";
    }

    public JPanel getComponent() {
        return this.myContentPane;
    }

    public void addHoveredListener(ColorHoveredListener listener) {
        this.myListeners.add(listener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JTextField jTextField;
        JButton jButton2;
        JPanel jPanel;
        JTextField jTextField2;
        JPanel jPanel2;
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, 5, false, false));
        this.myColorCode = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myColorFrame = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, true, true));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 3, 1, 8, 2, 1, 1, null, new Dimension(100, 24), null));
        this.mySetAsBackgroundButton = jButton2 = new JButton();
        jButton2.setText("Set as background");
        jPanel2.add((Component)jButton2, new GridConstraints(2, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myColorName = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.mySaveButton = jButton = new JButton();
        jButton.setText("Save");
        jPanel2.add((Component)jButton, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 1, 1, 2, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    static interface ColorHoveredListener {
        public void entered(ExtractedColor var1);

        public void exited();
    }
}

