/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.colorextractor;

import com.android.tools.idea.uibuilder.mockup.colorextractor.Clusterer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class KMeansClusterer
implements Clusterer {
    public static final int PASS_NUMBER = 100;
    private final int myK;
    private int myInputDataSize;
    private double[][] myData;
    private double[][] myOutputColors;

    public KMeansClusterer(int k) {
        this.myK = k;
        this.myOutputColors = new double[this.myK][3];
    }

    @Override
    public List<List<double[]>> cluster(double[][] points) {
        int dist;
        this.myData = points;
        this.myInputDataSize = points.length;
        this.getInitialColors();
        for (int i = 0; i < 100 && (dist = this.pass()) != 0; ++i) {
        }
        ArrayList<List<double[]>> clusters = new ArrayList<List<double[]>>(this.myOutputColors.length);
        for (int i = 0; i < this.myOutputColors.length; ++i) {
            ArrayList<double[]> cluster = new ArrayList<double[]>(1);
            cluster.add(this.myOutputColors[i]);
            clusters.add(cluster);
        }
        return clusters;
    }

    int pass() {
        double[][] centers = new double[this.myK][3];
        int[] count = new int[this.myK];
        for (int pointIndex = 0; pointIndex < this.myInputDataSize; ++pointIndex) {
            double minDist = Double.MAX_VALUE;
            int closestColor = 0;
            for (int outputIndex = 0; outputIndex < this.myOutputColors.length; ++outputIndex) {
                double distance = KMeansClusterer.distance(this.myOutputColors[outputIndex], this.myData[pointIndex]);
                if (!(distance < minDist)) continue;
                minDist = distance;
                closestColor = outputIndex;
            }
            double[] dArray = centers[closestColor];
            dArray[0] = dArray[0] + this.myData[pointIndex][0];
            double[] dArray2 = centers[closestColor];
            dArray2[1] = dArray2[1] + this.myData[pointIndex][1];
            double[] dArray3 = centers[closestColor];
            dArray3[2] = dArray3[2] + this.myData[pointIndex][2];
            int n = closestColor;
            count[n] = count[n] + 1;
        }
        int dist = 0;
        for (int j = 0; j < this.myOutputColors.length; ++j) {
            if (count[j] == 0) continue;
            int l = (int)centers[j][0] / count[j];
            int a = (int)centers[j][1] / count[j];
            int b = (int)centers[j][2] / count[j];
            double[] oldColor = new double[3];
            System.arraycopy(this.myOutputColors[j], 0, oldColor, 0, 3);
            this.myOutputColors[j][0] = l;
            this.myOutputColors[j][1] = a;
            this.myOutputColors[j][2] = b;
            dist = (int)((double)dist + KMeansClusterer.distance(oldColor, this.myOutputColors[j]));
        }
        return dist;
    }

    private static double distance(double[] neighbor, double[] point) {
        double squares = 0.0;
        for (int i = 0; i < Math.min(neighbor.length, point.length); ++i) {
            squares += Math.pow(neighbor[i] - point[i], 2.0);
        }
        return squares;
    }

    void getInitialColors() {
        HashSet<double[]> set = new HashSet<double[]>();
        for (int step = 256; step > 0; step /= 2) {
            for (int i = 0; i < this.myInputDataSize; i += step) {
                double[] v = this.myData[i];
                set.add(v);
                if (set.size() == this.myK) break;
            }
            if (set.size() == this.myK) break;
        }
        double[][] c = (double[][])set.toArray((T[])new double[set.size()][3]);
        if (this.myOutputColors.length < set.size()) {
            this.myOutputColors = new double[set.size()][3];
        }
        System.arraycopy(c, 0, this.myOutputColors, 0, c.length);
    }
}

