/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.lint;

import com.android.tools.idea.uibuilder.lint.LintAnnotationsModel;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.android.inspections.lint.AndroidLintExternalAnnotator;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintUtil;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.inspections.lint.State;
import org.jetbrains.annotations.NotNull;

public class NlLintHighlightingPass
implements HighlightingPass {
    private final DesignSurface mySurface;
    private LintAnnotationsModel myLintAnnotationsModel;

    public NlLintHighlightingPass(@NotNull DesignSurface surface) {
        if (surface == null) {
            NlLintHighlightingPass.$$$reportNull$$$0(0);
        }
        this.mySurface = surface;
    }

    public void collectInformation(@NotNull ProgressIndicator progress) {
        ScreenView screenView;
        if (progress == null) {
            NlLintHighlightingPass.$$$reportNull$$$0(1);
        }
        if ((screenView = this.mySurface.getCurrentScreenView()) == null) {
            return;
        }
        this.myLintAnnotationsModel = NlLintHighlightingPass.getAnnotations(screenView.getModel(), progress);
    }

    public void applyInformationToEditor() {
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        if (screenView == null) {
            return;
        }
        screenView.getModel().setLintAnnotationsModel(this.myLintAnnotationsModel);
        screenView.getSurface().repaint();
    }

    @NotNull
    private static LintAnnotationsModel getAnnotations(@NotNull NlModel model, @NotNull ProgressIndicator progress) {
        if (model == null) {
            NlLintHighlightingPass.$$$reportNull$$$0(2);
        }
        if (progress == null) {
            NlLintHighlightingPass.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LintAnnotationsModel lintModel = new LintAnnotationsModel();
        XmlFile xmlFile = model.getFile();
        AndroidLintExternalAnnotator annotator = new AndroidLintExternalAnnotator();
        State state = annotator.collectInformation((PsiFile)xmlFile);
        if (state != null) {
            state = annotator.doAnnotate(state);
        }
        if (state == null) {
            LintAnnotationsModel lintAnnotationsModel = lintModel;
            if (lintAnnotationsModel == null) {
                NlLintHighlightingPass.$$$reportNull$$$0(4);
            }
            return lintAnnotationsModel;
        }
        for (ProblemData problemData : state.getProblems()) {
            AndroidLintInspectionBase inspection;
            NlComponent component;
            if (progress.isCanceled()) break;
            TextRange range = problemData.getTextRange();
            PsiElement startElement = xmlFile.findElementAt(range.getStartOffset());
            PsiElement endElement = xmlFile.findElementAt(range.getEndOffset());
            if (startElement == null || endElement == null || (component = model.findViewByPsi(startElement)) == null) continue;
            Issue issue = problemData.getIssue();
            Pair<AndroidLintInspectionBase, HighlightDisplayLevel> pair = AndroidLintUtil.getHighlighLevelAndInspection(xmlFile.getProject(), issue, (PsiElement)xmlFile);
            if (pair == null || (inspection = (AndroidLintInspectionBase)((Object)pair.getFirst())) == null) continue;
            HighlightDisplayLevel level = (HighlightDisplayLevel)pair.getSecond();
            HighlightDisplayKey key = HighlightDisplayKey.find((String)inspection.getShortName());
            if (key == null) continue;
            lintModel.addIssue(component, issue, problemData.getMessage(), inspection, level, startElement, endElement);
        }
        LintAnnotationsModel lintAnnotationsModel = lintModel;
        if (lintAnnotationsModel == null) {
            NlLintHighlightingPass.$$$reportNull$$$0(5);
        }
        return lintAnnotationsModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/lint/NlLintHighlightingPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/lint/NlLintHighlightingPass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotations";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

