/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.menu;

import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.menu.ActionBar;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GroupDragHandler
extends DragHandler {
    private final NlComponent myGroup;
    private final List<NlComponent> myItems;
    private final ActionBar myActionBar;
    private NlComponent myActiveItem;

    GroupDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull NlComponent group, @NotNull List<NlComponent> items, @NotNull DragType type) {
        if (editor == null) {
            GroupDragHandler.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            GroupDragHandler.$$$reportNull$$$0(1);
        }
        if (group == null) {
            GroupDragHandler.$$$reportNull$$$0(2);
        }
        if (items == null) {
            GroupDragHandler.$$$reportNull$$$0(3);
        }
        if (type == null) {
            GroupDragHandler.$$$reportNull$$$0(4);
        }
        super(editor, handler, group, items, type);
        assert (!items.isEmpty());
        this.myGroup = group;
        this.myItems = items;
        this.myActionBar = new ActionBar(group);
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        if (insertType == null) {
            GroupDragHandler.$$$reportNull$$$0(5);
        }
        this.updateOrderInCategoryAttributes();
        this.updateShowAsActionAttribute();
        this.insertComponents(this.getInsertIndex(), insertType);
    }

    private void updateOrderInCategoryAttributes() {
        if (this.myActiveItem == null || this.myActiveItem == this.myItems.get(0)) {
            return;
        }
        Integer order = GroupDragHandler.getOrderInCategory(this.myActiveItem);
        if (order == null) {
            return;
        }
        if (this.isActionBarGroupActive()) {
            this.updateActionBarGroupOrderInCategoryAttributes(order);
        } else {
            this.updateOverflowGroupOrderInCategoryAttributes(order);
        }
    }

    private void updateActionBarGroupOrderInCategoryAttributes(int order) {
        if (this.lastX >= this.myActiveItem.getMidpointX()) {
            ++order;
        }
        GroupDragHandler.incrementOrderInCategoryAttributes(this.createOrderToItemMultimap(this.myActionBar.getItems()), order);
        this.myItems.get(0).setAndroidAttribute("orderInCategory", Integer.toString(order));
    }

    private void updateOverflowGroupOrderInCategoryAttributes(int order) {
        if (this.lastY >= this.myActiveItem.getMidpointY()) {
            ++order;
        }
        GroupDragHandler.incrementOrderInCategoryAttributes(this.createOrderToItemMultimap(this.myActionBar.getOverflowItems()), order);
        this.myItems.get(0).setAndroidAttribute("orderInCategory", Integer.toString(order));
    }

    private static void incrementOrderInCategoryAttributes(@NotNull Multimap<Integer, NlComponent> orderToItemMultimap, int order) {
        Collection items;
        if (orderToItemMultimap == null) {
            GroupDragHandler.$$$reportNull$$$0(6);
        }
        if (!(items = orderToItemMultimap.get((Object)order)).isEmpty()) {
            items.forEach(item -> item.setAndroidAttribute("orderInCategory", Integer.toString(order + 1)));
            GroupDragHandler.incrementOrderInCategoryAttributes(orderToItemMultimap, order + 1);
        }
    }

    @NotNull
    private Multimap<Integer, NlComponent> createOrderToItemMultimap(@NotNull Iterable<NlComponent> group) {
        if (group == null) {
            GroupDragHandler.$$$reportNull$$$0(7);
        }
        NlComponent draggedItem = this.myItems.get(0);
        ArrayListMultimap orderToItemMultimap = ArrayListMultimap.create();
        for (NlComponent item : group) {
            Integer order;
            if (item == draggedItem || (order = GroupDragHandler.getOrderInCategory(item)) == null) continue;
            orderToItemMultimap.put((Object)order, (Object)item);
        }
        ArrayListMultimap arrayListMultimap = orderToItemMultimap;
        if (arrayListMultimap == null) {
            GroupDragHandler.$$$reportNull$$$0(8);
        }
        return arrayListMultimap;
    }

    @Nullable
    private static Integer getOrderInCategory(@NotNull NlComponent item) {
        String order;
        if (item == null) {
            GroupDragHandler.$$$reportNull$$$0(9);
        }
        return (order = item.getAndroidAttribute("orderInCategory")) == null ? null : Ints.tryParse((String)order);
    }

    private void updateShowAsActionAttribute() {
        if (this.isActionBarGroupActive()) {
            this.myItems.get(0).setAttribute(this.getNamespace(), "showAsAction", "always");
        } else {
            this.myItems.get(0).removeAttribute(this.getNamespace(), "showAsAction");
        }
    }

    private String getNamespace() {
        return this.editor.getModel().isModuleDependency("com.android.support:appcompat-v7") ? "http://schemas.android.com/apk/res-auto" : "http://schemas.android.com/apk/res/android";
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers) {
        String message = super.update(x, y, modifiers);
        if (message != null) {
            this.myActiveItem = null;
            return message;
        }
        if (this.isActionBarGroupActive()) {
            this.updateUsingActionBarGroup();
        } else if (this.isOverflowGroupActive()) {
            this.updateUsingOverflowGroup();
        } else {
            this.myActiveItem = null;
        }
        return null;
    }

    private void updateUsingActionBarGroup() {
        List<NlComponent> items = this.myActionBar.getItems();
        if (this.lastX < items.get((int)0).x) {
            this.myActiveItem = items.get(0);
        } else {
            Optional<NlComponent> activeItem = items.stream().filter(item -> item.containsX(this.lastX)).findFirst();
            this.myActiveItem = activeItem.orElse(items.get(items.size() - 1));
        }
    }

    private void updateUsingOverflowGroup() {
        List<NlComponent> overflowItems = this.myActionBar.getOverflowItems();
        if (this.lastY < overflowItems.get((int)0).y) {
            this.myActiveItem = overflowItems.get(0);
        } else {
            Optional<NlComponent> activeItem = overflowItems.stream().filter(item -> item.containsY(this.lastY)).findFirst();
            this.myActiveItem = activeItem.orElse(overflowItems.get(overflowItems.size() - 1));
        }
    }

    @Override
    public void paint(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            GroupDragHandler.$$$reportNull$$$0(10);
        }
        if (this.isActionBarGroupActive()) {
            this.drawActionBarGroupDropPreviewLine(graphics);
            this.drawActionBarGroupDropRecipientLines(graphics);
            this.drawActionBarGroupDropZoneLines(graphics);
        } else if (this.isOverflowGroupActive()) {
            this.drawOverflowGroupDropPreviewLine(graphics);
            this.drawOverflowGroupDropRecipientLines(graphics);
            this.drawOverflowGroupDropZoneLines(graphics);
        }
    }

    private void drawActionBarGroupDropPreviewLine(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            GroupDragHandler.$$$reportNull$$$0(11);
        }
        graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
        if (this.lastX < this.myActiveItem.getMidpointX()) {
            graphics.drawLeft(this.myActiveItem);
        } else {
            graphics.drawRight(this.myActiveItem);
        }
    }

    private void drawActionBarGroupDropRecipientLines(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            GroupDragHandler.$$$reportNull$$$0(12);
        }
        Rectangle itemBounds = this.myActionBar.getItemBounds();
        assert (itemBounds != null);
        List<NlComponent> items = this.myActionBar.getItems();
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        graphics.drawTop(itemBounds);
        if (this.lastX >= items.get(0).getMidpointX()) {
            graphics.drawLeft(itemBounds);
        }
        if (this.lastX < items.get(items.size() - 1).getMidpointX()) {
            graphics.drawRight(itemBounds);
        }
        graphics.drawBottom(itemBounds);
    }

    private void drawActionBarGroupDropZoneLines(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            GroupDragHandler.$$$reportNull$$$0(13);
        }
        List<NlComponent> items = this.myActionBar.getItems();
        int midpointX = this.myActiveItem.getMidpointX();
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        int size = items.size();
        for (int i = 1; i < size; ++i) {
            NlComponent item = items.get(i);
            if (this.myActiveItem == items.get(i - 1)) {
                if (this.lastX >= midpointX) continue;
                graphics.drawLeft(item);
                continue;
            }
            if (this.myActiveItem == item) {
                if (this.lastX < midpointX) continue;
                graphics.drawLeft(item);
                continue;
            }
            graphics.drawLeft(item);
        }
    }

    private void drawOverflowGroupDropPreviewLine(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            GroupDragHandler.$$$reportNull$$$0(14);
        }
        graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
        if (this.lastY < this.myActiveItem.getMidpointY()) {
            graphics.drawTop(this.myActiveItem);
        } else {
            graphics.drawBottom(this.myActiveItem);
        }
    }

    private void drawOverflowGroupDropRecipientLines(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            GroupDragHandler.$$$reportNull$$$0(15);
        }
        List<NlComponent> overflowItems = this.myActionBar.getOverflowItems();
        Rectangle overflowItemBounds = this.myActionBar.getOverflowItemBounds();
        assert (overflowItemBounds != null);
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        if (this.lastY >= overflowItems.get(0).getMidpointY()) {
            graphics.drawTop(overflowItemBounds);
        }
        graphics.drawLeft(overflowItemBounds);
        graphics.drawRight(overflowItemBounds);
        if (this.lastY < overflowItems.get(overflowItems.size() - 1).getMidpointY()) {
            graphics.drawBottom(overflowItemBounds);
        }
    }

    private void drawOverflowGroupDropZoneLines(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            GroupDragHandler.$$$reportNull$$$0(16);
        }
        List<NlComponent> overflowItems = this.myActionBar.getOverflowItems();
        int midpointY = this.myActiveItem.getMidpointY();
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        int size = overflowItems.size();
        for (int i = 1; i < size; ++i) {
            NlComponent item = overflowItems.get(i);
            if (this.myActiveItem == overflowItems.get(i - 1)) {
                if (this.lastY >= midpointY) continue;
                graphics.drawTop(item);
                continue;
            }
            if (this.myActiveItem == item) {
                if (this.lastY < midpointY) continue;
                graphics.drawTop(item);
                continue;
            }
            graphics.drawTop(item);
        }
    }

    int getInsertIndex() {
        if (this.isActionBarGroupActive()) {
            return this.getInsertIndexUsingActionBarGroup();
        }
        if (this.isOverflowGroupActive()) {
            return this.getInsertIndexUsingOverflowGroup();
        }
        return -1;
    }

    private int getInsertIndexUsingActionBarGroup() {
        Rectangle itemBounds = this.myActionBar.getItemBounds();
        assert (itemBounds != null);
        if (this.lastX < itemBounds.x) {
            return 0;
        }
        if (this.lastX >= itemBounds.x + itemBounds.width) {
            return -1;
        }
        int i = this.myGroup.getChildren().indexOf(this.myActiveItem);
        assert (i != -1);
        if (this.lastX >= this.myActiveItem.getMidpointX()) {
            ++i;
        }
        return i == this.myGroup.getChildCount() ? -1 : i;
    }

    private int getInsertIndexUsingOverflowGroup() {
        Rectangle overflowItemBounds = this.myActionBar.getOverflowItemBounds();
        assert (overflowItemBounds != null);
        if (this.lastY < overflowItemBounds.y) {
            return 0;
        }
        if (this.lastY >= overflowItemBounds.y + overflowItemBounds.height) {
            return -1;
        }
        int i = this.myGroup.getChildren().indexOf(this.myActiveItem);
        assert (i != -1);
        if (this.lastY >= this.myActiveItem.getMidpointY()) {
            ++i;
        }
        return i == this.myGroup.getChildCount() ? -1 : i;
    }

    private boolean isActionBarGroupActive() {
        Rectangle itemBounds = this.myActionBar.getItemBounds();
        return itemBounds != null && this.lastY < itemBounds.y + itemBounds.height;
    }

    private boolean isOverflowGroupActive() {
        return this.myActionBar.getOverflowItemBounds() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderToItemMultimap";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/menu/GroupDragHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrderToItemMultimap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "incrementOrderInCategoryAttributes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createOrderToItemMultimap";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrderInCategory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "drawActionBarGroupDropPreviewLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "drawActionBarGroupDropRecipientLines";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "drawActionBarGroupDropZoneLines";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "drawOverflowGroupDropPreviewLine";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "drawOverflowGroupDropRecipientLines";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "drawOverflowGroupDropZoneLines";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

