/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.Guideline;
import android.support.constraint.solver.widgets.WidgetContainer;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.resources.ResourceResolver;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintModel;
import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.Insets;
import com.android.tools.idea.uibuilder.model.NlAttributesHolder;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.TextDirection;
import com.android.tools.idea.uibuilder.scene.Scene;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.sherpa.drawing.decorator.TextWidget;
import com.android.tools.sherpa.drawing.decorator.WidgetDecorator;
import com.android.tools.sherpa.interaction.WidgetInteractionTargets;
import com.android.tools.sherpa.scout.Scout;
import com.android.tools.sherpa.structure.WidgetCompanion;
import com.android.tools.sherpa.structure.WidgetsScene;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintUtilities {
    static final boolean APPLY_MINIMUM_SIZE = false;
    static final int MINIMUM_SIZE = 48;
    static final int MINIMUM_SIZE_EXPAND = 6;
    private static HashMap<String, Integer> alignmentMap = new HashMap();

    public static int getAlignment(String s) {
        if (alignmentMap.containsKey(s)) {
            return alignmentMap.get(s);
        }
        return 5;
    }

    @Nullable
    static String getConnectionAttributeMargin(@Nullable ConstraintAnchor anchor) {
        if (anchor != null) {
            switch (anchor.getType()) {
                case LEFT: {
                    return "layout_marginLeft";
                }
                case TOP: {
                    return "layout_marginTop";
                }
                case RIGHT: {
                    return "layout_marginRight";
                }
                case BOTTOM: {
                    return "layout_marginBottom";
                }
            }
        }
        return null;
    }

    @Nullable
    static String getConnectionRtlAttributeMargin(@Nullable ConstraintAnchor anchor) {
        if (anchor != null) {
            switch (anchor.getType()) {
                case LEFT: {
                    return "layout_marginStart";
                }
                case RIGHT: {
                    return "layout_marginEnd";
                }
            }
        }
        return null;
    }

    @Nullable
    static String getConnectionAttribute(@Nullable ConstraintAnchor origin, @Nullable ConstraintAnchor target) {
        String attribute = null;
        if (origin != null && target != null) {
            block0 : switch (origin.getType()) {
                case BASELINE: {
                    if (target.getType() != ConstraintAnchor.Type.BASELINE) break;
                    attribute = "layout_constraintBaseline_toBaselineOf";
                    break;
                }
                case LEFT: {
                    switch (target.getType()) {
                        case LEFT: {
                            attribute = "layout_constraintLeft_toLeftOf";
                            break;
                        }
                        case RIGHT: {
                            attribute = "layout_constraintLeft_toRightOf";
                        }
                    }
                    break;
                }
                case RIGHT: {
                    switch (target.getType()) {
                        case LEFT: {
                            attribute = "layout_constraintRight_toLeftOf";
                            break;
                        }
                        case RIGHT: {
                            attribute = "layout_constraintRight_toRightOf";
                        }
                    }
                    break;
                }
                case TOP: {
                    switch (target.getType()) {
                        case TOP: {
                            attribute = "layout_constraintTop_toTopOf";
                            break;
                        }
                        case BOTTOM: {
                            attribute = "layout_constraintTop_toBottomOf";
                        }
                    }
                    break;
                }
                case BOTTOM: {
                    switch (target.getType()) {
                        case TOP: {
                            attribute = "layout_constraintBottom_toTopOf";
                            break block0;
                        }
                        case BOTTOM: {
                            attribute = "layout_constraintBottom_toBottomOf";
                        }
                    }
                }
            }
        }
        return attribute;
    }

    @Nullable
    static String getConnectionAttributeCreator(@Nullable ConstraintAnchor anchor) {
        if (anchor != null) {
            switch (anchor.getType()) {
                case LEFT: {
                    return "layout_constraintLeft_creator";
                }
                case TOP: {
                    return "layout_constraintTop_creator";
                }
                case RIGHT: {
                    return "layout_constraintRight_creator";
                }
                case BOTTOM: {
                    return "layout_constraintBottom_creator";
                }
                case BASELINE: {
                    return "layout_constraintBaseline_creator";
                }
                case CENTER: {
                    return "layout_constraintCenter_creator";
                }
                case CENTER_X: {
                    return "layout_constraintCenterX_creator";
                }
                case CENTER_Y: {
                    return "layout_constraintCenterY_creator";
                }
            }
        }
        return null;
    }

    public static void resetAnchor(@NotNull NlAttributesHolder attributes, @NotNull ConstraintAnchor.Type anchorType) {
        if (attributes == null) {
            ConstraintUtilities.$$$reportNull$$$0(0);
        }
        if (anchorType == null) {
            ConstraintUtilities.$$$reportNull$$$0(1);
        }
        switch (anchorType) {
            case LEFT: {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart", null);
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toLeftOf", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toRightOf", null);
                attributes.setAttribute("http://schemas.android.com/tools", "layout_constraintLeft_creator", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
                break;
            }
            case TOP: {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toTopOf", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toBottomOf", null);
                attributes.setAttribute("http://schemas.android.com/tools", "layout_constraintTop_creator", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
                break;
            }
            case RIGHT: {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd", null);
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toLeftOf", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf", null);
                attributes.setAttribute("http://schemas.android.com/tools", "layout_constraintRight_creator", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
                break;
            }
            case BOTTOM: {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toTopOf", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf", null);
                attributes.setAttribute("http://schemas.android.com/tools", "layout_constraintBottom_creator", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
                break;
            }
            case BASELINE: {
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf", null);
                attributes.setAttribute("http://schemas.android.com/tools", "layout_constraintBaseline_creator", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
            }
        }
    }

    public static void setEditorPosition(@Nullable ConstraintWidget widget, @NotNull NlAttributesHolder attributes, int x, int y) {
        if (attributes == null) {
            ConstraintUtilities.$$$reportNull$$$0(2);
        }
        String attributeX = "layout_editor_absoluteX";
        String attributeY = "layout_editor_absoluteY";
        if (widget != null && ConstraintUtilities.hasHorizontalConstraints(widget)) {
            attributes.setAttribute("http://schemas.android.com/tools", attributeX, null);
        } else {
            String sX = String.format("%ddp", x);
            attributes.setAttribute("http://schemas.android.com/tools", attributeX, sX);
        }
        if (widget != null && ConstraintUtilities.hasVerticalConstraints(widget)) {
            attributes.setAttribute("http://schemas.android.com/tools", attributeY, null);
        } else {
            String sY = String.format("%ddp", y);
            attributes.setAttribute("http://schemas.android.com/tools", attributeY, sY);
        }
    }

    public static void clearEditorPosition(@NotNull NlAttributesHolder attributes) {
        if (attributes == null) {
            ConstraintUtilities.$$$reportNull$$$0(3);
        }
        attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", null);
        attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", null);
    }

    private static boolean hasHorizontalConstraints(@NotNull ConstraintWidget widget) {
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(4);
        }
        ConstraintAnchor left = widget.getAnchor(ConstraintAnchor.Type.LEFT);
        ConstraintAnchor right = widget.getAnchor(ConstraintAnchor.Type.RIGHT);
        return left != null && left.isConnected() || right != null && right.isConnected();
    }

    private static boolean hasVerticalConstraints(@NotNull ConstraintWidget widget) {
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(5);
        }
        ConstraintAnchor top = widget.getAnchor(ConstraintAnchor.Type.TOP);
        ConstraintAnchor bottom = widget.getAnchor(ConstraintAnchor.Type.BOTTOM);
        ConstraintAnchor baseline = widget.getAnchor(ConstraintAnchor.Type.BASELINE);
        return top != null && top.isConnected() || bottom != null && bottom.isConnected() || baseline != null && baseline.isConnected();
    }

    private static boolean versionGreaterThan(GradleVersion v, int major, int minor, int micro, int beta, int alpha) {
        if (v == null) {
            return true;
        }
        if (v.getMajor() != major) {
            return v.getMajor() > major;
        }
        if (v.getMinor() != minor) {
            return v.getMinor() > minor;
        }
        if (v.getMicro() != micro) {
            return v.getMicro() > micro;
        }
        if (alpha > 0) {
            if ("alpha".equals(v.getPreviewType())) {
                return v.getPreview() > alpha;
            }
            return true;
        }
        if (beta > 0) {
            if ("beta".equals(v.getPreviewType())) {
                return v.getPreview() > beta;
            }
            return true;
        }
        return false;
    }

    private static boolean useParentReference(NlModel model) {
        String constraint_artifact = "com.android.support.constraint:constraint-layout";
        GradleVersion v = model.getModuleDependencyVersion(constraint_artifact);
        return ConstraintUtilities.versionGreaterThan(v, 1, 0, 0, 0, 4);
    }

    private static boolean useGuidelineFloat(NlModel model) {
        String constraint_artifact = "com.android.support.constraint:constraint-layout";
        GradleVersion v = model.getModuleDependencyVersion(constraint_artifact);
        return ConstraintUtilities.versionGreaterThan(v, 1, 0, 0, 0, 5);
    }

    static void setConnection(@NotNull NlAttributesHolder attributes, @NotNull ConstraintAnchor anchor) {
        if (attributes == null) {
            ConstraintUtilities.$$$reportNull$$$0(6);
        }
        if (anchor == null) {
            ConstraintUtilities.$$$reportNull$$$0(7);
        }
        ConstraintUtilities.resetAnchor(attributes, anchor.getType());
        String attribute = ConstraintUtilities.getConnectionAttribute(anchor, anchor.getTarget());
        String marginAttribute = ConstraintUtilities.getConnectionAttributeMargin(anchor);
        String marginAttributeRtl = ConstraintUtilities.getConnectionRtlAttributeMargin(anchor);
        if (anchor.isConnected() && attribute != null) {
            NlModel model;
            ConstraintWidget owner = anchor.getOwner();
            WidgetCompanion ownerCompanion = (WidgetCompanion)owner.getCompanionWidget();
            ConstraintWidget target = anchor.getTarget().getOwner();
            WidgetCompanion companion = (WidgetCompanion)target.getCompanionWidget();
            NlComponent targetComponent = (NlComponent)companion.getWidgetModel();
            boolean use_parent_ref = ConstraintUtilities.useParentReference(targetComponent.getModel());
            String targetId = owner.getParent() == target && use_parent_ref ? "parent" : "@+id/" + targetComponent.ensureId();
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", attribute, targetId);
            String margin = ownerCompanion.getWidgetProperties().getMarginValue(anchor);
            String marginRtl = ownerCompanion.getWidgetProperties().getMarginRtlValue(anchor);
            String marginValue = null;
            if (anchor.getMargin() > 0) {
                marginValue = String.format("%ddp", anchor.getMargin());
            }
            if (margin != null && !ownerCompanion.getWidgetProperties().isMarginReference(anchor)) {
                margin = marginValue;
            }
            if (marginRtl != null && !ownerCompanion.getWidgetProperties().isMarginRtlReference(anchor)) {
                marginRtl = marginValue;
            }
            if (ConstraintUtilities.supportsStartEnd(anchor, model = targetComponent.getModel())) {
                if (marginRtl == null) {
                    marginRtl = margin != null ? margin : marginValue;
                }
                if (ConstraintUtilities.requiresRightLeft(model) && margin == null) {
                    margin = marginRtl;
                }
            } else if (margin == null) {
                margin = marginValue;
            }
            if (marginAttribute != null && margin != null) {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", marginAttribute, margin);
            }
            if (marginAttributeRtl != null && marginRtl != null) {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", marginAttributeRtl, marginRtl);
            }
            String attributeCreator = ConstraintUtilities.getConnectionAttributeCreator(anchor);
            if (anchor.getConnectionCreator() != 0) {
                attributes.setAttribute("http://schemas.android.com/tools", attributeCreator, String.valueOf(anchor.getConnectionCreator()));
            } else {
                attributes.setAttribute("http://schemas.android.com/tools", attributeCreator, null);
            }
        }
    }

    static boolean isRtlMargin(String attribute) {
        return "layout_marginLeft".equals(attribute) || "layout_marginRight".equals(attribute);
    }

    @NotNull
    static String getRtlMarginAttribute(String attribute, TextDirection direction) {
        if ("layout_marginLeft".equals(attribute)) {
            String string = direction.getAttrMarginLeft();
            if (string == null) {
                ConstraintUtilities.$$$reportNull$$$0(8);
            }
            return string;
        }
        if ("layout_marginRight".equals(attribute)) {
            String string = direction.getAttrMarginRight();
            if (string == null) {
                ConstraintUtilities.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = direction.getAttrMarginLeft();
        if (string == null) {
            ConstraintUtilities.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static void setDimension(@NotNull NlAttributesHolder attributes, @NotNull ConstraintWidget widget) {
        String height;
        String width;
        if (attributes == null) {
            ConstraintUtilities.$$$reportNull$$$0(11);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(12);
        }
        switch (widget.getHorizontalDimensionBehaviour()) {
            case MATCH_CONSTRAINT: {
                width = "0dp";
                break;
            }
            case WRAP_CONTENT: {
                width = "wrap_content";
                break;
            }
            default: {
                width = String.format("%ddp", widget.getWidth());
            }
        }
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", width);
        switch (widget.getVerticalDimensionBehaviour()) {
            case MATCH_CONSTRAINT: {
                height = "0dp";
                break;
            }
            case WRAP_CONTENT: {
                height = "wrap_content";
                break;
            }
            default: {
                height = String.format("%ddp", widget.getHeight());
            }
        }
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", height);
    }

    private static String chainStyleToString(int style) {
        switch (style) {
            case 0: {
                return "spread";
            }
            case 1: {
                return "spread_inside";
            }
            case 2: {
                return "packed";
            }
        }
        return null;
    }

    static void setHorizontalChainStyle(@NotNull NlAttributesHolder attributes, @NotNull ConstraintWidget widget) {
        int style;
        if (attributes == null) {
            ConstraintUtilities.$$$reportNull$$$0(13);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(14);
        }
        if ((style = widget.getHorizontalChainStyle()) == 0) {
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_chainStyle", null);
        } else {
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_chainStyle", ConstraintUtilities.chainStyleToString(style));
        }
    }

    static void setVerticalChainStyle(@NotNull NlAttributesHolder attributes, @NotNull ConstraintWidget widget) {
        int style;
        if (attributes == null) {
            ConstraintUtilities.$$$reportNull$$$0(15);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(16);
        }
        if ((style = widget.getVerticalChainStyle()) == 0) {
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_chainStyle", null);
        } else {
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_chainStyle", ConstraintUtilities.chainStyleToString(style));
        }
    }

    static void setRatio(@NotNull NlAttributesHolder attributes, @NotNull ConstraintWidget widget) {
        if (attributes == null) {
            ConstraintUtilities.$$$reportNull$$$0(17);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(18);
        }
        WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
        attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintDimensionRatio", companion.getWidgetProperties().getDimensionRatio());
    }

    static void setHorizontalBias(@NotNull NlAttributesHolder attributes, @NotNull ConstraintWidget widget) {
        float bias;
        if (attributes == null) {
            ConstraintUtilities.$$$reportNull$$$0(19);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(20);
        }
        if ((bias = widget.getHorizontalBiasPercent()) != 0.5f) {
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", String.valueOf(bias));
        }
    }

    static void setVerticalBias(@NotNull NlAttributesHolder component, @NotNull ConstraintWidget widget) {
        float bias;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(21);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(22);
        }
        if ((bias = widget.getVerticalBiasPercent()) != 0.5f) {
            component.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", String.valueOf(bias));
        }
    }

    static void commitGuideline(NlModel model, @NotNull NlAttributesHolder component, @NotNull Guideline guideline) {
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(23);
        }
        if (guideline == null) {
            ConstraintUtilities.$$$reportNull$$$0(24);
        }
        int behaviour = guideline.getRelativeBehaviour();
        WidgetCompanion companion = (WidgetCompanion)guideline.getCompanionWidget();
        component.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", null);
        component.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", null);
        component.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", null);
        component.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_Percent", null);
        String previousValue = companion.getWidgetProperties().getGuidelineAttribute();
        if (previousValue != null && !previousValue.startsWith("@")) {
            previousValue = null;
        }
        String value = previousValue;
        if (behaviour == 0) {
            boolean useFloat = ConstraintUtilities.useGuidelineFloat(model);
            if (value == null) {
                float percent = guideline.getRelativePercent();
                value = useFloat ? String.valueOf(percent) : String.valueOf((int)(percent * 100.0f));
            }
            String percentAttribute = useFloat ? "layout_constraintGuide_percent" : "layout_constraintGuide_Percent";
            component.setAttribute("http://schemas.android.com/apk/res-auto", percentAttribute, value);
        } else if (behaviour == 1) {
            if (value == null) {
                value = String.format("%ddp", guideline.getRelativeBegin());
            }
            component.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", value);
        } else if (behaviour == 2) {
            if (value == null) {
                value = String.format("%ddp", guideline.getRelativeEnd());
            }
            component.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", value);
        }
    }

    static void setBias(@NotNull String attribute, @NotNull NlComponent component, @NotNull ConstraintWidget widget) {
        if (attribute == null) {
            ConstraintUtilities.$$$reportNull$$$0(25);
        }
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(26);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(27);
        }
        String biasString = component.getAttribute("http://schemas.android.com/apk/res-auto", attribute);
        float bias = ConstraintUtilities.parseFloat(biasString, 0.5f);
        if (attribute.equalsIgnoreCase("layout_constraintHorizontal_bias")) {
            widget.setHorizontalBiasPercent(bias);
        } else {
            widget.setVerticalBiasPercent(bias);
        }
    }

    static void setDimensionRatio(@NotNull String attribute, @NotNull NlComponent component, @NotNull ConstraintWidget widget) {
        if (attribute == null) {
            ConstraintUtilities.$$$reportNull$$$0(28);
        }
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(29);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(30);
        }
        String dimensionRatioString = component.getAttribute("http://schemas.android.com/apk/res-auto", attribute);
        widget.setDimensionRatio(dimensionRatioString);
    }

    static void setChainStyle(@NotNull String attribute, @NotNull NlComponent component, @NotNull ConstraintWidget widget) {
        String chainStyleString;
        if (attribute == null) {
            ConstraintUtilities.$$$reportNull$$$0(31);
        }
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(32);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(33);
        }
        if ((chainStyleString = component.getAttribute("http://schemas.android.com/apk/res-auto", attribute)) != null) {
            int style = 0;
            if (chainStyleString.equalsIgnoreCase("spread")) {
                style = 0;
            } else if (chainStyleString.equalsIgnoreCase("spread_inside")) {
                style = 1;
            } else if (chainStyleString.equalsIgnoreCase("packed")) {
                style = 2;
            }
            if ("layout_constraintHorizontal_chainStyle".equals(attribute)) {
                widget.setHorizontalChainStyle(style);
            } else {
                widget.setVerticalChainStyle(style);
            }
        }
    }

    static void setChainWeight(@NotNull String attribute, @NotNull NlComponent component, @NotNull ConstraintWidget widget) {
        if (attribute == null) {
            ConstraintUtilities.$$$reportNull$$$0(34);
        }
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(35);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(36);
        }
        String chainWeightString = component.getAttribute("http://schemas.android.com/apk/res-auto", attribute);
        float weight = ConstraintUtilities.parseFloat(chainWeightString, 0.0f);
        if ("layout_constraintHorizontal_weight".equals(attribute)) {
            widget.setHorizontalWeight(weight);
        } else {
            widget.setVerticalWeight(weight);
        }
    }

    private static float parseFloat(String string, float defaultValue) {
        float ret = defaultValue;
        if (string != null && string.length() > 0) {
            try {
                ret = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    static void setStartMargin(@Nullable String left, @NotNull NlComponent component, @NotNull ConstraintWidget widget) {
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(37);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(38);
        }
        if (left != null) {
            int margin = ConstraintUtilities.getMargin(component, "layout_marginStart");
            ConstraintAnchor anchor = widget.getAnchor(ConstraintAnchor.Type.LEFT);
            if (anchor != null) {
                anchor.setMargin(margin);
            }
        }
    }

    static void setEndMargin(@Nullable String right, @NotNull NlComponent component, @NotNull ConstraintWidget widget) {
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(39);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(40);
        }
        if (right != null) {
            int margin = ConstraintUtilities.getMargin(component, "layout_marginEnd");
            ConstraintAnchor anchor = widget.getAnchor(ConstraintAnchor.Type.RIGHT);
            if (anchor != null) {
                anchor.setMargin(margin);
            }
        }
    }

    static void setTopMargin(@Nullable String top, @NotNull NlComponent component, @NotNull ConstraintWidget widget) {
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(41);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(42);
        }
        if (top != null) {
            int margin = ConstraintUtilities.getMargin(component, "layout_marginTop");
            ConstraintAnchor anchor = widget.getAnchor(ConstraintAnchor.Type.TOP);
            if (anchor != null) {
                anchor.setMargin(margin);
            }
        }
    }

    static void setBottomMargin(@Nullable String bottom, @NotNull NlComponent component, @NotNull ConstraintWidget widget) {
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(43);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(44);
        }
        if (bottom != null) {
            int margin = ConstraintUtilities.getMargin(component, "layout_marginBottom");
            ConstraintAnchor anchor = widget.getAnchor(ConstraintAnchor.Type.BOTTOM);
            if (anchor != null) {
                anchor.setMargin(margin);
            }
        }
    }

    static int getMargin(@NotNull NlComponent component, @NotNull String attr) {
        String margin;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(45);
        }
        if (attr == null) {
            ConstraintUtilities.$$$reportNull$$$0(46);
        }
        if ((margin = component.getLiveAttribute("http://schemas.android.com/apk/res/android", attr)) == null) {
            if (attr == "layout_marginStart") {
                margin = component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
            } else if (attr == "layout_marginEnd") {
                margin = component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
            }
        }
        if (margin != null) {
            return ConstraintUtilities.getDpValue(component, margin);
        }
        return 0;
    }

    public static int getDpValue(@NotNull NlComponent component, String value) {
        Configuration configuration;
        ResourceResolver resourceResolver;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(47);
        }
        if (value != null && (resourceResolver = (configuration = component.getModel().getConfiguration()).getResourceResolver()) != null) {
            Integer px = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, value, configuration);
            return px == null ? 0 : (int)(0.5f + (float)px.intValue() / ((float)configuration.getDensity().getDpiValue() / 160.0f));
        }
        return 0;
    }

    private static int getLayoutDimensionDpValue(@NotNull NlComponent component, String value) {
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(48);
        }
        if ("wrap_content".equalsIgnoreCase(value)) {
            return -2;
        }
        if ("match_parent".equalsIgnoreCase(value)) {
            return -1;
        }
        return ConstraintUtilities.getDpValue(component, value);
    }

    static void setTarget(@NotNull NlModel model, @NotNull WidgetsScene widgetsScene, @Nullable String targetID, @Nullable ConstraintWidget widgetSrc, @NotNull ConstraintAnchor.Type constraintA, @NotNull ConstraintAnchor.Type constraintB) {
        if (model == null) {
            ConstraintUtilities.$$$reportNull$$$0(49);
        }
        if (widgetsScene == null) {
            ConstraintUtilities.$$$reportNull$$$0(50);
        }
        if (constraintA == null) {
            ConstraintUtilities.$$$reportNull$$$0(51);
        }
        if (constraintB == null) {
            ConstraintUtilities.$$$reportNull$$$0(52);
        }
        if (targetID == null) {
            return;
        }
        NlComponent componentFound = null;
        ConstraintWidget parent = widgetSrc.getParent();
        if (ConstraintUtilities.useParentReference(model) && targetID.equalsIgnoreCase("parent") && parent != null) {
            WidgetCompanion companion = (WidgetCompanion)parent.getCompanionWidget();
            componentFound = (NlComponent)companion.getWidgetModel();
        } else {
            String id = NlComponent.extractId(targetID);
            if (id == null) {
                return;
            }
            for (NlComponent component : model.getComponents()) {
                NlComponent found = ConstraintUtilities.getComponentFromId(component, id);
                if (found == null) continue;
                componentFound = found;
                break;
            }
        }
        if (componentFound != null) {
            ConstraintWidget widget = widgetsScene.getWidget((Object)componentFound);
            if (widgetSrc != null && widget != null) {
                int connectionCreator = 0;
                WidgetCompanion companion = (WidgetCompanion)widgetSrc.getCompanionWidget();
                NlComponent component = (NlComponent)companion.getWidgetModel();
                String creatorAttribute = ConstraintUtilities.getConnectionAttributeCreator(widgetSrc.getAnchor(constraintA));
                String creatorValue = null;
                if (component != null && creatorAttribute != null) {
                    creatorValue = component.getAttribute("http://schemas.android.com/tools", creatorAttribute);
                }
                if (creatorValue != null) {
                    try {
                        connectionCreator = Integer.parseInt(creatorValue);
                    }
                    catch (NumberFormatException e) {
                        connectionCreator = 0;
                    }
                }
                if (constraintA == constraintB && constraintA == ConstraintAnchor.Type.BASELINE) {
                    widgetSrc.getAnchor(constraintA).connect(widget.getAnchor(constraintB), 0, -1, ConstraintAnchor.Strength.STRONG, connectionCreator, true);
                } else {
                    widgetSrc.connect(constraintA, widget, constraintB, 0, ConstraintAnchor.Strength.STRONG, connectionCreator);
                }
            }
        }
    }

    @Nullable
    static NlComponent getComponentFromId(@NotNull NlComponent component, @NotNull String id) {
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(53);
        }
        if (id == null) {
            ConstraintUtilities.$$$reportNull$$$0(54);
        }
        if (ConstraintUtilities.useParentReference(component.getModel()) && id.equalsIgnoreCase("parent")) {
            return component.getParent();
        }
        if (component.getId() != null && component.getId().equalsIgnoreCase(id)) {
            return component;
        }
        for (NlComponent child : component.getChildren()) {
            NlComponent found = ConstraintUtilities.getComponentFromId(child, id);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private static void setMargin(@NotNull ConstraintWidget widget, int margin, @NotNull ConstraintAnchor.Type type) {
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(55);
        }
        if (type == null) {
            ConstraintUtilities.$$$reportNull$$$0(56);
        }
        if (widget.getAnchor(type).isConnected()) {
            widget.getAnchor(type).setMargin(margin);
        }
    }

    static boolean updateWidgetFromComponent(@Nullable Scene scene, @NotNull ConstraintModel constraintModel, @Nullable ConstraintWidget widget, @Nullable NlComponent component) {
        WidgetDecorator decorator;
        String absoluteY;
        String absoluteX;
        WidgetContainer parentContainer;
        ConstraintWidget parentWidget;
        String absoluteHeight;
        if (constraintModel == null) {
            ConstraintUtilities.$$$reportNull$$$0(57);
        }
        if (component == null || widget == null) {
            return false;
        }
        if (!(widget instanceof Guideline)) {
            widget.setVisibility(component.getAndroidViewVisibility());
        }
        widget.setDebugName(component.getId());
        Insets padding = component.getPadding(true);
        WidgetsScene widgetsScene = constraintModel.getScene();
        if (scene != null) {
            long time = System.currentTimeMillis();
            SceneComponent sceneComponent = scene.getSceneComponent(component);
            if (sceneComponent != null) {
                widget.setDrawOrigin(sceneComponent.getDrawX(time), sceneComponent.getDrawY(time));
                int w = sceneComponent.getDrawWidth(time);
                int h = sceneComponent.getDrawHeight(time);
                widget.setDimension(w, h);
                return false;
            }
        }
        if (widget instanceof ConstraintWidgetContainer) {
            int paddingLeft = constraintModel.pxToDp(padding.left);
            int paddingTop = constraintModel.pxToDp(padding.top);
            int paddingRight = constraintModel.pxToDp(padding.right);
            int paddingBottom = constraintModel.pxToDp(padding.bottom);
            ((ConstraintWidgetContainer)widget).setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
            widget.setDimension(constraintModel.pxToDp(component.w) - paddingLeft - paddingRight, constraintModel.pxToDp(component.h) - paddingTop - paddingBottom);
        } else {
            widget.setDimension(constraintModel.pxToDp(component.w), constraintModel.pxToDp(component.h));
        }
        String absoluteWidth = component.getAttribute("http://schemas.android.com/tools", "layout_conversion_absoluteWidth");
        if (absoluteWidth != null) {
            Configuration configuration = component.getModel().getConfiguration();
            ResourceResolver resourceResolver = configuration.getResourceResolver();
            int size = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, absoluteWidth, configuration);
            size = constraintModel.pxToDp(size);
            widget.setWidth(size);
        }
        if ((absoluteHeight = component.getAttribute("http://schemas.android.com/tools", "layout_conversion_absoluteHeight")) != null) {
            Configuration configuration = component.getModel().getConfiguration();
            ResourceResolver resourceResolver = configuration.getResourceResolver();
            int size = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, absoluteHeight, configuration);
            size = constraintModel.pxToDp(size);
            widget.setHeight(size);
        }
        widget.setMinWidth(constraintModel.pxToDp(component.getMinimumWidth()));
        widget.setMinHeight(constraintModel.pxToDp(component.getMinimumHeight()));
        NlComponent parent = component.getParent();
        NlModel model = component.getModel();
        if (parent != null && (parentWidget = widgetsScene.getWidget((Object)parent)) instanceof WidgetContainer) {
            WidgetContainer parentContainerWidget = (WidgetContainer)parentWidget;
            if (widget.getParent() != parentContainerWidget) {
                parentContainerWidget.add(widget);
            }
        }
        int x = constraintModel.pxToDp(component.x);
        int y = constraintModel.pxToDp(component.y);
        if (widget instanceof ConstraintWidgetContainer) {
            x += constraintModel.pxToDp(padding.left);
            y += constraintModel.pxToDp(padding.top);
        }
        if ((parentContainer = (WidgetContainer)widget.getParent()) != null) {
            if (!(parentContainer instanceof ConstraintWidgetContainer)) {
                x = constraintModel.pxToDp(component.x - component.getParent().x);
                y = constraintModel.pxToDp(component.y - component.getParent().y);
            } else {
                x -= parentContainer.getDrawX();
                y -= parentContainer.getDrawY();
            }
        }
        if ((absoluteX = component.getAttribute("http://schemas.android.com/tools", "layout_conversion_absoluteX")) != null) {
            Configuration configuration = component.getModel().getConfiguration();
            ResourceResolver resourceResolver = configuration.getResourceResolver();
            int position = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, absoluteX, configuration);
            x = constraintModel.pxToDp(position);
        }
        if ((absoluteY = component.getAttribute("http://schemas.android.com/tools", "layout_conversion_absoluteY")) != null) {
            Configuration configuration = component.getModel().getConfiguration();
            ResourceResolver resourceResolver = configuration.getResourceResolver();
            int position = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, absoluteY, configuration);
            y = constraintModel.pxToDp(position);
        }
        if (scene == null && (widget.getX() != x || widget.getY() != y)) {
            widget.setOrigin(x, y);
            widget.forceUpdateDrawPosition();
        }
        boolean overrideDimension = false;
        String layout_width = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_width");
        if (component.w == 0 || ConstraintUtilities.getLayoutDimensionDpValue(component, layout_width) == 0) {
            widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
        } else if (layout_width != null && layout_width.equalsIgnoreCase("wrap_content")) {
            widget.setWrapWidth(widget.getWidth());
            widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
        } else if (layout_width != null && layout_width.equalsIgnoreCase("match_parent")) {
            if (ConstraintUtilities.isWidgetInsideConstraintLayout(widget)) {
                if (widget.getAnchor(ConstraintAnchor.Type.LEFT).isConnected() && widget.getAnchor(ConstraintAnchor.Type.RIGHT).isConnected()) {
                    widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                } else {
                    widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    widget.setWidth(6);
                    int height = widget.getHeight();
                    ConstraintWidget.DimensionBehaviour verticalBehaviour = widget.getVerticalDimensionBehaviour();
                    if (height <= 1 && widget instanceof WidgetContainer) {
                        widget.setHeight(6);
                    }
                    ArrayList<ConstraintWidget> widgets = new ArrayList<ConstraintWidget>();
                    widgets.add(widget);
                    Scout.arrangeWidgets((Scout.Arrange)Scout.Arrange.ExpandHorizontally, widgets, (boolean)true);
                    widget.setHeight(height);
                    widget.setVerticalDimensionBehaviour(verticalBehaviour);
                    overrideDimension = true;
                }
            }
        } else {
            widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
        }
        String layout_height = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_height");
        if (component.h == 0 || ConstraintUtilities.getLayoutDimensionDpValue(component, layout_height) == 0) {
            widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
        } else if (layout_height != null && layout_height.equalsIgnoreCase("wrap_content")) {
            widget.setWrapHeight(widget.getHeight());
            widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
        } else if (layout_height != null && layout_height.equalsIgnoreCase("match_parent")) {
            if (ConstraintUtilities.isWidgetInsideConstraintLayout(widget)) {
                if (widget.getAnchor(ConstraintAnchor.Type.TOP).isConnected() && widget.getAnchor(ConstraintAnchor.Type.BOTTOM).isConnected()) {
                    widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                } else {
                    widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    widget.setHeight(6);
                    int width = widget.getWidth();
                    ConstraintWidget.DimensionBehaviour horizontalBehaviour = widget.getHorizontalDimensionBehaviour();
                    if (width <= 1 && widget instanceof WidgetContainer) {
                        widget.setWidth(6);
                    }
                    ArrayList<ConstraintWidget> widgets = new ArrayList<ConstraintWidget>();
                    widgets.add(widget);
                    Scout.arrangeWidgets((Scout.Arrange)Scout.Arrange.ExpandVertically, widgets, (boolean)true);
                    widget.setWidth(width);
                    widget.setHorizontalDimensionBehaviour(horizontalBehaviour);
                    overrideDimension = true;
                }
            }
        } else {
            widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
        }
        widget.setBaselineDistance(constraintModel.pxToDp(component.getBaseline()));
        widget.resetAnchors();
        String left1 = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toLeftOf");
        String left2 = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toRightOf");
        String right1 = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toLeftOf");
        String right2 = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf");
        String top1 = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toTopOf");
        String top2 = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toBottomOf");
        String bottom1 = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toTopOf");
        String bottom2 = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf");
        String baseline = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf");
        String ratio = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintDimensionRatio");
        WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
        companion.getWidgetProperties().clear();
        companion.getWidgetProperties().setDimensionRatio(ratio);
        ConstraintUtilities.setMarginType(ConstraintAnchor.Type.LEFT, component, widget);
        ConstraintUtilities.setMarginType(ConstraintAnchor.Type.RIGHT, component, widget);
        ConstraintUtilities.setMarginType(ConstraintAnchor.Type.TOP, component, widget);
        ConstraintUtilities.setMarginType(ConstraintAnchor.Type.BOTTOM, component, widget);
        ConstraintUtilities.setTarget(model, widgetsScene, left1, widget, ConstraintAnchor.Type.LEFT, ConstraintAnchor.Type.LEFT);
        ConstraintUtilities.setStartMargin(left1, component, widget);
        ConstraintUtilities.setTarget(model, widgetsScene, left2, widget, ConstraintAnchor.Type.LEFT, ConstraintAnchor.Type.RIGHT);
        ConstraintUtilities.setStartMargin(left2, component, widget);
        ConstraintUtilities.setTarget(model, widgetsScene, right1, widget, ConstraintAnchor.Type.RIGHT, ConstraintAnchor.Type.LEFT);
        ConstraintUtilities.setEndMargin(right1, component, widget);
        ConstraintUtilities.setTarget(model, widgetsScene, right2, widget, ConstraintAnchor.Type.RIGHT, ConstraintAnchor.Type.RIGHT);
        ConstraintUtilities.setEndMargin(right2, component, widget);
        ConstraintUtilities.setTarget(model, widgetsScene, top1, widget, ConstraintAnchor.Type.TOP, ConstraintAnchor.Type.TOP);
        ConstraintUtilities.setTopMargin(top1, component, widget);
        ConstraintUtilities.setTarget(model, widgetsScene, top2, widget, ConstraintAnchor.Type.TOP, ConstraintAnchor.Type.BOTTOM);
        ConstraintUtilities.setTopMargin(top2, component, widget);
        ConstraintUtilities.setTarget(model, widgetsScene, bottom1, widget, ConstraintAnchor.Type.BOTTOM, ConstraintAnchor.Type.TOP);
        ConstraintUtilities.setBottomMargin(bottom1, component, widget);
        ConstraintUtilities.setTarget(model, widgetsScene, bottom2, widget, ConstraintAnchor.Type.BOTTOM, ConstraintAnchor.Type.BOTTOM);
        ConstraintUtilities.setBottomMargin(bottom2, component, widget);
        ConstraintUtilities.setTarget(model, widgetsScene, baseline, widget, ConstraintAnchor.Type.BASELINE, ConstraintAnchor.Type.BASELINE);
        ConstraintUtilities.setBias("layout_constraintHorizontal_bias", component, widget);
        ConstraintUtilities.setBias("layout_constraintVertical_bias", component, widget);
        ConstraintUtilities.setDimensionRatio("layout_constraintDimensionRatio", component, widget);
        ConstraintUtilities.setChainStyle("layout_constraintHorizontal_chainStyle", component, widget);
        ConstraintUtilities.setChainStyle("layout_constraintVertical_chainStyle", component, widget);
        ConstraintUtilities.setChainWeight("layout_constraintHorizontal_weight", component, widget);
        ConstraintUtilities.setChainWeight("layout_constraintVertical_weight", component, widget);
        if (widget instanceof Guideline) {
            Guideline guideline = (Guideline)widget;
            ConstraintUtilities.setGuideline(component, guideline);
        }
        if ((decorator = companion.getWidgetDecorator(0)) != null && decorator instanceof TextWidget) {
            String alignment;
            String textSize;
            TextWidget textWidget = (TextWidget)decorator;
            textWidget.setText(ConstraintUtilities.getResolvedText(component));
            Configuration configuration = component.getModel().getConfiguration();
            ResourceResolver resourceResolver = configuration.getResourceResolver();
            Integer size = null;
            if (resourceResolver != null && (textSize = component.getAttribute("http://schemas.android.com/apk/res/android", "textSize")) != null) {
                size = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, textSize, configuration);
            }
            if (size == null) {
                size = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, "15sp", configuration);
            }
            textWidget.setTextAlignment((alignment = component.getAttribute("http://schemas.android.com/apk/res/android", "textAlignment")) == null ? 5 : alignmentMap.get(alignment));
            String single = component.getAttribute("http://schemas.android.com/apk/res/android", "singleLine");
            textWidget.setSingleLine(Boolean.parseBoolean(single));
            textWidget.setTextSize((float)constraintModel.pxToDp(size));
        }
        return overrideDimension;
    }

    private static void setMarginType(ConstraintAnchor.Type type, NlComponent component, ConstraintWidget widget) {
        String margin = null;
        String marginRtl = null;
        switch (type) {
            case LEFT: {
                margin = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
                marginRtl = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart");
                break;
            }
            case RIGHT: {
                margin = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
                marginRtl = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd");
                break;
            }
            case TOP: {
                margin = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop");
                break;
            }
            case BOTTOM: {
                margin = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom");
            }
        }
        if (margin == null && marginRtl == null) {
            return;
        }
        ConstraintAnchor anchor = widget.getAnchor(type);
        WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
        if (margin != null) {
            companion.getWidgetProperties().setMarginReference(anchor, margin);
        }
        if (marginRtl != null) {
            companion.getWidgetProperties().setMarginRtlReference(anchor, marginRtl);
        }
    }

    private static void setGuideline(NlComponent component, Guideline guideline) {
        String relativeBegin = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String relativeEnd = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        boolean useFloat = ConstraintUtilities.useGuidelineFloat(component.getModel());
        String percentAttribute = useFloat ? "layout_constraintGuide_percent" : "layout_constraintGuide_Percent";
        String relativePercent = component.getAttribute("http://schemas.android.com/apk/res-auto", percentAttribute);
        String oldRelativePercent = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_Percent");
        WidgetCompanion companion = (WidgetCompanion)guideline.getCompanionWidget();
        if (useFloat && oldRelativePercent != null) {
            companion.getWidgetProperties().setGuidelineAttribute(relativePercent);
            float value = 0.0f;
            try {
                value = (float)Integer.parseInt(oldRelativePercent) / 100.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            guideline.setGuidePercent(value);
        } else if (relativePercent != null && relativePercent.length() > 0) {
            companion.getWidgetProperties().setGuidelineAttribute(relativePercent);
            float value = 0.0f;
            try {
                value = useFloat ? Float.parseFloat(relativePercent) : (float)Integer.parseInt(relativePercent) / 100.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            guideline.setGuidePercent(value);
        } else if (relativeBegin != null && relativeBegin.length() > 0) {
            companion.getWidgetProperties().setGuidelineAttribute(relativeBegin);
            try {
                int value = ConstraintUtilities.getDpValue(component, relativeBegin);
                guideline.setGuideBegin(value);
            }
            catch (NumberFormatException value) {}
        } else if (relativeEnd != null && relativeEnd.length() > 0) {
            companion.getWidgetProperties().setGuidelineAttribute(relativeEnd);
            try {
                int value = ConstraintUtilities.getDpValue(component, relativeEnd);
                guideline.setGuideEnd(value);
            }
            catch (NumberFormatException value) {
                // empty catch block
            }
        }
        String orientation = component.getAttribute("http://schemas.android.com/apk/res/android", "orientation");
        if (orientation != null) {
            int newOrientation = 0;
            if ("vertical".equalsIgnoreCase(orientation)) {
                newOrientation = 1;
            }
            if (newOrientation != guideline.getOrientation()) {
                guideline.setOrientation(newOrientation);
                WidgetInteractionTargets interactionTargets = companion.getWidgetInteractionTargets();
                interactionTargets.resetConstraintHandles();
            }
        }
    }

    @NotNull
    static String resolveStringResource(@NotNull NlComponent component, @NotNull String text) {
        Configuration configuration;
        ResourceResolver resourceResolver;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(58);
        }
        if (text == null) {
            ConstraintUtilities.$$$reportNull$$$0(59);
        }
        if ((resourceResolver = (configuration = component.getModel().getConfiguration()).getResourceResolver()) != null) {
            String string = ResourceHelper.resolveStringValue((RenderResources)resourceResolver, text);
            if (string == null) {
                ConstraintUtilities.$$$reportNull$$$0(60);
            }
            return string;
        }
        if ("" == null) {
            ConstraintUtilities.$$$reportNull$$$0(61);
        }
        return "";
    }

    @NotNull
    public static String getResolvedText(@NotNull NlComponent component) {
        String text;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(62);
        }
        if ((text = component.getAttribute("http://schemas.android.com/apk/res/android", "text")) != null) {
            if (text.startsWith("@")) {
                String string = ConstraintUtilities.resolveStringResource(component, text);
                if (string == null) {
                    ConstraintUtilities.$$$reportNull$$$0(63);
                }
                return string;
            }
            String string = text;
            if (string == null) {
                ConstraintUtilities.$$$reportNull$$$0(64);
            }
            return string;
        }
        if ("" == null) {
            ConstraintUtilities.$$$reportNull$$$0(65);
        }
        return "";
    }

    private static void saveXmlWidgets(@NotNull ConstraintModel model, boolean commit) {
        if (model == null) {
            ConstraintUtilities.$$$reportNull$$$0(66);
        }
        Collection widgets = model.getScene().getWidgets();
        for (ConstraintWidget widget : widgets) {
            NlComponent component = ConstraintUtilities.getValidComponent(model, widget);
            if (component == null) continue;
            AttributesTransaction transaction = component.startAttributeTransaction();
            ConstraintUtilities.updateComponentFromWidget(model, widget, transaction);
            if (commit) {
                assert (ApplicationManager.getApplication().isWriteAccessAllowed());
                transaction.commit();
                continue;
            }
            transaction.apply();
        }
    }

    static void saveModelToXML(@NotNull NlModel nlModel, final boolean commit) {
        if (nlModel == null) {
            ConstraintUtilities.$$$reportNull$$$0(67);
        }
        final ConstraintModel model = ConstraintModel.getConstraintModel(nlModel);
        if (commit) {
            Project project = nlModel.getProject();
            XmlFile file = nlModel.getFile();
            String label = "Constraint";
            WriteCommandAction action = new WriteCommandAction(project, label, new PsiFile[]{file}){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ConstraintUtilities.saveXmlWidgets(model, commit);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities$1", "run"));
                }
            };
            action.execute();
        } else {
            ConstraintUtilities.saveXmlWidgets(model, commit);
        }
    }

    public static void rollbackXMLChanges(@NotNull NlModel nlModel) {
        if (nlModel == null) {
            ConstraintUtilities.$$$reportNull$$$0(68);
        }
        nlModel.getComponents().forEach(component -> component.startAttributeTransaction().rollback());
    }

    @Nullable
    static NlComponent getValidComponent(@NotNull ConstraintModel model, @NotNull ConstraintWidget widget) {
        if (model == null) {
            ConstraintUtilities.$$$reportNull$$$0(69);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(70);
        }
        WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
        NlComponent component = (NlComponent)companion.getWidgetModel();
        boolean isDroppedWidget = model.getDragDropWidget() == widget;
        boolean isInsideConstraintLayout = ConstraintUtilities.isWidgetInsideConstraintLayout(widget);
        if (!isDroppedWidget && (widget.isRoot() || widget.isRootContainer() || !isInsideConstraintLayout)) {
            return null;
        }
        return component;
    }

    @Nullable
    static NlAttributesHolder updateComponentFromWidget(@NotNull ConstraintModel model, @NotNull ConstraintWidget widget, @NotNull NlAttributesHolder transaction) {
        if (model == null) {
            ConstraintUtilities.$$$reportNull$$$0(71);
        }
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(72);
        }
        if (transaction == null) {
            ConstraintUtilities.$$$reportNull$$$0(73);
        }
        WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
        NlComponent component = (NlComponent)companion.getWidgetModel();
        boolean isDroppedWidget = model.getDragDropWidget() == widget;
        boolean isInsideConstraintLayout = ConstraintUtilities.isWidgetInsideConstraintLayout(widget);
        if (!isDroppedWidget && (widget.isRoot() || widget.isRootContainer() || !isInsideConstraintLayout)) {
            return null;
        }
        if (isInsideConstraintLayout || isDroppedWidget) {
            ConstraintUtilities.setEditorPosition(widget, transaction, widget.getX(), widget.getY());
        } else {
            ConstraintUtilities.clearEditorPosition(transaction);
        }
        ConstraintUtilities.setDimension(transaction, widget);
        ConstraintUtilities.setHorizontalChainStyle(transaction, widget);
        ConstraintUtilities.setVerticalChainStyle(transaction, widget);
        for (ConstraintAnchor anchor : widget.getAnchors()) {
            ConstraintUtilities.setConnection(transaction, anchor);
        }
        ConstraintUtilities.setRatio(transaction, widget);
        ConstraintUtilities.setHorizontalBias(transaction, widget);
        ConstraintUtilities.setVerticalBias(transaction, widget);
        if (widget instanceof Guideline) {
            ConstraintUtilities.commitGuideline(component.getModel(), transaction, (Guideline)widget);
        }
        return transaction;
    }

    private static boolean isWidgetInsideConstraintLayout(@NotNull ConstraintWidget widget) {
        ConstraintWidget parent;
        if (widget == null) {
            ConstraintUtilities.$$$reportNull$$$0(74);
        }
        if ((parent = widget.getParent()) == null) {
            return false;
        }
        return parent instanceof ConstraintWidgetContainer;
    }

    static void renderModel(@NotNull ConstraintModel model) {
        if (model == null) {
            ConstraintUtilities.$$$reportNull$$$0(75);
        }
        model.getNlModel().requestRender();
    }

    static AndroidVersion getCompileSdkVersion(@NotNull NlModel model) {
        if (model == null) {
            ConstraintUtilities.$$$reportNull$$$0(76);
        }
        return AndroidModuleInfo.get(model.getFacet()).getBuildSdkVersion();
    }

    static AndroidVersion getMinSdkVersion(@NotNull NlModel model) {
        if (model == null) {
            ConstraintUtilities.$$$reportNull$$$0(77);
        }
        return AndroidModuleInfo.get(model.getFacet()).getMinSdkVersion();
    }

    static AndroidVersion getTargetSdkVersion(@NotNull NlModel model) {
        if (model == null) {
            ConstraintUtilities.$$$reportNull$$$0(78);
        }
        return AndroidModuleInfo.get(model.getFacet()).getTargetSdkVersion();
    }

    static boolean supportsStartEnd(ConstraintAnchor anchor, @NotNull NlModel model) {
        if (model == null) {
            ConstraintUtilities.$$$reportNull$$$0(79);
        }
        if (anchor.getType() != ConstraintAnchor.Type.LEFT && anchor.getType() != ConstraintAnchor.Type.RIGHT) {
            return false;
        }
        AndroidVersion compileSdkVersion = ConstraintUtilities.getCompileSdkVersion(model);
        return compileSdkVersion == null || compileSdkVersion.isGreaterOrEqualThan(17) && ConstraintUtilities.getTargetSdkVersion(model).isGreaterOrEqualThan(17);
    }

    static boolean requiresRightLeft(@NotNull NlModel model) {
        if (model == null) {
            ConstraintUtilities.$$$reportNull$$$0(80);
        }
        return ConstraintUtilities.getMinSdkVersion(model).getApiLevel() < 17;
    }

    static {
        alignmentMap.put("center", 4);
        alignmentMap.put("textStart", 5);
        alignmentMap.put("textEnd", 6);
        alignmentMap.put("viewStart", 5);
        alignmentMap.put("viewEnd", 6);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorType";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 55: 
            case 70: 
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities";
                break;
            }
            case 21: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 53: 
            case 58: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guideline";
                break;
            }
            case 25: 
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 49: 
            case 66: 
            case 69: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widgetsScene";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintA";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintB";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintModel";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nlModel";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRtlMarginAttribute";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveStringResource";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetAnchor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setEditorPosition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "clearEditorPosition";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasHorizontalConstraints";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasVerticalConstraints";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setConnection";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setDimension";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setHorizontalChainStyle";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setVerticalChainStyle";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setRatio";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setHorizontalBias";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setVerticalBias";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "commitGuideline";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setBias";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setDimensionRatio";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setChainStyle";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setChainWeight";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setStartMargin";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setEndMargin";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setTopMargin";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setBottomMargin";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getMargin";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getDpValue";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutDimensionDpValue";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setTarget";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getComponentFromId";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "setMargin";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "updateWidgetFromComponent";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "resolveStringResource";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedText";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "saveXmlWidgets";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "saveModelToXML";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "rollbackXMLChanges";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getValidComponent";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "updateComponentFromWidget";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isWidgetInsideConstraintLayout";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "renderModel";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getCompileSdkVersion";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getMinSdkVersion";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getTargetSdkVersion";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "supportsStartEnd";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "requiresRightLeft";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

