/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.Guideline;
import android.support.constraint.solver.widgets.WidgetContainer;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.DrawConstraintModel;
import com.android.tools.idea.uibuilder.model.Insets;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionListener;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.scene.Scene;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.drawing.decorator.ButtonWidget;
import com.android.tools.sherpa.drawing.decorator.CheckboxWidget;
import com.android.tools.sherpa.drawing.decorator.ImageViewWidget;
import com.android.tools.sherpa.drawing.decorator.RadiobuttonWidget;
import com.android.tools.sherpa.drawing.decorator.SwitchWidget;
import com.android.tools.sherpa.drawing.decorator.TextWidget;
import com.android.tools.sherpa.drawing.decorator.WebViewWidget;
import com.android.tools.sherpa.drawing.decorator.WidgetDecorator;
import com.android.tools.sherpa.interaction.SnapCandidate;
import com.android.tools.sherpa.interaction.WidgetInteractionTargets;
import com.android.tools.sherpa.structure.Selection;
import com.android.tools.sherpa.structure.WidgetCompanion;
import com.android.tools.sherpa.structure.WidgetsScene;
import com.google.common.collect.Maps;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Timer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintModel
implements ModelListener,
SelectionListener,
Selection.SelectionListener,
WidgetDecorator.StateModel {
    public static final int DEFAULT_DENSITY = 160;
    private static final boolean DEBUG = false;
    private static final boolean USE_GUIDELINES_DURING_DND = true;
    private WidgetsScene myWidgetsScene = new WidgetsScene();
    private Selection mySelection = new Selection(null);
    private static boolean ourAutoConnect = PropertiesComponent.getInstance().getBoolean("ConstraintLayoutPreferenceAutoConnect", false);
    private float myDpiFactor;
    private int myNeedsAnimateConstraints = -1;
    private final NlModel myNlModel;
    private ConstraintWidget myDragDropWidget;
    private ArrayList<DrawConstraintModel> myDrawConstraintModels = new ArrayList();
    private static Lock ourLock = new ReentrantLock();
    private long myModificationCount = -1L;
    private static final Map<ScreenView, DrawConstraintModel> ourDrawModelCache = ContainerUtil.createWeakMap();
    private static final Map<NlModel, ConstraintModel> ourModelCache = ContainerUtil.createWeakMap();
    private SaveXMLTimer mySaveXmlTimer = new SaveXMLTimer();

    public static void setAutoConnect(boolean autoConnect) {
        if (autoConnect != ourAutoConnect) {
            ourAutoConnect = autoConnect;
            PropertiesComponent.getInstance().setValue("ConstraintLayoutPreferenceAutoConnect", autoConnect, false);
        }
    }

    public static boolean isAutoConnect() {
        return ourAutoConnect;
    }

    public int pxToDp(int px) {
        return (int)(0.5f + (float)px / this.myDpiFactor);
    }

    public int dpToPx(int dp) {
        return (int)(0.5f + (float)dp * this.myDpiFactor);
    }

    public void setDpiValue(int dpiValue) {
        this.myDpiFactor = (float)dpiValue / 160.0f;
    }

    public static DrawConstraintModel getDrawConstraintModel(ScreenView screenView) {
        ConstraintModel constraintModel = ConstraintModel.getConstraintModel(screenView.getModel());
        ourLock.lock();
        DrawConstraintModel drawConstraintModel = ourDrawModelCache.get(screenView);
        if (drawConstraintModel == null && constraintModel != null) {
            drawConstraintModel = new DrawConstraintModel(screenView, constraintModel);
            ourDrawModelCache.put(screenView, drawConstraintModel);
            constraintModel.myDrawConstraintModels.add(drawConstraintModel);
        }
        if (drawConstraintModel != null) {
            int dpi = screenView.getConfiguration().getDensity().getDpiValue();
            drawConstraintModel.getConstraintModel().setDpiValue(dpi);
            float dpiFactor = (float)dpi / 160.0f;
            ViewTransform transform = drawConstraintModel.getViewTransform();
            transform.setScale((float)(screenView.getScale() * (double)dpiFactor));
            int swingX = screenView.getX();
            int swingY = screenView.getY();
            transform.setTranslate((float)swingX, (float)swingY);
        }
        ourLock.unlock();
        return drawConstraintModel;
    }

    public static ConstraintModel getConstraintModel(NlModel model) {
        ourLock.lock();
        ConstraintModel constraintModel = ourModelCache.get(model);
        if (constraintModel == null) {
            constraintModel = new ConstraintModel(model);
            model.addListener(constraintModel);
            ourModelCache.put(model, constraintModel);
            constraintModel.modelChanged(model);
        }
        ourLock.unlock();
        return constraintModel;
    }

    public static void clearCache() {
        ourLock.lock();
        ourModelCache.clear();
        ourLock.unlock();
    }

    @Override
    public void modelChanged(@NotNull NlModel model) {
        if (model == null) {
            ConstraintModel.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (model == null) {
                ConstraintModel.$$$reportNull$$$0(15);
            }
            ourLock.lock();
            int dpi = model.getConfiguration().getDensity().getDpiValue();
            this.setDpiValue(dpi);
            this.updateNlModel(null, model.getComponents(), true);
            this.myModificationCount = model.getResourceVersion();
            ourLock.unlock();
        }, model.getModule().getDisposed());
    }

    @Override
    public void modelRendered(@NotNull NlModel model) {
        if (model == null) {
            ConstraintModel.$$$reportNull$$$0(1);
        }
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
        if (model == null) {
            ConstraintModel.$$$reportNull$$$0(2);
        }
    }

    public void updateMemoryXML() {
        ConstraintUtilities.saveModelToXML(this.myNlModel, false);
    }

    public void rollbackXml() {
        ConstraintUtilities.rollbackXMLChanges(this.myNlModel);
    }

    public ArrayList<DrawConstraintModel> getDrawConstraintModels() {
        return this.myDrawConstraintModels;
    }

    public void setDragDropWidget(ConstraintWidget droppedWidget) {
        this.myDragDropWidget = droppedWidget;
    }

    public ConstraintWidget getDragDropWidget() {
        return this.myDragDropWidget;
    }

    public void removeDragComponent() {
        if (this.myDragDropWidget != null) {
            this.myWidgetsScene.removeWidget(this.myDragDropWidget);
            this.myDragDropWidget = null;
        }
    }

    public void commitDragComponent(NlComponent component) {
        if (this.myDragDropWidget != null) {
            this.myWidgetsScene.removeWidget(this.myDragDropWidget);
            WidgetCompanion companion = (WidgetCompanion)this.myDragDropWidget.getCompanionWidget();
            companion.setWidgetModel((Object)component);
            companion.setWidgetTag((Object)component);
        }
    }

    private void connectDroppedWidget() {
        if (!ourAutoConnect) {
            ArrayList<DrawConstraintModel> drawConstraintModels = this.getDrawConstraintModels();
            if (drawConstraintModels.size() < 1) {
                return;
            }
            for (DrawConstraintModel drawConstraintModel : drawConstraintModels) {
                drawConstraintModel.getMouseInteraction().clearIndicators();
            }
            return;
        }
        ArrayList<DrawConstraintModel> drawConstraintModels = this.getDrawConstraintModels();
        if (drawConstraintModels.size() < 1) {
            return;
        }
        for (DrawConstraintModel drawConstraintModel : drawConstraintModels) {
            for (SnapCandidate candidate : drawConstraintModel.getMouseInteraction().getSnapCandidates()) {
                int margin = candidate.margin;
                if (candidate.padding != 0) {
                    margin = candidate.padding;
                }
                margin = Math.abs(margin);
                ConstraintWidget widget = candidate.source.getOwner();
                widget.connect(candidate.source, candidate.target, margin, 2);
            }
            drawConstraintModel.getMouseInteraction().clearIndicators();
        }
        this.saveToXML(true);
    }

    public void dragComponent(int x, int y) {
        if (this.myDragDropWidget == null) {
            return;
        }
        int ax = this.pxToDp(x);
        int ay = this.pxToDp(y);
        this.myDragDropWidget.setX(ax);
        this.myDragDropWidget.setY(ay);
        this.myDragDropWidget.forceUpdateDrawPosition();
        for (DrawConstraintModel drawConstraintModel : this.getDrawConstraintModels()) {
            drawConstraintModel.getMouseInteraction().dragAndDrop(this.myDragDropWidget, ax, ay);
        }
    }

    @Override
    public void selectionChanged(@NotNull SelectionModel model, @NotNull List<NlComponent> selection) {
        boolean different;
        if (model == null) {
            ConstraintModel.$$$reportNull$$$0(3);
        }
        if (selection == null) {
            ConstraintModel.$$$reportNull$$$0(4);
        }
        if (selection.isEmpty()) {
            return;
        }
        boolean bl = different = selection.size() != this.mySelection.size();
        if (!different) {
            for (NlComponent component : model.getSelection()) {
                if (this.mySelection.contains(this.myWidgetsScene.getWidget((Object)component))) continue;
                different = true;
                break;
            }
        }
        if (!different) {
            return;
        }
        this.mySelection.silentClear();
        for (NlComponent component : model.getSelection()) {
            ConstraintWidget widget = this.myWidgetsScene.getWidget((Object)component);
            if (widget == null || widget.isRoot() || widget.isRootContainer()) continue;
            this.mySelection.silentAdd(widget);
        }
    }

    public void onSelectionChanged(Selection selection) {
        SelectionModel selectionModel = this.myNlModel.getSelectionModel();
        if (selection.isEmpty()) {
            selectionModel.clear();
            return;
        }
        ArrayList<NlComponent> components = new ArrayList<NlComponent>();
        for (Selection.Element selectedElement : this.mySelection.getElements()) {
            if (selectedElement.widget == this.myDragDropWidget) continue;
            WidgetCompanion companion = (WidgetCompanion)selectedElement.widget.getCompanionWidget();
            NlComponent component = (NlComponent)companion.getWidgetModel();
            components.add(component);
        }
        if (!components.isEmpty()) {
            selectionModel.setSelection(components);
        } else {
            selectionModel.clear();
        }
    }

    public void save(WidgetDecorator decorator) {
        this.saveToXML(true);
    }

    public void requestSaveToXML() {
        this.updateMemoryXML();
        this.mySaveXmlTimer.reset();
    }

    public void requestRender() {
        ourLock.lock();
        ConstraintUtilities.renderModel(this);
        ourLock.unlock();
    }

    public void requestLayout(boolean animate) {
        this.updateMemoryXML();
        this.getNlModel().requestLayout(animate);
    }

    public ConstraintModel(NlModel model) {
        this.myNlModel = model;
        this.mySelection.setSelectedAnchor(null);
        this.myWidgetsScene.setSelection(this.mySelection);
        model.getSelectionModel().addListener(this);
        this.mySelection.addSelectionListener((Selection.SelectionListener)this);
    }

    @NotNull
    public WidgetsScene getScene() {
        WidgetsScene widgetsScene = this.myWidgetsScene;
        if (widgetsScene == null) {
            ConstraintModel.$$$reportNull$$$0(5);
        }
        return widgetsScene;
    }

    @NotNull
    public Selection getSelection() {
        Selection selection = this.mySelection;
        if (selection == null) {
            ConstraintModel.$$$reportNull$$$0(6);
        }
        return selection;
    }

    public void updateNlModel(@Nullable Scene scene, @NotNull List<NlComponent> components, boolean deepUpdate) {
        ArrayList<ConstraintWidget> widgets;
        if (components == null) {
            ConstraintModel.$$$reportNull$$$0(7);
        }
        if ((widgets = new ArrayList<ConstraintWidget>(this.myWidgetsScene.getWidgets())).size() > 0) {
            for (NlComponent component : components) {
                this.findComponent(component, widgets);
            }
            if (widgets.size() > 0) {
                for (ConstraintWidget widget : widgets) {
                    this.myWidgetsScene.removeWidget(widget);
                }
            }
        }
        boolean saveXML = false;
        for (NlComponent component : components) {
            saveXML |= this.createSolverWidgetFromComponent(component);
        }
        for (NlComponent component : components) {
            saveXML |= this.updateSolverWidgetFromComponent(scene, component, deepUpdate);
        }
        if (this.myDragDropWidget != null && !this.myWidgetsScene.getWidgets().contains(this.myDragDropWidget)) {
            this.myDragDropWidget = null;
        }
        if (!saveXML) {
            this.updateConstraintLayoutRoots(this.myWidgetsScene.getRoot());
        }
        if (saveXML) {
            this.saveToXML(true);
        }
    }

    private void findComponent(@NotNull NlComponent component, @NotNull ArrayList<ConstraintWidget> widgets) {
        ConstraintWidget widget;
        if (component == null) {
            ConstraintModel.$$$reportNull$$$0(8);
        }
        if (widgets == null) {
            ConstraintModel.$$$reportNull$$$0(9);
        }
        if ((widget = this.myWidgetsScene.getWidget((Object)component)) != null) {
            widgets.remove(widget);
        }
        if (component.children != null) {
            for (NlComponent child : component.children) {
                this.findComponent(child, widgets);
            }
        }
    }

    private boolean createSolverWidgetFromComponent(@NotNull NlComponent component) {
        if (component == null) {
            ConstraintModel.$$$reportNull$$$0(10);
        }
        Object widget = this.myWidgetsScene.getWidget((Object)component);
        boolean saveXML = false;
        if (widget != null && ConstraintModel.isConstraintLayout(component) && !(widget instanceof ConstraintWidgetContainer)) {
            if (widget instanceof WidgetContainer) {
                ConstraintWidgetContainer container = new ConstraintWidgetContainer();
                this.myWidgetsScene.transformContainerToContainer((WidgetContainer)widget, container);
                saveXML = this.setupConstraintWidget(component, (ConstraintWidget)container);
                widget = container;
            } else {
                this.myWidgetsScene.removeWidget(widget);
                widget = null;
            }
        }
        if (widget == null) {
            WidgetCompanion companion;
            boolean dropWidget = false;
            if (this.myDragDropWidget != null && (companion = (WidgetCompanion)this.myDragDropWidget.getCompanionWidget()).getWidgetModel() == component) {
                widget = this.myDragDropWidget;
                if (component.isOrHasSuperclass("android.view.ViewGroup") || ConstraintModel.isDataBindingLayout(component)) {
                    widget = new WidgetContainer();
                }
                widget.setCompanionWidget(null);
                dropWidget = true;
            }
            if (widget == null) {
                if (ConstraintModel.isConstraintLayout(component)) {
                    widget = new ConstraintWidgetContainer();
                } else if (component.getTagName().equalsIgnoreCase("android.support.constraint.Guideline")) {
                    widget = new Guideline();
                    String orientation = component.getAttribute("http://schemas.android.com/apk/res/android", "orientation");
                    if (orientation != null && "vertical".equalsIgnoreCase(orientation)) {
                        Guideline guideline = (Guideline)widget;
                        guideline.setOrientation(1);
                    }
                } else {
                    widget = component.isOrHasSuperclass("android.view.ViewGroup") || ConstraintModel.isDataBindingLayout(component) || component.getChildCount() > 0 ? new WidgetContainer() : new ConstraintWidget();
                }
            }
            saveXML |= this.setupConstraintWidget(component, (ConstraintWidget)widget);
            this.myWidgetsScene.setWidget(widget);
            if (dropWidget) {
                this.connectDroppedWidget();
                this.myDragDropWidget = null;
                this.mySelection.add(widget);
            }
        }
        for (NlComponent child : component.getChildren()) {
            saveXML |= this.createSolverWidgetFromComponent(child);
        }
        return saveXML;
    }

    private static boolean isConstraintLayout(@NotNull NlComponent component) {
        if (component == null) {
            ConstraintModel.$$$reportNull$$$0(11);
        }
        return component.isOrHasSuperclass("android.support.constraint.ConstraintLayout") || component.getTag().getName().equals("android.support.constraint.ConstraintLayout");
    }

    private static boolean isDataBindingLayout(@NotNull NlComponent component) {
        if (component == null) {
            ConstraintModel.$$$reportNull$$$0(12);
        }
        return component.getTagName().equals("layout");
    }

    private boolean setupConstraintWidget(@NotNull NlComponent component, ConstraintWidget widget) {
        if (component == null) {
            ConstraintModel.$$$reportNull$$$0(13);
        }
        WidgetDecorator blueprintDecorator = ConstraintModel.createDecorator(component, widget);
        WidgetDecorator androidDecorator = ConstraintModel.createDecorator(component, widget);
        blueprintDecorator.setStateModel((WidgetDecorator.StateModel)this);
        androidDecorator.setStateModel((WidgetDecorator.StateModel)this);
        blueprintDecorator.setStyle(0);
        androidDecorator.setStyle(1);
        WidgetCompanion companion = new WidgetCompanion();
        companion.addDecorator(blueprintDecorator);
        companion.addDecorator(androidDecorator);
        companion.setWidgetInteractionTargets(new WidgetInteractionTargets(widget));
        companion.setWidgetModel((Object)component);
        companion.setWidgetTag((Object)component);
        widget.setCompanionWidget((Object)companion);
        widget.setDebugName(component.getId());
        return ConstraintUtilities.updateWidgetFromComponent(null, this, widget, component);
    }

    private static WidgetDecorator createDecorator(NlComponent component, ConstraintWidget widget) {
        TextWidget decorator = null;
        if (component.getTagName().equalsIgnoreCase("TextView")) {
            decorator = new TextWidget(widget, ConstraintUtilities.getResolvedText(component));
        } else if (component.getTagName().equalsIgnoreCase("Button")) {
            decorator = new ButtonWidget(widget, ConstraintUtilities.getResolvedText(component));
        } else if (component.getTagName().equalsIgnoreCase("RadioButton")) {
            decorator = new RadiobuttonWidget(widget, ConstraintUtilities.getResolvedText(component));
        } else if (component.getTagName().equalsIgnoreCase("CheckBox")) {
            decorator = new CheckboxWidget(widget, ConstraintUtilities.getResolvedText(component));
        } else if (component.getTagName().equalsIgnoreCase("Switch")) {
            decorator = new SwitchWidget(widget, ConstraintUtilities.getResolvedText(component));
        } else if (component.getTagName().equalsIgnoreCase("ImageView")) {
            decorator = new ImageViewWidget(widget);
        } else if (component.getTagName().equalsIgnoreCase("WebView")) {
            decorator = new WebViewWidget(widget);
        } else if (component.getTagName().equalsIgnoreCase("EditText")) {
            decorator = new TextWidget(widget, ConstraintUtilities.getResolvedText(component));
        }
        if (decorator == null) {
            decorator = new WidgetDecorator(widget);
        }
        return decorator;
    }

    private boolean updateSolverWidgetFromComponent(@Nullable Scene scene, @NotNull NlComponent component, boolean deepUpdate) {
        WidgetCompanion companion;
        if (component == null) {
            ConstraintModel.$$$reportNull$$$0(14);
        }
        ConstraintWidget widget = this.myWidgetsScene.getWidget((Object)component);
        if (this.myDragDropWidget != null && (companion = (WidgetCompanion)this.myDragDropWidget.getCompanionWidget()).getWidgetModel() == component) {
            this.saveToXML(true);
            this.myDragDropWidget = null;
            return false;
        }
        boolean saveXML = ConstraintUtilities.updateWidgetFromComponent(scene, this, widget, component);
        for (NlComponent child : component.getChildren()) {
            saveXML |= this.updateSolverWidgetFromComponent(scene, child, deepUpdate);
        }
        return saveXML;
    }

    private void updateConstraintLayoutRoots(WidgetContainer container) {
        NlComponent root;
        XmlTag parentTag;
        NlComponent component;
        if (container == null) {
            return;
        }
        HashMap wrapContentSizes = Maps.newHashMap();
        if (container instanceof ConstraintWidgetContainer) {
            component = (NlComponent)((WidgetCompanion)container.getCompanionWidget()).getWidgetModel();
            Insets padding = component.getPadding(true);
            container.setDimension(this.pxToDp(component.w - padding.width()), this.pxToDp(component.h - padding.height()));
            int x = this.pxToDp(component.x);
            int y = this.pxToDp(component.y);
            x += this.pxToDp(padding.left);
            y += this.pxToDp(padding.top);
            WidgetContainer parentContainer = (WidgetContainer)container.getParent();
            if (parentContainer != null) {
                if (!(parentContainer instanceof ConstraintWidgetContainer)) {
                    x = this.pxToDp(component.x - component.getParent().x);
                    y = this.pxToDp(component.y - component.getParent().y);
                } else {
                    x -= parentContainer.getDrawX();
                    y -= parentContainer.getDrawY();
                }
            }
            if (container.getX() != x || container.getY() != y) {
                container.setOrigin(x, y);
                container.forceUpdateDrawPosition();
            }
        }
        if (!(container instanceof ConstraintWidgetContainer)) {
            component = (NlComponent)((WidgetCompanion)container.getCompanionWidget()).getWidgetModel();
            container.setDimension(this.pxToDp(component.w), this.pxToDp(component.h));
        }
        if (container instanceof ConstraintWidgetContainer && container.getChildren().size() > 0 && (parentTag = (root = (NlComponent)((WidgetCompanion)container.getCompanionWidget()).getWidgetModel()).getTag()).isValid()) {
            HashMap tagToComponent = Maps.newHashMapWithExpectedSize((int)root.getChildCount());
            for (NlComponent child : root.getChildren()) {
                tagToComponent.put(child.getTag(), child);
            }
            XmlFile xmlFile = this.myNlModel.getFile();
            AndroidFacet facet = this.myNlModel.getFacet();
            RenderService renderService = RenderService.get(facet);
            RenderLogger logger = renderService.createLogger();
            RenderTask task = renderService.createTask((PsiFile)xmlFile, this.myNlModel.getConfiguration(), logger, null);
            if (task != null) {
                Map<XmlTag, ViewInfo> map = task.measureChildren(parentTag, new RenderTask.AttributeFilter(){

                    @Override
                    public String getAttribute(@NotNull XmlTag n, @Nullable String namespace, @NotNull String localName) {
                        if (n == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (localName == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if ("layout_width".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                            return "wrap_content";
                        }
                        if ("layout_height".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                            return "wrap_content";
                        }
                        return null;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "n";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "localName";
                                break;
                            }
                        }
                        objectArray[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintModel$1";
                        objectArray[2] = "getAttribute";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                task.dispose();
                if (map != null) {
                    for (Map.Entry<XmlTag, ViewInfo> entry : map.entrySet()) {
                        ViewInfo viewInfo = entry.getValue();
                        viewInfo = RenderService.getSafeBounds(viewInfo);
                        Dimension size = new Dimension(viewInfo.getRight() - viewInfo.getLeft(), viewInfo.getBottom() - viewInfo.getTop());
                        NlComponent child = (NlComponent)tagToComponent.get(entry.getKey());
                        if (child == null) continue;
                        wrapContentSizes.put(child, size);
                    }
                }
            }
        }
        for (ConstraintWidget child : container.getChildren()) {
            NlComponent component2 = (NlComponent)((WidgetCompanion)child.getCompanionWidget()).getWidgetModel();
            Dimension dimension = (Dimension)wrapContentSizes.get(component2);
            if (dimension != null) {
                child.setWrapWidth(this.pxToDp((int)dimension.getWidth()));
                child.setWrapHeight(this.pxToDp((int)dimension.getHeight()));
            }
            if (!(child instanceof WidgetContainer)) continue;
            this.updateConstraintLayoutRoots((WidgetContainer)child);
        }
    }

    public void saveToXML(boolean forceSave) {
        Selection selection = this.getSelection();
        if (forceSave || !selection.getModifiedWidgets().isEmpty()) {
            ourLock.lock();
            ++this.myModificationCount;
            ourLock.unlock();
            ConstraintUtilities.saveModelToXML(this.myNlModel, true);
            selection.clearModifiedWidgets();
            this.requestRender();
        }
    }

    public void setNeedsAnimateConstraints(int type) {
        this.myNeedsAnimateConstraints = type;
    }

    public int getNeedsAnimateConstraints() {
        return this.myNeedsAnimateConstraints;
    }

    public NlModel getNlModel() {
        return this.myNlModel;
    }

    private /* synthetic */ void lambda$modelChanged$0(@NotNull NlModel model) {
        if (model == null) {
            ConstraintModel.$$$reportNull$$$0(16);
        }
        ourLock.lock();
        int dpi = model.getConfiguration().getDensity().getDpiValue();
        this.setDpiValue(dpi);
        this.updateNlModel(null, model.getComponents(), true);
        this.myModificationCount = model.getResourceVersion();
        for (DrawConstraintModel drawConstraintModel : this.getDrawConstraintModels()) {
            drawConstraintModel.repaint();
        }
        ourLock.unlock();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widgets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getScene";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modelChanged";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "modelRendered";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "modelChangedOnLayout";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateNlModel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findComponent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createSolverWidgetFromComponent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isConstraintLayout";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDataBindingLayout";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setupConstraintWidget";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateSolverWidgetFromComponent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$modelChanged$1";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$modelChanged$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class SaveXMLTimer
    implements ActionListener {
        Timer myTimer = new Timer(800, this);

        public SaveXMLTimer() {
            this.myTimer.setRepeats(false);
        }

        public void delay() {
            if (this.myTimer.isRunning()) {
                this.reset();
            }
        }

        public void reset() {
            this.myTimer.restart();
        }

        public void cancel() {
            this.myTimer.stop();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConstraintModel.this.saveToXML(true);
        }
    }
}

