/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import android.support.constraint.solver.widgets.ConstraintWidget;
import com.android.tools.idea.uibuilder.analytics.NlUsageTracker;
import com.android.tools.idea.uibuilder.analytics.NlUsageTrackerManager;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.DirectViewAction;
import com.android.tools.idea.uibuilder.api.actions.NestedViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.api.actions.ViewActionSeparator;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintModel;
import com.android.tools.idea.uibuilder.handlers.constraint.DrawConstraintModel;
import com.android.tools.idea.uibuilder.handlers.constraint.MarginPopup;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.scene.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.scene.Scene;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.SceneDragHandler;
import com.android.tools.idea.uibuilder.scene.SceneInteraction;
import com.android.tools.idea.uibuilder.scene.draw.ConstraintLayoutComponentNotchProvider;
import com.android.tools.idea.uibuilder.scene.draw.ConstraintLayoutNotchProvider;
import com.android.tools.idea.uibuilder.scene.target.ActionTarget;
import com.android.tools.idea.uibuilder.scene.target.AnchorTarget;
import com.android.tools.idea.uibuilder.scene.target.ChainCycleTarget;
import com.android.tools.idea.uibuilder.scene.target.ClearConstraintsTarget;
import com.android.tools.idea.uibuilder.scene.target.DragTarget;
import com.android.tools.idea.uibuilder.scene.target.GuidelineAnchorTarget;
import com.android.tools.idea.uibuilder.scene.target.GuidelineCycleTarget;
import com.android.tools.idea.uibuilder.scene.target.GuidelineTarget;
import com.android.tools.idea.uibuilder.scene.target.LassoTarget;
import com.android.tools.idea.uibuilder.scene.target.ResizeTarget;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.Interaction;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.sherpa.drawing.WidgetDraw;
import com.android.tools.sherpa.drawing.decorator.WidgetDecorator;
import com.android.tools.sherpa.interaction.MouseInteraction;
import com.android.tools.sherpa.scout.Scout;
import com.android.tools.sherpa.structure.Selection;
import com.android.tools.sherpa.structure.WidgetsScene;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class ConstraintLayoutHandler
extends ViewGroupHandler {
    public static final boolean USE_SOLVER = false;
    public static final boolean USE_SCENE_INTERACTION = true;
    private static final String PREFERENCE_KEY_PREFIX = "ConstraintLayoutPreference";
    public static final String AUTO_CONNECT_PREF_KEY = "ConstraintLayoutPreferenceAutoConnect";
    public static final String SHOW_CONSTRAINTS_PREF_KEY = "ConstraintLayoutPreferenceShowAllConstraints";
    private boolean myShowAllConstraints = true;
    ArrayList<ViewAction> myActions = new ArrayList();
    ArrayList<ViewAction> myPopupActions = new ArrayList();
    ArrayList<ViewAction> myControlActions = new ArrayList();

    static Image iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = UIUtil.createImage((int)w, (int)h, (int)6);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public ConstraintLayoutHandler() {
        ConstraintLayoutHandler.loadWidgetDecoratorImages();
    }

    private static void loadWidgetDecoratorImages() {
        if (WidgetDecorator.sLockImageIcon == null) {
            WidgetDecorator.sLockImageIcon = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.LockConstraints);
        }
        if (WidgetDecorator.sUnlockImageIcon == null) {
            WidgetDecorator.sUnlockImageIcon = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.UnlockConstraints);
        }
        if (WidgetDecorator.sDeleteConnectionsImageIcon == null) {
            WidgetDecorator.sDeleteConnectionsImageIcon = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.DeleteConstraintB);
        }
        if (WidgetDecorator.sPackChainImageIcon == null) {
            WidgetDecorator.sPackChainImageIcon = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.ChainStyle);
        }
        if (WidgetDraw.sGuidelineArrowLeft == null) {
            WidgetDraw.sGuidelineArrowLeft = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.ArrowLeft);
        }
        if (WidgetDraw.sGuidelineArrowRight == null) {
            WidgetDraw.sGuidelineArrowRight = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.ArrowRight);
        }
        if (WidgetDraw.sGuidelineArrowUp == null) {
            WidgetDraw.sGuidelineArrowUp = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.ArrowUp);
        }
        if (WidgetDraw.sGuidelineArrowDown == null) {
            WidgetDraw.sGuidelineArrowDown = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.ArrowDown);
        }
        if (WidgetDraw.sGuidelinePercent == null) {
            WidgetDraw.sGuidelinePercent = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.Percent);
        }
    }

    @Override
    @NotNull
    public String getGradleCoordinateId(@NotNull String tagName) {
        if (tagName == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(0);
        }
        if ("com.android.support.constraint:constraint-layout" == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(1);
        }
        return "com.android.support.constraint:constraint-layout";
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions) {
        if (actions == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(2);
        }
        this.myActions.clear();
        this.myControlActions.clear();
        actions.add(new ToggleConstraintModeAction());
        actions.add(new ToggleAutoConnectAction());
        actions.add(new ViewActionSeparator());
        actions.add(new ClearConstraintsAction());
        actions.add(new InferAction());
        actions.add(new ViewActionSeparator());
        actions.add(new MarginSelector());
        actions.add(new NestedViewActionMenu("Pack", AndroidIcons.SherpaIcons.PackSelectionVerticallyB, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new ViewAction[]{new AlignAction(Scout.Arrange.HorizontalPack, AndroidIcons.SherpaIcons.PackSelectionHorizontally, "Pack Horizontally"), new AlignAction(Scout.Arrange.VerticalPack, AndroidIcons.SherpaIcons.PackSelectionVertically, "Pack Vertically"), new AlignAction(Scout.Arrange.ExpandHorizontally, AndroidIcons.SherpaIcons.HorizontalExpand, "Expand Horizontally"), new AlignAction(Scout.Arrange.ExpandVertically, AndroidIcons.SherpaIcons.VerticalExpand, "Expand Vertically")}), Lists.newArrayList((Object[])new ViewAction[]{new ViewActionSeparator()}), Lists.newArrayList((Object[])new ViewAction[]{new AlignAction(Scout.Arrange.DistributeHorizontally, AndroidIcons.SherpaIcons.HorizontalDistribute, AndroidIcons.SherpaIcons.HorizontalDistributeB, "Distribute Horizontally"), new AlignAction(Scout.Arrange.DistributeVertically, AndroidIcons.SherpaIcons.verticallyDistribute, AndroidIcons.SherpaIcons.verticallyDistribute, "Distribute Vertically")})})));
        actions.add(new NestedViewActionMenu("Align", AndroidIcons.SherpaIcons.LeftAlignedB, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new ViewAction[]{new AlignAction(Scout.Arrange.AlignHorizontallyLeft, AndroidIcons.SherpaIcons.LeftAligned, AndroidIcons.SherpaIcons.LeftAlignedB, "Align Left Edges"), new AlignAction(Scout.Arrange.AlignHorizontallyCenter, AndroidIcons.SherpaIcons.CenterAligned, AndroidIcons.SherpaIcons.CenterAlignedB, "Align Horizontal Centers"), new AlignAction(Scout.Arrange.AlignHorizontallyRight, AndroidIcons.SherpaIcons.RightAligned, AndroidIcons.SherpaIcons.RightAlignedB, "Align Right Edges")}), Lists.newArrayList((Object[])new ViewAction[]{new AlignAction(Scout.Arrange.AlignVerticallyTop, AndroidIcons.SherpaIcons.TopAlign, AndroidIcons.SherpaIcons.TopAlignB, "Align Top Edges"), new AlignAction(Scout.Arrange.AlignVerticallyMiddle, AndroidIcons.SherpaIcons.MiddleAlign, AndroidIcons.SherpaIcons.MiddleAlignB, "Align Vertical Centers"), new AlignAction(Scout.Arrange.AlignVerticallyBottom, AndroidIcons.SherpaIcons.BottomAlign, AndroidIcons.SherpaIcons.BottomAlignB, "Align Bottom Edges"), new AlignAction(Scout.Arrange.AlignBaseline, AndroidIcons.SherpaIcons.BaselineAlign, AndroidIcons.SherpaIcons.BaselineAlignB, "Align Baselines")}), Lists.newArrayList((Object[])new ViewAction[]{new ViewActionSeparator()}), Lists.newArrayList((Object[])new ViewAction[]{new AlignAction(Scout.Arrange.CenterHorizontally, AndroidIcons.SherpaIcons.HorizontalCenter, AndroidIcons.SherpaIcons.HorizontalCenterB, "Center Horizontally"), new AlignAction(Scout.Arrange.CenterVertically, AndroidIcons.SherpaIcons.VerticalCenter, AndroidIcons.SherpaIcons.VerticalCenterB, "Center Vertically"), new AlignAction(Scout.Arrange.CenterHorizontallyInParent, AndroidIcons.SherpaIcons.HorizontalCenterParent, AndroidIcons.SherpaIcons.HorizontalCenterParentB, "Center Horizontally in Parent"), new AlignAction(Scout.Arrange.CenterVerticallyInParent, AndroidIcons.SherpaIcons.VerticalCenterParent, AndroidIcons.SherpaIcons.VerticalCenterParent, "Center Vertically in Parent")})})));
        actions.add(new NestedViewActionMenu("Guidelines", AndroidIcons.SherpaIcons.GuidelineVertical, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new ViewAction[]{new AddElementAction(1, AndroidIcons.SherpaIcons.GuidelineVertical, "Add Vertical Guideline"), new AddElementAction(0, AndroidIcons.SherpaIcons.GuidelineHorizontal, "Add Horizontal Guideline")})})));
    }

    @Override
    public void addPopupMenuActions(@NotNull List<ViewAction> actions) {
        if (actions == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(3);
        }
        actions.add(new ClearConstraintsAction());
        String str = "Pack Horizontally";
        DirectViewAction action = new AlignAction(Scout.Arrange.HorizontalPack, AndroidIcons.SherpaIcons.PackSelectionHorizontally, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Pack Vertically";
        action = new AlignAction(Scout.Arrange.VerticalPack, AndroidIcons.SherpaIcons.PackSelectionVertically, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Expand Horizontally";
        action = new AlignAction(Scout.Arrange.ExpandHorizontally, AndroidIcons.SherpaIcons.HorizontalExpand, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Expand Vertically";
        action = new AlignAction(Scout.Arrange.ExpandVertically, AndroidIcons.SherpaIcons.VerticalExpand, str);
        actions.add(action);
        this.myPopupActions.add(action);
        actions.add(new ViewActionSeparator());
        str = "Align Left Edges";
        action = new AlignAction(Scout.Arrange.AlignHorizontallyLeft, AndroidIcons.SherpaIcons.LeftAligned, AndroidIcons.SherpaIcons.LeftAlignedB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Align Horizontal Centers";
        action = new AlignAction(Scout.Arrange.AlignHorizontallyCenter, AndroidIcons.SherpaIcons.CenterAligned, AndroidIcons.SherpaIcons.CenterAlignedB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Align Right Edges";
        action = new AlignAction(Scout.Arrange.AlignHorizontallyRight, AndroidIcons.SherpaIcons.RightAligned, AndroidIcons.SherpaIcons.RightAlignedB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Align Top Edges";
        action = new AlignAction(Scout.Arrange.AlignVerticallyTop, AndroidIcons.SherpaIcons.TopAlign, AndroidIcons.SherpaIcons.TopAlignB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Align Vertical Centers";
        action = new AlignAction(Scout.Arrange.AlignVerticallyMiddle, AndroidIcons.SherpaIcons.MiddleAlign, AndroidIcons.SherpaIcons.MiddleAlignB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Align Bottom Edges";
        action = new AlignAction(Scout.Arrange.AlignVerticallyBottom, AndroidIcons.SherpaIcons.BottomAlign, AndroidIcons.SherpaIcons.BottomAlignB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Align Baselines";
        action = new AlignAction(Scout.Arrange.AlignBaseline, AndroidIcons.SherpaIcons.BaselineAlign, AndroidIcons.SherpaIcons.BottomAlignB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        actions.add(new ViewActionSeparator());
        str = "Center Horizontally";
        action = new AlignAction(Scout.Arrange.CenterHorizontally, AndroidIcons.SherpaIcons.HorizontalCenter, AndroidIcons.SherpaIcons.HorizontalCenterB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Center Vertically";
        action = new AlignAction(Scout.Arrange.CenterVertically, AndroidIcons.SherpaIcons.VerticalCenter, AndroidIcons.SherpaIcons.VerticalCenterB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Center Horizontally in Parent";
        action = new AlignAction(Scout.Arrange.CenterHorizontallyInParent, AndroidIcons.SherpaIcons.HorizontalCenterParent, AndroidIcons.SherpaIcons.HorizontalCenterParentB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Center Vertically in Parent";
        action = new AlignAction(Scout.Arrange.CenterVerticallyInParent, AndroidIcons.SherpaIcons.VerticalCenterParent, AndroidIcons.SherpaIcons.VerticalCenterParentB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        this.addToolbarActionsToMenu("Constraint Layout", actions);
        str = "Add Vertical Guideline";
        action = new AddElementAction(1, AndroidIcons.SherpaIcons.GuidelineVertical, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Add Horizontal Guideline";
        action = new AddElementAction(0, AndroidIcons.SherpaIcons.GuidelineHorizontal, str);
        actions.add(action);
        this.myPopupActions.add(action);
    }

    public void updateActions(Selection selection) {
        Enableable e;
        if (this.myActions == null) {
            return;
        }
        for (ViewAction action : this.myActions) {
            if (!(action instanceof Enableable)) continue;
            e = (Enableable)((Object)action);
            e.enable(selection);
        }
        for (ViewAction action : this.myPopupActions) {
            if (!(action instanceof Enableable)) continue;
            e = (Enableable)((Object)action);
            e.enable(selection);
        }
    }

    @Override
    public Interaction createInteraction(@NotNull ScreenView screenView, @NotNull NlComponent component) {
        if (screenView == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(4);
        }
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(5);
        }
        return new SceneInteraction(screenView);
    }

    @Override
    public void addTargets(@NotNull SceneComponent component, boolean isParent) {
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(6);
        }
        boolean showAnchors = !isParent;
        NlComponent nlComponent = component.getNlComponent();
        if (nlComponent.viewInfo != null && nlComponent.viewInfo.getClassName().equalsIgnoreCase("android.support.constraint.Guideline")) {
            String orientation = nlComponent.getAttribute("http://schemas.android.com/apk/res/android", "orientation");
            boolean isHorizontal = true;
            if (orientation != null && orientation.equalsIgnoreCase("vertical")) {
                isHorizontal = false;
            }
            component.addTarget(new GuidelineTarget(isHorizontal));
            if (isHorizontal) {
                component.addTarget(new GuidelineAnchorTarget(AnchorTarget.Type.TOP, true));
            } else {
                component.addTarget(new GuidelineAnchorTarget(AnchorTarget.Type.LEFT, false));
            }
            component.addTarget(new GuidelineCycleTarget(isHorizontal));
            return;
        }
        if (!isParent) {
            DragTarget dragTarget = new DragTarget();
            component.addTarget(dragTarget);
            component.addTarget(new ResizeTarget(ResizeTarget.Type.LEFT_TOP));
            component.addTarget(new ResizeTarget(ResizeTarget.Type.LEFT_BOTTOM));
            component.addTarget(new ResizeTarget(ResizeTarget.Type.RIGHT_TOP));
            component.addTarget(new ResizeTarget(ResizeTarget.Type.RIGHT_BOTTOM));
            component.setNotchProvider(new ConstraintLayoutComponentNotchProvider());
        } else {
            component.addTarget(new LassoTarget());
            component.setNotchProvider(new ConstraintLayoutNotchProvider());
        }
        component.addTarget(new AnchorTarget(AnchorTarget.Type.LEFT, showAnchors));
        component.addTarget(new AnchorTarget(AnchorTarget.Type.TOP, showAnchors));
        component.addTarget(new AnchorTarget(AnchorTarget.Type.RIGHT, showAnchors));
        component.addTarget(new AnchorTarget(AnchorTarget.Type.BOTTOM, showAnchors));
        if (!isParent) {
            ActionTarget previousAction = (ActionTarget)component.addTarget(new ClearConstraintsTarget(null));
            int baseline = component.getNlComponent().getBaseline();
            if (baseline <= 0 && component.getNlComponent().viewInfo != null) {
                baseline = component.getNlComponent().viewInfo.getBaseLine();
            }
            if (baseline > 0) {
                component.addTarget(new AnchorTarget(AnchorTarget.Type.BASELINE, showAnchors));
                ActionTarget baselineActionTarget = new ActionTarget(previousAction, c -> c.setShowBaseline(!c.canShowBaseline()));
                baselineActionTarget.setActionType(1);
                component.addTarget(baselineActionTarget);
                previousAction = baselineActionTarget;
            }
            component.addTarget(new ChainCycleTarget(previousAction, null));
        }
    }

    @Override
    public void clearAttributes(SceneComponent component) {
        ConstraintComponentUtilities.clearAttributes(component);
    }

    @Override
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull NlComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(7);
        }
        if (layout == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(8);
        }
        if (components == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(9);
        }
        if (type == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(10);
        }
        return new SceneDragHandler(editor, this, layout, components, type);
    }

    @Override
    public boolean updateCursor(@NotNull ScreenView screenView, int x, int y) {
        if (screenView == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(11);
        }
        Scene scene = screenView.getScene();
        int dpX = Coordinates.pxToDp(screenView, x);
        int dpY = Coordinates.pxToDp(screenView, y);
        scene.mouseHover(SceneContext.get(screenView), dpX, dpY);
        int cursor = scene.getMouseCursor();
        screenView.getSurface().setCursor(Cursor.getPredefinedCursor(cursor));
        screenView.getSurface().repaint();
        return true;
    }

    @Override
    public boolean handlesPainting() {
        return true;
    }

    @Override
    public boolean drawGroup(@NotNull Graphics2D gc, @NotNull ScreenView screenView, @NotNull NlComponent component) {
        if (gc == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(12);
        }
        if (screenView == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(13);
        }
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(14);
        }
        ConstraintModel constraintModel = ConstraintModel.getConstraintModel(screenView.getModel());
        DrawConstraintModel drawConstraintModel = ConstraintModel.getDrawConstraintModel(screenView);
        this.updateActions(constraintModel.getSelection());
        ConstraintWidget widget = constraintModel.getScene().getWidget((Object)component);
        return false;
    }

    @Override
    public boolean deleteChildren(@NotNull NlComponent parent, @NotNull List<NlComponent> deleted) {
        if (parent == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(15);
        }
        if (deleted == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(16);
        }
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            NlComponent component = parent.getChild(i);
            if (deleted.contains(component)) continue;
            this.willDelete(component, deleted);
        }
        return false;
    }

    private void willDelete(NlComponent component, @NotNull List<NlComponent> deleted) {
        if (deleted == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(17);
        }
        int count = deleted.size();
        for (int i = 0; i < count; ++i) {
            NlComponent deletedComponent = deleted.get(i);
            String id = deletedComponent.getId();
            ConstraintComponentUtilities.updateOnDelete(component, id);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 4: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 5: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gc";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleCoordinateId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGradleCoordinateId";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addPopupMenuActions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createInteraction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTargets";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDragHandler";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateCursor";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "drawGroup";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildren";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "willDelete";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MarginSelector
    extends DirectViewAction {
        MarginPopup myMarginPopup = new MarginPopup();
        private int myMarginIconValue;
        private Icon myMarginIcon;

        public MarginSelector() {
            this.setLabel("Default Margins");
            this.myMarginPopup.setActionListener(e -> this.setMargin());
        }

        public void setMargin() {
            Scout.setMargin((int)this.myMarginPopup.getValue());
            MouseInteraction.setMargin((int)this.myMarginPopup.getValue());
        }

        private void updateIcon() {
            final int margin = this.myMarginPopup.getValue();
            if (this.myMarginIconValue != margin) {
                this.myMarginIconValue = margin;
                this.myMarginIcon = new Icon(){

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        g.setFont(g.getFont().deriveFont(1, 12.0f));
                        String m = Integer.toString(margin);
                        FontMetrics metrics = g.getFontMetrics();
                        int strWidth = metrics.stringWidth(m);
                        int stringY = (this.getIconHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
                        g.drawString(m, x + (this.getIconWidth() - strWidth) / 2, y + stringY);
                    }

                    @Override
                    public int getIconWidth() {
                        return 16;
                    }

                    @Override
                    public int getIconHeight() {
                        return 16;
                    }
                };
            }
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            ConstraintModel model;
            if (editor == null) {
                MarginSelector.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                MarginSelector.$$$reportNull$$$0(1);
            }
            if (component == null) {
                MarginSelector.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                MarginSelector.$$$reportNull$$$0(3);
            }
            if ((model = ConstraintModel.getConstraintModel(editor.getModel())) == null) {
                return;
            }
            DesignSurface surface = ((ViewEditorImpl)editor).getScreenView().getSurface();
            NlUsageTrackerManager.getInstance(surface).logAction(LayoutEditorEvent.LayoutEditorEventType.DEFAULT_MARGINS);
            RelativePoint relativePoint = new RelativePoint((Component)surface, new Point(0, 0));
            JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myMarginPopup, this.myMarginPopup.getTextField()).setRequestFocus(true).createPopup().show(relativePoint);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                MarginSelector.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                MarginSelector.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                MarginSelector.$$$reportNull$$$0(6);
            }
            if (component == null) {
                MarginSelector.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                MarginSelector.$$$reportNull$$$0(8);
            }
            this.updateIcon();
            if (this.myMarginIcon instanceof ControlIcon) {
                ((ControlIcon)this.myMarginIcon).setHighlight(ConstraintModel.isAutoConnect() || (2 & modifiers) == 0);
            }
            presentation.setIcon(this.myMarginIcon);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$MarginSelector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AlignAction
    extends DirectViewAction {
        private final Scout.Arrange myActionType;
        private final Icon myAlignIcon;
        private final Icon myConstrainIcon;
        private final String myToolTip;

        AlignAction(Scout.Arrange actionType, Icon alignIcon, String toolTip) {
            this.myActionType = actionType;
            this.myAlignIcon = alignIcon;
            this.myConstrainIcon = null;
            this.myToolTip = toolTip;
        }

        AlignAction(Scout.Arrange actionType, Icon alignIcon, Icon constrainIcon, String toolTip) {
            this.myActionType = actionType;
            this.myAlignIcon = alignIcon;
            this.myConstrainIcon = constrainIcon;
            this.myToolTip = toolTip;
        }

        private boolean isEnabled(int count) {
            switch (this.myActionType) {
                case AlignVerticallyTop: 
                case AlignVerticallyMiddle: 
                case AlignVerticallyBottom: 
                case AlignHorizontallyLeft: 
                case AlignHorizontallyCenter: 
                case AlignHorizontallyRight: 
                case DistributeVertically: 
                case DistributeHorizontally: 
                case VerticalPack: 
                case HorizontalPack: 
                case AlignBaseline: {
                    return count > 1;
                }
                case ExpandVertically: 
                case ExpandHorizontally: 
                case CenterHorizontallyInParent: 
                case CenterVerticallyInParent: 
                case CenterVertically: 
                case CenterHorizontally: {
                    return count >= 1;
                }
            }
            return false;
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            ConstraintModel model;
            if (editor == null) {
                AlignAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                AlignAction.$$$reportNull$$$0(1);
            }
            if (component == null) {
                AlignAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                AlignAction.$$$reportNull$$$0(3);
            }
            if ((model = ConstraintModel.getConstraintModel(editor.getModel())) == null) {
                return;
            }
            NlUsageTrackerManager.getInstance(((ViewEditorImpl)editor).getScreenView().getSurface()).logAction(LayoutEditorEvent.LayoutEditorEventType.ALIGN);
            Scout.arrangeWidgets((Scout.Arrange)this.myActionType, (ArrayList)model.getSelection().getWidgets(), ((modifiers &= 2) == 0 || ConstraintModel.isAutoConnect() ? 1 : 0) != 0);
            model.saveToXML(true);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                AlignAction.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                AlignAction.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                AlignAction.$$$reportNull$$$0(6);
            }
            if (component == null) {
                AlignAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                AlignAction.$$$reportNull$$$0(8);
            }
            Icon icon = this.myAlignIcon;
            if (this.myConstrainIcon != null && (ConstraintModel.isAutoConnect() || (2 & modifiers) == 0)) {
                icon = this.myConstrainIcon;
            }
            presentation.setEnabled(this.isEnabled(selectedChildren.size()));
            presentation.setIcon(icon);
            presentation.setLabel(this.myToolTip);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$AlignAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddElementAction
    extends DirectViewAction {
        public static final int HORIZONTAL_GUIDELINE = 0;
        public static final int VERTICAL_GUIDELINE = 1;
        final int myType;

        public AddElementAction(int type, Icon icon, String text) {
            super(icon, text);
            this.myType = type;
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            NlComponent parent;
            if (editor == null) {
                AddElementAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                AddElementAction.$$$reportNull$$$0(1);
            }
            if (component == null) {
                AddElementAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                AddElementAction.$$$reportNull$$$0(3);
            }
            for (parent = component; parent != null && !parent.isOrHasSuperclass("android.support.constraint.ConstraintLayout"); parent = parent.getParent()) {
            }
            if (parent != null) {
                NlComponent guideline = parent.createChild(editor, "android.support.constraint.Guideline", null, InsertType.CREATE);
                guideline.ensureId();
                guideline.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", "20dp");
                NlUsageTracker tracker = NlUsageTrackerManager.getInstance(((ViewEditorImpl)editor).getScreenView().getSurface());
                if (this.myType == 0) {
                    tracker.logAction(LayoutEditorEvent.LayoutEditorEventType.ADD_HORIZONTAL_GUIDELINE);
                    guideline.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "horizontal");
                } else {
                    tracker.logAction(LayoutEditorEvent.LayoutEditorEventType.ADD_VERTICAL_GUIDELINE);
                    guideline.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "vertical");
                }
            }
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                AddElementAction.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                AddElementAction.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                AddElementAction.$$$reportNull$$$0(6);
            }
            if (component == null) {
                AddElementAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                AddElementAction.$$$reportNull$$$0(8);
            }
            presentation.setVisible(true);
            presentation.setEnabled(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$AddElementAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ControlIcon
    implements Icon {
        Icon myIcon;
        boolean myHighlight;

        ControlIcon(Icon icon) {
            this.myIcon = icon;
        }

        public void setHighlight(boolean mHighlight) {
            this.myHighlight = mHighlight;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.myIcon.paintIcon(c, g, x, y);
            if (this.myHighlight) {
                g.setColor(new Color(240116));
                g.fillRect(x, y + this.getIconHeight() - 2, this.getIconWidth(), 2);
            }
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }

    private class ToggleConstraintModeAction
    extends ToggleViewAction {
        public ToggleConstraintModeAction() {
            super(AndroidIcons.SherpaIcons.Hide, AndroidIcons.SherpaIcons.Unhide, "Show Constraints", "Hide Constraints");
            ConstraintLayoutHandler.this.myShowAllConstraints = PropertiesComponent.getInstance().getBoolean(ConstraintLayoutHandler.SHOW_CONSTRAINTS_PREF_KEY);
        }

        @Override
        public boolean isSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
            if (editor == null) {
                ToggleConstraintModeAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                ToggleConstraintModeAction.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                ToggleConstraintModeAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                ToggleConstraintModeAction.$$$reportNull$$$0(3);
            }
            return ConstraintLayoutHandler.this.myShowAllConstraints;
        }

        @Override
        public void setSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren, boolean selected) {
            if (editor == null) {
                ToggleConstraintModeAction.$$$reportNull$$$0(4);
            }
            if (handler == null) {
                ToggleConstraintModeAction.$$$reportNull$$$0(5);
            }
            if (parent == null) {
                ToggleConstraintModeAction.$$$reportNull$$$0(6);
            }
            if (selectedChildren == null) {
                ToggleConstraintModeAction.$$$reportNull$$$0(7);
            }
            ConstraintLayoutHandler.this.myShowAllConstraints = selected;
            NlUsageTrackerManager.getInstance(((ViewEditorImpl)editor).getScreenView().getSurface()).logAction(selected ? LayoutEditorEvent.LayoutEditorEventType.SHOW_CONSTRAINTS : LayoutEditorEvent.LayoutEditorEventType.HIDE_CONSTRAINTS);
            PropertiesComponent.getInstance().setValue(ConstraintLayoutHandler.SHOW_CONSTRAINTS_PREF_KEY, ConstraintLayoutHandler.this.myShowAllConstraints);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ToggleConstraintModeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InferAction
    extends DirectViewAction {
        private InferAction() {
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            ConstraintModel model;
            if (editor == null) {
                InferAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                InferAction.$$$reportNull$$$0(1);
            }
            if (component == null) {
                InferAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                InferAction.$$$reportNull$$$0(3);
            }
            if ((model = ConstraintModel.getConstraintModel(editor.getModel())) == null) {
                return;
            }
            NlUsageTrackerManager.getInstance(((ViewEditorImpl)editor).getScreenView().getSurface()).logAction(LayoutEditorEvent.LayoutEditorEventType.INFER_CONSTRAINS);
            WidgetsScene scene = model.getScene();
            try {
                Scout.inferConstraints((WidgetsScene)scene);
            }
            catch (Exception e) {
                Logger.getInstance(ConstraintLayoutHandler.class).warn("Error in inferring constraints", (Throwable)e);
            }
            model.saveToXML(true);
            model.setNeedsAnimateConstraints(1);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                InferAction.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                InferAction.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                InferAction.$$$reportNull$$$0(6);
            }
            if (component == null) {
                InferAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                InferAction.$$$reportNull$$$0(8);
            }
            presentation.setIcon(AndroidIcons.SherpaIcons.Inference);
            presentation.setLabel("Infer Constraints");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$InferAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LockConstraints
    extends DirectViewAction {
        private LockConstraints() {
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            ConstraintModel model;
            if (editor == null) {
                LockConstraints.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                LockConstraints.$$$reportNull$$$0(1);
            }
            if (component == null) {
                LockConstraints.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                LockConstraints.$$$reportNull$$$0(3);
            }
            if ((model = ConstraintModel.getConstraintModel(editor.getModel())) == null) {
                return;
            }
            if (model.getSelection().getWidgets().size() == 1) {
                WidgetsScene scene = model.getScene();
                scene.toggleLockConstraints((ConstraintWidget)model.getSelection().getWidgets().get(0));
            }
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                LockConstraints.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                LockConstraints.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                LockConstraints.$$$reportNull$$$0(6);
            }
            if (component == null) {
                LockConstraints.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                LockConstraints.$$$reportNull$$$0(8);
            }
            presentation.setIcon(AndroidIcons.SherpaIcons.LockConstraints);
            presentation.setLabel("Locks auto inferred constraints");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$LockConstraints";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClearConstraintsAction
    extends DirectViewAction {
        private ClearConstraintsAction() {
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            ConstraintModel model;
            if (editor == null) {
                ClearConstraintsAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                ClearConstraintsAction.$$$reportNull$$$0(1);
            }
            if (component == null) {
                ClearConstraintsAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                ClearConstraintsAction.$$$reportNull$$$0(3);
            }
            if ((model = ConstraintModel.getConstraintModel(editor.getModel())) == null) {
                return;
            }
            NlUsageTrackerManager.getInstance(((ViewEditorImpl)editor).getScreenView().getSurface()).logAction(LayoutEditorEvent.LayoutEditorEventType.CLEAR_ALL_CONSTRAINTS);
            ViewEditorImpl viewEditor = (ViewEditorImpl)editor;
            Scene scene = viewEditor.getScreenView().getScene();
            scene.clearAttributes();
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                ClearConstraintsAction.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                ClearConstraintsAction.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                ClearConstraintsAction.$$$reportNull$$$0(6);
            }
            if (component == null) {
                ClearConstraintsAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                ClearConstraintsAction.$$$reportNull$$$0(8);
            }
            presentation.setIcon(AndroidIcons.SherpaIcons.DeleteConstraint);
            presentation.setLabel("Clear All Constraints");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ClearConstraintsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ToggleAutoConnectAction
    extends ToggleViewAction
    implements Enableable {
        public ToggleAutoConnectAction() {
            super(AndroidIcons.SherpaIcons.AutoConnectOff, AndroidIcons.SherpaIcons.AutoConnect, "Turn On Autoconnect", "Turn Off Autoconnect");
        }

        @Override
        public void enable(Selection selection) {
        }

        @Override
        public boolean isSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
            if (editor == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(3);
            }
            return PropertiesComponent.getInstance().getBoolean(ConstraintLayoutHandler.AUTO_CONNECT_PREF_KEY, false);
        }

        @Override
        public void setSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren, boolean selected) {
            if (editor == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(4);
            }
            if (handler == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(5);
            }
            if (parent == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(6);
            }
            if (selectedChildren == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(7);
            }
            NlUsageTrackerManager.getInstance(((ViewEditorImpl)editor).getScreenView().getSurface()).logAction(selected ? LayoutEditorEvent.LayoutEditorEventType.TURN_ON_AUTOCONNECT : LayoutEditorEvent.LayoutEditorEventType.TURN_OFF_AUTOCONNECT);
            PropertiesComponent.getInstance().setValue(ConstraintLayoutHandler.AUTO_CONNECT_PREF_KEY, selected, false);
        }

        @Override
        public boolean affectsUndo() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ToggleAutoConnectAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface Enableable {
        public void enable(Selection var1);
    }
}

