/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.FrameLayoutHandler;
import com.android.tools.idea.uibuilder.model.Insets;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoordinatorLayoutHandler
extends FrameLayoutHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"context", (Object)"fitsSystemWindows");
        if (immutableList == null) {
            CoordinatorLayoutHandler.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull NlComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            CoordinatorLayoutHandler.$$$reportNull$$$0(1);
        }
        if (layout == null) {
            CoordinatorLayoutHandler.$$$reportNull$$$0(2);
        }
        if (components == null) {
            CoordinatorLayoutHandler.$$$reportNull$$$0(3);
        }
        if (type == null) {
            CoordinatorLayoutHandler.$$$reportNull$$$0(4);
        }
        if (components.size() == 1 && components.get(0) != null) {
            return new CoordinatorDragHandler(editor, layout, components, type);
        }
        return super.createDragHandler(editor, layout, components, type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/CoordinatorLayoutHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorProperties";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/CoordinatorLayoutHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDragHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CoordinatorDragHandler
    extends FrameLayoutHandler.FrameDragHandler {
        private NlComponent myAnchor;
        private NlComponent myDragged;
        private String myAnchorGravity;
        private String myGravity;
        private int myPreviewX;
        private int myPreviewY;

        public CoordinatorDragHandler(@NotNull ViewEditor editor, @NotNull NlComponent layout, @NotNull List<NlComponent> components, DragType type) {
            if (editor == null) {
                CoordinatorDragHandler.$$$reportNull$$$0(0);
            }
            if (layout == null) {
                CoordinatorDragHandler.$$$reportNull$$$0(1);
            }
            if (components == null) {
                CoordinatorDragHandler.$$$reportNull$$$0(2);
            }
            if (type == null) {
                CoordinatorDragHandler.$$$reportNull$$$0(3);
            }
            super(CoordinatorLayoutHandler.this, editor, CoordinatorLayoutHandler.this, layout, components, type);
            assert (components.size() == 1);
            this.myDragged = components.get(0);
            assert (this.myDragged != null);
        }

        @Override
        public void start(int x, int y, int modifiers) {
            super.start(x, y, modifiers);
            this.checkPosition();
        }

        @Override
        @Nullable
        public String update(int x, int y, int modifiers) {
            String result = super.update(x, y, modifiers);
            this.checkPosition();
            return result;
        }

        @Override
        public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
            if (insertType == null) {
                CoordinatorDragHandler.$$$reportNull$$$0(4);
            }
            this.checkPosition();
            if (this.myAnchor == null) {
                this.myDragged.setAttribute("http://schemas.android.com/apk/res-auto", "layout_anchor", null);
                this.myDragged.setAttribute("http://schemas.android.com/apk/res-auto", "layout_anchorGravity", null);
            } else {
                NlComponent root = this.myDragged.getRoot();
                root.ensureNamespace("app", "http://schemas.android.com/apk/res-auto");
                root.ensureNamespace("android", "http://schemas.android.com/apk/res/android");
                this.myAnchor.ensureId();
                String id = this.myAnchor.getAttribute("http://schemas.android.com/apk/res/android", "id");
                this.myDragged.setAttribute("http://schemas.android.com/apk/res-auto", "layout_anchor", id);
                this.myDragged.setAttribute("http://schemas.android.com/apk/res-auto", "layout_anchorGravity", this.myAnchorGravity);
                this.myDragged.setAttribute("http://schemas.android.com/apk/res/android", "layout_gravity", this.myGravity);
            }
            this.insertComponents(-1, insertType);
        }

        @Override
        public void paint(@NotNull NlGraphics gc) {
            if (gc == null) {
                CoordinatorDragHandler.$$$reportNull$$$0(5);
            }
            if (this.myAnchor == null) {
                super.paint(gc);
            } else {
                Insets padding = this.myAnchor.getPadding();
                int anchorX = this.myAnchor.x + padding.left;
                int anchorW = this.myAnchor.w - padding.width();
                int anchorY = this.myAnchor.y + padding.top;
                int anchorH = this.myAnchor.h - padding.height();
                gc.useStyle(NlDrawingStyle.DROP_RECIPIENT);
                gc.drawRect(anchorX, anchorY, anchorW, anchorH);
                gc.useStyle(NlDrawingStyle.DROP_ZONE);
                gc.drawRect(this.myAnchor.x - this.myDragged.w, this.myAnchor.y - this.myDragged.h, this.myDragged.w * 2, this.myDragged.h * 2);
                gc.drawRect(this.myAnchor.x + this.myAnchor.w - this.myDragged.w, this.myAnchor.y - this.myDragged.h, this.myDragged.w * 2, this.myDragged.h * 2);
                gc.drawRect(this.myAnchor.x - this.myDragged.w, this.myAnchor.y + this.myAnchor.h - this.myDragged.h, this.myDragged.w * 2, this.myDragged.h * 2);
                gc.drawRect(this.myAnchor.x + this.myAnchor.w - this.myDragged.w, this.myAnchor.y + this.myAnchor.h - this.myDragged.h, this.myDragged.w * 2, this.myDragged.h * 2);
                if (this.myAnchor.w > 4 * this.myDragged.w) {
                    gc.drawRect(this.myAnchor.x + this.myAnchor.w / 2 - this.myDragged.w, this.myAnchor.y - this.myDragged.h, this.myDragged.w * 2, this.myDragged.h * 2);
                    gc.drawRect(this.myAnchor.x + this.myAnchor.w / 2 - this.myDragged.w, this.myAnchor.y + this.myAnchor.h - this.myDragged.h, this.myDragged.w * 2, this.myDragged.h * 2);
                }
                if (this.myAnchor.h > 4 * this.myDragged.h) {
                    gc.drawRect(this.myAnchor.x - this.myDragged.w, this.myAnchor.y + this.myAnchor.h / 2 - this.myDragged.h, this.myDragged.w * 2, this.myDragged.h * 2);
                    gc.drawRect(this.myAnchor.x + this.myAnchor.w - this.myDragged.w, this.myAnchor.y + this.myAnchor.h / 2 - this.myDragged.h, this.myDragged.w * 2, this.myDragged.h * 2);
                }
                if (this.myAnchor.w > 4 * this.myDragged.w && this.myAnchor.h > 4 * this.myDragged.h) {
                    gc.drawRect(this.myAnchor.x + this.myAnchor.w / 2 - this.myDragged.w, this.myAnchor.y + this.myAnchor.h / 2 - this.myDragged.h, this.myDragged.w * 2, this.myDragged.h * 2);
                }
                if (this.myAnchorGravity != null) {
                    gc.useStyle(NlDrawingStyle.DROP_PREVIEW);
                    gc.drawRect(this.myPreviewX, this.myPreviewY, this.myDragged.w, this.myDragged.h);
                }
            }
        }

        private void checkPosition() {
            this.myAnchor = this.findAnchor();
            this.myAnchorGravity = null;
            this.myGravity = null;
            this.myPreviewX = -1;
            this.myPreviewY = -1;
            if (this.myAnchor != null) {
                String anchorHgrav = null;
                String anchorVgrav = null;
                String selfHgrav = null;
                String selfVgrav = null;
                int left = -1;
                int top = -1;
                int x = -1;
                int y = -1;
                if (this.lastX < this.myAnchor.x + this.myDragged.w) {
                    anchorHgrav = "left";
                    left = this.myAnchor.x - this.myDragged.w;
                    x = this.lastX - this.myAnchor.x;
                } else if (this.lastX >= this.myAnchor.x + this.myAnchor.w - this.myDragged.w) {
                    anchorHgrav = "right";
                    left = this.myAnchor.x + this.myAnchor.w - this.myDragged.w;
                    x = this.lastX - (this.myAnchor.x + this.myAnchor.w - this.myDragged.w);
                } else if (this.myAnchor.w > 4 * this.myDragged.w && this.myAnchor.x + this.myAnchor.w / 2 - this.myDragged.w <= this.lastX && this.lastX < this.myAnchor.x + this.myAnchor.w / 2 + this.myDragged.w) {
                    anchorHgrav = "center_horizontal";
                    left = this.myAnchor.x + this.myAnchor.w / 2 - this.myDragged.w;
                    x = (this.lastX - (this.myAnchor.x + this.myAnchor.w / 2 - this.myDragged.w)) / 2;
                }
                if (anchorHgrav != null) {
                    if (x < this.myDragged.w / 3) {
                        selfHgrav = "left";
                    } else if (x < 2 * this.myDragged.w / 3) {
                        selfHgrav = "center_horizontal";
                        left += this.myDragged.w / 2;
                    } else {
                        selfHgrav = "right";
                        left += this.myDragged.w;
                    }
                }
                if (this.lastY < this.myAnchor.y + this.myDragged.h) {
                    anchorVgrav = "top";
                    top = this.myAnchor.y - this.myDragged.h;
                    y = this.lastY - this.myAnchor.y;
                } else if (this.lastY >= this.myAnchor.y + this.myAnchor.h - this.myDragged.h) {
                    anchorVgrav = "bottom";
                    top = this.myAnchor.y + this.myAnchor.h - this.myDragged.h;
                    y = this.lastY - (this.myAnchor.y + this.myAnchor.h - this.myDragged.h);
                } else if (this.myAnchor.h > 4 * this.myDragged.h && this.myAnchor.y + this.myAnchor.h / 2 - this.myDragged.h <= this.lastY && this.lastY < this.myAnchor.y + this.myAnchor.h / 2 + this.myDragged.h) {
                    anchorVgrav = "center_vertical";
                    top = this.myAnchor.y + this.myAnchor.h / 2 - this.myDragged.h;
                    y = (this.lastY - (this.myAnchor.y + this.myAnchor.h / 2 - this.myDragged.h)) / 2;
                }
                if (anchorVgrav != null) {
                    if (y < this.myDragged.h / 3) {
                        selfVgrav = "top";
                    } else if (y < 2 * this.myDragged.h / 3) {
                        selfVgrav = "center_vertical";
                        top += this.myDragged.h / 2;
                    } else {
                        selfVgrav = "bottom";
                        top += this.myDragged.h;
                    }
                }
                if (anchorHgrav != null && anchorVgrav != null) {
                    this.myAnchorGravity = anchorVgrav + "|" + anchorHgrav;
                    this.myGravity = selfVgrav + "|" + selfHgrav;
                    this.myPreviewX = left;
                    this.myPreviewY = top;
                }
            }
        }

        @Nullable
        NlComponent findAnchor() {
            for (int i = this.layout.getChildCount() - 1; i >= 0; --i) {
                NlComponent component = this.layout.getChild(i);
                assert (component != null);
                if (component.x >= this.lastX || this.lastX >= component.x + component.w || component.y >= this.lastY || this.lastY >= component.y + component.h || component.w <= this.myDragged.w * 3 || component.h <= this.myDragged.h * 3) continue;
                return component;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layout";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gc";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/CoordinatorLayoutHandler$CoordinatorDragHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commit";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

