/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.uibuilder.api.DefaultResizeHandler;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ResizeHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.SegmentType;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbsoluteLayoutHandler
extends ViewGroupHandler {
    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull NlComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            AbsoluteLayoutHandler.$$$reportNull$$$0(0);
        }
        if (layout == null) {
            AbsoluteLayoutHandler.$$$reportNull$$$0(1);
        }
        if (components == null) {
            AbsoluteLayoutHandler.$$$reportNull$$$0(2);
        }
        if (type == null) {
            AbsoluteLayoutHandler.$$$reportNull$$$0(3);
        }
        return new DragHandler(editor, this, layout, components, type){

            @Override
            public void paint(@NotNull NlGraphics graphics) {
                if (graphics == null) {
                    1.$$$reportNull$$$0(0);
                }
                int deltaX = this.lastX - this.startX;
                int deltaY = this.lastY - this.startY;
                for (NlComponent component : this.components) {
                    int x = component.x + deltaX;
                    int y = component.y + deltaY;
                    int w = component.w;
                    int h = component.h;
                    graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
                    graphics.drawRect(x, y, w, h);
                }
            }

            @Override
            public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
                if (insertType == null) {
                    1.$$$reportNull$$$0(1);
                }
                int deltaX = x - this.startX;
                int deltaY = y - this.startY;
                for (NlComponent component : this.components) {
                    component.setAttribute("http://schemas.android.com/apk/res/android", "layout_x", this.editor.pxToDpWithUnits(component.x - this.layout.x + deltaX));
                    component.setAttribute("http://schemas.android.com/apk/res/android", "layout_y", this.editor.pxToDpWithUnits(component.y - this.layout.y + deltaY));
                }
                this.insertComponents(-1, insertType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "graphics";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "insertType";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "paint";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commit";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @Nullable
    public ResizeHandler createResizeHandler(@NotNull ViewEditor editor, @NotNull NlComponent component, @Nullable SegmentType horizontalEdgeType, @Nullable SegmentType verticalEdgeType) {
        if (editor == null) {
            AbsoluteLayoutHandler.$$$reportNull$$$0(4);
        }
        if (component == null) {
            AbsoluteLayoutHandler.$$$reportNull$$$0(5);
        }
        return new DefaultResizeHandler(editor, this, component, horizontalEdgeType, verticalEdgeType){

            @Override
            protected void setNewSizeBounds(@NotNull NlComponent component, @NotNull NlComponent layout, @NotNull Rectangle oldBounds, @NotNull Rectangle newBounds, @Nullable SegmentType horizontalEdge, @Nullable SegmentType verticalEdge) {
                if (component == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (layout == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (oldBounds == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (newBounds == null) {
                    2.$$$reportNull$$$0(3);
                }
                Rectangle previousBounds = new Rectangle(component.x, component.y, component.w, component.h);
                super.setNewSizeBounds(component, layout, previousBounds, newBounds, horizontalEdge, verticalEdge);
                if (verticalEdge != null && newBounds.x != previousBounds.x) {
                    component.setAttribute("http://schemas.android.com/apk/res/android", "layout_x", String.format("%ddp", this.editor.pxToDp(newBounds.x - layout.x)));
                }
                if (horizontalEdge != null && newBounds.y != previousBounds.y) {
                    component.setAttribute("http://schemas.android.com/apk/res/android", "layout_y", String.format("%ddp", this.editor.pxToDp(newBounds.y - layout.y)));
                }
            }

            @Override
            protected String getResizeUpdateMessage(@NotNull NlComponent child, @NotNull NlComponent parent, @NotNull Rectangle newBounds, @Nullable SegmentType horizontalEdge, @Nullable SegmentType verticalEdge) {
                if (child == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (parent == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (newBounds == null) {
                    2.$$$reportNull$$$0(6);
                }
                Rectangle parentBounds = new Rectangle(this.layout.x, this.layout.y, this.layout.w, this.layout.h);
                if (horizontalEdge == SegmentType.BOTTOM && verticalEdge == SegmentType.RIGHT) {
                    return super.getResizeUpdateMessage(child, parent, newBounds, horizontalEdge, verticalEdge);
                }
                return String.format("x=%d, y=%d\nwidth=%s, height=%s", this.editor.pxToDp(newBounds.x - parentBounds.x), this.editor.pxToDp(newBounds.y - parentBounds.y), this.getWidthAttribute(), this.getHeightAttribute());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "layout";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldBounds";
                        break;
                    }
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newBounds";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "child";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setNewSizeBounds";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getResizeUpdateMessage";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/AbsoluteLayoutHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createDragHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createResizeHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

