/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import android.view.View;
import android.view.ViewGroup;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import org.jetbrains.annotations.NotNull;

public final class ScrollViewScrollHandler
implements ScrollHandler {
    private final View myScrollView;
    private final int myMaxScrollableHeight;
    private final int myScrollUnitSize;
    private final int myStartScrollPosition;

    public ScrollViewScrollHandler(NlComponent component, int maxScrollableHeight, int scrollUnitSize) {
        this.myMaxScrollableHeight = maxScrollableHeight;
        this.myScrollUnitSize = scrollUnitSize;
        ViewInfo viewInfo = component.viewInfo;
        assert (viewInfo != null);
        this.myScrollView = (View)viewInfo.getViewObject();
        this.myStartScrollPosition = this.myScrollView.getScrollY();
    }

    private static void handleScrolling(@NotNull View view) {
        if (view == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(0);
        }
        int scrollPosX = view.getScrollX();
        int scrollPosY = view.getScrollY();
        if (scrollPosX != 0 || scrollPosY != 0) {
            if (view.isNestedScrollingEnabled()) {
                int[] consumed = new int[2];
                int axis = scrollPosX != 0 ? 1 : 0;
                if (view.startNestedScroll(axis |= scrollPosY != 0 ? 2 : 0)) {
                    view.dispatchNestedPreScroll(scrollPosX, scrollPosY, consumed, null);
                    view.dispatchNestedScroll(consumed[0], consumed[1], scrollPosX, scrollPosY, null);
                    view.stopNestedScroll();
                    scrollPosX -= consumed[0];
                    scrollPosY -= consumed[1];
                }
            }
            if (scrollPosX != 0 || scrollPosY != 0) {
                view.scrollTo(scrollPosX, scrollPosY);
            }
        }
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup group = (ViewGroup)view;
        for (int i = 0; i < group.getChildCount(); ++i) {
            View child = group.getChildAt(i);
            ScrollViewScrollHandler.handleScrolling(child);
        }
    }

    @Override
    public int update(int scrollAmount) {
        int currentScrollPosition = this.myScrollView.getScrollY();
        int newScrollY = Math.min(this.myMaxScrollableHeight, Math.max(0, this.myStartScrollPosition + scrollAmount * this.myScrollUnitSize));
        if (newScrollY == currentScrollPosition) {
            return 0;
        }
        this.myScrollView.setScrollY(newScrollY);
        ScrollViewScrollHandler.handleScrolling(this.myScrollView);
        return newScrollY - currentScrollPosition;
    }

    @Override
    public void commit(int scrollAmount) {
        this.update(scrollAmount);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/api/ScrollViewScrollHandler", "handleScrolling"));
    }
}

