/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.validation;

import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.validation.Validator;
import com.android.tools.idea.ui.validation.validators.TrueValidator;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class ValidatorPanel
extends JPanel
implements Disposable {
    private static final String BLANK = " ";
    private final ListenerManager myListeners;
    private final Table<Validator.Severity, ObservableValue<?>, String> myMessages;
    private final BoolProperty myHasErrors;
    private JPanel myRootPanel;
    private JPanel mySouthPanel;
    private JBLabel myValidationLabel;

    public ValidatorPanel(@NotNull Disposable parentDisposable, @NotNull JPanel innerPanel) {
        if (parentDisposable == null) {
            ValidatorPanel.$$$reportNull$$$0(0);
        }
        if (innerPanel == null) {
            ValidatorPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myMessages = HashBasedTable.create();
        this.myHasErrors = new BoolValueProperty();
        this.add(this.myRootPanel);
        this.myRootPanel.add(innerPanel);
        this.myValidationLabel.setName("ValidationLabel");
        this.myValidationLabel.setText(BLANK);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public <T> void registerValidator(final @NotNull ObservableValue<T> value, final @NotNull Validator<T> validator) {
        if (value == null) {
            ValidatorPanel.$$$reportNull$$$0(2);
        }
        if (validator == null) {
            ValidatorPanel.$$$reportNull$$$0(3);
        }
        this.myListeners.listenAndFire(value, new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    1.$$$reportNull$$$0(0);
                }
                Validator.Result result = validator.validate(value.get());
                ValidatorPanel.this.myMessages.column((Object)value).clear();
                if (result.getSeverity() != Validator.Severity.OK) {
                    ValidatorPanel.this.myMessages.put((Object)result.getSeverity(), (Object)value, (Object)result.getMessage());
                }
                ValidatorPanel.this.updateValidationLabel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/ui/validation/ValidatorPanel$1", "onInvalidated"));
            }
        });
    }

    public void registerValidator(@NotNull ObservableValue<Boolean> value, @NotNull String errorMessage) {
        if (value == null) {
            ValidatorPanel.$$$reportNull$$$0(4);
        }
        if (errorMessage == null) {
            ValidatorPanel.$$$reportNull$$$0(5);
        }
        this.registerValidator(value, new TrueValidator(errorMessage));
    }

    public void registerValidator(@NotNull ObservableValue<Boolean> value, @NotNull Validator.Severity severity, @NotNull String errorMessage) {
        if (value == null) {
            ValidatorPanel.$$$reportNull$$$0(6);
        }
        if (severity == null) {
            ValidatorPanel.$$$reportNull$$$0(7);
        }
        if (errorMessage == null) {
            ValidatorPanel.$$$reportNull$$$0(8);
        }
        this.registerValidator(value, new TrueValidator(severity, errorMessage));
    }

    @NotNull
    public ObservableBool hasErrors() {
        BoolProperty boolProperty = this.myHasErrors;
        if (boolProperty == null) {
            ValidatorPanel.$$$reportNull$$$0(9);
        }
        return boolProperty;
    }

    private void updateValidationLabel() {
        this.myHasErrors.set(false);
        this.myValidationLabel.setIcon(null);
        this.myValidationLabel.setText(BLANK);
        for (Validator.Severity severity : Validator.Severity.values()) {
            Iterator messages = this.myMessages.row((Object)severity).values().iterator();
            if (!messages.hasNext()) continue;
            this.myValidationLabel.setText((String)messages.next());
            this.myValidationLabel.setIcon(severity.getIcon());
            if (severity != Validator.Severity.ERROR) continue;
            this.myHasErrors.set(true);
        }
    }

    public void dispose() {
        this.myListeners.releaseAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerPanel";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/validation/ValidatorPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/validation/ValidatorPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "hasErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerValidator";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 15));
        this.mySouthPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "South");
        this.myValidationLabel = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

