/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.res2.DataFile;
import com.android.ide.common.resources.FrameworkResources;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.ui.resourcechooser.ResourceChooserItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResourceChooserGroup {
    @NotNull
    private final List<ResourceChooserItem> myItems;
    @NotNull
    private final String myLabel;
    @NotNull
    private final ResourceType myType;
    public static final boolean FILTER_OUT_PRIVATE = true;

    public ResourceChooserGroup(@NotNull String label, @NotNull ResourceType type, @NotNull AndroidFacet facet, boolean framework, boolean includeFileResources) {
        if (label == null) {
            ResourceChooserGroup.$$$reportNull$$$0(0);
        }
        if (type == null) {
            ResourceChooserGroup.$$$reportNull$$$0(1);
        }
        if (facet == null) {
            ResourceChooserGroup.$$$reportNull$$$0(2);
        }
        this.myItems = new ArrayList<ResourceChooserItem>();
        assert (type != ResourceType.MIPMAP);
        this.myType = type;
        this.myLabel = label;
        if (framework) {
            FrameworkResources frameworkResources;
            AndroidPlatform androidPlatform = AndroidPlatform.getInstance(facet.getModule());
            if (androidPlatform == null) {
                return;
            }
            AndroidTargetData targetData = androidPlatform.getSdkData().getTargetData(androidPlatform.getTarget());
            try {
                frameworkResources = targetData.getFrameworkResources(type == ResourceType.STRING);
                if (frameworkResources == null) {
                    return;
                }
            }
            catch (IOException ignore) {
                return;
            }
            this.addFrameworkItems(type, includeFileResources, frameworkResources);
            if (type == ResourceType.DRAWABLE) {
                this.addFrameworkItems(ResourceType.MIPMAP, includeFileResources, frameworkResources);
            }
        } else {
            AppResourceRepository repository = AppResourceRepository.getAppResources(facet, true);
            ResourceVisibilityLookup lookup = repository.getResourceVisibility(facet);
            this.addProjectItems(type, includeFileResources, repository, lookup);
            if (type == ResourceType.DRAWABLE) {
                this.addProjectItems(ResourceType.MIPMAP, includeFileResources, repository, lookup);
            }
        }
        this.sortItems();
    }

    public ResourceChooserGroup(@NotNull String label, @NotNull ResourceType type, @NotNull AndroidFacet facet, @NotNull Collection<String> attrs) {
        if (label == null) {
            ResourceChooserGroup.$$$reportNull$$$0(3);
        }
        if (type == null) {
            ResourceChooserGroup.$$$reportNull$$$0(4);
        }
        if (facet == null) {
            ResourceChooserGroup.$$$reportNull$$$0(5);
        }
        if (attrs == null) {
            ResourceChooserGroup.$$$reportNull$$$0(6);
        }
        this.myItems = new ArrayList<ResourceChooserItem>();
        this.myType = type;
        this.myLabel = label;
        AppResourceRepository repository = AppResourceRepository.getAppResources(facet, true);
        ResourceVisibilityLookup lookup = repository.getResourceVisibility(facet);
        for (String name : attrs) {
            String simpleName;
            boolean framework = name.startsWith("android:");
            String string = simpleName = framework ? ResolutionUtils.getNameFromQualifiedName(name) : name;
            if (!framework && lookup != null && lookup.isPrivate(ResourceType.ATTR, simpleName)) continue;
            this.myItems.add(new ResourceChooserItem.AttrItem(this.myType, framework, simpleName));
        }
        this.sortItems();
    }

    private void addFrameworkItems(@NotNull ResourceType type, boolean includeFileResources, @NotNull FrameworkResources frameworkResources) {
        if (type == null) {
            ResourceChooserGroup.$$$reportNull$$$0(7);
        }
        if (frameworkResources == null) {
            ResourceChooserGroup.$$$reportNull$$$0(8);
        }
        List items = frameworkResources.getResourceItemsOfType(type);
        for (ResourceItem item : items) {
            List sourceFileList;
            if (!includeFileResources && !(sourceFileList = item.getSourceFileList()).isEmpty() && !((ResourceFile)sourceFileList.get(0)).getFolder().getFolder().getName().startsWith("values")) continue;
            this.myItems.add(new ResourceChooserItem.FrameworkItem(this.myType, item.getName(), item));
        }
    }

    private void addProjectItems(@NotNull ResourceType type, boolean includeFileResources, @NotNull AppResourceRepository repository, @Nullable ResourceVisibilityLookup lookup) {
        if (type == null) {
            ResourceChooserGroup.$$$reportNull$$$0(9);
        }
        if (repository == null) {
            ResourceChooserGroup.$$$reportNull$$$0(10);
        }
        for (String resourceName : repository.getItemsOfType(type)) {
            List items;
            if (lookup != null && lookup.isPrivate(type, resourceName) || (items = repository.getResourceItem(type, resourceName)) == null || items.isEmpty() || !includeFileResources && ((com.android.ide.common.res2.ResourceItem)items.get(0)).getSourceType() != DataFile.FileType.XML_VALUES) continue;
            this.myItems.add(new ResourceChooserItem.ProjectItem(type, resourceName, items));
        }
    }

    private void sortItems() {
        Collections.sort(this.myItems, (resource1, resource2) -> {
            int framework2;
            int framework1 = resource1.isFramework() ? 1 : 0;
            int delta = framework1 - (framework2 = resource2.isFramework() ? 1 : 0);
            if (delta != 0) {
                return delta;
            }
            return resource1.getName().compareTo(resource2.getName());
        });
    }

    @NotNull
    public ResourceType getType() {
        ResourceType resourceType = this.myType;
        if (resourceType == null) {
            ResourceChooserGroup.$$$reportNull$$$0(11);
        }
        return resourceType;
    }

    @NotNull
    public List<ResourceChooserItem> getItems() {
        List<ResourceChooserItem> list = this.myItems;
        if (list == null) {
            ResourceChooserGroup.$$$reportNull$$$0(12);
        }
        return list;
    }

    public String toString() {
        return this.myLabel;
    }

    public boolean isEmpty() {
        return this.getItems().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkResources";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserGroup";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFrameworkItems";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addProjectItems";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

