/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.collections;

import com.android.tools.idea.ui.properties.AbstractObservableValue;
import com.android.tools.idea.ui.properties.SettableValue;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ForwardingListIterator;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObservableList<E>
extends AbstractObservableValue<List<? extends E>>
implements List<E>,
SettableValue<List<? extends E>> {
    @NotNull
    private List<E> myInnerList;
    private int myUpdateCount;
    private boolean myInvalidatedWhileUpdating;

    public ObservableList() {
        this.myInnerList = Lists.newArrayList();
    }

    public ObservableList(@NotNull Iterable<? extends E> otherCollection) {
        if (otherCollection == null) {
            ObservableList.$$$reportNull$$$0(0);
        }
        this.myInnerList = Lists.newArrayList(otherCollection);
    }

    public void beginUpdate() {
        ++this.myUpdateCount;
    }

    public void endUpdate() {
        if (this.myUpdateCount == 0) {
            throw new IllegalStateException("Can't call ObservableList.endUpdate without matching beginUpdate");
        }
        --this.myUpdateCount;
        if (this.myUpdateCount == 0 && this.myInvalidatedWhileUpdating) {
            this.myInvalidatedWhileUpdating = false;
            this.notifyInvalidated();
        }
    }

    private void notifyContentsChanged() {
        if (this.myUpdateCount > 0) {
            this.myInvalidatedWhileUpdating = true;
            return;
        }
        this.notifyInvalidated();
    }

    @Override
    public int size() {
        return this.myInnerList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myInnerList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.myInnerList.contains(o);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        ObservableIterator observableIterator = new ObservableIterator(this.myInnerList.iterator());
        if (observableIterator == null) {
            ObservableList.$$$reportNull$$$0(1);
        }
        return observableIterator;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objectArray = this.myInnerList.toArray();
        if (objectArray == null) {
            ObservableList.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @Override
    @NotNull
    public <T> T[] toArray(T[] a) {
        T[] TArray = this.myInnerList.toArray(a);
        if (TArray == null) {
            ObservableList.$$$reportNull$$$0(3);
        }
        return TArray;
    }

    @Override
    public boolean add(E e) {
        boolean added = this.myInnerList.add(e);
        if (added) {
            this.notifyContentsChanged();
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.myInnerList.remove(o);
        if (removed) {
            this.notifyContentsChanged();
        }
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.myInnerList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added = this.myInnerList.addAll(c);
        if (added) {
            this.notifyContentsChanged();
        }
        return added;
    }

    public boolean setAll(@NotNull Collection<? extends E> c) {
        boolean changed;
        if (c == null) {
            ObservableList.$$$reportNull$$$0(4);
        }
        this.beginUpdate();
        boolean cleared = false;
        if (!this.myInnerList.isEmpty()) {
            this.myInnerList.clear();
            cleared = true;
        }
        boolean added = this.myInnerList.addAll(c);
        boolean bl = changed = cleared || added;
        if (changed) {
            this.notifyContentsChanged();
        }
        this.endUpdate();
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean added = this.myInnerList.addAll(index, c);
        if (added) {
            this.notifyContentsChanged();
        }
        return added;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = this.myInnerList.removeAll(c);
        if (removed) {
            this.notifyContentsChanged();
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retained = this.myInnerList.retainAll(c);
        if (retained) {
            this.notifyContentsChanged();
        }
        return retained;
    }

    @Override
    public void clear() {
        if (this.myInnerList.isEmpty()) {
            return;
        }
        this.myInnerList.clear();
        this.notifyContentsChanged();
    }

    @Override
    @Nullable
    public E get(int index) {
        return this.myInnerList.get(index);
    }

    @Override
    @Nullable
    public E set(int index, E element) {
        E result = this.myInnerList.set(index, element);
        this.notifyContentsChanged();
        return result;
    }

    @Override
    public void add(int index, E element) {
        this.myInnerList.add(index, element);
        this.notifyContentsChanged();
    }

    @Override
    @Nullable
    public E remove(int index) {
        E result = this.myInnerList.remove(index);
        this.notifyContentsChanged();
        return result;
    }

    @Override
    public int indexOf(Object o) {
        return this.myInnerList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.myInnerList.lastIndexOf(o);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        ObservableListIterator observableListIterator = new ObservableListIterator(this.myInnerList.listIterator());
        if (observableListIterator == null) {
            ObservableList.$$$reportNull$$$0(5);
        }
        return observableListIterator;
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        ObservableListIterator observableListIterator = new ObservableListIterator(this.myInnerList.listIterator(index));
        if (observableListIterator == null) {
            ObservableList.$$$reportNull$$$0(6);
        }
        return observableListIterator;
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        List<E> list = this.myInnerList.subList(fromIndex, toIndex);
        if (list == null) {
            ObservableList.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    public int hashCode() {
        return this.myInnerList.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.myInnerList.equals(o)) {
            return true;
        }
        if (o != null && o instanceof ObservableList) {
            return ((ObservableList)o).myInnerList.equals(this.myInnerList);
        }
        return false;
    }

    public String toString() {
        return this.myInnerList.toString();
    }

    @Override
    @NotNull
    public List<E> get() {
        List<E> list = this.myInnerList;
        if (list == null) {
            ObservableList.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    public void set(@NotNull List<? extends E> value) {
        if (value == null) {
            ObservableList.$$$reportNull$$$0(9);
        }
        this.setAll(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherCollection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/properties/collections/ObservableList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/properties/collections/ObservableList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "listIterator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "subList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAll";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ObservableListIterator
    extends ForwardingListIterator<E> {
        @NotNull
        private final ListIterator<E> myInner;

        public ObservableListIterator(ListIterator<E> inner) {
            if (inner == null) {
                ObservableListIterator.$$$reportNull$$$0(0);
            }
            this.myInner = inner;
        }

        protected ListIterator<E> delegate() {
            return this.myInner;
        }

        public void remove() {
            this.myInner.remove();
            ObservableList.this.notifyContentsChanged();
        }

        public void set(@NotNull E e) {
            if (e == null) {
                ObservableListIterator.$$$reportNull$$$0(1);
            }
            this.myInner.set(e);
            ObservableList.this.notifyContentsChanged();
        }

        public void add(@NotNull E e) {
            if (e == null) {
                ObservableListIterator.$$$reportNull$$$0(2);
            }
            this.myInner.add(e);
            ObservableList.this.notifyContentsChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inner";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ui/properties/collections/ObservableList$ObservableListIterator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "set";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ObservableIterator
    extends ForwardingIterator<E> {
        private final Iterator<E> myInner;

        public ObservableIterator(Iterator<E> inner) {
            if (inner == null) {
                ObservableIterator.$$$reportNull$$$0(0);
            }
            this.myInner = inner;
        }

        protected Iterator<E> delegate() {
            return this.myInner;
        }

        public void remove() {
            this.myInner.remove();
            ObservableList.this.notifyContentsChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inner", "com/android/tools/idea/ui/properties/collections/ObservableList$ObservableIterator", "<init>"));
        }
    }
}

