/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public final class TableUtils {
    private TableUtils() {
    }

    public static void paste(@NotNull JTable table, @NotNull Transferable transferable) {
        if (table == null) {
            TableUtils.$$$reportNull$$$0(0);
        }
        if (transferable == null) {
            TableUtils.$$$reportNull$$$0(1);
        }
        if (table.getSelectedRowCount() != 1 || table.getSelectedColumnCount() != 1) {
            return;
        }
        if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        int row = table.getSelectedRow();
        int rowCount = table.getRowCount();
        int selectedColumn = table.getSelectedColumn();
        int columnCount = table.getColumnCount();
        for (String values : TableUtils.getTransferDataAsString(transferable).split("\n")) {
            if (row >= rowCount) break;
            int column = selectedColumn;
            for (String value : values.split("\t")) {
                if (column >= columnCount) break;
                table.setValueAt(value, row, column++);
            }
            ++row;
        }
    }

    @NotNull
    private static String getTransferDataAsString(@NotNull Transferable transferable) {
        String string;
        if (transferable == null) {
            TableUtils.$$$reportNull$$$0(2);
        }
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            Logger.getInstance(TableUtils.class).warn((Throwable)exception);
            if ("" == null) {
                TableUtils.$$$reportNull$$$0(4);
            }
            return "";
        }
        if (string == null) {
            TableUtils.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static void selectCellAt(@NotNull JTable table, int row, int column) {
        if (table == null) {
            TableUtils.$$$reportNull$$$0(5);
        }
        table.setRowSelectionInterval(row, row);
        table.setColumnSelectionInterval(column, column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferable";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/TableUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/TableUtils";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransferDataAsString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "paste";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTransferDataAsString";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectCellAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

